 $(function() {
 
 var Mouse = {
	x: 0,
	y: 0,
	refresh: function(e) {
		var posx = 0,
		posy = 0;
		if (!e) {
			e = window.event;
		}
		if (e.pageX || e.pageY) {
			posx = e.pageX;
			posy = e.pageY;
		} else if (e.clientX || e.clientY) {
			posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
			posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
		}
		this.x = posx;
		this.y = posy;
	}
},
mouseMoveHandler = document.onmousemove ||
function() {};
document.onmousemove = function(e) {
	mouseMoveHandler(e);
	Mouse.refresh(e);
};
var MPosition = {
	get: function(obj) {
		var curleft = curtop = 0;
		if (obj.offsetParent) {
			do {
				curleft += obj.offsetLeft;
				curtop += obj.offsetTop;
			} while (( obj = obj . offsetParent ));
		}
		return [curleft, curtop];
	}
},
Slider = function(wrapper, options) {
	if (typeof(wrapper) == 'string') {
		wrapper = document.getElementById(wrapper);
	}
	if (!wrapper) {
		return;
	}
	var handle = wrapper.getElementsByTagName('div')[0];
	if (!handle || handle.className.search(/(^|\s)flexpaper_handle(\s|$)/) == -1) {
		return;
	}
	this.init(wrapper, handle, options || {});
	this.setup();
};
Slider.prototype = {
	init: function(wrapper, handle, options) {
		this.wrapper = wrapper;
		this.handle = handle;
		this.options = options;
		this.value = {
			current: options.value || 0,
			target: options.value || 0,
			prev: -1
		};
		this.disabled = options.disabled || false;
		this.steps = options.steps || 0;
		this.snapping = options.snapping || false;
		this.speed = options.speed || 5;
		this.callback = options.callback || null;
		this.animation_callback = options.animation_callback || null;
		this.bounds = {
			pleft: options.pleft || 0,
			left: 0,
			pright: -(options.pright || 0),
			right: 0,
			width: 0,
			diff: 0
		};
		this.offset = {
			wrapper: 0,
			mouse: 0,
			target: 0,
			current: 0,
			prev: -9999
		};
		this.dragging = false;
		this.tapping = false;
	},
	setup: function() {
		var self = this;
		this.wrapper.onselectstart = function() {
			return false;
		};
		this.handle.onmousedown = function(e) {
			self.preventDefaults(e, true);
			this.focus();
			self.handleMouseDownHandler(e);
		};
		this.wrapper.onmousedown = function(e) {
			self.preventDefaults(e);
			self.wrapperMouseDownHandler(e);
		};
		var mouseUpHandler = document.onmouseup ||
		function() {};
		document.onmouseup = function(e) {
			if (self.dragging) {
				mouseUpHandler(e);
				self.preventDefaults(e);
				self.documentMouseUpHandler(e);
			}
		};
		var resizeHandler = document.onresize ||
		function() {};
		window.onresize = function(e) {
			resizeHandler(e);
			self.setWrapperOffset();
			self.setBounds();
		};
		this.setWrapperOffset();
		if (!this.bounds.pleft && !this.bounds.pright) {
			this.bounds.pleft = MPosition.get(this.handle)[0] - this.offset.wrapper;
			this.bounds.pright = -this.bounds.pleft;
		}
		this.setBounds();
		this.setSteps();
		this.interval = setInterval(function() {
			self.animate();
		},
		20);
		self.animate(false, true);
	},
	setWrapperOffset: function() {
		this.offset.wrapper = MPosition.get(this.wrapper)[0];
	},
	setBounds: function() {
		this.bounds.left = this.bounds.pleft;
		this.bounds.right = this.bounds.pright + this.wrapper.offsetWidth;
		this.bounds.width = this.bounds.right - this.bounds.left;
		this.bounds.diff = this.bounds.width - this.handle.offsetWidth;
	},
	setSteps: function() {
		if (this.steps > 1) {
			this.stepsRatio = [];
			for (var i = 0; i <= this.steps - 1; i++) {
				this.stepsRatio[i] = i / (this.steps - 1);
			}
		}
	},
	disable: function() {
		this.disabled = true;
		this.handle.className += ' disabled';
	},
	enable: function() {
		this.disabled = false;
		this.handle.className = this.handle.className.replace(/\s?disabled/g, '');
	},
	handleMouseDownHandler: function(e) {
		this.startDrag(e);
		this.cancelEvent(e);
	},
	wrapperMouseDownHandler: function(e) {
		this.startTap();
	},
	documentMouseUpHandler: function(e) {
		this.stopDrag();
		this.stopTap();
	},
	startTap: function(target) {
		if (this.disabled) {
			return;
		}
		if (target === undefined) {
			target = Mouse.x - this.offset.wrapper - (this.handle.offsetWidth / 2);
		}
		this.setOffsetTarget(target);
		this.tapping = true;
	},
	stopTap: function() {
		if (this.disabled || !this.tapping) {
			return;
		}
		this.setOffsetTarget(this.offset.current);
		this.tapping = false;
		this.result();
	},
	startDrag: function(e) {
		if (!e) {
			e = window.event;
		}
		if (this.disabled) {
			return;
		}
		this.offset.mouse = Mouse.x - MPosition.get(this.handle)[0];
		this.dragging = true;
		if (e.preventDefault) e.preventDefault();
	},
	stopDrag: function() {
		if (this.disabled || !this.dragging) {
			return;
		}
		this.dragging = false;
		this.result();
	},
	feedback: function() {
		var value = this.value.current;
		if (this.steps > 1 && this.snapping) {
			value = this.getClosestStep(value);
		}
		if (value != this.value.prev) {
			if (typeof(this.animation_callback) == 'function') {
				this.animation_callback(value);
			}
			this.value.prev = value;
		}
	},
	result: function() {
		var value = this.value.target;
		if (this.steps > 1) {
			value = this.getClosestStep(value);
		}
		if (typeof(this.callback) == 'function') {
			this.callback(value);
		}
	},
	animate: function(onMove, first) {
		if (onMove && !this.dragging) {
			return;
		}
		if (this.dragging) {
			this.setOffsetTarget(Mouse.x - this.offset.mouse - this.offset.wrapper);
		}
		this.value.target = Math.max(this.value.target, 0);
		this.value.target = Math.min(this.value.target, 1);
		this.offset.target = this.getOffsetByRatio(this.value.target);
		if ((!this.dragging && !this.tapping) || this.snapping) {
			if (this.steps > 1) {
				this.setValueTarget(this.getClosestStep(this.value.target));
			}
		}
		if (this.dragging || first) {
			this.value.current = this.value.target;
		}
		this.slide();
		this.show();
		this.feedback();
	},
	slide: function() {
		if (this.value.target > this.value.current) {
			this.value.current += Math.min(this.value.target - this.value.current, this.speed / 100);
		} else if (this.value.target < this.value.current) {
			this.value.current -= Math.min(this.value.current - this.value.target, this.speed / 100);
		}
		if (!this.snapping) {
			this.offset.current = this.getOffsetByRatio(this.value.current);
		} else {
			this.offset.current = this.getOffsetByRatio(this.getClosestStep(this.value.current));
		}
	},
	show: function() {
		if (this.offset.current != this.offset.prev) {
			this.handle.style.left = String(this.offset.current) + 'px';
			this.offset.prev = this.offset.current;
		}
	},
	setValue: function(value, snap) {
		this.setValueTarget(value);
		if (snap) {
			this.value.current = this.value.target;
		}
	},
	setValueTarget: function(value) {
		this.value.target = value;
		this.offset.target = this.getOffsetByRatio(value);
	},
	setOffsetTarget: function(value) {
		this.offset.target = value;
		this.value.target = this.getRatioByOffset(value);
	},
	getRatioByOffset: function(offset) {
		return (offset - this.bounds.left) / this.bounds.diff;
	},
	getOffsetByRatio: function(ratio) {
		return Math.round(ratio * this.bounds.diff) + this.bounds.left;
	},
	getClosestStep: function(value) {
		var k = 0,
		min = 1;
		for (var i = 0; i <= this.steps - 1; i++) {
			if (Math.abs(this.stepsRatio[i] - value) < min) {
				min = Math.abs(this.stepsRatio[i] - value);
				k = i;
			}
		}
		return this.stepsRatio[k];
	},
	preventDefaults: function(e, selection) {
		if (!e) {
			e = window.event;
		}
		if (e.preventDefault) {
			e.preventDefault();
		}
		if (selection && document.selection) {
			document.selection.empty();
		}
	},
	cancelEvent: function(e) {
		if (!e) {
			e = window.event;
		}
		if (e.stopPropagation) {
			e.stopPropagation();
		} else {
			e.cancelBubble = true;
		}
	}
};
var h = void 0,
l = true,
o = null,
r = false;
function s() {
	return function() {};
}
var FLEXPAPER = window.FLEXPAPER = {},
v = 1,
aa = v;
FLEXPAPER.LogManager = function() {
	var g = [];
	return {
		addLogger: function(c) {
			g.push(c);
		},
		notify: function(c, d) {
			for (var e = 0,
			f = g.length; e < f; e++) {
				var t = g[e];
				if (t[c]) t[c](d);
			}
		}
	};
} ();
function A(g) {
	aa >= v && (E("Warning: " + g), FLEXPAPER.LogManager.notify("warn", g));
}
function E(g) {
	console && console.log ? console.log(arguments) : print && print(g);
}
function H(g) {
	E("Error: " + g);
	var c = E,
	d;
	try {
		throw Error();
	} catch(e) {
		d = e.stack ? e.stack.split("\n").slice(2).join("\n") : "";
	}
	c(d);
	FLEXPAPER.LogManager.notify("error", g);
	throw Error(g);
}
FLEXPAPER.Yd = {
	init: function() {
		if (typeof eb == "undefined" || !eb) eb = {};
		var g = navigator.userAgent.toLowerCase(),
		c = eb,
		d = /win/.test(g),
		e = /mac/.test(g),
		f;
		try {
			f = "ontouchstart" in document.documentElement;
		} catch(t) {
			f = r;
		}
		c.platform = {
			win: d,
			mac: e,
			touchdevice: f,
			ios: g.match(/iphone/i) || g.match(/ipod/i) || g.match(/ipad/i),
			Ed: g.indexOf("android") > -1,
			Nf: navigator.userAgent.match(/(iPad|iPhone);.*CPU.*OS 6_\d/i),
			Of: g.match(/iphone/i) || g.match(/ipod/i),
			ah: g.match(/ipad/i)
		};
		eb.browser = {
			version: (g.match(/.+?(?:rv|it|ra|ie)[\/: ]([\d.]+)(?!.+opera)/) || [])[1],
			safari: /webkit/.test(g) && !/chrome/.test(g),
			opera: /opera/.test(g),
			msie: /msie/.test(g) && !/opera/.test(g),
			mozilla: /mozilla/.test(g) && !/(compatible|webkit)/.test(g),
			chrome: /chrome/.test(g)
		};
		eb.browser.Oa = {
			Qa: !eb.platform.touchdevice || eb.platform.Nf && !window.annotations
		};
		if (eb.browser.msie) {
			var g = eb.browser,
			p;
			try { 
				/MSIE([0-9]{1,}[.0-9]{0,})/.exec(navigator.userAgent) != o && (rv = parseFloat(RegExp.$1)),p = rv;
			} catch(j) {
				p = -1;
			}
			g.version = p;
		}
		if (eb.platform.mac) p = function(c) {
			return (c.wheelDeltaX ? "x": c.axis && c.axis == c.HORIZONTAL_AXIS ? "x": "y") != "x";
		},
		typeof window.addEventListener != "undefined" && window.addEventListener("DOMMouseScroll", p, r),
		window.onmousewheel = document.onmousewheel = p;
		else {
			p = function(c) {
				return (c.wheelDeltaX ? "x": c.axis && c.axis == c.HORIZONTAL_AXIS ? "x": "y") != "x";
			};
			window.addEventListener && !eb.browser.msie && window.addEventListener("DOMMouseScroll", p, r);
			if (!eb.browser.msie) window.onmousewheel = document.onmousewheel = p;
			window.attachEvent && !eb.browser.msie && window.attachEvent("onmousewheel", p);
		}
	}
};
var I = "Portrait",
Q = "BookView",
R = "TwoPage",
ba = "FlipView",
T = "ThumbView";
function ca(g, c, d) {
	this.aa = g;
	this.xb = c;
	this.containerId = d;
	this.scroll = function() {
		var c = this;
		jQuery(this.xb).bind("mousedown",
		function(d) {
			return c.aa.Tb ? l: (c.lg(), c.ne = d.pageY, r);
		});
		jQuery(this.xb).bind("mousemove",
		function(d) {
			if (!c.be) return l;
			c.scrollTo(c.ne - d.pageY);
			c.ne = d.pageY;
			return r;
		});
		jQuery(this.xb).bind("mouseout",
		function() {
			c.Ae();
		});
		jQuery(this.xb).bind("mouseup",
		function() {
			c.Ae();
		});
	};
	this.lg = function() {
		this.be = l;
		jQuery(this.xb).removeClass("flexpaper_grab");
		jQuery(this.xb).addClass("flexpaper_grabbing");
	};
	this.Ae = function() {
		this.be = r;
		jQuery(this.xb).removeClass("flexpaper_grabbing");
		jQuery(this.xb).addClass("flexpaper_grab");
	};
	this.scrollTo = function(c) {
		c = jQuery(this.containerId).scrollTop() + c;
		jQuery(this.containerId).scrollTop(c);
	};
}
function U(g) {
	function c(c, d) {
		var e, f, t, g, j;
		t = c & 2147483648;
		g = d & 2147483648;
		e = c & 1073741824;
		f = d & 1073741824;
		j = (c & 1073741823) + (d & 1073741823);
		return e & f ? j ^ 2147483648 ^ t ^ g: e | f ? j & 1073741824 ? j ^ 3221225472 ^ t ^ g: j ^ 1073741824 ^ t ^ g: j ^ t ^ g;
	}
	function d(d, e, f, t, g, j, p) {
		d = c(d, c(c(e & f | ~e & t, g), p));
		return c(d << j | d >>> 32 - j, e);
	}
	function e(d, e, f, t, g, j, p) {
		d = c(d, c(c(e & t | f & ~t, g), p));
		return c(d << j | d >>> 32 - j, e);
	}
	function f(d, e, f, t, g, j, p) {
		d = c(d, c(c(e ^ f ^ t, g), p));
		return c(d << j | d >>> 32 - j, e);
	}
	function t(d, e, f, t, g, j, p) {
		d = c(d, c(c(f ^ (e | ~t), g), p));
		return c(d << j | d >>> 32 - j, e);
	}
	function p(c) {
		var d = "",
		e = "",
		f;
		for (f = 0; f <= 3; f++) e = c >>> f * 8 & 255,
		e = "0" + e.toString(16),
		d += e.substr(e.length - 2, 2);
		return d;
	}
	var j = [],
	u,
	z,
	w,
	y,
	m,
	q,
	k,
	n,
	g = function(c) {
		for (var c = c.replace(/\r\n/g, "\n"), d = "", e = 0; e < c.length; e++) {
			var f = c.charCodeAt(e);
			f < 128 ? d += String.fromCharCode(f) : (f > 127 && f < 2048 ? d += String.fromCharCode(f >> 6 | 192) : (d += String.fromCharCode(f >> 12 | 224), d += String.fromCharCode(f >> 6 & 63 | 128)), d += String.fromCharCode(f & 63 | 128));
		}
		return d;
	} (g),
	j = function(c) {
		var d, e = c.length;
		d = e + 8;
		for (var f = ((d - d % 64) / 64 + 1) * 16, t = Array(f - 1), g = 0, j = 0; j < e;) d = (j - j % 4) / 4,
		g = j % 4 * 8,
		t[d] |= c.charCodeAt(j) << g,
		j++;
		t[(j - j % 4) / 4] |= 128 << j % 4 * 8;
		t[f - 2] = e << 3;
		t[f - 1] = e >>> 29;
		return t;
	} (g);
	m = 1732584193;
	q = 4023233417;
	k = 2562383102;
	n = 271733878;
	for (g = 0; g < j.length; g += 16) u = m,
	z = q,
	w = k,
	y = n,
	m = d(m, q, k, n, j[g + 0], 7, 3614090360),
	n = d(n, m, q, k, j[g + 1], 12, 3905402710),
	k = d(k, n, m, q, j[g + 2], 17, 606105819),
	q = d(q, k, n, m, j[g + 3], 22, 3250441966),
	m = d(m, q, k, n, j[g + 4], 7, 4118548399),
	n = d(n, m, q, k, j[g + 5], 12, 1200080426),
	k = d(k, n, m, q, j[g + 6], 17, 2821735955),
	q = d(q, k, n, m, j[g + 7], 22, 4249261313),
	m = d(m, q, k, n, j[g + 8], 7, 1770035416),
	n = d(n, m, q, k, j[g + 9], 12, 2336552879),
	k = d(k, n, m, q, j[g + 10], 17, 4294925233),
	q = d(q, k, n, m, j[g + 11], 22, 2304563134),
	m = d(m, q, k, n, j[g + 12], 7, 1804603682),
	n = d(n, m, q, k, j[g + 13], 12, 4254626195),
	k = d(k, n, m, q, j[g + 14], 17, 2792965006),
	q = d(q, k, n, m, j[g + 15], 22, 1236535329),
	m = e(m, q, k, n, j[g + 1], 5, 4129170786),
	n = e(n, m, q, k, j[g + 6], 9, 3225465664),
	k = e(k, n, m, q, j[g + 11], 14, 643717713),
	q = e(q, k, n, m, j[g + 0], 20, 3921069994),
	m = e(m, q, k, n, j[g + 5], 5, 3593408605),
	n = e(n, m, q, k, j[g + 10], 9, 38016083),
	k = e(k, n, m, q, j[g + 15], 14, 3634488961),
	q = e(q, k, n, m, j[g + 4], 20, 3889429448),
	m = e(m, q, k, n, j[g + 9], 5, 568446438),
	n = e(n, m, q, k, j[g + 14], 9, 3275163606),
	k = e(k, n, m, q, j[g + 3], 14, 4107603335),
	q = e(q, k, n, m, j[g + 8], 20, 1163531501),
	m = e(m, q, k, n, j[g + 13], 5, 2850285829),
	n = e(n, m, q, k, j[g + 2], 9, 4243563512),
	k = e(k, n, m, q, j[g + 7], 14, 1735328473),
	q = e(q, k, n, m, j[g + 12], 20, 2368359562),
	m = f(m, q, k, n, j[g + 5], 4, 4294588738),
	n = f(n, m, q, k, j[g + 8], 11, 2272392833),
	k = f(k, n, m, q, j[g + 11], 16, 1839030562),
	q = f(q, k, n, m, j[g + 14], 23, 4259657740),
	m = f(m, q, k, n, j[g + 1], 4, 2763975236),
	n = f(n, m, q, k, j[g + 4], 11, 1272893353),
	k = f(k, n, m, q, j[g + 7], 16, 4139469664),
	q = f(q, k, n, m, j[g + 10], 23, 3200236656),
	m = f(m, q, k, n, j[g + 13], 4, 681279174),
	n = f(n, m, q, k, j[g + 0], 11, 3936430074),
	k = f(k, n, m, q, j[g + 3], 16, 3572445317),
	q = f(q, k, n, m, j[g + 6], 23, 76029189),
	m = f(m, q, k, n, j[g + 9], 4, 3654602809),
	n = f(n, m, q, k, j[g + 12], 11, 3873151461),
	k = f(k, n, m, q, j[g + 15], 16, 530742520),
	q = f(q, k, n, m, j[g + 2], 23, 3299628645),
	m = t(m, q, k, n, j[g + 0], 6, 4096336452),
	n = t(n, m, q, k, j[g + 7], 10, 1126891415),
	k = t(k, n, m, q, j[g + 14], 15, 2878612391),
	q = t(q, k, n, m, j[g + 5], 21, 4237533241),
	m = t(m, q, k, n, j[g + 12], 6, 1700485571),
	n = t(n, m, q, k, j[g + 3], 10, 2399980690),
	k = t(k, n, m, q, j[g + 10], 15, 4293915773),
	q = t(q, k, n, m, j[g + 1], 21, 2240044497),
	m = t(m, q, k, n, j[g + 8], 6, 1873313359),
	n = t(n, m, q, k, j[g + 15], 10, 4264355552),
	k = t(k, n, m, q, j[g + 6], 15, 2734768916),
	q = t(q, k, n, m, j[g + 13], 21, 1309151649),
	m = t(m, q, k, n, j[g + 4], 6, 4149444226),
	n = t(n, m, q, k, j[g + 11], 10, 3174756917),
	k = t(k, n, m, q, j[g + 2], 15, 718787259),
	q = t(q, k, n, m, j[g + 9], 21, 3951481745),
	m = c(m, u),
	q = c(q, z),
	k = c(k, w),
	n = c(n, y);
	return (p(m) + p(q) + p(k) + p(n)).toLowerCase();
}
String.format = function() {
	for (var g = arguments[0], c = 0; c < arguments.length - 1; c++) g = g.replace(RegExp("\\{" + c + "\\}", "gm"), arguments[c + 1]);
	return g;
};
jQuery.fn.Qg = function(g, c) {
	return this.each(function() {
		jQuery(this).fadeIn(g,
		function() {
			eb.browser.msie && $(this).get(0).style.removeAttribute("filter");
			typeof eval(c) == "function" && eval(c)();
		});
	});
};
jQuery.fn.vf = function(g) {
	this.each(function() {
		eb.browser.msie ? eval(g)() : jQuery(this).fadeOut(400,
		function() {
			eb.browser.msie && $(this).get(0).style.removeAttribute("filter");
			typeof eval(g) == "function" && eval(g)();
		});
	});
};
jQuery.fn.bh = function(g, c) {
	if (jQuery.fn.jquery.indexOf("1.8") >= 0) {
		try {
			if (jQuery._data(this[0], "events") === h) return r;
		} catch(d) {
			return r;
		}
		var e = jQuery._data(this[0], "events")[g];
		if (e === h || e.length === 0) return r;
		var f = 0;
	} else {
		if (this.data("events") === h) return r;
		e = this.data("events")[g];
		if (e === h || e.length === 0) return r;
		f = 0;
	}
	for (; f < e.length; f++) if (e[f].handler == c) return l;
	return r;
};
jQuery.fn.Ih = function(g) {
	if (this.data("events") === h) return r;
	var c = this.data("events")[g];
	if (c === h || c.length === 0) return r;
	for (var d = 0; d < c.length; d++) jQuery(this).unbind(g, c[d].handler);
	return r;
};
jQuery.fn.ih = function() {
	eb.browser.Oa.Qa ? this.scrollTo(ce, 0, {
		axis: "xy",
		offset: -30
	}) : this.data("jsp").scrollToElement(ce, r);
};
Array.prototype.remove = function(g) {
	for (var c = 0; c < this.length;) this[c] === g ? this.splice(c, 1) : ++c;
};
jQuery.fn.nh = function(g, c) {
	this.css({
		width: 0,
		height: 0,
		"border-bottom": String.format("{0}px solid transparent", g),
		"border-top": String.format("{0}px solid transparent", g),
		"border-right": String.format("{0}px solid {1}", g, c),
		"font-size": "0px",
		"line-height": "0px",
		cursor: "pointer"
	});
	this.on("mouseover",
	function(c) {
		jQuery(c.target).css({
			"border-right": String.format("{0}px solid {1}", g, "#DEDEDE")
		});
	});
	this.on("mouseout",
	function(d) {
		jQuery(d.target).css({
			"border-right": String.format("{0}px solid {1}", g, c)
		});
	});
};
jQuery.fn.oh = function(g, c) {
	this.css({
		width: 0,
		height: 0,
		"border-bottom": String.format("{0}px solid transparent", g),
		"border-top": String.format("{0}px solid transparent", g),
		"border-left": String.format("{0}px solid {1}", g, c),
		"font-size": "0px",
		"line-height": "0px",
		cursor: "pointer"
	});
	this.on("mouseover",
	function(c) {
		jQuery(c.target).css({
			"border-left": String.format("{0}px solid {1}", g, "#DEDEDE")
		});
	});
	this.on("mouseout",
	function(d) {
		jQuery(d.target).css({
			"border-left": String.format("{0}px solid {1}", g, c)
		});
	});
};
jQuery.fn.Yg = function() {
	var g = this.css("transform");
	if (g && g != "none") {
		if (g.translate != "0px,0px") return l;
		if (parseFloat(g.scale) != 1) return l;
	}
	return r;
};
jQuery.fn.spin = function(g) {
	this.each(function() {
		var c = jQuery(this),
		d = c.data();
		d.yd && (d.yd.stop(), delete d.yd);
		if (g !== r) d.yd = (new Spinner(jQuery.extend({
			color: c.css("color")
		},
		g))).spin(this);
	});
	return this;
};
jQuery.Xd = function(g, c, d) {
	g = g.offset();
	return {
		x: Math.floor(c - g.left),
		y: Math.floor(d - g.top)
	};
};
jQuery.fn.Xd = function(g, c) {
	return jQuery.Xd(this.first(), g, c);
}; (function(g) {
	g.fn.moveTo = function(c) {
		return this.each(function() {
			var d = g(this).clone();
			g(d).appendTo(c);
			g(this).remove();
		});
	};
})(jQuery);
var ImagePageRenderer = window.ImagePageRenderer = function() {
	function g(c, d, e) {
		this.ga = c;
		this.config = d;
		this.ec = d.jsonfile;
		this.jsDirectory = e;
		this.pageImagePattern = d.pageImagePattern;
		this.pageThumbImagePattern = d.pageThumbImagePattern;
		this.pageSVGImagePattern = d.pageSVGImagePattern;
		this.kh = d.pageHighResImagePattern;
		this.JSONPageDataFormat = this.Ma = this.dimensions = o;
		this.Na = d.compressedJSONFormat != o ? d.compressedJSONFormat: l;
		this.ra = o;
		this.Ua = "pageLoader_[pageNumber]";
		this.nb = "data:image/gif;base64,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%3D%3D";
		this.bb = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
		this.pa = -1;
		this.La = o;
		this.cc = r;
		this.wc = l;
		this.Ec = d.SVGMode;
	}
	g.prototype = {
		yb: function() {
			return "ImagePageRenderer";
		},
		za: function(c) {
			return c.aa.ha ? c.aa.ha.sa: "";
		},
		Fa: function(c) {
			return c.aa.ha.$g;
		},
		initialize: function(c) {
			var d = this;
			d.Ac = c;
			d.JSONPageDataFormat = d.Na ? {
				Qb: "width",
				Pb: "height",
				Gb: "text",
				Hb: "d",
				Fc: "f",
				pc: "l",
				rc: "t",
				tc: "w",
				oc: "h"
			}: {
				Qb: d.config.JSONPageDataFormat.pageWidth,
				Pb: d.config.JSONPageDataFormat.pageHeight,
				Gb: d.config.JSONPageDataFormat.textCollection,
				Hb: d.config.JSONPageDataFormat.textFragment,
				Fc: d.config.JSONPageDataFormat.textFont,
				pc: d.config.JSONPageDataFormat.textLeft,
				rc: d.config.JSONPageDataFormat.textTop,
				tc: d.config.JSONPageDataFormat.textWidth,
				oc: d.config.JSONPageDataFormat.textHeight
			};
			jQuery.ajaxSetup({
				cache: r
			});
			d.La = new V(d.ga, d.Na, d.JSONPageDataFormat, l);
			jQuery.ajaxPrefilter(function(c, d, e) {
				if (c.onreadystatechange) {
					var g = c.xhr;
					c.xhr = function() {
						function d() {
							c.onreadystatechange(t, e);
						}
						var t = g.apply(this, arguments);
						t.addEventListener ? t.addEventListener("readystatechange", d, r) : setTimeout(function() {
							var c = t.onreadystatechange;
							if (c) t.onreadystatechange = function() {
								d();
								c.apply(this, arguments);
							};
						},
						0);
						return t;
					};
				}
			});
			if (!eb.browser.msie) {
				var e = jQuery.ajaxSettings.xhr;
				jQuery.ajaxSettings.xhr = function() {
					return e();
				};
			}
			jQuery("#" + d.ga).trigger("onDocumentLoading");
			c = document.createElement("a");
			c.href = d.ec;
			c.search += c.search.length > 0 ? "&": "?";
			c.search += "callback=?";
			d.Kg = r;
			d.ec.indexOf("{page}") > 0 ? (d.$a = l, jQuery.ajax({
				url: d.xc(10),
				dataType: d.config.JSONDataType,
				success: function(c) {
					if (c.length > 0) {
						d.ra = Array(c[0].pages);
						for (var e = 0; e < c.length; e++) d.ra[e] = c[e],
						d.ra[e].loaded = l;
						for (e = 0; e < d.ra.length; e++) if (d.ra[e] == o) d.ra[e] = [],
						d.ra[e].loaded = r;
						d.Ac();
						d.La.Cc(c);
					}
				},
				error: function(c) {
					H("Error loading JSON file (" + c.statusText + "). Please check your configuration.");
				}
			})) : jQuery.ajax({
				url: d.ec,
				dataType: d.config.JSONDataType,
				success: function(c) {
					for (var e = 0; e < c.length; e++) c[e].loaded = l;
					d.ra = c;
					d.Ac();
					d.La.Cc(c);
				},
				onreadystatechange: s(),
				error: function(c) {
					H("Error loading JSON file (" + c.statusText + "). Please check your configuration.");
				}
			});
		},
		getDimensions: function(c, d) {
			var e = this.ra.length;
			c == o && (c = 0);
			d == o && (d = e);
			if (this.dimensions == o || d && c) {
				if (this.dimensions == o) this.dimensions = [],
				this.Ma = [];
				for (e = c; e < d; e++) if (this.ra[e].loaded) {
					if (this.dimensions[e] = [], this.ue(e), this.Wa == o) this.Wa = this.dimensions[e];
				} else if (this.Wa != o) this.dimensions[e] = [],
				this.dimensions[e].page = e,
				this.dimensions[e].loaded = r,
				this.dimensions[e].width = this.Wa.width,
				this.dimensions[e].height = this.Wa.height,
				this.dimensions[e].xa = this.Wa.xa,
				this.dimensions[e].Da = this.Wa.Da;
			}
			return this.dimensions;
		},
		ue: function(c) {
			this.dimensions[c].page = c;
			this.dimensions[c].loaded = l;
			this.dimensions[c].width = this.ra[c][this.JSONPageDataFormat.Qb];
			this.dimensions[c].height = this.ra[c][this.JSONPageDataFormat.Pb];
			this.dimensions[c].xa = this.dimensions[c].width;
			this.dimensions[c].Da = this.dimensions[c].height;
			this.Ma[c] = [];
			this.Ma[c] = "";
			if (this.dimensions[c].width > 900) this.dimensions[c].width = 918,
			this.dimensions[c].height = 1188;
			for (var d = 0,
			e; e = this.ra[c][this.JSONPageDataFormat.Gb][d++];) this.Ma[c] += this.Na ? e[5] : e[this.JSONPageDataFormat.Hb];
			this.Ma[c] = this.Ma[c].toLowerCase();
		},
		Zc: function(c) {
			if (c.ba == I || c.ba == "SinglePage") c.da(c.oa).addClass("flexpaper_hidden"),
			this.Ec ? c.da(c.qa).append("<object data='" + this.bb + "' type='image/svg+xml' id='" + c.page + "' class='flexpaper_interactivearea flexpaper_border flexpaper_grab flexpaper_hidden flexpaper_rescale' style='" + c.getDimensions() + "' /></div>") : c.da(c.qa).append("<img alt='' src='" + this.bb + "' id='" + c.page + "' class='flexpaper_interactivearea flexpaper_border flexpaper_grab flexpaper_hidden flexpaper_rescale' style='" + c.getDimensions() + ";background-size:cover;' />");
			c.ba == T && jQuery(c.oa).append("<img src='" + this.bb + "' alt='" + this.Ba(c.pageNumber + 1) + "'  id='" + c.page + "' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden' style='" + c.getDimensions() + "'/>");
			c.ba == this.za(c) && this.Fa(c).Zc(this, c);
			if (c.ba == R || c.ba == Q) c.pageNumber == 0 && (jQuery(c.oa + "_1").append("<img id='" + c.Ua + "_1' class='flexpaper_pageLoader' src='" + this.nb + "' style='position:absolute;left:50%;top:" + c.gb() / 4 + "px;margin-left:-32px;' />"), jQuery(c.oa + "_1").append("<img src='" + this.bb + "' alt='" + this.Ba(c.pageNumber + 1) + "'  id='" + c.page + "' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden flexpaper_load_on_demand' style='" + c.getDimensions() + ";position:absolute;background-size:cover;'/>"), jQuery(c.oa + "_1").append("<div id='" + c.fb + "_1_textoverlay' style='position:relative;left:0px;top:0px;width:100%;height:100%;'></div>")),
			c.pageNumber == 1 && (jQuery(c.oa + "_2").append("<img id='" + c.Ua + "_2' class='flexpaper_pageLoader' src='" + this.nb + "' style='position:absolute;left:50%;top:" + c.gb() / 4 + "px;margin-left:-32px;' />"), jQuery(c.oa + "_2").append("<img src='" + this.bb + "' alt='" + this.Ba(c.pageNumber + 1) + "'  id='" + c.page + "' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden flexpaper_load_on_demand' style='" + c.getDimensions() + ";position:absolute;left:0px;top:0px;background-size:cover;'/>"), jQuery(c.oa + "_2").append("<div id='" + c.fb + "_2_textoverlay' style='position:absolute;left:0px;top:0px;width:100%;height:100%;'></div>"));
		},
		xc: function(c) {
			return this.ec.replace("{page}", c);
		},
		Ba: function(c, d, e) {
			return ! e || e && !this.pageSVGImagePattern ? d ? this.pageThumbImagePattern != o && this.pageThumbImagePattern.length > 0 ? this.pageThumbImagePattern.indexOf("?") > 0 ? this.pageThumbImagePattern.replace("{page}", c) + "&resolution=" + d: this.pageThumbImagePattern.replace("{page}", c) + "?resolution=" + d: this.pageImagePattern.indexOf("?") > 0 ? this.pageImagePattern.replace("{page}", c) + "&resolution=" + d: this.pageImagePattern.replace("{page}", c) + "?resolution=" + d: this.pageImagePattern.replace("{page}", c) : d ? this.pageThumbImagePattern != o && this.pageThumbImagePattern.length > 0 ? this.pageThumbImagePattern.replace("{page}", c) : this.pageSVGImagePattern.indexOf("?") > 0 ? this.pageSVGImagePattern.replace("{page}", c) + "&resolution=" + d: this.pageSVGImagePattern.replace("{page}", c) + "?resolution=" + d: this.pageSVGImagePattern.replace("{page}", c);
		},
		Sc: function(c) {
			return c + (10 - c % 10);
		},
		$c: function(c, d, e) {
			var f = this;
			if (f.ob != f.Sc(c)) f.ob = f.Sc(c),
			jQuery.ajax({
				url: f.xc(f.ob),
				dataType: f.config.JSONDataType,
				async: d,
				success: function(c) {
					if (c.length > 0) {
						for (var d = 0; d < c.length; d++) {
							var g = parseInt(c[d].number) - 1;
							f.ra[g] = c[d];
							f.ra[g].loaded = l;
							f.ue(g);
						}
						f.La.Cc(f.ra);
						jQuery(f).trigger("onTextDataUpdated");
						e != o && e();
					}
					f.ob = o;
				},
				error: function(c) {
					H("Error loading JSON file (" + c.statusText + "). Please check your configuration.");
					f.ob = o;
				}
			});
		},
		Db: function(c, d, e) {
			var f = this;
			if (! (c.Ja && c.ba != f.za(c))) if (c.ba != f.za(c) && f.pa > -1) window.clearTimeout(c.jc),
			c.jc = setTimeout(function() {
				f.Db(c, d, e);
			},
			250);
			else {
				c.dimensions.loaded || f.$c(c.pageNumber + 1, l,
				function() {
					f.Kb(c);
				});
				if (c.ba == I || c.ba == T) {
					if (!c.Ja && (jQuery(c.ua).attr("src") == f.bb || f.Ec) && !c.Wc) f.pa = c.pageNumber,
					c.nc(),
					f.Ga = new Image,
					jQuery(f.Ga).bind("load",
					function() {
						c.Wc = l;
						c.od = this.height;
						c.pd = this.width;
						f.mc(c);
						if (c.dimensions.xa > c.dimensions.width) c.dimensions.width = c.dimensions.xa,
						c.dimensions.height = c.dimensions.Da,
						(c.ba == I || c.ba == "SinglePage") && c.Va();
					}).bind("error",
					function() {
						H("Error loading image (" + this.src + ")");
					}),
					jQuery(f.Ga).bind("error",
					function() {
						f.pa = -1;
					}),
					jQuery(f.Ga).attr("src", f.Ba(c.pageNumber + 1, c.ba == T ? 200 : o)); ! c.Ja && jQuery(c.ua).attr("src") == f.bb && c.Wc && f.mc(c);
					e != o && e();
				}
				c.ba == f.za(c) && f.Fa(c).Db(f, c, d, e);
				if (c.ba == "SinglePage") {
					if (!c.gc) c.nc(),
					c.gc = l;
					if (c.pageNumber == 0) f.pa = c.ca.ja,
					f.Ga = new Image,
					jQuery(f.Ga).bind("load",
					function() {
						c.Wc = l;
						c.od = this.height;
						c.pd = this.width;
						c.lb();
						f.mc(c);
						if (c.dimensions.xa > c.dimensions.width) c.dimensions.width = c.dimensions.xa,
						c.dimensions.height = c.dimensions.Da,
						c.Va();
						c.Ja = l;
						f.pa = -1;
					}),
					jQuery(f.Ga).bind("error",
					function() {
						c.lb();
						f.pa = -1;
					}),
					jQuery(f.Ga).attr("src", f.Ba(c.ca.ja + 1)),
					jQuery(c.oa + "_1").removeClass("flexpaper_load_on_demand"),
					e != o && e();
				}
				if (c.ba == R || c.ba == Q) {
					if (!c.gc) c.nc(),
					c.gc = l;
					if (c.pageNumber == 0) {
						jQuery(c.ua);
						if (c.ba == Q) f.pa = c.ca.ja != 0 ? c.ca.ja: c.ca.ja + 1;
						else if (c.ba == R) f.pa = c.ca.ja;
						f.Ga = new Image;
						jQuery(f.Ga).bind("load",
						function() {
							c.Wc = l;
							c.od = this.height;
							c.pd = this.width;
							c.lb();
							f.mc(c);
							if (c.dimensions.xa > c.dimensions.width) c.dimensions.width = c.dimensions.xa,
							c.dimensions.height = c.dimensions.Da,
							c.Va();
							c.Ja = l;
							f.pa = -1;
						});
						jQuery(f.Ga).bind("error",
						function() {
							c.lb();
							f.pa = -1;
						});
						c.ba == Q && jQuery(f.Ga).attr("src", f.Ba(c.ca.ja != 0 ? c.ca.ja: c.ca.ja + 1));
						c.ba == R && jQuery(f.Ga).attr("src", f.Ba(c.ca.ja + 1));
						jQuery(c.oa + "_1").removeClass("flexpaper_load_on_demand");
						e != o && e();
					} else if (c.pageNumber == 1) {
						var g = jQuery(c.ua);
						c.ca.ja + 1 > c.ca.getTotalPages() ? g.attr("src", "") : (c.ca.ja != 0 || c.ba == R ? (f.pa = c.ca.ja + 1, f.Ga = new Image, jQuery(f.Ga).bind("load",
						function() {
							c.lb();
							f.mc(c);
							if (c.dimensions.xa > c.dimensions.width) c.dimensions.width = c.dimensions.xa,
							c.dimensions.height = c.dimensions.Da;
							c.Ja = l;
							f.pa = -1;
						}), jQuery(f.Ga).bind("error",
						function() {
							f.pa = -1;
							c.lb();
						})) : c.lb(), c.ba == Q && jQuery(f.Ga).attr("src", f.Ba(c.ca.ja + 1)), c.ba == R && jQuery(f.Ga).attr("src", f.Ba(c.ca.ja + 2)), c.ca.ja > 1 && jQuery(c.oa + "_2").removeClass("flexpaper_hidden"), jQuery(c.oa + "_2").removeClass("flexpaper_load_on_demand"));
						e != o && e();
					}
				}
			}
		},
		mc: function(c) {
			if (c.ba == I && (Math.round(c.pd / c.od * 100) != Math.round(c.dimensions.width / c.dimensions.height * 100) || this.Ec)) this.Ec ? (jQuery(c.ua).attr("data", this.Ba(c.pageNumber + 1, o, l)), jQuery(c.oa).removeClass("flexpaper_load_on_demand"), jQuery(c.ua).css("width", jQuery(c.ua).css("width"))) : (jQuery(c.ua).css("background-image", "url(" + this.Ba(c.pageNumber + 1) + ")"), jQuery(c.ua).attr("src", this.bb)),
			jQuery("#" + c.Ua).hide(),
			c.Ja = l;
			else if (c.ba == this.za(c)) this.Fa(c).mc(this, c);
			else {
				if (c.ba == R || c.ba == Q) {
					if (c.pageNumber == 0) {
						var d = c.ba == Q ? c.ca.ja != 0 ? c.ca.ja: c.ca.ja + 1 : c.ca.ja + 1;
						if (c.wd != d) eb.browser.msie ? jQuery(c.ua).attr("src", this.Ba(d)) : jQuery(c.ua).css("background-image", "url(" + this.Ba(d) + ")"),
						jQuery(c.oa + "_1").removeClass("flexpaper_hidden"),
						c.wd = d;
						jQuery(c.ua).removeClass("flexpaper_hidden");
					}
					if (c.pageNumber == 1) {
						d = c.ba == Q ? c.ca.ja + 1 : c.ca.ja + 2;
						if (c.wd != d) eb.browser.msie ? jQuery(c.ua).attr("src", this.Ba(d)) : jQuery(c.ua).css("background-image", "url(" + this.Ba(d) + ")"),
						c.wd = d,
						c.ba == R && jQuery(c.oa + "_2").removeClass("flexpaper_hidden");
						jQuery(c.ua).removeClass("flexpaper_hidden");
					}
				} else c.ba == "SinglePage" ? jQuery(c.ua).attr("src", this.Ba(this.pa + 1)) : this.Ec ? (jQuery(c.ua).attr("data", this.Ba(c.pageNumber + 1, o, l)), jQuery(c.oa).removeClass("flexpaper_load_on_demand")) : jQuery(c.ua).attr("src", this.Ba(c.pageNumber + 1)),
				jQuery("#" + c.Ua).hide();
				c.Ja = l;
			}
			this.pa = -1;
			if (!this.cc) this.cc = l,
			window.$FlexPaper(this.ga).ud();
		},
		unload: function(c) {
			jQuery(c.oa).addClass("flexpaper_load_on_demand");
			var d = o;
			if (c.ba == I || c.ba == T || c.ba == "SinglePage") d = jQuery("#" + c.Ua).next();
			if (c.ba == R || c.ba == Q) d = jQuery(c.ua),
			jQuery(c.ua).addClass("flexpaper_hidden");
			c.ba == this.za(c) && this.Fa(c).unload(this, c);
			d != o && d.length > 0 && (d.attr("alt", d.attr("src")), d.attr("src", "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"));
			c.gc = r;
			jQuery(".flexpaper_pageword_" + this.ga + "_page_" + c.pageNumber).remove();
			c.vd && c.vd();
			jQuery(".flexpaper_annotation_" + this.ga + "_page_" + c.pageNumber).remove();
		},
		getNumPages: function() {
			return this.ra.length;
		},
		Kb: function(c, d, e, f) {
			this.La.Kb(c, d, e, f);
		},
		Ya: function(c, d, e) {
			this.La.Ya(c, d, e);
		},
		Aa: function(c, d, e) {
			this.La.Aa(c, e);
		}
	};
	return g;
} (),
CanvasPageRenderer = window.CanvasPageRenderer = function() {
	function g(c, d, e, f) {
		this.ga = c;
		this.file = d;
		this.jsDirectory = e;
		this.ib = r;
		this.JSONPageDataFormat = this.ya = this.dimensions = o;
		this.pageThumbImagePattern = f.pageThumbImagePattern;
		this.config = f;
		this.Oc = "dummyPageCanvas_[pageNumber]";
		this.hd = "#" + this.Oc;
		this.Pc = "dummyPageCanvas2_[pageNumber]";
		this.jd = "#" + this.Pc;
		this.Ra = [];
		this.context = this.pb = o;
		this.Ia = [];
		this.spacedTextList = [];
		this.nb = "data:image/gif;base64,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%3D%3D";
		this.wc = this.cc = r;
		this.bb = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
		this.ad = 1;
		this.Ma = [];
		this.bd = {};
		this.JSONPageDataFormat = o;
		this.Na = f.compressedJSONFormat != o ? f.compressedJSONFormat: l;
	}
	g.prototype = {
		yb: function() {
			return "CanvasPageRenderer";
		},
		za: function(c) {
			return c.aa.ha ? c.aa.ha.sa: "";
		},
		Fa: function(c) {
			return c.aa.ha.Mg;
		},
		initialize: function(c) {
			var d = this;
			d.Ac = c;
			d.le = (d.jsDirectory != "undefined" && this.jsDirectory != o ? d.jsDirectory: "js/") + "pdf.min.js";
			d.JSONPageDataFormat = d.Na ? {
				Qb: "width",
				Pb: "height",
				Gb: "text",
				Hb: "d",
				Fc: "f",
				pc: "l",
				rc: "t",
				tc: "w",
				oc: "h"
			}: {
				Qb: d.config.JSONPageDataFormat.pageWidth,
				Pb: d.config.JSONPageDataFormat.pageHeight,
				Gb: d.config.JSONPageDataFormat.textCollection,
				Hb: d.config.JSONPageDataFormat.textFragment,
				Fc: d.config.JSONPageDataFormat.textFont,
				pc: d.config.JSONPageDataFormat.textLeft,
				rc: d.config.JSONPageDataFormat.textTop,
				tc: d.config.JSONPageDataFormat.textWidth,
				oc: d.config.JSONPageDataFormat.textHeight
			};
			d.$a = d.file.indexOf("[*,") >= 0 && d.config && d.config.jsonfile != o;
			jQuery.getScript(d.le,
			function() {
				jQuery("#" + d.ga).trigger("onDocumentLoading");
				PDFJS.disableWorker = eb.platform.ios;
				PDFJS.workerSrc = d.le;
				if (d.file.indexOf("[*,") == -1) PDFJS.getDocument(d.file).then(function(c) {
					d.pdf = d.ya = c;
					d.ib = l;
					d.dimensions = o;
					d.Ra = Array(d.ya.numPages);
					d.dimensions = [];
					d.ya.getDestinations().then(function(c) {
						d.destinations = c;
					});
					d.ya.getPage(1).then(function(c) {
						c = c.getViewport(1);
						for (i = 1; i <= d.ya.numPages; i++) d.dimensions[i - 1] = [],
						d.dimensions[i - 1].page = i - 1,
						d.dimensions[i - 1].width = c.width,
						d.dimensions[i - 1].height = c.height,
						d.dimensions[i - 1].xa = c.width,
						d.dimensions[i - 1].Da = c.height;
						d.gd = l;
						d.Ac();
					});
					d.ze(d.ya);
				},
				function(c) {
					H("Cannot load PDF file (" + c + ")");
					jQuery(d).trigger("loadingProgress", {
						ga: d.ga,
						progress: "Error"
					});
				},
				s(),
				function(c) {
					jQuery(d).trigger("loadingProgress", {
						ga: d.ga,
						progress: Math.round(c.loaded / c.total * 100) + "%"
					});
				});
				else if (d.file.indexOf("[*,") >= 0 && d.config && d.config.jsonfile != o) d.$a = l,
				d.ec = d.config.jsonfile,
				jQuery.ajax({
					url: d.xc(10),
					dataType: d.config.JSONDataType,
					success: function(c) {
						if (c.length > 0) {
							d.ra = Array(c[0].pages);
							for (var f = 0; f < c.length; f++) d.ra[f] = c[f],
							d.ra[f].loaded = l,
							d.we(f);
							for (f = 0; f < d.ra.length; f++) if (d.ra[f] == o) d.ra[f] = [],
							d.ra[f].loaded = r;
							d.La.Cc(d.ra);
						}
						d.Lb = 1;
						d.ya = Array(c[0].pages);
						d.Ra = Array(c[0].pages);
						d.ee(d.Lb,
						function() {
							d.Ac();
						});
					},
					error: function(c) {
						H("Error loading JSON file (" + c.statusText + "). Please check your configuration.");
					}
				});
			});
			d.JSONPageDataFormat = {
				Qb: "width",
				Pb: "height",
				Gb: "text",
				Hb: "d",
				Fc: "f",
				pc: "l",
				rc: "t",
				tc: "w",
				oc: "h"
			};
			d.La = new V(d.ga, d.$a, d.JSONPageDataFormat, l);
			window["wordPageList_" + d.ga] = d.La.Ia;
		},
		ee: function(c, d) {
			var e = this;
			PDFJS.getDocument(e.rf(c)).then(function(f) {
				e.ya[c - 1] = f;
				e.ib = l;
				if (!e.dimensions) e.dimensions = [];
				e.ya[c - 1].getDestinations().then(function(c) {
					e.destinations = c;
				});
				e.ya[c - 1].getPage(1).then(function(f) {
					var g = f.getViewport(1);
					for (i = 1; i <= e.ya[c - 1].numPages; i++) {
						e.dimensions[i - 1] = [];
						e.dimensions[i - 1].loaded = l;
						e.dimensions[i - 1].page = i - 1;
						e.dimensions[i - 1].width = g.width;
						e.dimensions[i - 1].height = g.height;
						e.dimensions[i - 1].xa = g.width;
						e.dimensions[i - 1].Da = g.height;
						if (e.wa[i - 1] != o) e.dimensions[i - 1].Vb = e.wa[i].Vb,
						e.dimensions[i - 1].Ub = e.wa[i].Ub,
						e.dimensions[i - 1].Ib = e.wa[i].Ib,
						e.dimensions[i - 1].uc = e.wa[i].uc;
						e.bd[c - 1 + " " + f.ref.gen + " R"] = c - 1;
					}
					e.gd = l;
					e.Lb = -1;
					d && d();
				});
				e.Lb = -1;
			},
			function(c) {
				H("Cannot load PDF file (" + c + ")");
				jQuery(e).trigger("loadingProgress", {
					ga: e.ga,
					progress: "Error"
				});
				e.Lb = -1;
			},
			s(),
			function(c) {
				jQuery(e).trigger("loadingProgress", {
					ga: e.ga,
					progress: Math.round(c.loaded / c.total * 100) + "%"
				});
			});
		},
		xc: function(c) {
			return this.ec.replace("{page}", c);
		},
		rf: function(c) {
			if (this.file.indexOf("{page}") >= 0) return this.file.replace("{page}", c);
			if (this.file.indexOf("[*,") >= 0) {
				var d = this.file.substr(this.file.indexOf("[*,"), this.file.indexOf("]") - this.file.indexOf("[*,") + 1),
				e = parseInt(d.substr(d.indexOf(",") + 1, d.indexOf("]") - 2)),
				f = "0";
				c += "";
				var g = c;
				if (f == o || f.length < 1) f = " ";
				if (c.length < e) {
					for (var g = "",
					p = 0; p < e - c.length; p++) g += f;
					g += c;
				}
				return this.file.replace(d, g);
			}
		},
		Sc: function(c) {
			return c + (10 - c % 10);
		},
		$c: function(c, d, e) {
			var f = this;
			f.ob = f.Sc(c);
			jQuery.ajax({
				url: f.xc(f.ob),
				dataType: f.config.JSONDataType,
				async: d,
				success: function(c) {
					if (c.length > 0) {
						for (var d = 0; d < c.length; d++) {
							var g = parseInt(c[d].number) - 1;
							f.ra[g] = c[d];
							f.ra[g].loaded = l;
							f.Rf(g);
							f.we(g);
						}
						f.La.Cc(f.ra);
						jQuery(f).trigger("onTextDataUpdated");
						e != o && e();
					}
					f.ob = o;
				},
				error: function(c) {
					H("Error loading JSON file (" + c.statusText + "). Please check your configuration.");
					f.ob = o;
				}
			});
		},
		we: function(c) {
			if (!this.wa) this.wa = [];
			this.wa[c] || (this.wa[c] = []);
			this.wa[c].Vb = this.ra[c][this.JSONPageDataFormat.Qb];
			this.wa[c].Ub = this.ra[c][this.JSONPageDataFormat.Pb];
			this.wa[c].Ib = this.wa[c].Vb;
			this.wa[c].uc = this.wa[c].Ub;
			for (var c = this.wa[c], d = 0; d < this.getNumPages(); d++) if (this.wa[d] == o) this.wa[d] = [],
			this.wa[d].Vb = c.Vb,
			this.wa[d].Ub = c.Ub,
			this.wa[d].Ib = c.Ib,
			this.wa[d].uc = c.uc;
		},
		getDimensions: function() {
			var c = this;
			if (c.dimensions == o || c.gd || c.dimensions != o && c.dimensions.length == 0) {
				if (c.dimensions == o) c.dimensions = [];
				var d = c.ya.numPages;
				if (c.$a) for (var e = 0; e < c.getNumPages(); e++) if (c.dimensions[e] != o || c.dimensions[e] != o && !c.dimensions[e].loaded) {
					if (c.Wa == o) c.Wa = c.dimensions[e];
				} else {
					if (c.Wa != o) {
						c.dimensions[e] = [];
						c.dimensions[e].page = e;
						c.dimensions[e].loaded = r;
						c.dimensions[e].width = c.Wa.width;
						c.dimensions[e].height = c.Wa.height;
						c.dimensions[e].xa = c.Wa.xa;
						c.dimensions[e].Da = c.Wa.Da;
						if (c.wa[e - 1] != o) c.dimensions[e - 1].Vb = c.wa[e].Vb,
						c.dimensions[e - 1].Ub = c.wa[e].Ub,
						c.dimensions[e - 1].Ib = c.wa[e].Ib,
						c.dimensions[e - 1].uc = c.wa[e].uc;
						c.bd[e + " 0 R"] = e;
					}
				} else for (e = 1; e <= d; e++) c.ya.getPage(e).then(function(d) {
					var g = d.getViewport(1);
					c.dimensions[e - 1] = [];
					c.dimensions[e - 1].page = e - 1;
					c.dimensions[e - 1].width = g.width;
					c.dimensions[e - 1].height = g.height;
					c.dimensions[e - 1].xa = g.width;
					c.dimensions[e - 1].Da = g.height;
					g = d.ref;
					c.bd[g.num + " " + g.gen + " R"] = d.pageInfo.pageIndex;
				});
				c.gd = r;
			}
			return c.dimensions;
		},
		Rf: function(c) {
			this.dimensions[c].page = c;
			this.dimensions[c].loaded = l;
			this.Ma[c] = [];
			this.Ma[c] = "";
			for (var d = 0,
			e; e = this.ra[c][this.JSONPageDataFormat.Gb][d++];) this.Ma[c] += this.Na ? e[5] : e[this.JSONPageDataFormat.Hb];
			this.Ma[c] = this.Ma[c].toLowerCase();
		},
		getNumPages: function() {
			return this.$a ? this.ra.length: this.ya.numPages;
		},
		getPage: function(c) {
			this.ya.getPage(c).then(function(c) {
				return c;
			});
			return o;
		},
		Zc: function(c) { (c.ba == I || c.ba == "SinglePage") && jQuery(c.oa).append("<canvas id='" + this.Za(1, c) + "' style='position:relative;left:0px;top:0px;width:100%;height:100%;display:none;' class='flexpaper_border flexpaper_interactivearea flexpaper_grab flexpaper_hidden flexpaper_rescale'></canvas><canvas id='" + this.Za(2, c) + "' style='position:relative;left:0px;top:0px;width:100%;height:100%;display:block' class='flexpaper_border flexpaper_interactivearea flexpaper_grab flexpaper_hidden flexpaper_rescale'></canvas>");
			c.ba == this.za(c) && this.Fa(c).Zc(this, c);
			c.ba == T && jQuery(c.oa).append("<canvas id='" + this.Za(1, c) + "' style='" + c.getDimensions() + "' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden' ></canvas>");
			if (c.ba == R || c.ba == Q) c.pageNumber == 0 && (jQuery(c.oa + "_1").append("<img id='" + c.Ua + "_1' src='" + this.nb + "' style='position:absolute;left:" + (c.hb() - 30) + "px;top:" + c.gb() / 2 + "px;' />"), jQuery(c.oa + "_1").append("<canvas id='" + this.Za(1, c) + "' style='position:absolute;width:100%;height:100%;' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden'/></canvas>"), jQuery(c.oa + "_1").append("<div id='" + c.fb + "_1_textoverlay' style='position:relative;left:0px;top:0px;width:100%;height:100%;z-index:10'></div>")),
			c.pageNumber == 1 && (jQuery(c.oa + "_2").append("<img id='" + c.Ua + "_2' src='" + this.nb + "' style='position:absolute;left:" + (c.hb() / 2 - 10) + "px;top:" + c.gb() / 2 + "px;' />"), jQuery(c.oa + "_2").append("<canvas id='" + this.Za(2, c) + "' style='position:absolute;width:100%;height:100%;' class='flexpaper_interactivearea flexpaper_grab flexpaper_hidden'/></canvas>"), jQuery(c.oa + "_2").append("<div id='" + c.fb + "_2_textoverlay' style='position:absolute;left:0px;top:0px;width:100%;height:100%;z-index:10'></div>"));
		},
		Za: function(c, d) {
			var e = d.pageNumber;
			if ((d.ba == R || d.ba == Q) && d.pageNumber % 2 == 0) return "dummyCanvas1";
			if ((d.ba == R || d.ba == Q) && d.pageNumber % 2 != 0) return "dummyCanvas2";
			if (c == 1) return this.Oc.replace("[pageNumber]", e);
			if (c == 2) return this.Pc.replace("[pageNumber]", e);
		},
		Bf: function(c, d) {
			if ((d.ba == R || d.ba == Q) && d.pageNumber % 2 == 0) return "#dummyCanvas1";
			if ((d.ba == R || d.ba == Q) && d.pageNumber % 2 != 0) return "#dummyCanvas2";
			if (c == 1) return this.hd.replace("[pageNumber]", d.pageNumber);
			if (c == 2) return this.jd.replace("[pageNumber]", d.pageNumber);
		},
		Db: function(c, d, e) {
			var f = this;
			f.wf = l;
			if (c.ba != f.za(c) || f.Fa(c).zh(f, c, d, e)) {
				if ((c.ba == I || c.ba == R || c.ba == Q) && c.context == o && !c.gc) c.nc(),
				c.gc = l;
				if (f.pa > -1) window.clearTimeout(c.jc),
				c.jc = setTimeout(function() {
					f.Db(c, d, e);
				},
				50);
				else {
					if (c.ba == R || c.ba == Q) if (c.pageNumber == 0) {
						if (c.ba == Q) f.pa = c.ca.ja == 0 ? c.ca.ja: c.ca.ja - 1;
						else if (c.ba == R) f.pa = c.ca.ja;
						f.Od = c;
						c.lb();
					} else if (c.pageNumber == 1) {
						if (c.ba == Q) f.pa = c.ca.ja;
						else if (c.ba == R) f.pa = c.ca.ja + 1;
						f.Od = c;
						jQuery(c.oa + "_2").removeClass("flexpaper_hidden");
						jQuery(c.oa + "_2").removeClass("flexpaper_load_on_demand");
						c.lb();
					} else return;
					else c.ba == "SinglePage" ? f.pa = c.ca.ja: (f.pa = c.pageNumber, f.Od = c);
					f.te(c);
					f.Ra[f.pa] == o && !f.$a && f.ya.getPage(f.pa + 1).then(function(c) {
						f.Ra[f.pa] = c;
					});
					if (c.pb.width != 100 && c.scale == 1 && c.ba == f.za(c) && !c.bg) jQuery("#" + f.Za(1, c)).show(),
					jQuery("#" + f.Za(2, c)).hide(),
					f.pa = -1,
					c.Ja = l,
					f.Aa(c, l, e);
					else {
						if (f.Ra[f.pa] == o && f.$a) f.ya[f.pa] == o && f.Lb == -1 ? (f.Lb = f.pa + 1, f.ee(f.Lb,
						function() {
							window.clearTimeout(c.jc);
							f.pa = -1;
							f.Db(c, d, e);
						})) : f.ya[f.pa] != o && f.ya[f.pa].getPage(1).then(function(c) {
							f.Ra[f.pa] = c;
						});
						if (f.Ra[f.pa] != o && (c.ba == f.za(c) ? f.Fa(c).Db(f, c, d, e) : (c.pb.width = c.hb(), c.pb.height = c.gb()), f.Ra[f.pa] != o)) {
							var g = r,
							p = c.qb + "_textLayer";
							jQuery("#" + p).remove();
							if (jQuery("#" + p).length == 0 && (c.ba == I || c.ba == "SinglePage" || c.ba == R || c.ba == Q || c.ba == f.za(c) && f.Fa(c).Kh(f, c))) {
								var g = l,
								j = c.Mb(),
								j = "<div id='" + p + "' class='textLayer flexpaper_pageword_" + f.ga + "' style='margin-left:" + j + "px;'></div>";
								c.ba == I || f.za(c) ? jQuery(c.qa).append(j) : (c.ba == R || c.ba == Q) && jQuery(c.qa + "_" + (c.pageNumber % 2 + 1)).append(j);
							}
							var j = c.pb.height / f.getDimensions()[c.pageNumber].height,
							u = f.Ra[f.pa].getViewport(j),
							z = {
								canvasContext: c.context,
								viewport: u,
								textLayer: g ? new da(document.getElementById(p)) : o,
								continueCallback: function(c) {
									c();
								}
							};
							f.wf ? setTimeout(function() {
								f.Ra[f.pa].render(z).then(function() {
									f.Ra[f.pa] != o ? (f.$a || f.ig(f.Ra[f.pa], c, u), f.Qd(c, e)) : A(c.pageNumber + "  is missing its pdf page");
								},
								function(c) {
									H(c.toString());
								});
							},
							50) : f.pa = -1;
							jQuery(c.oa).removeClass("flexpaper_load_on_demand");
						}
					}
				}
			}
		},
		te: function(c) {
			c.ba == I || c.ba == "SinglePage" ? jQuery(this.Bf(1, c)).is(":visible") ? (c.Mc = this.Za(2, c), c.Yc = this.Za(1, c)) : (c.Mc = this.Za(1, c), c.Yc = this.Za(2, c)) : c.ba == this.za(c) ? this.Fa(c).te(this, c) : (c.Mc = this.Za(1, c), c.Yc = o);
			c.pb = document.getElementById(c.Mc);
			if (c.Lf != o) c.Lf = document.getElementById(c.Yc);
			c.context = c.pb.getContext("2d");
		},
		qf: function(c, d, e, f) {
			c = f.convertToViewportRectangle(d.rect);
			c = PDFJS.Util.normalizeRect(c);
			d = e.Mb();
			f = document.createElement("a");
			f.style.position = "absolute";
			f.style.left = Math.floor(c[0]) + d + "px";
			f.style.top = Math.floor(c[1]) + "px";
			f.style.width = Math.ceil(c[2] - c[0]) + "px";
			f.style.height = Math.ceil(c[3] - c[1]) + "px";
			f.style["z-index"] = 20;
			f.className = "pdfPageLink_" + e.pageNumber + " flexpaper_interactiveobject_" + this.ga;
			return f;
		},
		ig: function(c, d, e) {
			var f = this;
			jQuery(".pdfPageLink_" + d.pageNumber).remove();
			c.getAnnotations().then(function(c) {
				for (var g = 0; g < c.length; g++) {
					var j = c[g];
					switch (j.type) {
					case "Link":
						var u = f.qf("a", j, d, e);
						u.href = j.url || "";
						if (j.url) {
							if (u.href != o && u.href != "") jQuery(u).on("click",
							function() {
								window.location = this.href;
							});
						} else j = typeof j.dest === "string" ? f.destinations[j.dest][0] : j.dest[0],
						j = j instanceof Object ? f.bd[j.num + " " + j.gen + " R"] : j + 1,
						jQuery(u).data("gotoPage", j),
						jQuery(u).on("click",
						function() {
							d.aa.gotoPage(parseInt(jQuery(this).data("gotoPage")));
							return r;
						});
						jQuery(d.qa).append(u);
					}
				}
			});
		},
		Qd: function(c, d) {
			if (!this.$a) {
				for (var e = c.pb.height / this.getDimensions()[c.pageNumber].height, f = this.Ra[c.pageNumber].spacedTextList, g = 0; g < f.length; g++) f[g].h /= e,
				f[g].l /= e,
				f[g].t /= e,
				f[g].w /= e;
				c.ba == "SinglePage" || c.ba == R || c.ba == Q ? this.La.ve(f, this.pa, this.getNumPages()) : this.La.ve(f, c.pageNumber, this.getNumPages());
			}
			jQuery(".flexpaper_pageword_" + this.ga + "_page_" + c.pageNumber).remove();
			this.Aa(c, l, d);
			jQuery("#" + c.Mc).show();
			this.If(c); (c.ba == I || c.ba == "SinglePage") && jQuery(c.jb).remove();
			c.ba == this.za(c) && this.Fa(c).Qd(this, c, d);
			if (c.ba == R || c.ba == Q) c.pageNumber == 0 && (jQuery(c.ua).removeClass("flexpaper_hidden"), jQuery(c.oa + "_1").removeClass("flexpaper_hidden")),
			c.pageNumber == 1 && jQuery(c.ua).removeClass("flexpaper_hidden");
			c.Ja = l;
			c.bg = r;
			if (!this.cc) this.cc = l,
			window.$FlexPaper(this.ga).ud();
			d != o && d();
			this.$a && (this.ya[c.pageNumber] = o, this.Ra[c.pageNumber] = o);
		},
		If: function(c) {
			c.ba != R && c.ba != Q && jQuery("#" + c.Yc).hide();
			this.pa = -1;
		},
		Ba: function(c, d) {
			if (d) {
				if (this.pageThumbImagePattern != o && this.pageThumbImagePattern.length > 0) return this.pageThumbImagePattern.replace("{page}", c) + (this.pageThumbImagePattern.indexOf("?") > 0 ? "&": "?") + "resolution=" + d;
			} else return this.pageSVGImagePattern.replace("{page}", c);
		},
		unload: function(c) {
			jQuery(".flexpaper_pageword_" + this.ga + "_page_" + c.pageNumber).remove();
			c.context != o && c.pb != o && c.pb.width != 100 && (this.$a && (this.ya[c.pageNumber] = o, this.Ra[c.pageNumber] = o), c.vd && c.vd(), jQuery(".flexpaper_annotation_" + this.ga + "_page_" + c.pageNumber).remove());
		},
		ze: function(c) {
			var d = this;
			jQuery(d).trigger("loadingProgressStatusChanged", {
				ga: d.ga,
				label: "Indexing Publication"
			});
			jQuery(d).trigger("loadingProgress", {
				ga: d.ga,
				progress: "0%"
			});
			d.ya.getPage(d.ad).then(function(e) {
				jQuery(d).trigger("loadingProgress", {
					ga: d.ga,
					progress: (i + 1) / c.numPages * 100 + "%"
				});
				e.getTextContent().then(function(e) {
					for (var e = e.bidiTexts,
					g = "",
					p = 0; p < e.length; p++) g += e[p].str;
					d.Ma[d.ad - 1] = g.toLowerCase();
					d.ad + 1 < d.getNumPages() + 1 && (d.ad++, d.ze(c));
				});
			});
		},
		Kb: function(c, d, e, f) {
			this.La.Kb(c, d, e, f);
		},
		Ya: function(c, d, e) {
			this.La.Ya(c, d, e);
		},
		Aa: function(c, d, e) {
			if (c.Ja || d) {
				if (c.mg != c.scale) jQuery(".flexpaper_pageword_" + this.ga + "_page_" + c.pageNumber).remove(),
				c.mg = c.scale;
				d = this.qc != o ? this.qc: e;
				this.qc = o;
				this.La.Aa(c, d);
			} else if (e != o) if (this.qc != o) {
				var f = this.qc;
				this.qc = function() {
					f();
					e();
				};
			} else this.qc = e;
		}
	};
	return g;
} ();
function da(g) {
	this.Ch = g;
	this.beginLayout = function() {
		this.Bh = [];
		this.Eh = [];
	};
	this.endLayout = s();
	this.Ig = s();
}
var V = window.TextOverlay = function() {
	function g(c, d, e, f) {
		this.ga = c;
		this.JSONPageDataFormat = e;
		this.ra = [];
		this.ub = o;
		this.Ia = [];
		this.Na = d;
		this.wc = f;
		this.bb = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
	}
	g.prototype = {
		za: function(c) {
			return c.aa.ha ? c.aa.ha.sa: "";
		},
		Fa: function(c) {
			return c.aa.ha.Dh;
		},
		Cc: function(c) {
			this.ra = c;
			if (this.ub == o) this.ub = Array(c.length);
			window["wordPageList_" + this.ga] = this.Ia;
		},
		ve: function(c, d, e) {
			if (this.ub == o) this.ub = Array(e);
			this.ra[d] = [];
			this.ra[d].text = c;
			window["wordPageList_" + this.ga] = this.Ia;
		},
		Kb: function(c, d, e, f) {
			var g = c.pageNumber,
			p = r;
			if (!window.annotations && eb.touchdevice && !f) e && e();
			else if (!window.annotations && !c.aa.Tb && !f && (p = l), c.ba != T) {
				if (c.ba == Q) {
					c.pageNumber == 0 && (g = c.ca.ja != 0 ? c.ca.ja - 1 : c.ca.ja);
					if (c.pageNumber == 1) g = c.ca.ja;
					if (c.ca.ja % 2 == 0 && c.ca.ja == c.ca.getTotalPages()) return;
				}
				if (c.ba == "SinglePage") g = c.ca.ja;
				if (c.ba == R) {
					if (c.pageNumber == 0) g = c.ca.ja;
					c.pageNumber == 1 && (g = c.ca.ja + 1);
					if (c.pageNumber == 1 && g >= c.ca.getTotalPages() && c.ca.getTotalPages() % 2 != 0) return;
				}
				d = c.Pa || !d;
				c.ba == this.za(c) && (isvisble = this.Fa(c).dc(this, c));
				f = jQuery(".flexpaper_pageword_" + this.ga + "_page_" + g).length;
				if (d && f == 0) {
					var j = f = "",
					u = 0;
					if (this.ub[g] == o || !this.wc) {
						if (this.ra[g] == o) return;
						this.ub[g] = this.ra[g][this.JSONPageDataFormat.Gb];
					}
					if (this.ub[g] != o) {
						var z = new WordPage(this.ga, g),
						w = c.dimensions.Ib != o ? c.dimensions.Ib: c.dimensions.xa,
						w = this.wc ? c.hb() / w: 1,
						y = c.Mb(),
						m = [],
						q = c.yc(),
						k = c.Sd(),
						n = r,
						J = -1,
						F = -1,
						M = 0,
						N = -1,
						P = -1,
						S = r;
						this.Ia[g] = z;
						c.ba == this.za(c) && (w = this.Fa(c).Sg(this, c, w));
						for (var X = 0; n = this.ub[g][X++];) {
							var x = !this.Na ? n[this.JSONPageDataFormat.Hb] : n[5],
							K = o,
							O = o;
							if (x == o) {
								A("word not found in node");
								return;
							}
							x.length == 0 && (x = " ");
							x.indexOf("actionGoToR") >= 0 ? (K = x.substring(x.indexOf("actionGoToR") + 12, x.indexOf(",", x.indexOf("actionGoToR") + 13)), x = x.substring(x.indexOf(",") + 1)) : x.indexOf("actionGoTo") >= 0 ? (K = x.substring(x.indexOf("actionGoTo") + 11, x.indexOf(",", x.indexOf("actionGoTo") + 12)), x = x.substring(x.indexOf(",") + 1)) : x.indexOf("actionURI") >= 0 && (O = x.substring(x.indexOf("actionURI") + 10), x = x.substring(x.indexOf("actionURI") + 10));
							if (K || O || !p) {
								var C = (!this.Na ? n[this.JSONPageDataFormat.rc] : n[0]) * w + (c.ba == I || c.ba == "SinglePage" || c.ba == this.za(c) || c.ba == R || c.ba == Q ? 2 : 0),
								G = (!this.Na ? n[this.JSONPageDataFormat.pc] : n[1]) * w + ((c.ba == R || c.ba == Q) && c.pageNumber == 0 ? 0 : 0),
								D = (!this.Na ? n[this.JSONPageDataFormat.tc] : n[2]) * w,
								L = (!this.Na ? n[this.JSONPageDataFormat.oc] : n[3]) * w;
								z.hg(u, x);
								n = J != -1 && J != C;
								S = X == this.ub[g].length;
								G < 0 && (G = 0);
								C < 0 && (C = 0);
								G + D > q && (D = q - G);
								C + L > k && (L = k - C);
								m[u] = {};
								m[u].left = G;
								m[u].right = G + D;
								m[u].top = C;
								m[u].bottom = C + L;
								m[u].el = "#" + this.ga + "page_" + g + "_word_" + u;
								m[u].i = u;
								m[u].ke = K;
								m[u].Ce = O;
								f += "<span id='" + this.ga + "page_" + g + "_word_" + u + "' class='flexpaper_pageword flexpaper_pageword_" + this.ga + "_page_" + g + " flexpaper_pageword_" + this.ga + "' style='left:" + G + "px;top:" + C + "px;width:" + D + "px;height:" + L + "px;margin-left:" + y + "px;" + (m[u].ke || m[u].Ce ? "cursor:hand;": "") + ";" + (eb.browser.msie ? "background-image:url(" + this.bb + ");color:transparent;": "") + "'></span>";
								if (K != o || O != o) {
									var B = document.createElement("a");
									B.style.position = "absolute";
									B.style.left = Math.floor(G) + y + "px";
									B.style.top = Math.floor(C) + "px";
									B.style.width = Math.ceil(D) + "px";
									B.style.height = Math.ceil(L) + "px";
									B.style["z-index"] = 20;
									B.style["margin-left"] = y;
									B.href = O != o ? O: "";
									B.className = "pdfPageLink_" + c.pageNumber + " flexpaper_interactiveobject_" + this.ga + " gotoPage_" + K;
									K != o && (jQuery(B).data("gotoPage", K), jQuery(B).on("click",
									function() {
										c.aa.gotoPage(parseInt(jQuery(this).data("gotoPage")));
										return r;
									}));
									jQuery(c.qa).append(B);
								}
								eb.platform.touchdevice && c.ba == I && (n || S ? (S && (M += D, j = j + "<div style='float:left;width:" + D + "px'>" + (x == " " ? "&nbsp;": x) + "</div>"), j = "<div id='" + this.ga + "page_" + g + "_word_" + u + "_wordspan' class='flexpaper_pageword flexpaper_pageword_" + this.ga + "_page_" + g + " flexpaper_pageword_" + this.ga + "' style='color:transparent;left:" + N + "px;top:" + J + "px;width:" + M + "px;height:" + F + "px;margin-left:" + P + "px;font-size:" + F + "px" + (m[u].ke || m[u].Ce ? "cursor:hand;": "") + "'>" + j + "</div>", jQuery(c.rd).append(j), J = C, F = L, M = D, N = G, P = y, j = "<div style='background-colorfloat:left;width:" + D + "px'>" + (x == " " ? "&nbsp;": x) + "</div>") : (N == -1 && (N = G), P == -1 && (P = y), J == -1 && (J = C), F == -1 && (F = L), j = j + "<div style='float:left;width:" + D + "px'>" + (x == " " ? "&nbsp;": x) + "</div>", M += D, F = L));
							}
							u++;
						}
						z.eg(m);
						c.ba == I && jQuery(c.qa).append(f);
						c.ba == "SinglePage" && jQuery(c.qa).append(f);
						c.ba == this.za(c) && this.Fa(c).Jg(this, c, f);
						if (c.ba == R || c.ba == Q) c.pageNumber == 0 && jQuery(c.oa + "_1_textoverlay").append(f),
						c.pageNumber == 1 && jQuery(c.oa + "_2_textoverlay").append(f);
						d && jQuery(c).trigger("onAddedTextOverlay", c.pageNumber);
					}
				}
				e != o && e();
			}
		},
		Ya: function(c, d, e) {
			var f = this;
			jQuery(c).unbind("onAddedTextOverlay");
			var g = c.ba == R || c.ba == Q ? c.ca.ja + c.pageNumber: c.pageNumber;
			c.ba == Q && c.ca.ja > 0 && c.pageNumber == 1 && (g -= 2);
			if (c.ba == "SinglePage") g = c.ca.ja;
			if ((c.Pa || !e) && window.va - 1 == g) if (jQuery(".flexpaper_selected").removeClass("flexpaper_selected"), jQuery(".flexpaper_selected_searchmatch").removeClass("flexpaper_selected_searchmatch"), jQuery(".flexpaper_selected_default").removeClass("flexpaper_selected_default"), jQuery(".flexpaper_tmpselection").remove(), !f.Ia[g] || f.Ia[g] != o && f.Ia[g].Hc.length == 0) jQuery(c).bind("onAddedTextOverlay",
			function() {
				f.Ya(c, d, e);
			}),
			f.Kb(c, e, o, l);
			else for (var p = f.Ia[g].Hc, j = "", u = 0, z = 0, w = -1, y = -1, m = d.split(" "), q = 0; q < p.length; q++) {
				var k = (p[q] + "").toLowerCase();
				if (jQuery.trim(k) == d || jQuery.trim(j + k) == d) k = jQuery.trim(k);
				if (d.indexOf(j + k) == 0 && (j + k).length <= d.length && j + k != " ") {
					if (j += k, w == -1 && (w = u, y = u + 1), d.length == k.length && (w = u), j.length == d.length) if (z++, window.Bb == z) {
						if (c.ba == I || c.ba == "SinglePage") eb.browser.Oa.Qa ? jQuery("#pagesContainer_" + f.ga).scrollTo(jQuery(f.Ia[g].Ea[w].el), 0, {
							axis: "xy",
							offset: -30
						}) : jQuery("#pagesContainer_" + f.ga).data("jsp").scrollToElement(jQuery(f.Ia[g].Ea[w].el), r);
						for (var n = w; n < u + 1; n++) c.ba == f.za(c) ? (k = jQuery(f.Ia[g].Ea[n].el).clone(), f.Fa(c).pf(f, c, k, d)) : (jQuery(f.Ia[g].Ea[n].el).addClass("flexpaper_selected"), jQuery(f.Ia[g].Ea[n].el).addClass("flexpaper_selected_default"), jQuery(f.Ia[g].Ea[n].el).addClass("flexpaper_selected_searchmatch"));
					} else j = "",
					w = -1;
				} else if ((j + k).indexOf(m[0]) >= 0) {
					w == -1 && (w = u, y = u + 1);
					j += k;
					if (m.length > 1) for (k = 0; k < m.length - 1; k++) m[k].length > 0 && p.length > u + 1 + k && (j + p[u + 1 + k]).toLowerCase().indexOf(m[k]) >= 0 ? (j += p[u + 1 + k].toLowerCase(), y = u + 1 + k + 1) : (j = "", y = w = -1);
					j.indexOf(d) == -1 ? (j = "", y = w = -1) : z++;
					if (window.Bb == z && j.length > 0) {
						for (var n = jQuery(f.Ia[g].Ea[w].el), J = parseFloat(n.css("left").substring(0, n.css("left").length - 2)) - (c.ba == f.za(c) ? c.Mb() : 0), k = n.clone(), F = 0, M = 0, N = 0; w < y; w++) F += parseFloat(jQuery(f.Ia[g].Ea[w].el).css("width").substring(0, n.css("width").length - 2));
						M = 1 - (j.length - d.length) / j.length;
						N = j.indexOf(d) / j.length;
						k.addClass("flexpaper_tmpselection");
						k.attr("id", k.attr("id") + "tmp");
						k.addClass("flexpaper_selected");
						k.addClass("flexpaper_selected_searchmatch");
						k.addClass("flexpaper_selected_default");
						k.css("width", F * M + "px");
						k.css("left", J + F * N + "px");
						if (c.ba == I || c.ba == "SinglePage") jQuery(c.qa).append(k),
						eb.browser.Oa.Qa ? jQuery("#pagesContainer_" + f.ga).scrollTo(k, 0, {
							axis: "xy",
							offset: -30
						}) : jQuery("#pagesContainer_" + f.ga).data("jsp").scrollToElement(k, r);
						c.ba == f.za(c) && f.Fa(c).pf(f, c, k, d);
						c.ba == "SinglePage" && jQuery("#dummyPage_0_" + f.ga + "_textoverlay").append(k);
						c.ba == Q && (g == 0 ? jQuery("#dummyPage_0_" + f.ga + "_1_textoverlay").append(k) : jQuery("#dummyPage_" + (g - 1) % 2 + "_" + f.ga + "_" + ((g - 1) % 2 + 1) + "_textoverlay").append(k));
						c.ba == R && jQuery("#dummyPage_" + g % 2 + "_" + f.ga + "_" + (g % 2 + 1) + "_textoverlay").append(k);
					} else j = "";
					y = w = -1;
				} else j.length > 0 && (j = "", w = -1);
				u++;
			}
		},
		Aa: function(c, d) {
			this.Kb(c, d == o, d);
		}
	};
	return g;
} ();
window.WordPage = function(g, c) {
	this.ga = g;
	this.pageNumber = c;
	this.Hc = [];
	this.Ea = o;
	this.sg = "";
	this.Vg = function() {
		return this.Hc;
	};
	this.Tg = function() {
		return this.pageNumber;
	};
	this.hg = function(c, e) {
		this.Hc[c] = e;
	};
	this.yh = function(c) {
		this.sg = c;
	};
	this.eg = function(c) {
		this.Ea = c;
	};
	this.Ug = function() {
		return this.Ea;
	};
	this.match = function(c, e) {
		var f, g = o;
		f = "#page_" + this.pageNumber + "_" + this.ga;
		jQuery(f).length == 0 && (f = "#dummyPage_" + this.pageNumber + "_" + this.ga);
		f = jQuery(f).offset();
		window.$FlexPaper(this.ga).ba == "SinglePage" && (f = "#dummyPage_0_" + this.ga, f = jQuery(f).offset());
		if (window.$FlexPaper(this.ga).ba == R || window.$FlexPaper(this.ga).ba == Q) f = this.pageNumber == 0 || window.$FlexPaper(this.ga).ba == R ? jQuery("#dummyPage_" + this.pageNumber % 2 + "_" + this.ga + "_" + (this.pageNumber % 2 + 1) + "_textoverlay").offset() : jQuery("#dummyPage_" + (this.pageNumber - 1) % 2 + "_" + this.ga + "_" + ((this.pageNumber - 1) % 2 + 1) + "_textoverlay").offset();
		c.top -= f.top;
		c.left -= f.left;
		for (f = 0; f < this.Ea.length; f++) if (this.Kf(c, this.Ea[f], e) && (g == o || g != o && g.top < this.Ea[f].top || g != o && g.top <= this.Ea[f].top && g != o && g.left < this.Ea[f].left)) g = this.Ea[f],
		g.pageNumber = this.pageNumber;
		return g;
	};
	this.Kf = function(c, e, f) {
		var g = eb.platform.touchdevice ? 3 : 3;
		return ! e ? r: f ? c.left + g >= e.left && c.left - g <= e.right && c.top + g >= e.top && c.top - g <= e.bottom: c.left + g >= e.left && c.top + g >= e.top;
	};
	this.Zb = function(c, e) {
		var f = window.a,
		g = window.b,
		p = new ea,
		j, u, z = 0,
		w = -1;
		if (o == f) return p;
		if (f && g) {
			var y = [],
			m;
			f.top > g.top ? (j = g, u = f) : (j = f, u = g);
			for (j = j.i; j <= u.i; j++) if (this.Ea[j]) {
				var q = jQuery(this.Ea[j].el);
				q.length != 0 && (m = parseInt(q.attr("id").substring(q.attr("id").indexOf("word_") + 5)), w = parseInt(q.attr("id").substring(q.attr("id").indexOf("page_") + 5, q.attr("id").indexOf("word_") - 1)) + 1, m >= 0 && y.push(this.Hc[m]), z++, c && (q.addClass("flexpaper_selected"), q.addClass(e), e == "flexpaper_selected_strikeout" && !q.data("adjusted") && (m = q.height(), q.css("margin-top", m / 2 - m / 2.3 / 1.5), q.height(m / 2.3), q.data("adjusted", l))));
			}
			eb.platform.touchdevice || jQuery(".flexpaper_selector").val(y.join("")).select();
		} else eb.platform.touchdevice || jQuery("#selector").val("");
		p.Zg = z;
		p.Sh = f.left;
		p.Th = f.right;
		p.Uh = f.top;
		p.Rh = f.bottom;
		p.Oh = f.left;
		p.Ph = f.right;
		p.Qh = f.top;
		p.Nh = f.bottom;
		p.xf = y != o && y.length > 0 ? y[0] : o;
		p.dh = y != o && y.length > 0 ? y[y.length - 1] : p.xf;
		p.yf = f != o ? f.i: -1;
		p.eh = g != o ? g.i: p.yf;
		p.text = y != o ? y.join("") : "";
		p.page = w;
		p.Mh = this;
		return p;
	};
};
function ea() {}
function W(g) {
	var c = hoverPage,
	g = window["wordPageList_" + g];
	return ! g ? h: g.length >= c ? g[c] : o;
}
var ga = function() {
	function g(c, d, e, f) {
		this.aa = d;
		this.ia = c;
		this.ca = {};
		this.selectors = [];
		this.container = "pagesContainer_" + e;
		this.la = "#" + this.container;
		this.ja = f == o ? 0 : f - 1;
		this.Dc = f;
		this.cd = this.lc = o;
		this.Ab = this.zb = -1;
		this.gh = this.fh = 0;
		this.ib = r;
		this.ga = this.aa.ga;
		this.document = this.aa.document;
	}
	g.prototype = {
		da: function(c) {
			this.selectors[c] || (this.selectors[c] = jQuery(c));
			return this.selectors[c];
		},
		ie: function() {
			if (this.Pd != o) window.clearTimeout(this.Pd),
			this.Pd = o;
			this.aa.ha && this.aa.ha.ab.ie(this);
		},
		fd: function() {
			return this.aa.ha && this.aa.ha.ab.fd(this);
		},
		Va: function(c, d, e) {
			var f = this.aa.scale;
			this.aa.scale = c;
			if (this.aa.ba == R || this.aa.ba == Q) {
				var g = c * 100 + "%";
				eb.platform.touchdevice || this.da(this.la).css({
					width: g,
					"margin-left": this.bc()
				});
			}
			this.ca[0].scale = c;
			for (g = 0; g < this.document.numPages; g++) if (this.sb(g)) this.ca[g].scale = c,
			this.ca[g].Va();
			this.aa.ha && this.aa.ha.ab.Va(this, f, c, d, e);
		},
		resize: function(c, d, e) {
			if (this.aa.ba == I || this.aa.ba == "SinglePage") c -= eb.browser.msie ? 0 : 2;
			this.aa.ba == T && (d -= 10);
			this.da(this.la).css({
				width: c,
				height: d
			});
			if (this.aa.ba == R) this.aa.ed = this.ia.height() - (!eb.platform.touchdevice ? 27 : 0),
			this.aa.Gc = c / 2 - 2,
			this.da(this.la).height(this.aa.ed),
			this.da("#" + this.container + "_2").css("left", this.da("#" + this.container).width() / 2),
			eb.platform.touchdevice || (this.da(this.la + "_1").width(this.aa.Gc), this.da(this.la + "_2").width(this.aa.Gc));
			if (this.aa.ha) this.aa.ha.ab.resize(this, c, d, e);
			else for (c = 0; c < this.document.numPages; c++) this.sb(c) && this.ca[c].Va();
			this.Ad = o;
		},
		Uc: function(c) {
			var d = this;
			if (!d.sd) {
				var e = r;
				typeof d.nd === "function" && d.Wg();
				jQuery(".flexpaper_pageword").each(function() {
					jQuery(this).hasClass("flexpaper_selected_default") && (e = l);
				});
				if (d.touchwipe != o) d.touchwipe.config.preventDefaultEvents = r;
				d.fd() || (jQuery(".flexpaper_pageword_" + d.ga).remove(), setTimeout(function() { (d.aa.ba == R || d.aa.ba == Q) && d.Rb();
					d.Aa();
					e && d.getPage(window.va - 1).Ya(window.rb, r);
				},
				500));
				d.aa.ha ? d.aa.ha.ab.Uc(d, c) : d.Va(1);
				d.jScrollPane != o ? (d.jScrollPane.data("jsp").reinitialise(d.mb), d.jScrollPane.data("jsp").scrollTo(d.zb, d.Ab, r)) : (d.aa.ba == R || d.aa.ba == Q) && d.da(d.la).parent().scrollTo({
					left: d.zb + "px",
					top: d.Ab + "px"
				},
				0, {
					axis: "xy"
				});
			}
		},
		Vc: function() {
			var c = this;
			if (!c.sd) {
				var d = r;
				if (c.touchwipe != o) c.touchwipe.config.preventDefaultEvents = l;
				typeof c.nd === "function" && c.Xg();
				jQuery(".flexpaper_pageword").each(function() {
					jQuery(this).hasClass("flexpaper_selected_default") && (d = l);
				});
				c.fd() || jQuery(".flexpaper_pageword_" + c.ga).remove();
				c.aa.ha ? c.aa.ha.ab.Vc(c) : c.Va(window.FitHeightScale);
				setTimeout(function() {
					c.Aa();
					d && c.getPage(window.va - 1).Ya(window.rb, r);
				},
				500);
				c.Aa();
				c.jScrollPane != o ? (c.jScrollPane.data("jsp").scrollTo(0, 0, r), c.jScrollPane.data("jsp").reinitialise(c.mb)) : c.da(c.la).parent().scrollTo({
					left: 0,
					top: 0
				},
				0, {
					axis: "xy"
				});
			}
		},
		ge: function() {
			var c = this;
			c.Lc();
			if (c.aa.ha) c.aa.ha.ab.ge(c);
			else if (c.aa.ba == R || c.aa.ba == Q) c.touchwipe = c.da(c.la).touchwipe({
				wipeLeft: function() {
					c.sd == o && (c.aa.ba == R || c.aa.ba == Q) && c.aa.scale != 1 && c.next();
				},
				wipeRight: function() {
					c.sd == o && (c.aa.ba == R || c.aa.ba == Q) && c.aa.scale != 1 && c.previous();
				},
				preventDefaultEvents: l,
				min_move_x: 100,
				min_move_y: 100
			});
			c.da(c.la).on("touchstart",
			function(d) {
				c.zb = d.originalEvent.touches[0].pageX;
				c.Ab = d.originalEvent.touches[0].pageY;
			});
			c.da(c.la).on("touchend",
			function() {
				c.aa.ca.jScrollPane != o && c.aa.ca.jScrollPane.data("jsp").enable();
			});
			c.aa.ha || eb.platform.touchdevice && c.da(c.la).doubletap(function(d) {
				if (c.aa.ba == R || c.aa.ba == Q)(c.aa.ba == R || c.aa.ba == Q) && c.aa.scale != 1 ? c.Uc() : (c.aa.ba == R || c.aa.ba == Q) && c.aa.scale == 1 && c.Vc(),
				d.preventDefault();
			},
			o, 300);
			c.da(c.la).on("scroll gesturechange",
			function() {
				if (c.aa.ba != "SinglePage" && !(c.aa.ha && c.aa.ba == c.aa.ha.sa)) {
					eb.platform.ios && c.xd(c.da(c.la).scrollTop() * -1);
					eb.platform.ios ? (setTimeout(function() {
						c.vc();
						c.Ob();
					},
					1E3), setTimeout(function() {
						c.vc();
						c.Ob();
					},
					2E3), setTimeout(function() {
						c.vc();
						c.Ob();
					},
					3E3)) : c.vc();
					c.Ob();
					c.Aa();
					if (c.lc != o) window.clearTimeout(c.lc),
					c.lc = o;
					c.lc = setTimeout(function() {
						c.Zd();
						window.clearTimeout(c.lc);
						c.lc = o;
					},
					100);
					c.mh = l;
				}
			});
			this.Zd();
		},
		xd: function(c) {
			for (var d = 0; d < this.document.numPages; d++) this.sb(d) && this.ca[d].xd(c);
		},
		Lc: function() {
			this.aa.ha && this.aa.ha.ab.Lc(this);
		},
		getTotalPages: function() {
			return this.document.numPages;
		},
		Nd: function(c) {
			var d = this;
			c.empty();
			jQuery(d.aa.renderer).on("onTextDataUpdated",
			function() {
				d.Aa();
			});
			if (d.aa.cd == o) d.aa.cd = d.ia.height(),
			eb.platform.touchdevice ? d.ia.height(d.aa.cd - 20) : d.ia.height(d.aa.cd - 24);
			var e = d.aa.ha && d.aa.ha.backgroundColor ? "background-color:" + d.aa.ha.backgroundColor + ";": "";
			if (d.aa.ba == I || d.aa.ba == "SinglePage") {
				var f = d.ia.height() + (eb.browser.Oa.Qa ? 0 : 10),
				g = d.ia.width() - (eb.browser.msie ? 2 : 2),
				p = eb.browser.msie && eb.browser.version < 9 ? "position:relative;": "";
				c.append("<div id='" + d.container + "' class='flexpaper_pages' style='-moz-user-select:none;-webkit-user-select:none;" + p + ";" + (d.Dc > 1 ? "visibility:hidden;": "") + "height:" + f + "px;width:" + g + "px;" + (window.eb.browser.msie || eb.platform.Ed ? "overflow-y: auto;overflow-x: auto;": "overflow-y: auto;overflow-x: auto;") + ";-webkit-overflow-scrolling: touch;border-left:1px solid #777777;border-right:1px solid #777777;border-bottom:1px solid #777777;" + e + "'></div>");
				eb.browser.Oa.Qa ? (jQuery(c).css("overflow-y", "visible"), jQuery(c).css("overflow-x", "visible"), jQuery(c).css("-webkit-overflow-scrolling", "visible")) : (jQuery(c).css("overflow-y", "hidden"), jQuery(c).css("overflow-x", "hidden"), jQuery(c).css("-webkit-overflow-scrolling", "hidden"));
				jQuery(d.la).on("touchmove", s());
			}
			if (d.aa.ba == R || d.aa.ba == Q) {
				f = d.ia.height() - (eb.browser.msie ? 37 : 0);
				g = d.ia.width() - (eb.browser.msie ? 0 : 20);
				e = 0;
				d.aa.na == 1 && d.aa.ba == Q && (e = g / 3, g -= e);
				eb.platform.touchdevice ? eb.browser.Oa.Qa ? (c.append("<div id='" + d.container + "' style='-moz-user-select:none;-webkit-user-select:none;margin-left:" + e + "px;position:relative;width:100%;' class='flexpaper_twopage_container'><div id='" + d.container + "_1' class='flexpaper_pages' style='position:absolute;top:0px;height:99%;margin-top:20px;'></div><div id='" + d.container + "_2' class='flexpaper_pages' style='position:absolute;top:0px;height:99%;margin-top:20px;'></div></div>"), jQuery(c).css("overflow-y", "scroll"), jQuery(c).css("overflow-x", "scroll"), jQuery(c).css("-webkit-overflow-scrolling", "touch")) : (c.append("<div id='" + d.container + "_jpane' style='-moz-user-select:none;-webkit-user-select:none;height:" + f + "px;width:100%;" + (window.eb.browser.msie || eb.platform.Ed ? "overflow-y: scroll;overflow-x: scroll;": "overflow-y: auto;overflow-x: auto;") + ";-webkit-overflow-scrolling: touch;'><div id='" + d.container + "' style='margin-left:" + e + "px;position:relative;height:100%;width:100%' class='flexpaper_twopage_container'><div id='" + d.container + "_1' class='flexpaper_pages' style='position:absolute;top:0px;height:99%;margin-top:20px;'></div><div id='" + d.container + "_2' class='flexpaper_pages' style='position:absolute;top:0px;height:99%;margin-top:20px;'></div></div></div>"), jQuery(c).css("overflow-y", "visible"), jQuery(c).css("overflow-x", "visible"), jQuery(c).css("-webkit-overflow-scrolling", "visible")) : (c.append("<div id='" + d.container + "' style='-moz-user-select:none;-webkit-user-select:none;margin-left:" + e + "px;position:relative;' class='flexpaper_twopage_container'><div id='" + d.container + "_1' class='flexpaper_pages' style='position:absolute;top:0px;height:99%;margin-top:" + (!eb.browser.msie ? 20 : 10) + "px;'></div><div id='" + d.container + "_2' class='flexpaper_pages " + (d.aa.ba == Q && d.Dc < 2 ? "flexpaper_hidden": "") + "' style='position:absolute;top:0px;height:99%;margin-top:" + (!eb.browser.msie ? 20 : 10) + "px;'></div></div>"), jQuery(c).css("overflow-y", "auto"), jQuery(c).css("overflow-x", "auto"), jQuery(c).css("-webkit-overflow-scrolling", "touch"));
				if (d.aa.ed == o) d.aa.ed = d.ia.height() - (!eb.platform.touchdevice ? 27 : 0),
				d.aa.Gc = d.da(d.la).width() / 2 - 2;
				d.da(d.la).height(d.aa.ed);
				d.da("#" + this.container + "_2").css("left", d.da("#" + d.container).width() / 2);
				eb.platform.touchdevice || (d.da(d.la + "_1").width(d.aa.Gc), d.da(d.la + "_2").width(d.aa.Gc));
			}
			d.aa.ba == T && (jQuery(c).css("overflow-y", "visible"), jQuery(c).css("overflow-x", "visible"), jQuery(c).css("-webkit-overflow-scrolling", "visible"), p = eb.browser.msie && eb.browser.version < 9 ? "position:relative;": "", c.append("<div id='" + this.container + "' class='flexpaper_pages' style='" + p + ";" + (eb.platform.touchdevice ? "padding-left:10px;": "") + (eb.browser.msie ? "overflow-y: scroll;overflow-x: hidden;": "overflow-y: auto;overflow-x: hidden;-webkit-overflow-scrolling: touch;") + "'></div>"), jQuery(".flexpaper_pages").height(d.ia.height() - (eb.browser.msie ? -27 : !eb.platform.touchdevice ? 0 : 0)));
			d.aa.ha && d.aa.ha.ab.Nd(d, c);
			d.ia.trigger("onPagesContainerCreated");
			jQuery(d).bind("onScaleChanged", d.ie);
		},
		Qc: function(c) {
			return this.getPage(c).Qc();
		},
		Rc: function(c) {
			return this.getPage(c).Rc();
		},
		Ud: function(c) {
			return this.getPage(c).scale;
		},
		Wd: function(c) {
			return this.getPage(c).hb();
		},
		Vd: function(c) {
			return this.getPage(c).gb();
		},
		create: function(c) {
			var d = this;
			d.Nd(c);
			if (!eb.browser.Oa.Qa && d.aa.ba != T && (d.mb = {},
			d.aa.ba == R || d.aa.ba == Q)) d.jScrollPane = d.da(d.la + "_jpane").jScrollPane(d.mb);
			for (c = 0; c < this.document.numPages; c++) d.sb(c) && this.lf(c);
			d.ge();
			if (!eb.browser.Oa.Qa) {
				if (d.aa.ba == I || d.aa.ba == "SinglePage") d.jScrollPane = d.da(this.la).jScrollPane(d.mb);
				window.zine && !(d.aa.ha && d.aa.ha.sa == d.aa.ba) && jQuery(d.da(this.la)).bind("jsp-initialised",
				function() {
					jQuery(this).find(".jspHorizontalBar, .jspVerticalBar").hide();
				}).jScrollPane().hover(function() {
					jQuery(this).find(".jspHorizontalBar, .jspVerticalBar").stop().fadeTo("fast", 0.9);
				},
				function() {
					jQuery(this).find(".jspHorizontalBar, .jspVerticalBar").stop().fadeTo("fast", 0);
				});
			}
			if (!eb.browser.Oa.Qa && d.aa.ba == T) d.jScrollPane = d.da(d.la).jScrollPane(d.mb);
			d.Dc > 1 && d.aa.ba == I && setTimeout(function() {
				d.scrollTo(d.Dc, l);
				d.Dc = -1;
				jQuery(d.la).css("visibility", "visible");
			},
			500);
		},
		getPage: function(c) {
			if (this.aa.ba == R || this.aa.ba == Q) {
				if (c % 2 != 0) return this.ca[1];
				if (c % 2 == 0) return this.ca[0];
			} else return this.aa.ba == "SinglePage" ? this.ca[0] : this.ca[c];
		},
		sb: function(c) {
			return (this.aa.ba == R || this.aa.ba == Q) && (c == 0 || c == 1) || this.aa.ba != R && this.aa.ba != Q;
		},
		lf: function(c) {
			this.ca[c] = new fa(this.ga, c, this, this.ia, this.aa, this.Cf(c));
			this.ca[c].create(this.da(this.la));
		},
		Cf: function(c) {
			for (var d = 0; d < this.document.dimensions.length; d++) if (this.document.dimensions[d].page == c) return this.document.dimensions[d];
			return {
				width: -1,
				height: -1
			};
		},
		scrollTo: function(c, d) {
			if (this.ja + 1 != c || d) eb.browser.Oa.Qa ? jQuery(this.la).scrollTo(this.ca[c - 1].da(this.ca[c - 1].qa), 0) : this.jScrollPane.data("jsp").scrollToElement(this.ca[c - 1].da(this.ca[c - 1].qa), l, r);
			this.Aa();
		},
		ag: function() {
			for (var c = 0; c < this.getTotalPages(); c++) this.sb(c) && this.ca[c] && this.ca[c].jc && window.clearTimeout(this.ca[c].jc);
		},
		Zd: function() {
			this.Bc();
		},
		Bc: function() {
			var c = this;
			if (c.kc != o) window.clearTimeout(c.kc),
			c.kc = o;
			c.kc = setTimeout(function() {
				c.Rb();
			},
			200);
		},
		zd: function() {
			if (this.jScrollPane != o) try {
				this.jScrollPane.data("jsp").reinitialise(this.mb);
			} catch(c) {}
		},
		Rb: function(c) {
			var d = this;
			if (d.aa.ha) d.aa.ha.ab.Rb(d, c);
			else {
				if (d.kc != o) window.clearTimeout(d.kc),
				d.kc = o;
				for (var c = d.da(this.la).scrollTop(), e = 0; e < this.document.numPages; e++) if (d.sb(e)) this.ca[e].dc(c, d.da(this.la).height(), l) ? (this.ca[e].Pa = l, this.ca[e].load(function() {
					if (d.aa.ba == R || d.aa.ba == Q) if (!d.da(d.la).is(":animated") && d.aa.scale != 1 && (d.da(d.la).css("margin-left", d.bc()), d.da("#" + this.container + "_2").css("left", d.da("#" + d.container).width() / 2)), !d.ib && d.jScrollPane != o) d.jScrollPane.data("jsp").reinitialise(d.mb),
					d.ib = l;
				}), this.ca[e].Pf(), this.ca[e].Aa()) : d.aa.ba != R && d.aa.ba != Q && this.ca[e].unload();
			}
		},
		Ob: function() {
			this.aa.ba != this.aa.sa() ? this.aa.$b(this.ja + 1) : this.aa.$b(this.ja);
		},
		Aa: function() {
			for (var c = 0; c < this.document.numPages; c++) this.sb(c) && this.ca[c].Pa && this.ca[c].Aa();
		},
		vc: function() {
			for (var c = this.ja, d = this.da(this.la).scrollTop(), e = 0; e < this.document.numPages; e++) 
				if (this.sb(e) && this.ca[e].dc(d, this.da(this.la).height(), r)) {
					c = e;
					break
				}
			this.ja != c && this.ia.trigger("onCurrentPageChanged", c + 1);
			this.ja = c;
		},
		gotoPage: function(c) {
			this.aa.gotoPage(c);
		},
		md: function(c, d) {
			var c = parseInt(c),
			e = this;
			jQuery(".flexpaper_pageword").remove();
			jQuery(".flexpaper_interactiveobject_" + e.ga).remove();
			e.ca[0].unload();
			e.ca[0].visible = l;
			var f = e.da(this.la).scrollTop();
			e.aa.$b(c);
			e.ca[0].dc(f, e.da(this.la).height(), l) && e.ca[0].load(function() {
				d != o && d();
				e.Bc();
				e.jScrollPane != o && e.jScrollPane.data("jsp").reinitialise(e.mb);
			});
		},
		zc: function(c, d) {
			var c = parseInt(c),
			e = this;
			c % 2 == 0 && c > 0 && e.aa.ba == Q && c != e.getTotalPages() && (c += 1);
			c == e.getTotalPages() && e.aa.ba == R && e.getTotalPages() % 2 == 0 && (c = e.getTotalPages() - 1);
			c % 2 == 0 && e.aa.ba == R && (c -= 1);
			c > e.getTotalPages() && (c = e.getTotalPages());
			jQuery(".flexpaper_pageword").remove();
			jQuery(".flexpaper_interactiveobject_" + e.ga).remove();
			if (c <= e.getTotalPages() && c > 0) {
				e.aa.$b(c);
				e.ja != c && e.ia.trigger("onCurrentPageChanged", c);
				e.ca[0].unload();
				e.ca[0].load(function() {
					if (e.aa.ba == R || e.aa.ba == Q) e.da(e.la).animate({
						"margin-left": e.bc()
					},
					{
						duration: 250
					}),
					e.da("#" + this.container + "_2").css("left", e.da("#" + e.container).width() / 2),
					e.Va(e.aa.scale);
				});
				e.aa.na > 1 ? (e.da(e.ca[1].oa + "_2").removeClass("flexpaper_hidden"), e.da(e.la + "_2").removeClass("flexpaper_hidden")) : e.aa.ba == Q && e.aa.na == 1 && (e.da(e.ca[1].oa + "_2").addClass("flexpaper_hidden"), e.da(e.la + "_2").addClass("flexpaper_hidden"));
				e.getTotalPages() % 2 != 0 && e.aa.ba == R && c >= e.getTotalPages() && e.da(e.ca[1].oa + "_2").addClass("flexpaper_hidden");
				e.getTotalPages() % 2 == 0 && e.aa.ba == Q && c >= e.getTotalPages() && e.da(e.ca[1].oa + "_2").addClass("flexpaper_hidden");
				var f = e.da(this.la).scrollTop();
				e.ca[1].unload();
				e.ca[1].visible = l; ! e.da(e.ca[1].oa + "_2").hasClass("flexpaper_hidden") && e.ca[1].dc(f, e.da(this.la).height(), l) && e.ca[1].load(function() {
					d != o && d();
					e.da(e.la).animate({
						"margin-left": e.bc()
					},
					{
						duration: 250
					});
					e.da("#" + this.container + "_2").css("left", e.da("#" + e.container).width() / 2);
					e.Bc();
					e.jScrollPane != o && e.jScrollPane.data("jsp").reinitialise(e.mb);
				});
			}
		},
		rotate: function(c) {
			this.ca[c].rotate();
		},
		bc: function(c) {
			this.ia.width();
			var d = 0;
			this.aa.na == 1 && !c && this.aa.ba == Q ? d = this.Hh = (this.ia.width() / 2 - this.da(this.la + "_1").width() / 2) * (this.aa.scale + 0.7) : (c = jQuery(this.la + "_2").width(), c == 0 && (c = this.da(this.la + "_1").width()), d = this.Gh = (this.ia.width() - (this.da(this.la + "_1").width() + c)) / 2);
			return d;
		},
		previous: function() {
			var c = this;
			if (c.aa.ba == I) {
				var d = c.da(c.la).scrollTop() - c.ca[0].height - 14;
				d < 0 && (d = 1);
				eb.browser.Oa.Qa ? c.da(c.la).scrollTo(d, 500) : c.jScrollPane.data("jsp").scrollToElement(this.ca[c.aa.na - 2].da(this.ca[c.aa.na - 2].qa), l, l);
			}
			c.aa.ba == "SinglePage" && c.aa.na - 1 > 0 && c.md(c.aa.na - 1);
			c.aa.ha && c.aa.ha.ab.previous(c);
			if ((c.aa.ba == R || c.aa.ba == Q) && !(c.aa.na - 2 < 1)) ! eb.platform.touchdevice || this.aa.scale == 1 ? c.zc(c.aa.na - 2) : (c.ja = c.aa.na - 2, c.da(c.la).animate({
				"margin-left": 1E3
			},
			{
				duration: 350,
				complete: function() {
					jQuery(".flexpaper_interactiveobject_" + c.ga).remove();
					c.aa.na - 2 == 1 && c.aa.ba == Q && c.ca[1].da(c.ca[1].oa + "_2").addClass("flexpaper_hidden");
					setTimeout(function() {
						c.da(c.la).css("margin-left", -800);
						c.ca[0].unload();
						c.ca[1].unload();
						c.da(c.la).animate({
							"margin-left": c.bc()
						},
						{
							duration: 350,
							complete: function() {
								setTimeout(function() {
									c.zc(c.aa.na - 2);
								},
								500);
							}
						});
					},
					500);
				}
			}));
		},
		next: function() {
			var c = this;
			if (c.aa.ba == I) {
				var d = c.aa.na - 1,
				d = this.ca[c.aa.na - 1].da(this.ca[c.aa.na - 1].qa).offset().top - c.ia.offset().top > 100 ? c.aa.na - 1 : c.aa.na;
				eb.browser.Oa.Qa ? c.da(c.la).scrollTo(this.ca[d].da(this.ca[d].qa), 500) : c.jScrollPane.data("jsp").scrollToElement(this.ca[c.aa.na].da(this.ca[c.aa.na].qa), l, l);
			}
			c.aa.ba == "SinglePage" && c.aa.na < c.getTotalPages() && c.md(c.aa.na + 1);
			c.aa.ha && c.aa.ha.ab.next(c);
			if (c.aa.ba == R || c.aa.ba == Q) {
				if (c.aa.ba == R && c.aa.na + 2 > c.getTotalPages()) return r; ! eb.platform.touchdevice || this.aa.scale == 1 ? c.zc(c.aa.na + 2) : (c.ja = c.aa.na + 2, c.da(c.la).animate({
					"margin-left": -1E3
				},
				{
					duration: 350,
					complete: function() {
						jQuery(".flexpaper_interactiveobject_" + c.ga).remove();
						c.aa.na + 2 <= c.getTotalPages() && c.aa.na + 2 > 0 && c.ca[1].da(c.ca[1].oa + "_2").removeClass("flexpaper_hidden");
						setTimeout(function() {
							c.da(c.la).css("margin-left", 800);
							c.ca[0].unload();
							c.ca[1].unload();
							c.ca[0].Pa = l;
							c.ca[1].Pa = l;
							c.da(c.la).animate({
								"margin-left": c.bc(l)
							},
							{
								duration: 350,
								complete: function() {
									setTimeout(function() {
										c.zc(c.aa.na + 2);
									},
									500);
								}
							});
						},
						500);
					}
				}));
			}
		}
	};
	return g;
} (),
fa = function() {
	function g(c, d, e, f, g, p) {
		this.ia = f;
		this.aa = g;
		this.ca = e;
		this.Ca = 1E3;
		this.Ja = this.Pa = r;
		this.ga = c;
		this.pageNumber = d;
		this.dimensions = p;
		this.selectors = [];
		this.nb = "data:image/gif;base64,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%3D%3D";
		this.fb = "dummyPage_" + this.pageNumber + "_" + this.ga;
		this.page = "page_" + this.pageNumber + "_" + this.ga;
		this.qb = "pageContainer_" + this.pageNumber + "_" + this.ga;
		this.Xf = this.qb + "_textlayer";
		this.Oc = "dummyPageCanvas_" + this.pageNumber + "_" + this.ga;
		this.Pc = "dummyPageCanvas2_" + this.pageNumber + "_" + this.ga;
		this.Kc = this.page + "_canvasOverlay";
		this.Ua = "pageLoader_" + this.pageNumber + "_" + this.ga;
		this.je = this.qb + "_textoverlay";
		this.ba = this.aa.ba;
		this.sa = this.aa.ha ? this.aa.ha.sa: "";
		this.renderer = this.aa.renderer;
		c = this.aa.scale;
		this.scale = c;
		this.oa = "#" + this.fb;
		this.ua = "#" + this.page;
		this.qa = "#" + this.qb;
		this.jh = "#" + this.Xf;
		this.hd = "#" + this.Oc;
		this.jd = "#" + this.Pc;
		this.Lg = "#" + this.Kc;
		this.jb = "#" + this.Ua;
		this.rd = "#" + this.je;
	}
	g.prototype = {
		da: function(c) {
			this.selectors[c] || (this.selectors[c] = jQuery(c));
			return this.selectors[c];
		},
		show: function() {
			this.aa.ba != R && this.aa.ba != Q && this.da(this.ua).removeClass("flexpaper_hidden");
		},
		Lc: function() {
			eb.platform.touchdevice || (!eb.browser.Oa.Qa && this.ca.jScrollPane ? this.ca.jScrollPane.data("jsp").scrollToX(this.da(this.qa).width() / 2, r) : this.da(this.qa).parent().scrollTo({
				left: "50%"
			},
			0, {
				axis: "x"
			}));
		},
		create: function(c) {
			if (this.aa.ba == I && (c.append("<div class='flexpaper_page' id='" + this.qb + "' class='flexpaper_rescale' style='position:relative;'><div id='" + this.fb + "' class='' style='z-index:11;" + this.getDimensions() + ";'></div></div>"), jQuery(this.aa.Bd).length > 0)) {
				var d = this.Ca * this.scale;
				jQuery(this.aa.Bd).append("<div id='" + this.je + "' class='flexpaper_page' style='position:relative;height:" + d + "px;width:100%;overflow:hidden;'></div>");
			}
			this.aa.ba == "SinglePage" && this.pageNumber == 0 && c.append("<div class='flexpaper_page' id='" + this.qb + "' class='flexpaper_rescale' style='position:relative;'><div id='" + this.fb + "' class='' style='z-index:11;" + this.getDimensions() + "'></div></div>");
			this.aa.ba == this.sa && this.aa.ha.tb.create(this, c);
			if (this.aa.ba == R || this.aa.ba == Q) this.pageNumber == 0 && jQuery(c.children().get(0)).append("<div class='flexpaper_page' id='" + this.qb + "_1' style='z-index:2;float:right;position:relative;'><div id='" + this.fb + "_1' class='flexpaper_hidden flexpaper_border' style='" + this.getDimensions() + ";float:right;'></div></div>"),
			this.pageNumber == 1 && jQuery(c.children().get(1)).append("<div class='flexpaper_page' id='" + this.qb + "_2' style='position:relative;z-index:1;float:left;'><div id='" + this.fb + "_2' class='flexpaper_hidden flexpaper_border' style='" + this.getDimensions() + ";float:left'></div></div>");
			this.aa.ba == T && c.append("<div class='flexpaper_page' id='" + this.qb + "' style='position:relative;" + (eb.browser.msie ? "clear:none;float:left;": "display:inline-block;") + "'><div id=\"" + this.fb + '" onclick="window.$FlexPaper(\'' + this.ga + "').gotoPage(" + (this.pageNumber + 1) + ')" class="flexpaper_page flexpaper_thumb flexpaper_border flexpaper_load_on_demand" style="margin-left:10px;' + this.getDimensions() + '"></div></div>');
			this.renderer.Zc(this);
			this.show();
			this.height = this.da(this.qa).height();
			this.jg();
		},
		Af: function() {
			if (this.aa.ba == I || this.aa.ba == "SinglePage") return this.Kc;
			if (this.aa.ba == R || this.aa.ba == Q) {
				if (this.pageNumber == 0) return this.Kc + "_1";
				if (this.pageNumber == 1) return this.Kc + "_2";
			}
		},
		Qc: function() {
			if (this.aa.ba == I || this.aa.ba == "SinglePage") return this.oa;
			if (this.aa.ba == R || this.aa.ba == Q) {
				if (this.pageNumber == 0) return this.qa + "_1";
				if (this.pageNumber == 1) return this.qa + "_2";
			}
		},
		Rc: function() {
			if (this.aa.ba == I || this.aa.ba == "SinglePage") return this.qa;
			if (this.aa.ba == R || this.aa.ba == Q) {
				if (this.pageNumber == 0) return this.qa + "_1";
				if (this.pageNumber == 1) return this.qa + "_2";
			}
		},
		xd: function(c) {
			this.da(this.rd).css({
				top: c
			});
		},
		lb: function() { (this.aa.ba == I || this.aa.ba == "SinglePage" || this.aa.ba == this.sa) && this.da("#" + this.Ua).hide();
			if (this.aa.ba == R || this.aa.ba == Q) this.pageNumber == 0 && this.da(this.jb + "_1").hide(),
			this.pageNumber == 1 && this.da(this.jb + "_2").hide();
		},
		nc: function() {
			var c = this;
			if (c.aa.ba == I || c.aa.ba == "SinglePage" || c.aa.ba == c.sa) {
				c.Ca = 1E3;
				if (c.da(c.jb).length > 0) return;
				c.Ic === o && c.aa.ba == c.sa ? (c.Ic = jQuery("<div style='position:absolute;left:50%;top:50%;'></div>"), c.da(c.qa).append(c.Ic), c.Ic.spin({
					color: "#777"
				}), c.Xc = setTimeout(function() {
					c.Ic.remove();
				},
				1E3)) : c.da(c.qa).find("#" + c.Ua).length == 0 && c.da(c.qa).append("<img id='" + c.Ua + "' src='" + c.nb + "' class='flexpaper_pageLoader'  style='position:absolute;left:50%;top:50%;margin-left:" + c.Mb() + "' />");
			}
			if (c.aa.ba == R || c.aa.ba == Q) {
				if (c.pageNumber == 0) {
					if (c.da(c.jb + "_1").length > 0) {
						c.da(c.jb + "_1").show();
						return;
					}
					c.da(c.oa + "_1").append("<img id='" + c.Ua + "_1' src='" + c.nb + "' style='position:absolute;left:" + (c.hb() - 30) + "px;top:" + c.gb() / 2 + "px;' />");
					c.da(c.jb + "_1").show();
				}
				c.pageNumber == 1 && (c.da(c.jb + "_2").length > 0 || c.da(c.oa + "_2").append("<img id='" + c.Ua + "_2' src='" + c.nb + "' style='position:absolute;left:" + (c.hb() / 2 - 10) + "px;top:" + c.gb() / 2 + "px;' />"), c.da(c.jb + "_2").show());
			}
		},
		Va: function() {
			var c = this.hb(),
			d = this.gb(),
			e = this.Mb();
			if (this.aa.ba == I || this.aa.ba == "SinglePage") this.rotation == 90 ? (this.da(this.qa).css({
				"margin-left": (this.da(this.qa).height() - this.da(this.qa).width()) / 2 + 10
			}), this.da(this.qa).css({
				"margin-top": (this.da(this.qa).width() - this.da(this.qa).height()) / 2 + 10
			})) : this.rotation == 270 ? (this.da(this.qa).css({
				"margin-left": (this.da(this.qa).height() - this.da(this.qa).width()) / 2 + 10
			}), this.da(this.qa).css({
				"margin-top": (this.da(this.qa).width() - this.da(this.qa).height()) / 2 + 100
			})) : this.rotation == 180 ? this.da(this.qa).css({
				height: d,
				width: c,
				"margin-left": e * 3,
				"margin-top": 0
			}) : this.da(this.qa).css({
				height: d,
				width: c,
				"margin-left": e,
				"margin-top": 0
			}),
			this.da(this.rd).css({
				height: d,
				width: "99%",
				"margin-left": e
			}),
			this.da(this.oa).css({
				height: d,
				width: c,
				"margin-left": e
			}),
			this.da(this.ua).css({
				height: d,
				width: c,
				"margin-left": e
			}),
			this.da(this.hd).css({
				height: d,
				width: c
			}),
			this.da(this.jd).css({
				height: d,
				width: c
			}),
			this.da(this.jb).css({
				"margin-left": e
			});
			if (this.aa.ba == R || this.aa.ba == Q) this.da(this.oa + "_1").css({
				height: d,
				width: c
			}),
			this.da(this.oa + "_2").css({
				height: d,
				width: c
			}),
			this.da(this.oa + "_1_textoverlay").css({
				height: d,
				width: c
			}),
			this.da(this.oa + "_2_textoverlay").css({
				height: d,
				width: c
			}),
			this.da(this.ua).css({
				height: d,
				width: c
			}),
			eb.browser.Oa.Qa || (this.ca.ja == 0 ? this.ca.da(this.ca.la).css({
				height: d,
				width: c
			}) : this.ca.da(this.ca.la).css({
				height: d,
				width: c * 2
			}), this.aa.ba == R && this.ca.da(this.ca.la).css({
				width: "100%"
			})),
			eb.platform.touchdevice && this.scale >= 1 && this.ca.da(this.ca.la).css({
				width: c * 2
			}),
			eb.platform.touchdevice && (this.aa.ba == R && this.ca.da(this.ca.la + "_2").css("left", this.ca.da(this.ca.la + "_1").width() + e + 2), this.aa.ba == Q && this.ca.da(this.ca.la + "_2").css("left", this.ca.da(this.ca.la + "_1").width() + e + 2));
			this.height = d;
			this.width = c;
		},
		resize: s(),
		yc: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.yc(this) : this.Ca * this.scale * (this.dimensions.xa / this.dimensions.Da);
		},
		Sd: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.Sd(this) : this.Ca * this.scale;
		},
		getDimensions: function() {
			var c = this.ld(),
			d = this.aa.yc();
			if (this.aa.ba == I || this.aa.ba == "SinglePage") {
				var e = this.Ca * this.scale;
				return "height:" + e + "px;width:" + e * c + "px;margin-left:" + (d - e * c) / 2 + "px;";
			}
			if (this.aa.ba == this.sa) return this.aa.ha.tb.getDimensions(this, c);
			if (this.aa.ba == R || this.aa.ba == Q) return e = this.ia.width() / 2 * this.scale,
			(this.pageNumber == 0 ? "margin-left:0px;": "") + "height:" + e + "px;width:" + e * c + "px";
			if (this.aa.ba == T) return e = this.Ca * ((this.ia.height() - 100) / this.Ca) / 2.7,
			"height:" + e + "px;width:" + e * c + "px";
		},
		ld: function() {
			return this.dimensions.xa / this.dimensions.Da;
		},
		hb: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.hb(this) : this.Ca * this.ld() * this.scale;
		},
		Ff: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.Ff(this) : this.Ca * this.ld();
		},
		Ef: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.Ef(this) : this.Ca;
		},
		gb: function() {
			return this.aa.ba == this.sa ? this.aa.ha.tb.gb(this) : this.Ca * this.scale;
		},
		Mb: function() {
			var c = this.aa.yc(),
			d = 0;
			if (this.aa.ba == I || this.aa.ba == "SinglePage") return d = (c - this.hb()) / 2 / 2 - 4,
			d > 0 ? d: 0;
			if (this.aa.ba == R || this.aa.ba == Q) return 0;
			if (this.aa.ba == this.sa) return this.aa.ha.tb.Mb(this);
		},
		dc: function(c, d, e) {
			if (this.aa.ba == I || this.aa.ba == T) if (this.offset = this.da(this.qa).offset()) {
				if (!this.ca.Ad) this.ca.Ad = this.aa.ma.offset().top;
				var f = this.offset.top - this.ca.Ad + c,
				g = this.offset.top + this.height,
				d = c + d;
				var h = eb.platform.touchdevice ? 50 : 0;
				this.Pa = e || eb.platform.touchdevice ? c - this.height + h <= f && d >= f || f - this.height + h <= c && g >= d: c <= f && d >= f || f <= c && g >= d;
			} else this.Pa = r;
			if (this.aa.ba == "SinglePage") this.Pa = this.pageNumber == 0;
			if (this.aa.ba == this.sa) this.Pa = this.aa.ha.tb.dc(this);
			if (this.aa.ba == Q) {
				if (this.ca.getTotalPages() % 2 == 0 && this.ca.ja >= this.ca.getTotalPages() && this.pageNumber == 1) return r;
				this.Pa = this.pageNumber == 0 || this.ca.ja != 0 && this.pageNumber == 1;
			}
			if (this.aa.ba == R) {
				if (this.ca.getTotalPages() % 2 != 0 && this.ca.ja >= this.ca.getTotalPages() && this.pageNumber == 1) return r;
				this.Pa = this.pageNumber == 0 || this.pageNumber == 1;
			}
			return this.Pa;
		},
		Pf: function() {
			this.Ja || this.load();
		},
		load: function(c) {
			this.Aa(c);
			if (!this.Ja) {
				if (this.aa.ba == R && (c = this.renderer.getDimensions(this.pageNumber - 1, this.pageNumber - 1)[this.ca.ja + this.pageNumber], c.width != this.dimensions.width || c.height != this.dimensions.height)) this.dimensions = c,
				this.Va();
				if (this.aa.ba == Q && (c = this.renderer.getDimensions(this.pageNumber - 1, this.pageNumber - 1)[this.ca.ja - (this.ca.ja > 0 ? 1 : 0) + this.pageNumber], c.width != this.dimensions.width || c.height != this.dimensions.height)) this.dimensions = c,
				this.Va();
				this.renderer.Db(this, r);
				typeof this.nd === "function" && this.loadOverlay();
			}
		},
		unload: function() {
			if (this.Ja || !(this.aa.ba != R && this.aa.ba != Q && this.aa.ba != this.sa)) this.Ja = r,
			this.renderer.unload(this),
			this.aa.ba != R && this.aa.ba != Q && this.da("#" + this.Af()).remove(),
			typeof this.nd === "function" && this.Jh();
		},
		Aa: function(c) {
			this.aa.ba != T && (this.Pa || c != o) && !this.ca.Fd && this.renderer.Aa(this, r, c);
		},
		Ya: function(c, d) {
			this.renderer.Ya(this, c, d);
		},
		jg: function() { ! (eb.browser.msie && eb.browser.version < 9) && !eb.platform.ios && (new ca(this.aa, this.ua, this.da(this.qa).parent())).scroll();
		},
		rotate: function() {
			if (!this.rotation || this.rotation == 360) this.rotation = 0;
			this.rotation += 90;
			if (this.aa.ba == I || this.aa.ba == "SinglePage") this.Va(),
			this.da(this.qa).transition({
				rotate: this.rotation
			});
		}
	};
	return g;
} ();
function ha(g, c) {
	this.aa = this.Pg = g;
	this.ia = this.aa.ia;
	this.resources = this.aa.resources;
	this.ga = this.aa.ga;
	this.document = c;
	this.Wb = o;
	this.Ta = "toolbar_" + this.aa.ga;
	this.ea = "#" + this.Ta;
	this.Md = this.Ta + "_bttnPrintdialogPrint";
	this.Ld = this.Ta + "_bttnPrintdialogCancel";
	this.Id = this.Ta + "_bttnPrintDialog_RangeAll";
	this.Jd = this.Ta + "_bttnPrintDialog_RangeCurrent";
	this.Kd = this.Ta + "_bttnPrintDialog_RangeSpecific";
	this.Hd = this.Ta + "_bttnPrintDialogRangeText";
	this.kd = o;
	this.create = function() {
		var c = this;
		if (!eb.platform.touchdevice && !c.kd) {
			var e = c.resources.ka.He,
			f = String.format("<div class='flexpaper_floatright flexpaper_bttnPercent' sbttnPrintIdtyle='text-align:center;padding-top:5px;background-repeat:no-repeat;width:20px;height:20px;font-size:9px;font-family:Arial;background-image:url({0})'><div id='lblPercent'></div></div>", c.resources.ka.Ye);
			eb.browser.msie && addCSSRule(".flexpaper_tbtextinput", "height", "18px");
			jQuery(c.ea).html((c.aa.config.document.PrintToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton print flexpaper_bttnPrint'/>", c.resources.ka.Te) + String.format("<img src='{0}' class='flexpaper_tbseparator' />", e) : "") + (c.aa.config.document.ViewModeToolsVisible ? String.format("<img src='{1}' class='flexpaper_bttnSinglePage flexpaper_tbbutton flexpaper_viewmode flexpaper_singlepage {0}' />", c.aa.Nb == I ? "flexpaper_tbbutton_pressed": "", c.resources.ka.Xe) + String.format("<img src='{1}' class='flexpaper_bttnTwoPage flexpaper_tbbutton flexpaper_viewmode flexpaper_twopage {0}' />", c.aa.Nb == R ? "flexpaper_tbbutton_pressed": "", c.resources.ka.bf) + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_thumbview flexpaper_viewmode flexpaper_bttnThumbView' />", c.resources.ka.$e) + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_fitmode flexpaper_fitwidth flexpaper_bttnFitWidth' />", c.resources.ka.Re) + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_fitmode flexpaper_fitheight flexpaper_bttnFitHeight'/>", c.resources.ka.Qe) + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_bttnRotate'/>", c.resources.ka.Ve) + String.format("<img src='{0}' class='flexpaper_tbseparator' />", e) : "") + (c.aa.config.document.ZoomToolsVisible ? String.format("<div class='flexpaper_slider flexpaper_zoomSlider'><div class='flexpaper_handle'></div></div>") + String.format("<input type='text' class='flexpaper_tbtextinput flexpaper_txtZoomFactor' style='width:40px;' />") + String.format("<img class='flexpaper_tbbutton flexpaper_bttnFullScreen' src='{0}' />", c.resources.ka.Ne) + String.format("<img src='{0}' class='flexpaper_tbseparator' style='margin-left:5px' />", e) : "") + (c.aa.config.document.NavToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_previous flexpaper_bttnPrevPage'/>", c.resources.ka.De) + String.format("<input type='text' class='flexpaper_tbtextinput flexpaper_currPageNum flexpaper_txtPageNumber' value='1' style='width:50px;text-align:right;' />") + String.format("<div class='flexpaper_tblabel flexpaper_numberOfPages flexpaper_lblTotalPages'> / </div>") + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_next flexpaper_bttnPrevNext'/>", c.resources.ka.Fe) + String.format("<img src='{0}' class='flexpaper_tbseparator' />", e) : "") + (c.aa.config.document.CursorToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_bttnTextSelect'/>", c.resources.ka.Ze) + String.format("<img src='{0}' class='flexpaper_tbbutton flexpaper_tbbutton_pressed flexpaper_bttnHand'/>", c.resources.ka.Pe) + String.format("<img src='{0}' class='flexpaper_tbseparator' />", e) : "") + (c.aa.config.document.SearchToolsVisible ? String.format("<input type='text' class='flexpaper_tbtextinput flexpaper_txtSearch' style='width:70px;margin-left:4px' />") + String.format("<img src='{0}' class='flexpaper_find flexpaper_tbbutton flexpaper_bttnFind' />", c.resources.ka.Ke) + String.format("<img src='{0}' class='flexpaper_tbseparator' />", e) : "") + f);
			jQuery(c.ea).addClass("flexpaper_toolbarstd");
		} else if (!c.kd) e = c.resources.ka.Ie,
		jQuery(c.ea).html((c.aa.config.document.PrintToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton_large flexpaper_print flexpaper_bttnPrint' style='margin-left:5px;'/>", c.resources.ka.Ue) : "") + (c.aa.config.document.ViewModeToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton_large flexpaper_viewmode flexpaper_singlepage {1} flexpaper_bttnSinglePage' style='margin-left:15px;'>", c.resources.ka.We, c.aa.Nb == I ? "flexpaper_tbbutton_pressed": "") + String.format("<img src='{0}' style='margin-left:-1px;' class='flexpaper_tbbutton_large flexpaper_viewmode  flexpaper_twopage {1} flexpaper_bttnTwoPage'>", c.resources.ka.df, c.aa.Nb == R ? "flexpaper_tbbutton_pressed": "") + String.format("<img src='{0}' style='margin-left:-1px;' class='flexpaper_tbbutton_large flexpaper_viewmode flexpaper_thumbview flexpaper_bttnThumbView'>", c.resources.ka.af) + (!eb.platform.ios ? String.format("<img src='{0}' style='margin-left:-1px;' class='flexpaper_tbbutton_large flexpaper_fitmode flexpaper_fitwidth flexpaper_bttnFitWidth'>", c.resources.ka.Me) : "") + (!eb.platform.ios ? String.format("<img src='{0}' style='margin-left:-1px;' class='flexpaper_tbbutton_large flexpaper_fitmode fitheight flexpaper_bttnFitHeight'>", c.resources.ka.Se) : "") + "": "") + (c.aa.config.document.ZoomToolsVisible ? String.format("<img class='flexpaper_tbbutton_large flexpaper_bttnZoomIn' src='{0}' style='margin-left:15px;' />", c.resources.ka.ef) + String.format("<img class='flexpaper_tbbutton_large flexpaper_bttnZoomOut' src='{0}' style='margin-left:-1px;' />", c.resources.ka.gf) + String.format("<img class='flexpaper_tbbutton_large flexpaper_bttnFullScreen' src='{0}' style='margin-left:-1px;' />", c.resources.ka.Oe) + "": "") + (c.aa.config.document.NavToolsVisible ? String.format("<img src='{0}' class='flexpaper_tbbutton_large flexpaper_previous flexpaper_bttnPrevPage' style='margin-left:15px;'/>", c.resources.ka.Ee) + String.format("<input type='text' class='flexpaper_tbtextinput_large flexpaper_currPageNum flexpaper_txtPageNumber' value='1' style='width:80px;text-align:right;' />") + String.format("<div class='flexpaper_tblabel_large flexpaper_numberOfPages flexpaper_lblTotalPages'> / </div>") + String.format("<img src='{0}'  class='flexpaper_tbbutton_large flexpaper_next flexpaper_bttnPrevNext'/>", c.resources.ka.Ge) + "": "") + (c.aa.config.document.SearchToolsVisible ? String.format("<input type='text' class='flexpaper_tbtextinput_large flexpaper_txtSearch' style='margin-left:15px;width:130px;' />") + String.format("<img src='{0}' class='flexpaper_find flexpaper_tbbutton_large flexpaper_bttnFind' style=''/>", c.resources.ka.Le) + "": "")),
		jQuery(c.ea).addClass("flexpaper_toolbarios");
		jQuery(c.ia).bind("onDocumentLoaded",
		function() {
			jQuery(c.ea).find(".flexpaper_bttnPercent").hide();
		});
	};
	this.de = function(c) {
		var a;
		a = this.Xa = c.split("\n"),
		c = a;
		jQuery(this.ea).find(".flexpaper_bttnPrint").attr("title", this.ta(c, "Print"));
		jQuery(this.ea).find(".flexpaper_bttnSinglePage").attr("title", this.ta(c, "SinglePage"));
		jQuery(this.ea).find(".flexpaper_bttnTwoPage, .flexpaper_bttnBookView").attr("title", this.ta(c, R));
		jQuery(this.ea).find(".flexpaper_bttnThumbView").attr("title", this.ta(c, T));
		jQuery(this.ea).find(".flexpaper_bttnFitWidth").attr("title", this.ta(c, "FitWidth"));
		jQuery(this.ea).find(".flexpaper_bttnFitHeight").attr("title", this.ta(c, "FitHeight"));
		jQuery(this.ea).find(".flexpaper_bttnFitHeight").attr("title", this.ta(c, "FitPage"));
		jQuery(this.ea).find(".flexpaper_zoomSlider").attr("title", this.ta(c, "Scale"));
		jQuery(this.ea).find(".flexpaper_txtZoomFactor").attr("title", this.ta(c, "Scale"));
		jQuery(this.ea).find(".flexpaper_bttnFullScreen, .flexpaper_bttnFullscreen").attr("title", this.ta(c, "Fullscreen"));
		jQuery(this.ea).find(".flexpaper_bttnPrevPage").attr("title", this.ta(c, "PreviousPage"));
		jQuery(this.ea).find(".flexpaper_txtPageNumber").attr("title", this.ta(c, "CurrentPage"));
		jQuery(this.ea).find(".flexpaper_bttnPrevNext").attr("title", this.ta(c, "NextPage"));
		jQuery(this.ea).find(".flexpaper_txtSearch").attr("title", this.ta(c, "Search"));
		jQuery(this.ea).find(".flexpaper_bttnFind").attr("title", this.ta(c, "Search"));
		this.aa.ma.find(".flexpaper_bttnHighlight").find(".flexpaper_tbtextbutton").html(this.ta(c, "Highlight", "Highlight"));
		this.aa.ma.find(".flexpaper_bttnComment").find(".flexpaper_tbtextbutton").html(this.ta(c, "Comment", "Comment"));
		this.aa.ma.find(".flexpaper_bttnStrikeout").find(".flexpaper_tbtextbutton").html(this.ta(c, "Strikeout", "Strikeout"));
		this.aa.ma.find(".flexpaper_bttnDraw").find(".flexpaper_tbtextbutton").html(this.ta(c, "Draw", "Draw"));
		this.aa.ma.find(".flexpaper_bttnDelete").find(".flexpaper_tbtextbutton").html(this.ta(c, "Delete", "Delete"));
		this.aa.ma.find(".flexpaper_bttnShowHide").find(".flexpaper_tbtextbutton").html(this.ta(c, "ShowAnnotations", "Show Annotations"));
	};
	this.ta = function(c, e, f) {
		for (var g = 0; g < c.length; g++) {
			var p = c[g].split("=");
			if (p[0] == e) return p[1];
		}
		return f ? f: o;
	};
	this.bindEvents = function() {
		var c = this;
		c.aa.ma.prepend("<div id='modal-print' class='modal-content flexpaper_printdialog' style='overflow:hidden;'><font style='color:#000000;font-size:11px'><b>" + c.ta(c.Xa, "Selectprintrange") + "</b></font><div style='width:98%;padding-top:5px;padding-left:5px;background-color:#ffffff;'><table border='0' style='margin-bottom:10px;'><tr><td><input type='radio' name='PrintRange' checked='checked' id='" + c.Id + "'/></td><td>" + c.ta(c.Xa, "All") + "</td></tr><tr><td><input type='radio' name='PrintRange' id='" + c.Jd + "'/></td><td>" + c.ta(c.Xa, "CurrentPage") + "</td></tr><tr><td><input type='radio' name='PrintRange' id='" + c.Kd + "'/></td><td>" + c.ta(c.Xa, "Pages") + "</td><td><input type='text' style='width:120px' id='" + c.Hd + "' /><td></tr><tr><td colspan='3'>" + c.ta(c.Xa, "Enterpagenumbers") + "</td></tr></table><a href='#' id='" + c.Md + "' class='flexpaper_printdialog_button'>" + c.ta(c.Xa, "Print") + "</a>&nbsp;&nbsp;<a href='#' class='flexpaper_printdialog_button' id='" + c.Ld + "'>" + c.ta(c.Xa, "Cancel") + "</a><div style='height:5px;display:block;margin-top:5px;'>&nbsp;</div></div></div>");
		jQuery("input:radio[name=PrintRange]:nth(0)").attr("checked", l);
		c.aa.config.Toolbar || (jQuery(c.ea).find(".flexpaper_bttnFitWidth").bind("click",
		function() {
			jQuery(this).hasClass("flexpaper_tbbutton_disabled") || (c.aa.fitwidth(), jQuery("#toolbar").trigger("onFitModeChanged", "Fit Width"));
		}), jQuery(c.ea).find(".flexpaper_bttnFitHeight").bind("click",
		function() {
			jQuery(this).hasClass("flexpaper_tbbutton_disabled") || (c.aa.fitheight(), jQuery("#toolbar").trigger("onFitModeChanged", "Fit Height"));
		}), jQuery(c.ea).find(".flexpaper_bttnTwoPage").bind("click",
		function() {
			c.aa.Nb == Q ? c.aa.switchMode(Q) : c.aa.switchMode(R);
		}), jQuery(c.ea).find(".flexpaper_bttnSinglePage").bind("click",
		function() {
			c.aa.switchMode(I);
		}), jQuery(c.ea).find(".flexpaper_bttnThumbView").bind("click",
		function() {
			c.aa.switchMode("Tile");
		}), jQuery(c.ea).find(".flexpaper_bttnPrint").bind("click",
		function() {
			jQuery("#modal-print").css("background-color", "#dedede");
			jQuery("#modal-print").modal({
				minHeight: 255,
				appendTo: c.aa.ma
			});
			jQuery("#modal-print").parent().css("background-color", "#dedede");
		}), jQuery(c.ea).find(".flexpaper_bttnPrevPage").bind("click",
		function() {
			c.aa.previous();
			return r;
		}), jQuery(c.ea).find(".flexpaper_bttnPrevNext").bind("click",
		function() {
			c.aa.next();
			return r;
		}), jQuery(c.ea).find(".flexpaper_bttnZoomIn").bind("click",
		function() {
			c.aa.ba == R || c.aa.ba == Q ? c.aa.ca.Uc() : c.aa.ba == I && c.aa.fitwidth();
		}), jQuery(c.ea).find(".flexpaper_bttnZoomOut").bind("click",
		function() {
			c.aa.ba == R || c.aa.ba == Q ? c.aa.ca.Vc() : c.aa.ba == I && c.aa.fitheight();
		}), jQuery(c.ea).find(".flexpaper_txtZoomFactor").bind("click",
		function() {
			if (!jQuery(this).hasClass("flexpaper_tbbutton_disabled")) return jQuery(c.ea).find(".flexpaper_txtZoomFactor").focus(),
			r;
		}), jQuery(c.ea).find(".flexpaper_currPageNum").bind("click",
		function() {
			jQuery(c.ea).find(".flexpaper_currPageNum").focus();
		}), jQuery(c.ea).find(".flexpaper_currPageNum").bind("keydown",
		function(e) {
			if (!jQuery(this).hasClass("flexpaper_tbbutton_disabled")) {
				if (e.keyCode != "13") return;
				c.gotoPage(this);
			}
			return r;
		}), jQuery(c.ea).find(".flexpaper_txtSearch").bind("click",
		function() {
			jQuery(c.ea).find(".flexpaper_txtSearch").focus();
			return r;
		}), jQuery(c.ea).find(".flexpaper_txtSearch").bind("keydown",
		function(e) {
			if (e.keyCode == "13") return c.searchText(jQuery(c.ea).find(".flexpaper_txtSearch").val()),
			r;
		}), jQuery(c.ea).find(".flexpaper_bttnFullScreen, .flexpaper_bttnFullscreen").bind("click",
		function() {
			c.aa.openFullScreen();
		}), jQuery(c.ea).find(".flexpaper_bttnFind").bind("click",
		function() {
			c.searchText(jQuery(c.ea).find(".flexpaper_txtSearch").val());
			jQuery(c.ea).find(".flexpaper_bttnFind").focus();
			return r;
		}), jQuery(c.ea).find(".flexpaper_bttnTextSelect").bind("click",
		function() {
			c.aa.Fb = "flexpaper_selected_default";
			jQuery(c.ea).find(".flexpaper_bttnTextSelect").addClass("flexpaper_tbbutton_pressed");
			jQuery(c.ea).find(".flexpaper_bttnHand").removeClass("flexpaper_tbbutton_pressed");
			c.aa.setCurrentCursor("TextSelectorCursor");
		}), jQuery(c.ea).find(".flexpaper_bttnHand").bind("click",
		function() {
			jQuery(c.ea).find(".flexpaper_bttnHand").addClass("flexpaper_tbbutton_pressed");
			jQuery(c.ea).find(".flexpaper_bttnTextSelect").removeClass("flexpaper_tbbutton_pressed");
			c.aa.setCurrentCursor("ArrowCursor");
		}), jQuery(c.ea).find(".flexpaper_bttnRotate").bind("click",
		function() {
			c.aa.rotate();
		}));
		jQuery(c.ea).bind("onZoomFactorChanged",
		function(e, f) {
			var g = Math.round(f.ac / c.aa.document.MaxZoomSize * 100 * c.aa.document.MaxZoomSize) + "%";
			jQuery(c.ea).find(".flexpaper_txtZoomFactor").val(g);
			if (c.ac != f.ac) c.ac = f.ac,
			jQuery(c.aa).trigger("onScaleChanged", f.ac);
		});
		jQuery(c.ea).bind("onCursorChanged",
		function(e, f) {
			f == "TextSelectorCursor" && (jQuery(c.ea).find(".flexpaper_bttnTextSelect").addClass("flexpaper_tbbutton_pressed"), jQuery(c.ea).find(".flexpaper_bttnHand").removeClass("flexpaper_tbbutton_pressed"));
			f == "ArrowCursor" && (jQuery(c.ea).find(".flexpaper_bttnHand").addClass("flexpaper_tbbutton_pressed"), jQuery(c.ea).find(".flexpaper_bttnTextSelect").removeClass("flexpaper_tbbutton_pressed"));
		});
		jQuery(c.ea).bind("onFitModeChanged",
		function(e, f) {
			jQuery(".flexpaper_fitmode").each(function() {
				jQuery(this).removeClass("flexpaper_tbbutton_pressed");
			});
			f == "FitHeight" && jQuery(c.ea).find(".flexpaper_bttnFitHeight").addClass("flexpaper_tbbutton_pressed");
			f == "FitWidth" && jQuery(c.ea).find(".flexpaper_bttnFitWidth").addClass("flexpaper_tbbutton_pressed");
		});
		jQuery(c.ea).bind("onProgressChanged",
		function(e, f) {
			jQuery("#lblPercent").html(f * 100);
			f == 1 && jQuery(c.ea).find(".flexpaper_bttnPercent").hide();
		});
		jQuery(c.ea).bind("onViewModeChanged",
		function() {
			jQuery(".flexpaper_viewmode").each(function() {
				jQuery(this).removeClass("flexpaper_tbbutton_pressed");
			});
			c.aa.ba == "Portrait" && (jQuery(c.ea).find(".flexpaper_bttnSinglePage").addClass("flexpaper_tbbutton_pressed"), jQuery(c.ea).find(".flexpaper_bttnFitWidth").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnFitHeight").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnPrevPage").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnPrevNext").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnTextSelect").removeClass("flexpaper_tbbutton_disabled"), eb.platform.touchdevice || (jQuery(c.ea).find(".flexpaper_zoomSlider").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_txtZoomFactor").removeClass("flexpaper_tbbutton_disabled"), c.aa.toolbar.Ka && c.aa.toolbar.Ka.enable()));
			if (c.aa.ba == "TwoPage" || c.aa.ba == "BookView") {
				jQuery(c.ea).find(".flexpaper_bttnTwoPage").addClass("flexpaper_tbbutton_pressed");
				jQuery(c.ea).find(".flexpaper_bttnFitWidth").addClass("flexpaper_tbbutton_disabled");
				jQuery(c.ea).find(".flexpaper_bttnFitHeight").addClass("flexpaper_tbbutton_disabled");
				jQuery(c.ea).find(".flexpaper_bttnPrevPage").removeClass("flexpaper_tbbutton_disabled");
				jQuery(c.ea).find(".flexpaper_bttnPrevNext").removeClass("flexpaper_tbbutton_disabled");
				jQuery(c.ea).find(".flexpaper_bttnTextSelect").removeClass("flexpaper_tbbutton_disabled");
				if (eb.platform.touchdevice || eb.browser.msie) jQuery(c.ea).find(".flexpaper_zoomSlider").addClass("flexpaper_tbbutton_disabled"),
				jQuery(c.ea).find(".flexpaper_txtZoomFactor").addClass("flexpaper_tbbutton_disabled"),
				c.aa.toolbar.Ka && c.aa.toolbar.Ka.disable(); ! eb.platform.touchdevice && !eb.browser.msie && (jQuery(c.ea).find(".flexpaper_zoomSlider").removeClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_txtZoomFactor").removeClass("flexpaper_tbbutton_disabled"), c.aa.toolbar.Ka && c.aa.toolbar.Ka.enable());
			}
			c.aa.ba == "ThumbView" && (jQuery(c.ea).find(".flexpaper_bttnThumbView").addClass("flexpaper_tbbutton_pressed"), jQuery(c.ea).find(".flexpaper_bttnFitWidth").addClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnFitHeight").addClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnPrevPage").addClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnPrevNext").addClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_bttnTextSelect").addClass("flexpaper_tbbutton_disabled"), eb.platform.touchdevice || (jQuery(c.ea).find(".flexpaper_zoomSlider").addClass("flexpaper_tbbutton_disabled"), jQuery(c.ea).find(".flexpaper_txtZoomFactor").addClass("flexpaper_tbbutton_disabled"), c.aa.toolbar.Ka && c.aa.toolbar.Ka.disable()));
		});
		jQuery(c.ea).bind("onFullscreenChanged",
		function(e, f) {
			f ? jQuery(c.ea).find(".flexpaper_bttnFullscreen").addClass("flexpaper_tbbutton_disabled") : jQuery(c.ea).find(".flexpaper_bttnFullscreen").removeClass("flexpaper_tbbutton_disabled");
		});
		jQuery(c.ea).bind("onScaleChanged",
		function(e, f) {
			c.Ka && c.Ka.setValue(f, l);
		});
		jQuery("#" + c.Ld).bind("mousedown",
		function() {
			jQuery.modal.close();
		});
		jQuery("#" + c.Md).bind("mousedown",
		function() {
			jQuery("#" + c.Id).is(":checked") && c.aa.printPaper("all");
			jQuery("#" + c.Jd).is(":checked") && c.aa.printPaper("current");
			if (jQuery("#" + c.Kd).is(":checked")) {
				var e = jQuery("#" + c.Hd).val();
				c.aa.printPaper(e);
			}
			jQuery.modal.close();
		});
		c.og();
	};
	this.nf = function(c, e) {
		var f = this;
		if (jQuery(f.ea).find(".flexpaper_zoomSlider").length != 0 && f.Ka == o) {
			f = this;
			this.ic = c;
			this.hc = e;
			if (window.zine) {
				var g = {
					ug: 0,
					zg: f.aa.ia.width() / 2,
					Ag: f.aa.ia.height() / 2
				};
				f.Ka = new Slider(jQuery(f.ea).find(".flexpaper_zoomSlider").get(0), {
					callback: function(c) {
						c * f.aa.document.MaxZoomSize >= f.aa.document.MinZoomSize && c <= f.aa.document.MaxZoomSize ? f.aa.Ha(f.aa.document.MaxZoomSize * c, g) : c * f.aa.document.MaxZoomSize < f.aa.document.MinZoomSize ? f.aa.Ha(f.aa.document.MinZoomSize, g) : c > f.aa.document.MaxZoomSize && f.aa.Ha(f.aa.document.MaxZoomSize, g);
					},
					animation_callback: function(c) {
						c * f.aa.document.MaxZoomSize >= f.aa.document.MinZoomSize && c <= f.aa.document.MaxZoomSize ? f.aa.Ha(f.aa.document.MaxZoomSize * c, g) : c * f.aa.document.MaxZoomSize < f.aa.document.MinZoomSize ? f.aa.Ha(f.aa.document.MinZoomSize, g) : c > f.aa.document.MaxZoomSize && f.aa.Ha(f.aa.document.MaxZoomSize, g);
					},
					snapping: r
				});
			} else f.Ka = new Slider(jQuery(f.ea).find(".flexpaper_zoomSlider").get(0), {
				callback: function(c) {
					c * f.aa.document.MaxZoomSize >= f.ic && c <= f.hc ? f.aa.Ha(f.aa.document.MaxZoomSize * c) : c * f.aa.document.MaxZoomSize < f.ic ? f.aa.Ha(f.ic) : c > f.hc && f.aa.Ha(f.hc);
				},
				animation_callback: function(c) {
					c * f.aa.document.MaxZoomSize >= f.ic && c <= f.hc ? f.aa.Ha(f.aa.document.MaxZoomSize * c) : c * f.aa.document.MaxZoomSize < f.ic ? f.aa.Ha(f.ic) : c > f.hc && f.aa.Ha(f.hc);
				},
				snapping: r
			});
			jQuery(f.ea).find(".flexpaper_txtZoomFactor").bind("keypress",
			function(c) {
				if (!jQuery(this).hasClass("flexpaper_tbbutton_disabled") && c.keyCode == 13) {
					try {
						var d = jQuery(f.ea).find(".flexpaper_txtZoomFactor").val().replace("%", "") / 100;
						f.aa.Zoom(d);
					} catch(e) {}
					return r;
				}
			});
		}
	};
	this.pg = function(c) {
		jQuery(c).val() > this.document.numPages && jQuery(c).val(this.document.numPages); (jQuery(c).val() < 1 || isNaN(jQuery(c).val())) && jQuery(c).val(1);
	};
	this.ng = function(c) {
		this.aa.ba == R ? c == "1" ? jQuery(this.ea).find(".flexpaper_txtPageNumber").val("1-2") : parseInt(c) <= this.document.numPages && this.document.numPages % 2 == 0 || parseInt(c) < this.document.numPages && this.document.numPages % 2 != 0 ? jQuery(this.ea).find(".flexpaper_txtPageNumber").val(c + "-" + (c + 1)) : jQuery(this.ea).find(".flexpaper_txtPageNumber").val(this.document.numPages) : this.aa.ba == Q || this.aa.ba == ba ? c == "1" ? jQuery(this.ea).find(".flexpaper_txtPageNumber").val("1") : parseInt(c) + 1 <= this.document.numPages ? (parseInt(c) % 2 != 0 && (c -= 1), jQuery(this.ea).find(".flexpaper_txtPageNumber").val(c + "-" + (c + 1))) : jQuery(this.ea).find(".flexpaper_txtPageNumber").val(c) : c != "0" && jQuery(this.ea).find(".flexpaper_txtPageNumber").val(c);
	};
	this.og = function() {
		jQuery(this.ea).find(".flexpaper_lblTotalPages").html(" / " + this.document.numPages);
	};
	this.gotoPage = function(c) {
		jQuery(c).val().indexOf("-") >= 0 && this.aa.ba == R ? (c = jQuery(c).val().split("-"), !isNaN(c[0]) && !isNaN(c[1]) && (parseInt(c[0]) % 2 == 0 ? this.aa.gotoPage(parseInt(c[0]) - 1) : this.aa.gotoPage(parseInt(c[0])))) : isNaN(jQuery(c).val()) || (this.pg(c), this.aa.gotoPage(jQuery(c).val()));
	};
	this.searchText = function(c) {
		this.aa.searchText(c);
	};
}
window.addCSSRule = function(g, c, d) {
	for (var e = 0; e < document.styleSheets.length; e++) {
		var f = document.styleSheets[e],
		t = f.cssRules || f.rules,
		p = g.toLowerCase();
		if (t != o) for (var j = 0,
		u = t.length; j < u; j++) if (t[j].selectorText && t[j].selectorText.toLowerCase() == p) if (d != o) {
			t[j].style[c] = d;
			return;
		} else f.deleteRule ? f.deleteRule(j) : f.removeRule ? f.removeRule(j) : t[j].style.cssText = "";
	}
	f = document.styleSheets[0] || {};
	f.insertRule ? (t = f.cssRules || f.rules, f.insertRule(g + "{ " + c + ":" + d + "; }", t.length)) : f.addRule && f.addRule(g, c + ":" + d + ";", 0);
};
window.FlexPaper_Resources = function(g) {
	this.aa = g;
	this.ia = this.aa.ia;
	this.ka = {};
	this.ka.Cd = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
	this.ka.Ye = "data:image/gif;base64,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%3D%3D";
	this.ka.Te = "data:image/gif;base64,R0lGODlhDwAPAOMGAPHx8f39/f7+/ujo6N3d3fr5+f///52dnf///////////////////////////////yH5BAEKAAgALAAAAAAPAA8AAARCEMlJ6zw4Y3uE+Z93VMdgnuZIHUTrtiqizbMcGp4HGuNR/MDgrwegaYqyVA5UGvRguB2L0MvodJrVzhCIrYyWsCUCADs%3D";
	this.ka.He = "data:image/gif;base64,R0lGODlhAwAVAIABAJmZmf///yH5BAEKAAEALAAAAAADABUAAAINRBynaaje0pORrWnhKQA7";
	this.ka.Xe = "data:image/gif;base64,R0lGODlhDwAPAOf/AAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAPgALAAAAAAPAA8AAAitAHEJFJgLmMFgwoQNI6aQ3b+HECM+FKbMocR//vrpy3cv1zGHqUKKFHmvXi1iFjH248dvnz579OTFEgZy5MiYroCBg5iRpUuY8lL9AnfP5khz5UzpIgpzXjx48N61Q4d0VC2il7Jq1Yr0Uyx295o+jToV6SZY7OptXTsu3KVW7OTJg+eO3bp16tCJC/eNkiN2ec2RGwcO3Ddv2bBZ+1Oo0SNGiiJLRmTJkaJDAQEAOw%3D%3D";
	this.ka.bf = "data:image/gif;base64,R0lGODlhDwAPAOf/AAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAP4ALAAAAAAPAA8AAAjCAHEJFAgMGK5gwhIOIyZsGLt/ECEOixhRmLKHFJX968dPX757uY49TEXy37F/JFPdq1eLGMaN/4j982iPnrxYwkaWFIaSpE1XwMBF7PcP2Mx8NeWl+gXuXsp7v5ySNFfOlK6mNePd03Wv3Tp0VEfVanqp7L1a98peovopFrt7We/F6vqV6iZY7OqprQdLb9lx4S61YidPHjzCreSBFRfuGyVH7NSBHQfO0Tdv3LJhs/anUKNHjBSJLqQIESNLjhQdCggAOw%3D%3D";
	this.ka.$e = "data:image/gif;base64,R0lGODlhDwAPAMZLAGZmZmxsbHl5eX5+foSEhIWFhYaGhoiIiImJiYqKiouLi4yMjI2NjY6OjpCQkJKSkpOTk5SUlJaWlqKioqenp6qqqqurq62trbCwsLGxsbW1tbi4uLm5ubq6ur29vcDAwMHBwcLCwsPDw8TExMfHx8rKyszMzNDQ0NbW1tnZ2dvb29zc3N7e3t/f3+Dg4OHh4ePj4+Tk5OXl5ebm5ujo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1QACH5BAEKAH8ALAAAAAAPAA8AAAepgBuCghwfHyAhiSEjISI4S5CRkpAhJzgCAAJLmAJJnEMflgAmAEujAEinQR4lOAEAAUqvAUazPhwkj5FHRURDQb1BGiOXmUqcQJw+GR04p0OnPac1ExiusD+zObMyEhc4Q0JAPz08Ozk3NjQyERXFAj+cOZwyDxbOpDynN6cvDhTXAuiYRWNWiwUNcKibEQOGixYsVqhIgWIAAQUMEhzYuNEAAggRDhQIBAA7";
	this.ka.Re = "data:image/gif;base64,R0lGODlhDwAPAOf/AAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAOAALAAAAAAPAA8AAAjRAHEJFJgLWDBhCIUNI6bwn8OHEB8KUxbxn79+/Pbpy3cv17GI/vhlzIfvXr1axCBe1MjRHj15sYT9gyemmEiS9+Z9cfbOFTB4Zr4Uc0cP3zx05IIKS/ULzJcvYMCssmct6lMwpnTRm7Pznr158eC1MyOm2aha8vK1GVaPXth26cBQO/cpFjyv9MC+a7dOHTpz5TbBgtdWHrx37NalO1duXLhLreDJM+yOnV9z5MSF+0bJkeW/5MZ988ZtWzZs1v4UavSIkaLXihAxqmTJkaJDAQEAOw%3D%3D";
	this.ka.Qe = "data:image/gif;base64,R0lGODlhDwAPAOf/AAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKANUALAAAAAAPAA8AAAjXAHEJxJULGLBgwhIKG0Zs4b+HEMHIg/hQGDSK/+h8MQPPXz9++4BdhOjmi0kx/EDm66WMIjJpYIwR26cv371cxyj68wfm3b58+O7Vq0UMokd+YObZtEdPXixd+37es1dvXjx47tqxSycKVr168uC9cwcmXbpz5caFs9RKXlh37NaB4WaOnLhw3yipihcP7jl0YK7dBeetm6RV7tytUwfGzJcyX75546YN0il2W89FC2PyF7dt2rAxcqROXd1xxsDc0rYtGzZrfggtaoSodm1DiSZRYoSoUEAAOw%3D%3D";
	this.ka.Ne = "data:image/gif;base64,R0lGODlhEQAOAMIGAGZmZm9vb4eHh4yMjLKyssrKyv///////yH5BAEKAAcALAAAAAARAA4AAAMweLrcDDDK+MK4GMM33Npf5x2gAoheSaKOeo4kwMHuZMvfPXlE7xOwgmBIFBRgSEUCADs%3D";
	this.ka.De = "data:image/gif;base64,R0lGODlhDwAPAMZsAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra////////////////////////////////////////////////////////////////////////////////yH5BAEHAH8ALAAAAAAPAA8AAAcrgH+Cg4SFhoNrh4ZriYqIjI6CjJCOk5SHlpeYlpF/nJ2TnZKNoqSip6iKgQA7";
	this.ka.Fe = "data:image/gif;base64,R0lGODlhDwAPAMZsAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra////////////////////////////////////////////////////////////////////////////////yH5BAEHAH8ALAAAAAAPAA8AAAcqgH+Cg4SFhWuGiX9riIqEjI2Oi5CSk5SOkJeJmZGbmoqfoJ2YlaWmp4SBADs%3D";
	this.ka.Ze = "data:image/gif;base64,R0lGODlhEAAPAIABAGtrawAAACH5BAEKAAEALAAAAAAQAA8AAAIkjI+pi+DhgJGMnrfsxEnDqHgRN3WjJp5Wel6mVzbsR8HMjScFADs%3D";
	this.ka.Pe = "data:image/gif;base64,R0lGODlhEAAPAIQYADk5OUJCQk1NTVVVVV9fX2ZmZuHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O7u7u/v7/Dw8PLy8vT09PX19QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEKAB8ALAAAAAAQAA8AAAVa4CeOZGmORXGSaTFJ6VpUVBFBxRKXc33nhYOKZam4YI6CYoiiSW4PnRCVKlJeEQdjKSpcak7oIjH9zC5WLGSLYM7CkEeDbGCaC5RnfF7mXfUMdix6cgmCKyYhADs%3D";
	this.ka.Ke = "data:image/gif;base64,R0lGODlhDwAPAMZBAOzs7GBgYEpKSj8/Qz09QUhISEtLSxkZGff39y8vLxYVG2dnaKKiooiIiG1tbczMzJCPk05OTt3c4dzc3B0dHY+PjzQ1NU1MT5mZmTY1Oy0tLfj4+NjX1u/v7z09PdLS0uvq6pmZltXV1k1MTiEhIe7u8OPj5O3t7c3Nzfb29ezr7pWVmdfX1/v7++nn6dXV1YyMjcbGxklJSdLR09LR0uPj44+PklNTVPLy8vn499TU1pKSkn5+fujo6CIhJtrZ2wAAAP///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH5BAEKAH8ALAAAAAAPAA8AAAdngH+Cg4SFhC40LIaFPxYJBxWLgjoEMEEoMjuLPRk2QUEAMR4MhjMKKkEtOA88EYYiPhKfNR0BDosrAyZBCBgUL5IQGg0BJEACJ5IhNwsTBccbkoMpF0AGINKCJSNAHNmCAB853+TSgQA7";
	this.ka.Ve = "data:image/gif;base64,R0lGODlhEQAQAOcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEHAP8ALAAAAAARABAAAAjcAP8JHDhQmcGDBgkC+6FH4LJs4Lp1A5dt2UBgSqIMRPZtHTp0674hG6hH48Bi2s6NG3dOWzGBQ5gMGfJEoLGUK1saG8jFSZCBwbCRCxeOHLZgBNsQ/GWNHDhw5Kz9IkjVV9Nv36L2cuRoESJEgv786dMHT5063cJJy9Uo2rZp06A9e2bQ2S+0atmCk1euHDly4rhxG9esTrhz1Ww14rbuqTdv3KxZ65asjjRqyGgtbgzuceTJyezQGq15b9+/gQc7s0OwkTRucOXSVWaX9UCuir4G8uOHDx+zdQgGBAA7";
	this.Gd = "data:image/png;base64,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%3D";
	this.Yf = function() {
		var c = this.aa;
		this.Hf = l;
		jQuery(".flexpaper_tbloader").hide();
		//jQuery(".flexpaper_floatright").show();
		var d = eb.platform.touchdevice || jQuery(".flexpaper_floatright").length == 2 && jQuery(".flexpaper_floatright").is(":visible") && jQuery(".flexpaper_bttnI").children(0).attr("src") == this.ka.Cd || r,
		e = Math.pow(9, 3),
		f = Math.pow(6, 2),
		d = c.config.key != o && c.config.key.length > 0 && c.config.key.indexOf("@") >= 0,
		g = "",
		g = "",
		g = ["d0ma1n"],
		g = g[0] + "",
		f = parseInt(f) + Y(l) + "AdaptiveUId0ma1n",
		e = U(parseInt(e) + (d ? c.config.key.split("$")[0] : Y(l)) + g),
		f = U(f),
		e = "$" + e.substring(11, 30).toLowerCase(),
		f = "$" + f.substring(11, 30).toLowerCase(); (d = Z() || c.config.key == e || c.config.key == f || d && e == "$" + c.config.key.split("$")[1]); //|| alert("License key not accepted. Please check your configuration settings.");
		this.Hf = r;
		jQuery(".flexpaper_tbloader").hide(); (d || Z()) && jQuery(this).trigger("onPostinitialized");
	};
	this.initialize = function() {
		var c = this.aa,
		d = this;
		c.ma.prepend("<div id='modal-I' class='modal-content'><p><img src='data:image/png;base64,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%3D%3D' style='display:block;padding-left:85px;padding-bottom:10px;' /></p>FlexPaper 2.1.2-rc6. Developed by Devaldi Ltd.<br/>For more information, see the <a href='http://flexpaper.devaldi.com/?ref=FlexPaper'>FlexPaper Project</a> home page</div>");
		var e = String.format("<div class='flexpaper_floatright flexpaper_bttnI' style='display:none'><img src='{0}' /></div>", c.resources.ka.Cd);
		eb.platform.touchdevice || jQuery(c.toolbar.ea).append(e);
		/*jQuery(c.ia).bind("onPagesContainerCreated",
		function() {
			c.ia.append("<div style='-moz-user-select:none;-webkit-user-select:none;float:right;position:relative;margin-top:-35px;margin-right:30px;z-index:11'><a href='#' onClick='dlInfoBox()'><img id='fpabt' src='" + d.Gd + "' border='0'></a></div>");
			jQuery("#fpabt").bind("mouseover",
			function() {
				jQuery("#fpabt").attr("src", "data:image/png;base64,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");
			});
			jQuery("#fpabt").bind("mouseout",
			function() {
				jQuery("#fpabt").attr("src", d.Gd);
			});
		});*/
		jQuery(c.toolbar.ea).find(".flexpaper_bttnI").bind("click",
		function() {
			jQuery("#modal-I").modal();
		});
		jQuery(c.toolbar.ea).bind("onProgressChanged",
		function(d, e) {
			e == 1 && jQuery(c.ea).find(".flexpaper_bttnI").show();
		});
	};
	this.ka.Ue = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAZMw/s7MUAAAPsSURBVEjHvVffTyJXFP4Ogq4D4ccMlAimqxiXl5I0G6P/wJZmq131tfvcTbr/QbP/zbbvW7fafehu9RXTNiHUiE9gJQQVVkdWhDhzTx/44cAMA+xqTzK5cOfm3O9+5zvn3CEYLJvNcrVaRa1WgxACd2UulwterxeKokCSJAQCAQIAai9IpVI8Pj4OWZYxNTWFu7ZcLodisYhoNIpgMAhZlskJANvb2+zz+RCbm+MWQDYC7WPcGsnmP/WMnfezsRhkWUY2mwVz8xVls1lWVRXxeBxutwc9QPqBGwbsMMZnZ+/p4OAAsdkYnKqqIhqNYlKSWLCw3WxzcxO/vHqFYYGsra9jZWXFkpm2+fx+DoVCVHlfgaPRaCAYDjMTYdDzUUcfwu/M3ByrqgqnruuA6HtS6hp5VCQw+iYb/9A0DU4AoLaCzPoYRdDWp2EeBLfj19mkUvRmCFtkycjUMAQbfPdjpUNEE8wNOCsWOuLj0XkhHkxoNzOGXSyY+cQsZthmk4kZiKGAQ7vWRsKhXWsDfHdbSzNsCtPFxQXevPmN/slksLi4RN8+eYKJexMjgZm4NwEmpl9fv8buboq+SCTw+PE38Hq9/cPEbIb/808vkU6nAQBHhSMwCySTSSwsLGBsbGxg7HRdhyzLYBY4Khzh5OQEf7x7h0q5jB+eP+/PDJhMmkmn051JoQt8qF7C6XTC7wu0wdv2JiIH168apGkaC110fKXTaeN+VtnEdtmEvb09vHjxo7WQ+s91it11j9a4Oy+7w0Q22UREEEJHo6F/UkckopvuzDbZxMRWFbc5wYzbMKMfi4QxCrhvO7gTMwBji6JHNEAPt4yGLPdyDirzxljflmbYrujZdG0wM2ZmZvHVo0cAEcYcDojmelsGHUTQhQCY8fvbt8jnc1ad3Kprm7NJURSqVCoAgIAcwJcPH370HfjPv/+iNhhFUXrKjLnOmE753dOn2NjYwL+Hh02KwdhNpbC1tQW3JBHMNz/DkRiXtRotLy9jcWmJqLX28/v3sbq62lvXOp8vTpfLhdPjYwRDn3V5fvAgjmffP8OHy0tIkgQWjFKphEq5jMqQOimVSmDBWFtbRzL5NTxuN3x+P1h0q+Ywn4PX6wVlMhmu1+sIhUII+BXTFcxUeCw+E/rFys5He81p+RiFQgHz8/NwJBIJqtfrOD8/x9l5BUzMzaLEYGI2ju2nvYbBzXJKDG49aM1x72h4h9bvk9MSisUiIpEIotHoTeB3dnbY4/FgcnIS09PTDAaBDIcyXtmo6zpGXXPG/20fN2OHxPxhHqqqIhwOIx6Pk6no7O/vc7VaxdXV1f/yrR0MBhGJRDoY/gMkxwIzT9ZCwQAAAABJRU5ErkJggg%3D%3D";
	this.ka.Ie = "data:image/gif;base64,R0lGODlhBgAqAKEBAJmZmf///////////yH+GkNyZWF0ZWQgd2l0aCBHSU1QIG9uIGEgTWFjACH5BAEKAAIALAAAAAAGACoAAAIkBBJmuOjPTlIR2hlbu05TzHWSMkohSFYn+m2h561svMKlbEcFADs%3D";
	this.ka.We = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAYCdD7BDYAAAMVSURBVEjHvVfdSuNQEP6mJEJjaG2aUtsorC3SKxHfwYfwB8HFfYPFB/ERll3cl7AoiBfe2gXjjbogZV1XbShoLWlmL5rEY9qkUVMHhsn5yZw53/yccwgCmabJ7XYbDw8PcBwH4yJZlpHJZJDP56EoCnK5HAEAeROOj495YmICmqahVCph3HRxcYFmswnDMKDrOjRNIwkA9vf3OZvNolKtsmsgi4aGELuSItoUkP74XKUCTdNgmiaY+0NkmiZbloVarYbJSRUBQ8KMi2NsHOL7+zs6OztDZa4CybIsGIaBtKKww87Qxb5sbQUXHjCEiPwdLi8vY2V1NRIZj7JTU1woFOj27happ6cn6MUiMxHCONYWmSHLMr5ub2Nvbw8/d3cpSqfIn6pVtiwLUq/XA5xQyF/lCkVRoCoKNE1DvV4HAKysrlOELr/Ptm2kAICY2WUI0v+OS91uF5IkYXFxEQBQr9fx4/s3CPqC7K8FABIAMDnBDBkWxCPJtm1Ml6axtr7GqqrSyckJDg8PYds2Nj9vcggqfiyl+i3ymAISDIrtql6vh1+NX2AQLS0tYWNjA7Ozszg6OvJ0iiyuST4yYEQgE99NjuNgZ2fHzy5ZlmHbtqeGQ2LH7+8bE1n531ZOmBndblewdPQ/bsywuHJSBe2lccQjM7ZvDDtjP4virOHGDEVlU2LQxIqZ59gao5sQ000UmU3JEMXNJiG4Ig+1ZLw0gAoHApg5xE2JIcQ81E084KbA0UzvLjLDoRlZxKTX1dj3BHDMokcf4KaQ03/QTQKCY8smJsSuM4lcrt5QZ0h8vqRkWcbN9TXY4VBOxJgI/Zfn58hkMqBGo8GdTgeFQgG5qfyAM4OFB0OeCWHvlSgd3pybf9e4urrC/Pw8UgsLC9TpdNBqtXDfuoV7/3SBZRalx94cBvfLNzHYZbh9HJTCGNzvvzd/0Gw2US6XYRjGc305ODhgVVWRTqcxMzPDYBBI2BQLgNCL6xi96BPbno5n6YN4+fsSlmWhWCyiVqvRQICenp5yu93G4+Pjh7y1dV1HuVz2bfgP5BfYXgA24coAAAAASUVORK5CYII%3D";
	this.ka.df = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAUJ6CYRvUAAAPBSURBVEjHxZfNThtXFMd/Z/wh4VAbPKYIG1mNkeUVUkpC+gY067as0k0CPEfUXdRnaHbNl8kD2Nl4JFasmqgLjJIIwsJqQsGMLAEGz5wu7DFjYzupXZorXZ25H+fec8/5/8+9I/hKuVzWWq3G8fExrutyVSUUChGNRjFNk0gkwuTkpACIN2Fzc1PD4TDxeJyZmRmuuuzs7FCpVEilUiQSCeLxuAQBSqWSxmIxMnNz2jJQ/Yb2KdqSMqAtXbI9fj2TIR6PUy6XUW0OSblcVtu2yeVyXLs2Tpch/Yz7HGM/p2i1eijb29tkrmcI2rZNKpViLBJRV5s4cV1XDcMQgPX1dYqFQjOmIt4pOgz57dEjVldWLu3km8/3d+6wvLysgLiui2EYAMQmJnRqakoODg8w6vU6ielpVRFUBEcVCQRQEfL5vBQLBbLZLOFwuL3wpeNJbyepKuFwmGw2S7FQIJ/Pi4oggQCOKt6e38zNqW3bGI7jgIt41cAQXOTF8zwvi0VM0+Te/VUikUh/Zw8gXiQS4d79VUzT5GWxyIvneXDBwOjYt9FoYACIqrYqoqrPnj6hWCwAsLBwk1AgoPV6ve+G0sdjAPV6nVAgwMLCTQCKxQLPnj7B26slAQg23dw+mj7+/bFsbGyQyWS48e0NXVpaIhAI0Gg0+qNQ3L6AbjQaTMRj+uNPP/BVdJxXf7wSyyrhOA3u/ny3g4VGsyVeFcuySKfTrKytsbh4m/rZubx5+w7HcQZwXPoyy3Ec3rx9J/Wzc1m8/Z2srK2RTqexLKu9p6cf7MgQLcru7e3xy4MHnJ+fSy/29M04veDkuvz68GGbXaFQ6OJg2pmfgr0A6DjOQE/8GwB3s+vs7KyvXgsz7aMNlch8+sPoSacxOtqlOKx+t14LMzJamtchb4amXidmlBHDxJBhokeYREe7AIeEjKfX5RlR+TRJrwTA/qeFB2DVkcKkQxrTVJRuAI/2NhkewHI5z4z6QvqP9ILerT1KmGTIMEmvMPm8PBSbRkszF2ySUqmkC7du8aXLn69fEwyFQux/+EBi6usvZsj73R2i0ShGLBajWq1yVD1EVNqVHhJfW7r6e7UHreH1/b3/kWq1immaGPPz83J6esrR0RHVowNa789mshZVv/SqN0fRZhoVRVuVVp92S98Yre+P+39RqVRIJpOkUqkLnluWpePj44yNjTE7O6sogvj+m9QHbOl4jklHn7/trXEh24zdfb+LbdtMT0+Ty+XkEpW3tra0VqtxcnLyv/xrJxIJkslk24Z/AJjcAKCwx1DkAAAAAElFTkSuQmCC";
	this.ka.af = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAWLXJ7zWkAAAL7SURBVEjHzVdRTxpBEP7G3JGABOTuCJHzoUIMT77VtOkP8keYCpEafoR/5nxqJPbNB88XtYkhtRblQgKY6E0fuDsW2Fs51KaTbJa9b3Z3dma+2YUgiOu63O/3MRgM4Ps+3kt0XUcul4NpmshkMigUCgQAFCq0221OpVIwDAPr6+t4b7m6ukKn04Ft27AsC4ZhkAYAjuNwPp9HpVrlwEAWDY0RDnpSjGmmj/DNSgWGYcB1XTCPIXJdlz3PQ61Ww+pqFjOGxBm3iLGLCD883NPFxQUqmxVonufBtm2kMxn22U+y2as8E0p+bY2LxSJ177vQHh8fYZVKzJLdDup1AoBut0sAYJomAKDRbIoYAowEDAAowCiYR41mU7YNPlSrfHpyQtrz8zPgJ3S5St9PNC8aPz09QQMAYhZdGIUoPPXu7i4A4OjoCKF+6C0JpponC3VkkAYATP5sHihzRtBPirHEK5EjxsZM9p3yTCqVmjpZOGbQspjsgNOeASORZ8AqjrGKf7J1I8+Q4zj8+dMXjrFYVWfwBtSO1jlpfw/CRCwN07fmgZTa+/WGiE1RO8Ck1N6vN/BimJiTXYoq/WUxIWdImjNxFAUTlsSUOaNN8mo+TOo8XAp7mU0Uw6Y4ihLH0/4FbAHPEMsYoCherCiIjATY1F7kOA5/3NnhmDC9+xMiXOfH6WmUwCSLYat1KKX23t5XarUOMUPtEIMKi8uXCbWXOM5bY0IC/1e3drK7iUmV3EpsoTojXSL+9mVSYMp5cTmj6zpWdF3H3e0t2Oe5FnvCV2Cydn15iVwuBzo7O+PRaIRisYjCmjkXTFnhoQVf5ao1Qp27P7e4ubnB1tYWVra3t2k0GqHX6+Gh1wUT87g4MZiYxT5soQ6DxyWXGBw0BN94thcwBL9/3/1Cp9NBuVyGbduT+nJ8fMzZbBbpdBobGxsMBoGEQwnPweA7ID4Tw2/iOFxj0kdOvP55Dc/zUCqVUKvVaK7onJ+fc7/fx3A4/Cf/tS3LQrlcjmz4C6V4EUpXdwN6AAAAAElFTkSuQmCC";
	this.ka.Me = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAWE7Ma0MIAAAM+SURBVEjHxVdNT9tAEH0TESQCSsBxGhFzKOGQE5eKHxbshL8Q2/yocOWIesCcgEtUSsGxIvEhgaeHeDfrzTpJW1FGenrrnTe7Y3u86yUoFkURTyYTPD09IU1TfJSVy2VUq1XU63VUKhXs7OwQAJAQnJ+f8/r6OizLwu7uLj7arq+vMRqN4DgObNuGZVm0BgDD4ZBrtRraBwecJchqogXGGdOCa9JY+vfbbViWhSiKwDx1URRFnCQJOp0ONje3oCVSlNwqya5iHMePdHV1hfZ+G2tJksBxHGxUKpxy+ieT/dOTEVbb3uZGo0EPjw8ovb6+wm42mYnwWfh6cMBJkqD0/v4OpCADYGAB8rpd0vop60dBLJnGEXh7e0MJAIiZM0BhFPTBc7vI4uYAAJ7bNfoMYDWuBABMqQBrrLfhesezopn6chA+1zs2+hWo4/MsGZAAaZxre66nVTCRDtXvuR6ZNIbxSSYDlmCNAWaAgZ7rmr4nFv4shnVJz3Xzfs7Nl4ubJpMuAqHnuebPPPPn9Abree6SOaDWDAuQxuj13eKFRtFl7cK1qdd3SdPPxU2T4dSIfs9buPCZYhZZv+cVzqXUDAmw4JN+f4XFXOpnj3eJnfT76ny5uBJytcUkOAhPl+cy04v20v0qCE/V+XJx2aInwSqHwenCO1X0or1QHwanqn4urqQU4lzxMjEFYbjkLeVR/ERCLiheGZcVsDRSWPTDDwI2F7DUibbxNflBgNmOI/VQ5lIXPbmFQmG1Tb4fmh7NPPRE/NCs0+eaFfBqGGgJmTSqDfxw5bGVAl591/YHgVLA5l0bAPxB8Le7tgRrbMTAn9aQpmOm6U0O/MA0FheMK+NoOBzyt6MjfLZ9v7jAWrlcxv3dHezGl09L5PbmGtVqFaVarYY4jjGOH0FMEjAwlGvS+k3Xi8YQfb/ufyKOY9TrdZQODw/p5eUF4/EY8fgBWSWLxZ5Vlj8gmYahLaNZHBSfZMWHrP3z/gdGoxFarRYcx5n9mZ2dnfHW1hY2Njawt7fHYBBIOWawcsQg5SsW/aJPvRZjzFgeVW5ub5AkCZrNJjqdDs2dYS4vL3kymeD5+fm/nLVt20ar1ZI5/AZC6tu9dBzKcQAAAABJRU5ErkJggg%3D%3D";
	this.ka.Se = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAVHAiInpAAAAMSSURBVEjHzVfbTuJQFF2bUBOJcimMoPgwI4n8XmmJ8wXQwlz8JE184gvsEzjJjEaYDENINBrtnof2HA71lJtx4iGLda6rq7uHfShBKb7v83Q6xd3dHYIgwFsVwzCQzWZRLBaRyWRQKBQIAEhM6PV6vLW1BdM0sb+/j7cug8EA19fXqFarKJVKME2T0gBwdnbGuVwOR7UaRwZZNZpQOGJa0KYYy/FPR0cwTRO+74M5HEr5vs+ZTAaVSgUEIgJxxIjqKkNpk5jXsCyo7ehDGlbHkc8XuF6vYzgc4tfPX0y9Xo+r1So+7O1x7M5Jc3fxqMBuNGT/99NTXjUyqs6g36fHx0ekHh4eUCqXmYmwLlQjwtgmOh9rNZ5MJkg9Pz8DAUgDaFiAHMvS7inHspCwlnQ6Ak9PT0gBADFzBCiMhD44trVwZzu2BXX+AkhdAKEZpkCAYxyvw3YaK/10bach1iZB1eeZGZAAxXiu7tjOWrnEsR2K1uug6pM0A5bgGAPMAANN294ouTVtW9VWdDHfL80Ei0BoOja9Jts2HXvJNcJ56XDPsC63yPLl6zddnlnLIIOT5sv+0AwHeA8lHdqmeGZ987NJp5OOQrjwMS0L75I2JYzrH9Nsy7yHyBDrBOTCzycny6KwNDKdbjcpKjIUYdKbFVJY9MPrdPg1G9PrdDA7cRgKxLXUpCePUCis1snzupsZ8bpQ9OKYXWt2HKwGd01DrtddWVuaWefU9tzOahFxO5ue2hIcYy1cb/Eecr2OTosTdJkJ6qnNpAE0LD7U9jytkbbnIWEt6XQEDMNAyjAMjG5vwQGvjVbbnTPSarsb6Vz1+8hms0jlcjmMx2P8Hf8J//NHgIahtAVarTBC7ZY3N2+Zhuj7PRpiPB6jWCyGCeni4oJ3d3eRz+eRL5hh4hPfDJI8S1XqnJf5NOm9IlYfjW5xc3ODSqWC4+NjklLn5+e8s7OD7e1tHB4ezkwIyZdmhCjN9alt9UZIHoEEAFc/rjCZTFAul1Gv1+lFCr+8vOTpdIr7+/v/8q5dKpVwcHAgPfwDmoUpP5Jd2SsAAAAASUVORK5CYII%3D";
	this.ka.ef = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wEAwEtNTlGiyEAAAOcSURBVEjHxZfNbttGEMd/Q0ty5MhULFF1LPkQy0B1MuDXiN+hybXIpS1a9yGaB2lO6SPYQHPxJTmazsXOoURiVaYIAZZUWJweRFKstKTktmkXWCx3ZjmcnfnPB4XUcF1XB4MBt7e3hGHI5xrFYhHbtqnX62xsbLC1tSUAEh84OzvTUqlErVZjZ2eHzz0uLy/xPI9Wq4XjONRqNSkAnJycaLVapb2/r5GCmlY0Y2i0Ss5e5taEv9duU6vVcF0X1SlLXNfVIAjodDo8fFhhTpEs5ZJ9GIaoKqqKiGBZFiKyqoHU92/k4uKC9l6bQhAEtFotyhsbGmq48LGllhFERBBEp0SV6Ka5lolH9dEjbTQa0rvpYY3HY5ztbVUR/q/5ZH9fgyCgMJlMIMy0gphuk2E1WfJu7jt3d3cUAGK7GvCxFDNv3vzK619eA3B4eMizr54nhyaTCWtra8tcncgtAKiE8xGihigxYsb76EkqT8WyFCBkgpUN5oUonCozU85kBclQSABsu5oQHMeJZQnAWqGYeROTqwpzdzdYRrNSiQKUSqVEWKm0Dqpp/tJoWrAM4UqKGzE4CAbJ82g0glD+dlaOMKN5bsrV0n3vJgTP+21e1rJoWnSTqtk06Wj48fh4WWgDcPzD90b6Ty9frmYZVIyY0RCw5N+pjDOT5WNGyXCTzHhP9vawbZv3FxfU63VK6+uMRyN832c4HCaSm80m6w8e8Md4TK/X48tOh7hMrOQmyYimNbES3ouvX5huw6tXP8vbd28BaDQafPvNdxgTpq4YTSpqyrggSFQ8Za4SJ2ce7zyGd1NipVJJA3jRU1Flz8phEYCzy4Gq5pYDUsJFhJmoxWhK8bLLASpZyUQkzqhq9nP3upsKbQ8TNMIwnPY5UxBmRmUhr/isMsrlcvK8ublprhuWtdI3/nHVXviw3utqpqqdV5vyO72nR0fy9Ogo2euKPXBenrl3cxXjwOT/yNBxBK7UXBWLRQrFYpHup084jS/uhRVB0DDfJbqiyz5cXWLbNla1WsX3ffr+DaKSTAwrqb3M0U37PBkx7ffuNb7vU6/XsQ4ODmQ0GtHv9/H7vWlvL5r0+ek1nvEZRafpWxSNJhFN59cUj+j5uvsRz/NoNpu0Wq1Zfjk9PdVKpUK5XGZ3d1fRqScS8KXawb9kHU3qmC7sYxmzNcHJ1YcrgiBge3ubTqcjC6A6Pz/XwWDAcDj8T/61Hceh2WwmOvwJjz3t/SbNLJ0AAAAASUVORK5CYII%3D";
	this.ka.gf = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wEAwEuF8cLmQYAAALYSURBVEjHzVfNbtpAEP7G2CQQZCe2KYqdQwCpPuW9qtzTh2geCq55gpheSC6oSUqMhRSgCjs9+AcHvMbkp+lIq/Xs2rOz334zsyZkxPd9nk6neHp6ghACHyWapkHXdViWhXq9jqOjIwIASl64urriarUK0zRxfHyMj5bhcIjRaATXdWHbNkzTJBUAer0eG4aBTrfLsYOcdVQiHPdUoNNan863Ox2Ypgnf98EcTZHv+xyGITzPw8FBA2uOyJxLdSEEmBnMDCKCoiggorIAcRA80mAwQKfdgRqGIVzXRa1eZ8FiY7GtyBCIiEAgjgaZ4p0WIpOIcXjIzWaTxo9jKIvFAnarxUyEz2qn3S6HYQh1uVwCQooC5e1Gghpt+bbwm+fnZ6gAkOCaw4+tnHmjvLCjAgCTWI8QzokSWTTl7ZZLOLIRhZEzK+fyUJAZpxILYQenImQyS+Ugw7JUEitMBfrWaNpABgIlN7kLb3eXmDNcdExlj+I10bR5TMz50CyXS1QqFQDA94uLN23/x+VlOWTAlMsZFgCU94jgF/AXc4YhOSZazZ2229B1HT8HA1iWhereHhbzOYIgwGw2Sy07joO9/X38WSwwHo/x1fOQlIlSx0SSaKqQks6dfzuX5ZhyVZtLRhMT5xlAVP1YRk7e+aTiyi6zExP4XcrB1mhaLVNQDsBEWxLLm5KJECK650QklNpR8Rq8dxRSlFJr/I9Vu6g2fcwduCjPfPrlStM0qJqm4eHuDnbzCz5Lbm+G0HUdimEYCIIAk+ARxJQ25PTI6LQ2nqcX2UjGfj/cIwgCWJYF5ezsjObzOSaTCYLJOLrbE6f3/GyftOQdBkfpmxgcN8RjvN5n5hA/3z/8wmg0guM4cF13lV/6/T43Gg3UajWcnJwwGATKkC9zHYzHE/rRi7GsnthY9SlPbm5vEIYhWq0WPM+jDVJdX1/zdDrFbDb7J//atm3DcZzUh7/MEqJMe2pkgAAAAABJRU5ErkJggg%3D%3D";
	this.ka.Oe = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAAUOVqXe5YAAAPASURBVEjHvVfLbttGFD1HpIxIMWRboqxY9EYKBMELbws4yKZ110m2ydIfEHQXoB9QIIsa7Q80u/Qn2trwKkaXTiE5BSoHMAQ/ZD0gwNRC4u2CIsXHkJILpwMIw+Ednrlz77kPEb7RbDZlOBzi9vYWtm3jS410Oo1cLodCoYBsNou1tTUCAN0Nx8fHsrS0hHw+j42NDXzp0Wq10G63YZomDMNAPp+nDgAHBweysrKC6uPHMlVQ/IrGDJnOTFgzNHvySrWKfD6PZrMJEUfEZrMpg8EA9XodDx8uI6RInHKLKLvIkF6vy9PTU1QrVeiDwQCmaSKTzYotHk/k70+f+Mu7d7zpdECSIgLSO//OiogICoaBvb091Go17/3K6qoUi0XedG/Ao6Mj+WpnR8Iff//mDa3RCJVKxQPzKRM4BIBSFv6u1Woh8+ABfnj7Nuxq/PnhA/XJZALY0Zt2u11sbW3h9evv7o20P/+0j0ajAcwC1Tt3PB5DBwC611Pwg47oXjlD77ggjg4AQjtsNgFA27YhtGVONEXOipPZtk0RcTEjUegoA0JpGRICxoEnWUYtI8EZZmSvHrpjwDIQACJxqWS6ECasg3lGpowQdb5ylEnK/DbnXJh3MJiLqX495Ywo3eT4VxZ1RdyaM946YR7CDBFY7DgXx8r+UxRxesEYTN1zs4ozQdl91CaSDGOGoynBTbhfNykwg25iTDQRRDxl7m4ZgiQjmCHLUFQAEHrk5qKJLbFYMhIUAZwpgdXlQNc0txAuUg7muknXNCeaksoBRJ0R+/0+Wv+0MJnYnEwmd0wms6FpGlKpFHq9vqOIqFsRPa7IfP3NLv74/Tfs7/84t09xbxvXRvhbjd3db2P9G1u1Xzx7jlKxKFdXV9R0PXANzTU3puUirIQIXEuKr0Uora9jZ+fJvKodjSZqKT55+jSOI6Jw2cI9sACJeYZxJd9/QCqVwng8xq/v3/Py4gKZTMZPRpKEZVkoPXqEl69eUdd1JYaKe+l0Gno6ncb15SWM4roiqwV1FNupuH99/AjLsmL50el0AHH2KzFC4/NZC7lcDjw5OZHRaIRisYi11UIkdkWRVLhg5kvCcPdcdy5xfn6OWq2G1Pb2NkejEfr9Pnr9GwhFnKQkEDrNhzu7P3ePQBwG0Elk7nfwybzZJ8P0+er6Au12G+VyGaZpzsLg8PBQlpeXkclksLm5KXAsHGiMfFfyFxAG3vnXLsZs9ox49vkMg8EApVIJ9XqdkaTTaDRkOBzCsqz/5b+2YRgol8ueDv8CmAsGVvaUUeAAAAAASUVORK5CYII%3D";
	this.ka.Ee = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAARF/s2ghwAAAMOSURBVEjHvVfRTuJAFD2XUBOQgJQSIvVhhRie/LbVAv7BSmE/Sl999sH6om5iyLouSkOimGjvPrSdDmVaCsadyc3pTKenZ+7cuZ0SpOI4Ds9mM7y8vMDzPHxV0TQN5XIZtVoNxWIR1WqVAIDCARcXF7y1tQVd17G7u4uvLre3txiPxzBNE4ZhQNd1ygPA2dkZVyoVtNptDgSyLDShcICU0qYYivv7rRZ0XYfjOGD2b5HjOOy6LjqdDra3S4gJSRKXRWyWws/PT3R9fY3Wfgs513VhmiYKxSJ7foWEacaxceyxx0dH3xHj4ITx8NhDZWeH6/U6Jk8T5N7e3mA0GsxE+KxZx8cEYO3nvrXb7Lou8h8fH4CX6HKKIRLa6FpHUZ+nfJZS+PH+/o48AFAYQcvxkSlmrO7x4hsE3eqYkXnyvlu9+A5hxS5R7qau1V2aMZOXRc3SLvTFROJUXqAEQdSzrASVtM5OW/SM9CqFZ1iZSnpda1UGSs0zqnyVlwJulXBx3etb6TPf8EsSxAynLdNC6fe6q6PS58uym5aXiTnbVE76/WxbhL3NPQOmtN3kCznprZHkaaOYyfktUSmGog5HP7NrUXORijfsB4Ccn6SEcQwXbDTMJiiBixN4fYWhGCZRISFUfcPRKFMAZzTBG4mJCkkY9ssIZoY9HHJ6ADMkDhlJ5pHeFS2T9AmFhEjoA5jItkfpAZzNIl7hmQ1tkCBoEy4pgIUPISES+hba9mCoCGDOaoJHCmBhHMM043DcwB6qVokVyEk80jIpYz0t78TH4dS2N8kzgkfTNOQ0TcPjwwPY40/bj9OBL2bN5+5ublAul0GXl5c8n89Rr9dR3aktHcFYcaChjP8raRzhmMe/D7i/v8fBwQFyh4eHNJ/PMZ1O8TydIIjkcPFYxtDCMYxYGg2eg3RPoHQPwfWfx98Yj8doNpswTTM6kZ2fn3OpVEKhUMDe3h6DQSBpUtJxMOgXx7qFPrkdckQonHj36w6u66LRaKDT6dDSF/Tq6opnsxleX1//y7+2YRhoNptCwz/m1JcKyxmy4QAAAABJRU5ErkJggg%3D%3D";
	this.ka.Ge = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAdCAYAAAAgqdWEAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wDCAATL+ECWAAAAAMHSURBVEjHvVdRT+JAEP6GFBOQgJRyROrDCTE8+dvEAvcPTgr+KH312QfrE5oYcp6n0pAoJtq5B7btsm2BHnpDvsxud/djdmc6syVI4jgOT6dTvLy8wPM8fJVks1kUi0VUKhXk83mUy2UCAPInXFxc8NbWFnRdx+7uLr5aRqMRxuMxTNOEYRjQdZ00ADg7O+NSqYRGs8nCQJYNTRAWmpb0SdHB+H6jAV3X4TgOmOdD5DgOu66LVquF7e0CFEOSjFvH2HWEn5+f6Pr6Go39BjKu68I0TeTyefbmP0g6Ee32kTqPY/qqjvCWdna4Wq3i8ekRmbe3Nxi1GjMR0gAArONjSrsuDt+bTXZdF5mPjw/AA8UAMRpBX0in3YY0hxbmRHWUR+D9/R0ZACBmFoCkkfAM5Eecb5DVhjK+LgJeAHNjmDwfrGi1HUAVq3Osrl8FmZ9DY0A+SNFqO0CcdKyOvH4VZH4KjAEHYEUDzFhsc5gxYqRrWUlcvMi78J/hyShBpYCUtugvkW7HWsEZgzBm2AcpOhGrpNuzKIYzjpeYOHQTs5ca60iv20nFJ2KGfLCik7Gm/Oj1ZO443uCoNYgYkorYZ9UdAMBgeOrzJ3EGz7V50otU4k8xaDg49XdKMVU9Uv01EcBxVVpeSEm7ST6RIfNqf8r/JdwUpnf6jCuEPRiAmWnFhiI8mghgSth16pOx7eHSpLiMR5Odtqn07eFGXJpftTd1k90fzEtFyptexE1SmP3T29S3B+CUd+Dktyk56lfGzIltJ+WRdQKY5M8XLZvN4uH+Hkb1W2of/zzpg73NI+72ZoRisQi6vLzk2WyGarWK8k4l4kz1jBETPEnfK8s4/DkPf+5xd3eHg4MDZA4PD2k2m2EymeB58ghx/xTOm19efB1cQMQcBs/T90I1F31VS2MQ7d8PvzAej1Gv12GaZphfzs/PuVAoIJfLYW9vj8EgkLQp+XpHkAsILTyT+z5HqINDvLm9geu6qNVqaLVaFAmqq6srnk6neH19/S/f2oZhoF6vBzb8BbU1MGBi7Vj6AAAAAElFTkSuQmCC";
	this.ka.Le = "data:image/png;base64,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";
	this.ka.vg = "";
	this.ka.wg = "";
	this.ka.xg = "";
	this.ka.Bg = "";
	this.ka.yg = "";
	this.ka.Eg = "";
	this.ka.Fg = "";
	this.ka.Gg = "";
	this.ka.Dg = "";
	this.ka.Hg = "";
};
window.dlInfoBox = function() {
	jQuery("#modal-I").modal();
};
function Y(g) {
	var c = window.location.href.toString();
	c.length == 0 && (c = document.URL.toString());
	if (g) {
		var d;
		d = c.indexOf("///");
		d >= 0 ? d += 3 : (d = c.indexOf("//"), d = d >= 0 ? d + 2 : 0);
		c = c.substr(d);
		d = c.indexOf(":");
		var e = c.indexOf("/");
		d > 0 && e > 0 && d < e || (e > 0 ? d = e: (e = c.indexOf("?"), d = e > 0 ? e: c.length));
		c = c.substr(0, d);
	}
	if (g && (g = c.split("."))) if (d = g.length, !(d <= 2)) {
		if (! (e = "co,com,net,org,web,gov,edu,".indexOf(g[d - 2] + ",") != -1)) b: {
			for (var e = ".ac.uk,.ab.ca,.bc.ca,.mb.ca,.nb.ca,.nf.ca,.nl.ca,.ns.ca,.nt.ca,.nu.ca,.on.ca,.pe.ca,.qc.ca,.sk.ca,.yk.ca".split(","), f = 0; f < e.length;) {
				if (c.indexOf(e[f], c.length - e[f].length) !== -1) {
					e = l;
					break b
				}
				f++;
			}
			e = r;
		}
		c = e ? g[d - 3] + "." + g[d - 2] + "." + g[d - 1] : g[d - 2] + "." + g[d - 1];
	}
	return c;
}
function Z() {
	var g = Y(r);
	//return g.indexOf("http://localhost/") == 0 ? l: g.indexOf("http://localhost:") == 0 ? l: g.indexOf("http://localhost:") == 0 ? l: g.indexOf("http://192.168.") == 0 ? l: g.indexOf("http://10.1.1.") == 0 ? l: g.indexOf("file://") == 0 ? l: g.indexOf("http://127.0.0.1") == 0 ? l: g.indexOf("http://") == 0 ? r: g.indexOf("/") == 0 ? l: r;
	return true;
}
var ia = typeof window == "undefined";
ia && (window = []);
window.FlexPaperViewer_HTML = function() {
	function g(c) {
		this.config = c;
		this.Mf = this.config.instanceid;
		this.document = this.config.document;
		this.ga = this.config.rootid;
		this.ia = {};
		this.vb = this.ma = o;
		this.selectors = [];
		this.ba = I;
		this.Nb = c.document.InitViewMode != o && c.document.InitViewMode != "undefined" && c.document.InitViewMode != "" ? c.document.InitViewMode: I;
		this.ib = r;
		this.Fb = "flexpaper_selected_default";
		this.Jb = {};
		this.jf = "data:image/gif;base64,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%3D";
		this.kf = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAZiS0dEAFEAUQBRjSJ44QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9wCCgEMO6ApCe8AAAFISURBVCjPfZJBi49hFMV/521MUYxEsSGWDDWkFKbkA/gAajaytPIFLKx8BVkodjP5AINGU0xZKAslC3Ys2NjP+VnM++rfPzmb23065z6de27aDsMwVD0C3AfOAYeB38BP9fEwDO/aMgwDAAFQDwKbwC9gZxScUM8Al5M8SPJ0Eu5JYV0FeAZcBFaAxSSPkjwHnrQ9Pf1E22XVsX5s+1m9o54cB9J2q+361KM+VN+ot9uqrjIH9VJbpz7qOvAeuAIcSnJzThA1SXaTBGAAvgCrwEvg0yxRXUhikrOjZ1RQz7uHFfUu/4C60fb16G9hetxq+1a9Pkdears2Dt1Rj87mdAx4BfwAttWvSQ4AV9W1aYlJtoFbmQJTjwP3gAvAIlDgG7CsXvu7uWQzs+cxmj0F7Fd3k3wfuRvqDWAfM+HxP6hL6oe2tn3xB7408HFbpc41AAAAAElFTkSuQmCC";
		this.hf = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAGYktHRAD/AP8A/6C9p5MAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfcCBUXESpvlMWrAAAAYklEQVQ4y9VTQQrAIAxLiv//cnaYDNeVWqYXA4LYNpoEKQkrMCxiLwFJABAAkcS4xvPXjPNAjvCe/Br1sLTseSo4bNGNGXyPzRpmtf0xZrqjWppCZkVJAjt+pVDZRxIO/EwXL00iPZwDxWYAAAAASUVORK5CYII%3D";
		this.qg = this.ga + "_textoverlay";
		this.Bd = "#" + this.qg;
		this.na = 1;
		this.dd = o;
		this.renderer = this.config.renderer;
		this.Ta = "toolbar_" + this.ga;
		this.ea = "#" + this.Ta;
		this.Tb = r;
		this.Fh = "highlight";
		this.scale = this.config.document.Scale;
		this.resources = new FlexPaper_Resources(this);
	}
	g.prototype = {
		da: function(c) {
			this.selectors[c] || (this.selectors[c] = jQuery(c));
			return this.selectors[c];
		},
		sa: function() {
			return this.ha ? this.ha.sa: "";
		},
		loadFromUrl: function(c) {
			var d = this,
			e;
			d.renderer.yb() == "CanvasPageRenderer" && (e = c.PDFFile ? new CanvasPageRenderer(this.ga, c.PDFFile, d.config.jsDirectory, {
				jsonfile: c.jsonfile,
				pageImagePattern: c.pageImagePattern,
				JSONDataType: d.renderer.config.JSONDataType
			}) : new CanvasPageRenderer(this.ga, translateUrlByFormat(unescape(c), "pdf"), d.config.jsDirectory, {
				jsonfile: translateUrlByFormat(unescape(c), d.renderer.config.JSONDataType),
				pageImagePattern: translateUrlByFormat(unescape(c), "png"),
				JSONDataType: d.renderer.config.JSONDataType
			}));
			d.renderer.yb() == "ImagePageRenderer" && (e = c.jsonfile && c.pageImagePattern ? new ImagePageRenderer(this.ga, {
				jsonfile: c.jsonfile,
				pageImagePattern: c.pageImagePattern,
				JSONDataType: d.renderer.config.JSONDataType
			}) : new ImagePageRenderer(this.ga, {
				jsonfile: translateUrlByFormat(unescape(c), d.renderer.config.JSONDataType),
				pageImagePattern: translateUrlByFormat(unescape(c), "png"),
				JSONDataType: d.renderer.config.JSONDataType
			}));
			e && e.initialize(function() {
				d.loadDoc(e, e.getNumPages());
				d.ia.trigger("onDocumentLoaded", e.getNumPages());
			});
		},
		loadDoc: function(c, d) {
			this.ib = r;
			this.document.numPages = d;
			this.renderer = c;
			this.show();
			this.config.document.FitPageOnLoad || eb.platform.touchdevice ? this.fitheight() : this.config.document.FitWidthOnLoad ? this.fitwidth() : this.toolbar && this.toolbar.Ka && this.toolbar.Ka.Gf && this.toolbar.Ka.setValue(this.toolbar.Ka.Gf(), l);
		},
		getDimensions: function(c) {
			return this.renderer.getDimensions(c);
		},
		tf: function(c) {
			var d = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageX: c.originalEvent.touches[0].pageX,
			e = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageY: c.originalEvent.touches[0].pageY;
			if (this.Tb || eb.platform.touchdevice) {
				c.target && c.target.id && c.target.id.indexOf("page") >= 0 && c.target.id.indexOf("word") >= 0 && (hoverPage = parseInt(c.target.id.substring(c.target.id.indexOf("_") + 1)), hoverPageObject = W(this.ga));
				if (!hoverPageObject && !window.Eb) return l;
				if (window.Eb) eb.platform.touchdevice && (event.preventDefault(), event.stopPropagation());
				else return l;
				window.b = hoverPageObject.match({
					left: d,
					top: e
				},
				r);
				window.b != o && window.a != o && window.a.pageNumber != window.b.pageNumber && (window.a = hoverPageObject.match({
					left: d - 1,
					top: e - 1
				},
				r));
				this.Yb(l);
				this.wb = hoverPageObject.Zb(l, this.Fb);
			} else if (c.target && c.target.id && c.target.id.indexOf("page") >= 0 && (hoverPage = parseInt(c.target.id.substring(c.target.id.indexOf("_") + 1)), hoverPageObject = W(this.ga)), hoverPageObject && hoverPageObject.match({
				left: d,
				top: e
			},
			l), !hoverPageObject && !window.Eb) return l;
		},
		Yb: function(c) {
			if (!eb.platform.touchdevice) this.wb = o;
			jQuery(".flexpaper_pageword_" + this.ga).removeClass("flexpaper_selected");
			jQuery(".flexpaper_pageword_" + this.ga).removeClass("flexpaper_selected_default");
			c && jQuery(".flexpaper_pageword_" + this.ga).each(function() {
				jQuery(this).hasClass("flexpaper_selected_yellow") && !jQuery(this).data("isMark") && jQuery(this).removeClass("flexpaper_selected_yellow");
				jQuery(this).hasClass("flexpaper_selected_orange") && !jQuery(this).data("isMark") && jQuery(this).removeClass("flexpaper_selected_orange");
				jQuery(this).hasClass("flexpaper_selected_green") && !jQuery(this).data("isMark") && jQuery(this).removeClass("flexpaper_selected_green");
				jQuery(this).hasClass("flexpaper_selected_blue") && !jQuery(this).data("isMark") && jQuery(this).removeClass("flexpaper_selected_blue");
				jQuery(this).hasClass("flexpaper_selected_strikeout") && !jQuery(this).data("isMark") && jQuery(this).removeClass("flexpaper_selected_strikeout");
			});
		},
		uf: function(c) {
			this.Sf = "up";
			this.fe = o;
			if (!this.ca.Fd) if (this.Tb || eb.platform.touchdevice) {
				if (hoverPageObject) {
					if (eb.platform.touchdevice) {
						var d = o;
						typeof c.originalEvent.touches != "undefined" && (d = c.originalEvent.touches[0] || c.originalEvent.changedTouches[0]);
						if (d != o && this.zb == d.pageX && this.Ab == d.pageY) this.Yb(),
						this.wb = hoverPageObject.Zb(window.Eb, this.Fb);
						if (d != o) this.zb = d.pageX,
						this.Ab = d.pageY;
					} else window.b = hoverPageObject.match({
						left: c.pageX,
						top: c.pageY
					},
					r);
					this.wb != o && this.ia.trigger("onSelectionCreated", this.wb.text);
					window.Eb = r;
					window.a = o;
					window.b = o;
				}
			} else if (hoverPageObject) window.b = hoverPageObject.match({
				left: c.pageX,
				top: c.pageY
			},
			r),
			window.Eb = r,
			this.Yb(),
			this.wb = hoverPageObject.Zb(r, this.Fb);
		},
		sf: function(c) {
			var d = this;
			d.Sf = "down";
			if (jQuery(c.target).hasClass("flexpaper_note_textarea")) window.b = o,
			window.a = o;
			else if (!d.ca.Fd) {
				var e = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageX: c.originalEvent.touches[0].pageX,
				f = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageY: c.originalEvent.touches[0].pageY;
				d.zb = e;
				d.Ab = f;
				if (eb.platform.touchdevice) window.clearTimeout(d.Qf),
				d.fe = (new Date).getTime(),
				d.Qf = setTimeout(function() {
					if (d.fe != o && c.originalEvent.touches && c.originalEvent.touches.length > 0) {
						var e = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageX: c.originalEvent.touches[0].pageX,
						f = !eb.platform.touchdevice || typeof c.originalEvent.touches === "undefined" ? c.pageY: c.originalEvent.touches[0].pageY;
						if (d.zb + 20 > e && d.zb - 20 < e && d.Ab + 20 > f && d.Ab - 20 < f && (hoverPage = parseInt(c.target.id.substring(c.target.id.indexOf("_") + 1)), hoverPageObject = W(d.ga), hoverPageObject != o)) d.ca.jScrollPane != o && d.ca.jScrollPane.data("jsp").disable(),
						window.Eb = l,
						d.Yb(l),
						window.b = hoverPageObject.match({
							left: e,
							top: f
						},
						r),
						window.a = hoverPageObject.match({
							left: e - 1,
							top: f - 1
						},
						r),
						d.wb = hoverPageObject.Zb(l, d.Fb);
					}
				},
				800);
				if (d.Tb || eb.platform.touchdevice) {
					if (!hoverPageObject) if (eb.platform.touchdevice) {
						if (c.target && c.target.id && c.target.id.indexOf("page") >= 0 && c.target.id.indexOf("word") >= 0 && (hoverPage = parseInt(c.target.id.substring(c.target.id.indexOf("_") + 1)), hoverPageObject = W(d.ga)), !hoverPageObject) {
							window.a = o;
							return;
						}
					} else {
						window.a = o;
						return;
					}
					window.a = hoverPageObject.match({
						left: e,
						top: f
					},
					l);
					if (window.a) return window.Eb = l,
					d.Yb(),
					d.wb = hoverPageObject.Zb(r, d.Fb),
					r;
					else {
						if (!jQuery(c.target).hasClass("flexpaper_tbtextbutton") && !jQuery(c.target).hasClass("flexpaper_colorselector") && !jQuery(c.target).hasClass("flexpaper_tbbutton") && !eb.platform.touchdevice) d.Yb(),
						d.wb = hoverPageObject.Zb(r, d.Fb);
						window.Eb = r;
						return l;
					}
				} else window.a = hoverPageObject ? hoverPageObject.match({
					left: e,
					top: f
				},
				l) : o;
			}
		},
		yc: function() {
			if (!this.width) this.width = this.ma.width();
			return this.width;
		},
		Je: function() {
			return this.ca.ja + 1;
		},
		bindEvents: function() {
			var c = this;
			hoverPage = 0;
			hoverPageObject = o;
			jQuery(document).ready(function() {
				c.ma.bind("mousemove",
				function(d) {
					return c.tf(d);
				});
				c.ma.bind("mousedown",
				function(d) {
					return c.sf(d);
				});
				c.ma.bind("mouseup",
				function(d) {
					return c.uf(d);
				});
				c.ma.resize(function() {
					var d = c.ma.width(),
					f = c.ma.height(),
					g = r,
					p = -1;
					window.resizeViewerWidth ? p = window.resizeViewerWidth: c.ma[0].style.width.indexOf("%") > 0 && (window.resizeViewerWidth = p = parseFloat(c.ma[0].style.width.substr(0, c.ma[0].style.width.length - 1) / 100));
					p > 0 && (d = c.ma.parent().width() == 0 ? jQuery(document).width() * p: c.ma.parent().width() * p, g = l);
					p = -1;
					window.resizeViewerHeight ? p = window.resizeViewerHeight: c.ma[0].style.width.indexOf("%") > 0 && (window.resizeViewerHeight = p = parseFloat(c.ma[0].style.height.substr(0, c.ma[0].style.height.length - 1) / 100));
					p > 0 && (f = c.ma.parent().height() == 0 ? (jQuery(window).height() - 80) * p: c.ma.parent().height() * p, g = l);
					g && c.resize(d, f);
				});
				try {
					jQuery.get(c.config.localeDirectory + c.document.localeChain + "/FlexPaper.txt",
					function(d) {
						c.toolbar.de(d);
						c.xe();
					}).error(function() {
						c.xe();
						H("Failed loading supplied locale (" + c.document.localeChain + ")");
					}),
					c.toolbar.de("");
				} catch(d) {}
				if (!c.qd) c.qd = "";
			});
		},
		xe: function() {
			if (!this.fc) this.fc = this.toolbar != o && this.toolbar.Xa != o ? this.toolbar.ta(this.toolbar.Xa, "LoadingPublication") : "Loading Publication";
			if (this.fc == o) this.fc = "Loading Publication";
			if (window.zine && !eb.browser.msie) {
				this.Jb = jQuery(String.format("<div id='flexpaper_initloader_{0}' class='flexpaper_initloader' style='position:{1};margin: 0px auto;z-index:100;top:40%;left:50%;'></div>", this.ga, this.ma.css("position") == "static" ? "relative": "absolute"));
				this.ma.append(this.Jb);
				var c = new CanvasLoader("flexpaper_initloader_" + this.ga);
				c.ph("#555555");
				c.wh("square");
				c.rh(70);
				c.qh(151);
				c.vh(0.8);
				c.xh(2);
				c.uh(42);
				c.show();
			} else this.Jb = jQuery(String.format("<div class='flexpaper_initloader' style='position:{2};z-index:100;'><div class='flexpaper_initloader_panel' style='{1};background-color:#ffffff;'><img src='{0}' style='vertical-align:middle;margin-top:7px;margin-left:5px;'><div style='float:right;margin-right:25px;margin-top:19px;' class='flexpaper_notifylabel'>" + this.fc + "<br/><div style='margin-left:30px;' class='flexpaper_notifystatus'>" + this.qd + "</div></div></div></div>", this.jf, "margin: 0px auto;", this.ma.css("position") == "static" ? "relative": "absolute")),
			this.ma.append(this.Jb);
		},
		initialize: function() {
			var c = this;
			FLEXPAPER.Yd.init();
			c.dg();
			c.ia = jQuery("#" + c.ga);
			c.toolbar = new ha(this, this.document);
			if (eb.platform.Of && !c.config.document.InitViewMode) c.Nb = I;
			c.config.document.InitViewMode == "BookView" && c.document.StartAtPage % 2 == 0 && (c.document.StartAtPage += 1);
			window.zine ? (c.ha = c.toolbar.kd = new FlexPaperViewer_Zine(c.toolbar, this, c.ia), c.ha.initialize()) : c.ba = c.Nb;
			if (c.ba == "CADView") c.ba = "SinglePage";
			if (window.zine && eb.browser.msie && eb.browser.version < 9) c.document.MinZoomSize = c.MinZoomSize = 0.3,
			c.ba = "BookView";
			c.ia.css("width") == "0px" && c.ia.css("width", "1024px");
			c.ia.css("height") == "0px" && c.ia.css("height", "600px");
			if (c.ma === o && !c.ha) c.ma = jQuery("<div style='" + c.ia.attr("style") + ";background-color:#d4dcdc;' class='flexpaper_viewer_container'/>"),
			c.ma.css({
				display: "block"
			}),
			(c.ma.css("position") == "" || c.ma.css("position") == "static") && c.ma.css({
				position: "relative"
			}),
			c.ma = c.ia.wrap(c.ma).parent(),
			c.ia.css({
				left: "0px",
				top: "0px",
				position: "relative",
				width: "100%",
				height: "100%"
			}).addClass("flexpaper_viewer"),
			window.annotations && c.config.document.AnnotationToolsVisible ? (c.Jc = 26, c.ia.height(c.ia.height() - c.Jc)) : c.Jc = 0;
			eb.browser.msie && jQuery(".flexpaper_initloader_panel").css("left", c.ia.width() - 500);
			if (c.config.Toolbar == o) c.Toolbar = c.ma.prepend("<div id='" + c.Ta + "' class='flexpaper_toolbarstd' style='z-index:200;overflow-y:hidden;overflow-x:hidden;'></div>").parent(),
			c.toolbar.create(c.Ta);
			else if (c.config.Toolbar != o && !(c.Toolbar instanceof jQuery)) c.Toolbar = jQuery(c.config.Toolbar),
			c.ma.prepend(c.Toolbar),
			jQuery(".flexpaper_toolbar").attr("id", c.Ta);
			c.of();
			c.resources.initialize();
			hoverPage = 0;
			hoverPageObject = o;
			if (c.ha != o) c.ha.Ng(c.Ta);
			else if (window.annotations) c.Cb = new FlexPaperViewerAnnotations_Plugin(this, this.document, c.Ta + "_annotations"),
			c.Cb.create(c.Ta + "_annotations"),
			c.Cb.bindEvents(c.aa);
			eb.platform.touchdevice || c.ma.append("<textarea id='selector' class='flexpaper_selector' rows='0' cols='0'></textarea>");
			c.ma.append("<iframe id='printFrame_" + c.ga + "' name='printFrame_" + c.ga + "' class='flexpaper_printFrame'>");
			jQuery(c.renderer).bind("loadingProgress",
			function(d, e) {
				c.fg(d, e);
			});
			jQuery(c.renderer).bind("loadingProgressStatusChanged",
			function(d, e) {
				c.gg(d, e);
			});
			jQuery(c.renderer).bind("UIBlockingRenderingOperation",
			function(d) {
				c.nc(d);
			});
		},
		of: function() {
			eb.platform.touchdevice ? eb.platform.ios ? this.ia.height(this.ia.height() - 35) : this.ia.height(this.ia.height() - 25) : this.ia.height(this.ia.height() - 13);
		},
		fg: function(c, d) {
			this.qd = d.progress;
			this.Jb.find(".flexpaper_notifystatus").html(d.progress);
		},
		gg: function(c, d) {
			this.fc = d.label;
			this.Jb.find(".flexpaper_notifylabel").html(d.label);
		},
		nc: function() {
			var c = this;
			if (c.vb === o) {
				c.vb = jQuery("<div style='position:absolute;left:50%;top:50%;'></div>");
				c.ma.append(c.vb);
				c.vb.spin({
					color: "#777"
				});
				if (c.Xc != o) window.clearTimeout(c.Xc),
				c.Xc = o;
				c.Xc = setTimeout(function() {
					c.vb.remove();
					c.vb = o;
				},
				1E3);
			}
		},
		Jf: function() {
			this.vb && this.vb.remove();
		},
		show: function() {
			var c = this;
			jQuery(c.resources).bind("onPostinitialized",
			function() {
				setTimeout(function() {
					c.me();
					c.toolbar.bindEvents(c.ia);
					c.ha != o && c.ha.bindEvents(c.ia);
					c.Dd(c.document.StartAtPage);
				},
				50);
			});
			c.resources.Yf();
		},
		ud: function() {
			var c = this;
			eb.platform.touchdevice ? (c.ib = l, (!c.ha && c.config.document.FitWidthOnLoad && c.ba != R && c.ba != Q || c.ba == I || c.ba == "SinglePage") && c.fitwidth(), (c.config.document.FitPageOnLoad || c.ba == R || c.ba == Q || c.ha) && c.fitheight(), c.ca.vc(), c.ca.Ob()) : (c.ib = l, c.Og || c.toolbar.nf(c.config.document.MinZoomSize, c.config.document.MaxZoomSize), c.config.document.FitPageOnLoad || c.ba == R || c.ba == Q ? c.fitheight() : c.config.document.FitWidthOnLoad && c.ba != R && c.ba != Q ? c.fitwidth() : c.Zoom(c.config.document.Scale), (!c.document.StartAtPage || c.document.StartAtPage == 1) && !c.ha && c.ia.trigger("onCurrentPageChanged", c.ca.ja + 1));
			c.document.StartAtPage && c.document.StartAtPage != 1 && c.ca.scrollTo(c.document.StartAtPage);
			c.ha && c.ha.ud();
			c.Jb.fadeOut(300,
			function() {
				jQuery(c.ca.la).fadeIn(300, s());
			});
		},
		Zf: function() {
			var c = this;
			if (c.dd != o) window.clearTimeout(c.dd),
			c.dd = o;
			c.dd = setTimeout(function() {
				c.ca.Bc();
				c.ca.vc();
				c.ca.Ob();
				c.Zf();
			},
			50);
		},
		me: function() {
			this.na = 1;
			this.ia.empty();
			this.renderer.cc = r;
			jQuery(this.Bd).remove();
		},
		Dd: function(c) {
			this.ca = new ga(this.ia, this, this.ga, c);
			this.ca.create(this.ia);
		},
		previous: function() {
			this.ca.previous();
		},
		setCurrentCursor: function(c) {
			if (c == "ArrowCursor") this.Tb = r,
			addCSSRule(".flexpaper_pageword", "cursor", "default"),
			window.annotations || jQuery(".flexpaper_pageword_" + this.ga).remove();
			if (c == "TextSelectorCursor") this.Tb = l,
			this.Fb = "flexpaper_selected_default",
			addCSSRule(".flexpaper_pageword", "cursor", "text"),
			window.annotations || (this.ca.getPage(this.ca.ja - 1), this.ca.getPage(this.ca.ja - 2), this.ca.Aa());
			this.ha && this.ha.setCurrentCursor(c);
			jQuery(this.ea).trigger("onCursorChanged", c);
		},
		printPaper: function(c) {
			if (c) {
				var d = o;
				this.renderer.yb() == "ImagePageRenderer" && (d = "{jsonfile : '" + this.renderer.config.jsonfile + "',compressedJsonFormat : " + (this.renderer.Na ? this.renderer.Na: r) + ",pageImagePattern : '" + this.renderer.config.pageImagePattern + "',JSONDataType : '" + this.renderer.config.JSONDataType + "'}");
				this.renderer.yb() == "CanvasPageRenderer" && (d = "{PdfFile : '" + this.renderer.file + "',compressedJsonFormat : " + (this.renderer.Na ? this.renderer.Na: r) + ",pageThumbImagePattern : '" + this.renderer.config.pageThumbImagePattern + "',pageImagePattern : '" + this.renderer.config.pageImagePattern + "',JSONDataType : '" + this.renderer.config.JSONDataType + "'}");
				if (jQuery("#printFrame_" + this.ga).length > 0) {
					var e = window.printFrame = eb.browser.msie && eb.browser.version < 9 ? window.open().document: jQuery("#printFrame_" + this.ga)[0].contentWindow.document || jQuery("#printFrame_" + this.ga)[0].contentDocument;
					e.open();
					e.write("<html>");
					e.write("<head>");
					e.write("<script type='text/javascript' src='" + this.config.jsDirectory + "jquery.min.js'><\/script>");
					e.write('<script type="text/javascript" src="' + this.config.jsDirectory + 'flexpaper.js"><\/script>');
					e.write('<script type="text/javascript" src="' + this.config.jsDirectory + 'flexpaper_handlers.js"><\/script>');
					e.write("<script type='text/javascript' src='" + this.config.jsDirectory + "FlexPaperViewer.js'><\/script>");
					e.write("<style type='text/css' media='print'>html, body { height:100%; }body { margin:0; padding:0; } .ppage { display:block;max-width:210mm;max-height:297mm;margin-bottom:20px;margin-top:0px; } .ppage_break { page-break-after : right; } .ppage_none { page-break-after : avoid; } @page {}</style>");
					e.write("</head>");
					e.write("<body>");
					e.write('<script type="text/javascript">');
					e.write("window.focus();");
					e.write("print_flexpaper_Document('" + this.renderer.yb() + "'," + d + ",'" + c + "', " + this.Je() + ", " + this.getTotalPages() + ", '" + this.config.jsDirectory + "');");
					e.write("<\/script>");
					e.write("</body></html>");
					eb.browser.msie || setTimeout("window['printFrame'].close();", 3E3);
				}
			} else jQuery("#modal-print").css("background-color", "#dedede"),
			jQuery("#modal-print").modal({
				minHeight: 255,
				appendTo: this.ma
			}),
			jQuery("#modal-print").parent().css("background-color", "#dedede");
		},
		switchMode: function(c, d) {
			var e = this;
			e.ba != c && jQuery(e.ca.la).vf(function() {
				e.ha && e.ha.switchMode(c, d);
				if (c == "Tile") e.ba = T;
				if (c == I) e.ba = I;
				if (c == "SinglePage") e.ba = "SinglePage";
				if (c == R) e.ba = R;
				if (c == Q) e.ba = Q;
				e.me();
				e.ca.ag();
				e.renderer.pa = -1;
				if (c != R && c != Q) d != o ? e.ca.ja = d - 1 : d = 1;
				e.Dd(d);
				jQuery(e.ea).trigger("onViewModeChanged", c);
				setTimeout(function() {
					eb.platform.touchdevice ? c != R && c != Q && c != e.sa() && e.fitwidth() : e.fitheight();
					c != R && c != Q && e.$b(d);
				},
				100);
			});
		},
		fitwidth: function() {
			var c = jQuery(this.ca.la).width() - 15,
			d = this.getTotalPages() > 1 ? this.na - 1 : 0,
			e = this.ca.getPage(d).dimensions.xa / this.ca.getPage(d).dimensions.Da;
			eb.platform.touchdevice ? (c = c / (this.ca.getPage(d).Ca * e) - 0.03, window.FitWidthScale = c, this.Ha(c), this.ca.zd()) : (c = c / (this.ca.getPage(d).Ca * this.document.MaxZoomSize * e) - 0.012, window.FitWidthScale = c, jQuery(this.ea).trigger("onScaleChanged", c / this.document.MaxZoomSize), c * this.document.MaxZoomSize >= this.document.MinZoomSize && c <= this.document.MaxZoomSize && this.Ha(this.document.MaxZoomSize * c));
		},
		Ha: function(c, d) {
			var e = this;
			if (e.ib) {
				var f = 100 / (e.document.ZoomInterval * 100),
				c = Math.round(c * f) / f;
				e.ba == e.sa() && c < 1 && (c = 1);
				jQuery(e.ea).trigger("onScaleChanged", c / e.document.MaxZoomSize);
				var f = jQuery(e.ca.la).prop("scrollHeight"),
				g = jQuery(e.ca.la).scrollTop(),
				f = g > 0 ? g / f: 0;
				if (e.Wb != o) window.clearTimeout(e.Wb),
				e.Wb = o;
				e.ca.fd() || jQuery(".flexpaper_pageword_" + e.ga).remove();
				e.Wb = setTimeout(function() {
					e.Rb();
					e.ca.Aa();
				},
				500);
				if (c > 0) {
					if (c < e.config.document.MinZoomSize) c = this.config.document.MinZoomSize;
					if (c > e.config.document.MaxZoomSize) c = this.config.document.MaxZoomSize;
					e.ca.Va(c, d);
					e.scale = c; (!d || d && !d.tg) && e.ca.ca[0].Lc();
					jQuery(e.ea).trigger("onZoomFactorChanged", {
						ac: c,
						aa: e
					});
					if (window.FitWidthScale != "undefined" && Math.round(window.FitWidthScale * 100) == Math.round(c / e.document.MaxZoomSize * 100)) {
						if (jQuery(e.ea).trigger("onFitModeChanged", "FitWidth"), window.onFitModeChanged) window.onFitModeChanged("Fit Width");
					} else if (window.FitHeightScale != "undefined" && Math.round(window.FitHeightScale * 100) == Math.round(c / e.document.MaxZoomSize * 100)) {
						if (jQuery(e.ea).trigger("onFitModeChanged", "FitHeight"), window.onFitModeChanged) window.onFitModeChanged("Fit Height");
					} else if (jQuery(e.ea).trigger("onFitModeChanged", "FitNone"), window.onFitModeChanged) window.onFitModeChanged("Fit None");
					e.ca.Ob();
					e.ca.Bc();
					e.ca.zd();
					g = jQuery(e.ca.la).prop("scrollHeight");
					eb.browser.Oa.Qa && jQuery(e.ca.la).scrollTo({
						top: g * f + "px"
					},
					0, {
						axis: "y"
					});
				}
			}
		},
		Rb: function() {
			if (this.Wb != o) window.clearTimeout(this.Wb),
			this.Wb = o;
			this.renderer.yb() == "CanvasPageRenderer" && jQuery(".flexpaper_pageword_" + this.ga).remove();
			for (var c = 0; c < this.document.numPages; c++) if (this.ca.sb(c)) this.ca.ca[c].Pa ? this.ca.ca[c].renderer.Db(this.ca.ca[c], l) : this.ca.ca[c].Ja = r;
		},
		Zoom: function(c, d) {
			eb.platform.touchdevice ? c > 1 ? this.ba == R || this.ba == Q ? this.ca.Uc() : (this.ba == I || this.ba == "SinglePage") && this.fitwidth() : this.ba == R || this.ba == Q ? this.ca.Vc() : (this.ba == I || this.ba == "SinglePage") && this.fitheight() : c > this.document.MaxZoomSize || (c /= this.document.MaxZoomSize, jQuery(this.ea).trigger("onScaleChanged", c), c * this.document.MaxZoomSize >= this.document.MinZoomSize && c <= this.document.MaxZoomSize && this.Ha(this.document.MaxZoomSize * c, d));
		},
		ye: function() {
			var c = this;
			if (!c.Sa) {
				jQuery(".flexpaper_searchabstract_result, .flexpaper_searchabstract_result_separator").remove();
				var d = c.fc = c.toolbar != o && c.toolbar.Xa != o ? c.toolbar.ta(c.toolbar.Xa, "Search") : "Search",
				e = jQuery(c.ea).css("background-color");
				e.toString() == "rgba(0, 0, 0, 0)" && (e = "#555");
				c.Be = jQuery(c.ea).css("margin-left");
				c.ma.append(jQuery(String.format("<div class='flexpaper_searchabstracts' style='position:absolute;left:0px;top:0px;height:{5}px;width:{2};min-width:{3};opacity: 0;z-index:13;'><div style='margin: 20px 20px 20px 20px;padding: 10px 10px 10px 10px;background-color:{6};height:95%;'><div style='height:25px;width:100%' <div class='flexpaper_tblabel' style='margin-left:10px; width: 100%;height:25px;'><img src='{1}' style='vertical-align: middle'><span style='margin-left:10px;vertical-align: middle'>{0}</span><img src='{4}' style='float:right;margin-right:5px;cursor:pointer;' class='flexpaper_searchabstracts_close' /></div><hr size='1' color='#ffffff' /></div></div>", d, c.kf, "20%", "250px", c.hf, c.ia.height(), e)));
				c.Sa = jQuery(".flexpaper_searchabstracts");
				jQuery(c.Sa.children()[0]).css({
					"border-radius": "3px",
					"-moz-border-radius": "3px"
				});
				jQuery(c.Sa.children()[0]).append("<div class='flexpaper_searchabstracts_content' style='display:block;position:relative;height:" + (jQuery(c.Sa.children()[0]).height() - 70) + "px;margin-bottom:50px;width:100%;overflow-y: auto;overflow-x: hidden;'></div>");
				c.resize(c.ia.width() - c.Sa.width(), c.ia.height(), r, s());
				c.ia.animate({
					left: c.Sa.width() + "px"
				},
				0);
				d = c.Sa.width() * 0.5;
				jQuery(c.ea).width() + d > c.ma.width() && (d = 0);
				jQuery(c.ea).animate({
					"margin-left": parseFloat(c.Be) + d + "px"
				},
				200,
				function() {
					if (window.onresize) window.onresize();
				});
				d == 0 && c.Sa.css({
					top: "40px",
					height: c.ia.height() - 40 + "px"
				});
				c.ba == c.sa() && c.ha.ye();
				c.Sa.fadeTo("fast", 1);
				var f = jQuery(".flexpaper_searchabstracts_content");
				jQuery(c).bind("onSearchAbstractAdded",
				function(d, e) {
					var g = e.Xb.zf;
					g.length > 100 && (g = g.substr(0, 100) + "...");
					g = g.replace(RegExp(window.rb, "g"), "<font style='color:#ffffff'>" + window.rb + "</font>");
					g = "p." + (e.Xb.pageIndex + 1) + " : " + g;
					f.append(jQuery(String.format("<div id='flexpaper_searchabstract_item_{1}' class='flexpaper_searchabstract_result'>{0}</div><br/><hr size=1 color='#777777' style='margin-top:-2px;' class='flexpaper_searchabstract_result_separator' />", g, e.Xb.id)));
					jQuery("#flexpaper_searchabstract_item_" + e.Xb.id).bind("mousedown",
					function() {
						window.va = e.Xb.pageIndex + 1;
						window.Bb = e.Xb.cg;
						window.kb = -1;
						c.searchText(window.rb, r);
					});
				});
				jQuery(".flexpaper_searchabstracts_close").bind("mousedown",
				function() {
					c.$d();
				});
			}
		},
		$d: function() {
			var c = this;
			if (c.Sa && (c.Sa.hide(), jQuery(".flexpaper_searchabstract_result, .flexpaper_searchabstract_result_separator").remove(), c.resize(c.ia.width() + c.Sa.width(), c.ia.height(), r), c.ia.css("left", "0px"), jQuery(c.ea).animate({
				"margin-left": parseFloat(c.Be) + "px"
			},
			200), c.ba == c.sa() && c.ha.$d(), c.Sa.fadeTo("fast", 0,
			function() {
				c.Sa.remove();
				c.Sa = o;
			}), window.onresize)) window.onresize();
			jQuery(c).unbind("onSearchAbstractAdded");
		},
		ce: function(c, d) {
			var e = this.renderer.getNumPages();
			d || (d = 0);
			for (var f = d; f < e; f++) this.mf(f, c);
		},
		mf: function(c, d) {
			var e = this,
			f = e.renderer.Ma;
			if (f[c] != o) for (var g = f[c].toLowerCase().indexOf(d), p = 0; g > 0;) {
				var j = g - 50 > 0 ? g - 50 : 0,
				u = g + 75 < f[c].length ? g + 75 : f[c].length,
				z = window.cb.length;
				window.cb.Sb[z] = [];
				window.cb.Sb[z].pageIndex = c;
				window.cb.Sb[z].cg = p;
				window.cb.Sb[z].id = c + "_" + p;
				window.cb.Sb[z].zf = f[c].substr(j, u - j);
				g = f[c].toLowerCase().indexOf(d, g + 1);
				jQuery(e).trigger("onSearchAbstractAdded", {
					Xb: window.cb.Sb[z]
				});
				p++;
			} else if (e.se == o) e.se = setTimeout(function() {
				e.renderer.ob == o && e.renderer.$c(c + 1, r,
				function() {
					e.se = o;
					e.ce(d, c);
				});
			},
			100);
		},
		searchText: function(c, d) {
			var e = this;
			if (c != o) if (d === h && window.zine && (d = l), jQuery(".flexpaper_txtSearch").val() != c && jQuery(".flexpaper_txtSearch").val(c), e.ba == T) e.switchMode(I),
			setTimeout(function() {
				e.searchText(c);
			},
			1E3);
			else {
				var f = e.renderer.Ma,
				g = e.renderer.getNumPages();
				if (!window.Bb) window.Bb = 0;
				if (!window.va) window.va = -1;
				c != o && c.length > 0 && (c = c.toLowerCase());
				if (window.rb != c) window.kb = -1,
				window.rb = c,
				window.Bb = 0,
				window.va = -1,
				window.cb = [],
				window.cb.Sb = [];
				window.va == -1 ? window.va = parseInt(e.na) : window.kb += c.length;
				if (window.cb.Sb.length == 0 && window.cb.searchText != c && d) window.cb.searchText = c,
				e.ye(),
				e.ce(c);
				for (; window.va - 1 < g;) {
					var p = f[window.va - 1];
					if (e.renderer.$a && p == o) jQuery(e.renderer).trigger("UIBlockingRenderingOperation", e.ga),
					e.kg = window.va,
					e.renderer.$c(window.va, r,
					function() {
						p = f[window.va - 1];
						e.kg = o;
					});
					window.kb = p.indexOf(c, window.kb == -1 ? 0 : window.kb);
					if (window.kb >= 0) {
						e.na != window.va && (e.ba == e.sa() && e.na != window.va + 1 || e.ba == Q && e.na != window.va + 1 || e.ba == R && e.na != window.va - 1 || e.ba == "SinglePage" && e.na != window.va) && (e.ba == R || e.ba == Q || e.ba == "SinglePage" || e.ba == e.sa()) ? e.gotoPage(window.va,
						function() {
							window.kb -= c.length;
							e.searchText(c);
						}) : (window.Bb++, e.renderer.wc ? this.ca.getPage(window.va - 1).load(function() {
							e.ca.getPage(window.va - 1).Ya(window.rb, r);
						}) : (e.ba == I && this.ca.getPage(window.va - 1).load(function() {
							e.ca.getPage(window.va - 1).Ya(window.rb, r);
						}), (e.ba == R || e.ba == "SinglePage" || e.ba == e.sa()) && this.ca.getPage(window.va - 1).Ya(window.rb, r)));
						break
					}
					window.va++;
					window.kb = -1;
					window.Bb = 0;
				}
				if (window.kb == -1) window.kb = -1,
				window.Bb = 0,
				window.va = -1,
				e.Jf(),
				alert(e.toolbar != o && e.toolbar.Xa != o ? e.toolbar.ta(e.toolbar.Xa, "Finishedsearching") : "No more search matches."),
				e.gotoPage(1);
			}
		},
		Df: function(c, d, e) {
			window[this.Mf].getTextFragment = this.Df;
			c = this.renderer.Ma[c - 1];
			if (c != o) return c.substr(d, e);
		},
		Qc: function(c) {
			return this.ca.Qc(c);
		},
		Rc: function(c) {
			return this.ca.Rc(c);
		},
		Ud: function(c) {
			return this.ca.Ud(c);
		},
		Wd: function(c) {
			return this.ca.Wd(c);
		},
		Vd: function(c) {
			return this.ca.Vd(c);
		},
		fitheight: function() {
			if (eb.platform.touchdevice) {
				if (c = this.Rd()) window.FitHeightScale = c,
				this.Ha(c),
				this.ca.zd();
			} else {
				var c = this.Rd();
				window.FitHeightScale = c;
				jQuery(this.ea).trigger("onScaleChanged", c / this.document.MaxZoomSize);
				c * this.document.MaxZoomSize >= this.document.MinZoomSize && c <= this.document.MaxZoomSize && this.Ha(this.document.MaxZoomSize * c);
			}
		},
		Rd: function() {
			if (this.ba == I || this.ba == "SinglePage" || this.ba == R || this.ba == Q) {
				var c = this.ca.getPage(this.na - 1).dimensions.width / this.ca.getPage(this.na - 1).dimensions.height;
				if (eb.platform.touchdevice) {
					if (d = jQuery(this.ia).height() - (this.ba == R || this.ba == Q ? 40 : 0), d /= this.ca.getPage(this.na - 1).Ca, e = this.ca.getPage(this.na - 1), e = e.Ca * (e.dimensions.xa / e.dimensions.Da) * d, (this.ba == R || this.ba == Q) && e * 2 > this.ia.width()) d = this.ia.width() - (this.ba == R || this.ba == Q ? 0 : 0),
					d /= this.ca.getPage(this.na - 1).Ca * 4;
				} else {
					var d = jQuery(this.ca.la).height() - (this.ba == R || this.ba == Q ? 20 : 0);
					d /= this.ca.getPage(this.na - 1).Ca * this.document.MaxZoomSize;
					var e = this.ca.getPage(this.na - 1),
					e = e.Ca * (e.dimensions.xa / e.dimensions.Da) * this.document.MaxZoomSize * d;
					if ((this.ba == R || this.ba == Q) && e * 2 > this.ia.width()) d = jQuery(this.ca.la).width() - 35 - (this.ba == R || this.ba == Q ? 20 : 0),
					d = d / 1.6 / (this.ca.getPage(this.na - 1).Ca * this.document.MaxZoomSize * c);
				}
				return window.FitHeightScale = d;
			}
		},
		next: function() {
			this.ca.next();
		},
		gotoPage: function(c, d) {
			var e = this;
			e.ba == T ? eb.platform.ios ? e.ha ? e.ha.Ah(c) : e.switchMode(I, c) : e.switchMode(I, c) : (e.ba == I && e.ca.scrollTo(c), e.ba == "SinglePage" && setTimeout(function() {
				e.ca.md(c, d);
			},
			300), (e.ba == R || e.ba == Q) && setTimeout(function() {
				e.ca.zc(c, d);
			},
			300), e.ha && e.ha.gotoPage(c, d));
		},
		rotate: function() {
			this.ca.rotate(this.getCurrPage() - 1);
		},
		getCurrPage: function() {
			return this.ca != o ? this.ca.ja + 1 : 1;
		},
		dg: function() {
			this.version = "2.1.2-rc6";
		},
		getTotalPages: function() {
			return this.ca.getTotalPages();
		},
		$b: function(c) {
			if (this.ba != this.sa()) this.na = c,
			this.ca.ja = this.na - 1;
			if ((this.ba == R || this.ba == Q || this.ba == "SinglePage") && this.ca.ja == this.ca.getTotalPages() - 1 && this.ca.ja % 2 != 0) this.ca.ja += 1;
			this.ha && (c == 0 && c++, this.ha.$b(c));
			this.toolbar.ng(c);
			this.Cb != o && (this.ba == R ? (this.Cb.Nc(this.ca.ja + 1), this.Cb.Nc(this.ca.ja + 2)) : this.ba == Q ? (c != 1 && this.Cb.Nc(this.ca.ja), this.Cb.Nc(this.ca.ja + 1)) : this.Cb.Nc(this.na));
		},
		openFullScreen: function() {
			var c = this;
			if (document.Rg || document.hh || document.Lh) return r;
			if (c.ma.css("top") != "0") c.Wf = c.ma.css("top");
			if (c.ma.css("left") != "0") c.Vf = c.ma.css("left");
			c.xa = c.ma.width();
			c.Da = c.ma.height();
			c.ma.css({
				visibility: "hidden"
			});
			var d = c.ma.get(0);
			document.documentElement.requestFullScreen ? (d.requestFullScreen(), c.ma.css({
				left: "0px",
				top: "0px"
			}), c.resize(screen.width, screen.height)) : document.documentElement.mozRequestFullScreen ? (c.ma.css({
				visibility: "hidden"
			}), d.mozRequestFullScreen(), c.ma.css({
				left: "0px",
				top: "0px"
			}), c.resize(screen.width, screen.height)) : document.documentElement.webkitRequestFullScreen ? (d.webkitRequestFullScreen(1), c.ma.css({
				left: "0px",
				top: "0px"
			}), c.resize(screen.width, screen.height)) : c.Uf();
			jQuery(c.ea).trigger("onFullscreenChanged", l);
			window.annotations && (jQuery(".flexpaper_pageword_" + c.ga).remove(), c.Rb(), c.ca.Aa());
			setTimeout(function() {
				c.ma.css({
					visibility: "visible"
				});
			},
			500);
			setTimeout(function() {
				jQuery(document).bind("webkitfullscreenchange mozfullscreenchange fullscreenchange",
				function() {
					c.ia.width() != c.xa && (c.ma.css({
						top: c.Wf,
						left: c.Vf
					}), c.resize(c.xa, c.Da - 2), jQuery(c.ea).trigger("onFullscreenChanged", r), jQuery(document).unbind("webkitfullscreenchange mozfullscreenchange fullscreenchange"), window.annotations && (jQuery(".flexpaper_pageword_" + c.ga).remove(), c.Rb(), c.ca.Aa()));
				});
			},
			1E3);
		},
		Uf: function() {
			var c = "",
			c = "toolbar=no, location=no, scrollbars=no, width=" + screen.width;
			c += ", height=" + screen.height;
			c += ", top=0, left=0";
			c += ", fullscreen=yes";
			nw = window.open("", "windowname4", c);
			nw.lh = c;
			c = "";
			c += '<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">';
			c += "<head>";
			c += '<link rel="stylesheet" type="text/css" href="' + this.config.cssDirectory + 'flexpaper.css" />';
			c += '<script type="text/javascript" src="' + this.config.jsDirectory + 'jquery.min.js"><\/script>';
			c += '<script type="text/javascript" src="' + this.config.jsDirectory + 'jquery.extensions.min.js"><\/script>';
			c += '<script type="text/javascript" src="' + this.config.jsDirectory + 'flexpaper.js"><\/script>';
			c += '<script type="text/javascript" src="' + this.config.jsDirectory + 'flexpaper_handlers.js"><\/script>';
			c += '<style type="text/css" media="screen">body{ margin:0; padding:0; overflow-x:hidden;overflow-y:hidden; }</style>';
			c += "</head>";
			c += '<body onload="openViewer();">';
			c += '<div id="documentViewer" class="flexpaper_viewer" style="position:absolute;width:100%;height:' + (window.annotations ? "97": "100") + '%;"></div>';
			c += '<script type="text/javascript">';
			c += "function openViewer(){";
			c += 'jQuery("#documentViewer").FlexPaperViewer(';
			c += "{ config : {";
			c += "";
			c += 'SWFFile : "' + this.document.SWFFile + '",';
			c += 'IMGFiles : "' + this.document.IMGFiles + '",';
			c += 'JSONFile : "' + this.document.JSONFile + '",';
			c += 'PDFFile : "' + this.document.PDFFile + '",';
			c += "";
			c += "Scale : " + this.scale + ",";
			c += 'ZoomTransition : "' + this.document.ZoomTransition + '",';
			c += "ZoomTime : " + this.document.ZoomTime + ",";
			c += "ZoomInterval : " + this.document.ZoomInterval + ",";
			c += "FitPageOnLoad : " + this.document.FitPageOnLoad + ",";
			c += "FitWidthOnLoad : " + this.document.FitWidthOnLoad + ",";
			c += "FullScreenAsMaxWindow : " + this.document.FullScreenAsMaxWindow + ",";
			c += "ProgressiveLoading : " + this.document.ProgressiveLoading + ",";
			c += "MinZoomSize : " + this.document.MinZoomSize + ",";
			c += "MaxZoomSize : " + this.document.MaxZoomSize + ",";
			c += "SearchMatchAll : " + this.document.SearchMatchAll + ",";
			c += 'InitViewMode : "' + this.document.InitViewMode + '",';
			c += 'RenderingOrder : "' + this.document.RenderingOrder + '",';
			c += "useCustomJSONFormat : " + this.document.useCustomJSONFormat + ",";
			c += 'JSONDataType : "' + this.document.JSONDataType + '",';
			this.document.JSONPageDataFormat != o && (c += "JSONPageDataFormat : {", c += 'pageWidth : "' + this.document.JSONPageDataFormat.Qb + '",', c += 'pageHeight : "' + this.document.JSONPageDataFormat.Pb + '",', c += 'textCollection : "' + this.document.JSONPageDataFormat.Gb + '",', c += 'textFragment : "' + this.document.JSONPageDataFormat.Hb + '",', c += 'textFont : "' + this.document.JSONPageDataFormat.Fc + '",', c += 'textLeft : "' + this.document.JSONPageDataFormat.pc + '",', c += 'textTop : "' + this.document.JSONPageDataFormat.rc + '",', c += 'textWidth : "' + this.document.JSONPageDataFormat.tc + '",', c += 'textHeight : "' + this.document.JSONPageDataFormat.oc + '"', c += "},");
			c += "PrintToolsVisible : " + this.document.PrintToolsVisible + ",";
			c += "ViewModeToolsVisible : " + this.document.ViewModeToolsVisible + ",";
			c += "ZoomToolsVisible : " + this.document.ZoomToolsVisible + ",";
			c += "NavToolsVisible : " + this.document.NavToolsVisible + ",";
			c += "CursorToolsVisible : " + this.document.CursorToolsVisible + ",";
			c += "SearchToolsVisible : " + this.document.SearchToolsVisible + ",";
			c += 'UIConfig : "' + this.document.UIConfig + '",';
			c += 'jsDirectory : "' + this.config.jsDirectory + '",';
			c += 'localeDirectory : "' + this.config.localeDirectory + '",';
			c += 'key : "' + this.config.key + '",';
			c += "";
			c += 'localeChain: "' + this.document.localeChain + '"';
			c += "}});";
			c += "}";
			c += "<\/script>";
			c += "</body>";
			c += "</html>";
			nw.document.write(c);
			nw.Cg = l;
			window.focus && nw.focus();
			nw.document.close();
			return r;
		},
		resize: function(c, d, e, f) {
			this.width = o;
			if (this.ba == this.sa()) this.ha.resize(c, d, e, f);
			else {
				var g = jQuery(this.ea).height() + 1 + 10;
				this.ia.css({
					width: c,
					height: d - g - this.Jc
				}); (e == o || e == l) && this.ma.css({
					width: c,
					height: d
				});
				this.ca.resize(c, d - g - this.Jc, f); (this.ba == R || this.ba == Q) && this.fitheight();
			}
		}
	};
	g.loadFromUrl = g.loadFromUrl;
	return g;
} ();
window.print_flexpaper_Document = function(g, c, d, e, f, t) {
	FLEXPAPER.Yd.init();
	var p = Array(f + 1);
	if (d == "all") for (d = 1; d < f; d++) p[d] = l;
	else if (d == "current") p[e] = l;
	else if (d.indexOf(",") == -1 && d.indexOf("-") > -1) {
		f = parseInt(d.substr(0, d.toString().indexOf("-")));
		for (e = parseInt(d.substr(d.toString().indexOf("-") + 1)); f < e + 1; f++) p[f] = l;
	} else if (d.indexOf(",") > 0) for (var j = d.split(","), d = 0; d < j.length; d++) if (j[d].indexOf("-") > -1) {
		f = parseInt(j[d].substr(0, j[d].toString().indexOf("-")));
		for (e = parseInt(j[d].substr(j[d].toString().indexOf("-") + 1)); f < e + 1; f++) p[f] = l;
	} else p[parseInt(j[d].toString())] = l;
	if (g == "ImagePageRenderer") {
		var u = new ImagePageRenderer(o, c, t);
		u.initialize(function() {
			for (var c = "",
			d = 0; d < u.getNumPages(); d++) p[d + 1] && (c += "<div class='flexpaper_ppage " + (d < u.getNumPages() - 1 ? "ppage_break": "ppage_none") + "'><img src='" + u.Ba(d + 1) + "'></div>");
			jQuery(document.body).append(c);
			window.document.close();
			window.focus();
			window.print();
			window.close();
		});
	}
	g == "CanvasPageRenderer" && (u = new CanvasPageRenderer(o, c.PdfFile, t, c), u.initialize(function() {
		for (var c = "",
		d = 0; d < u.getNumPages(); d++) p[d + 1] && (c += "<canvas id='ppage_" + d + "' class='flexpaper_ppage " + (d < u.getNumPages() - 1 ? "ppage_break": "ppage_none") + "'></canvas>");
		jQuery(document.body).append(c);
		renderPrintPage(u, 0);
	}));
};
window.renderPrintPage = function ja(c, d) {
	c.yb() == "CanvasPageRenderer" && (d < c.getNumPages() ? c.ya.getPage(d + 1).then(function(e) {
		var f = document.getElementById("ppage_" + d);
		if (f) {
			var t = f.getContext("2d"),
			p = e.getViewport(1),
			t = {
				canvasContext: t,
				viewport: p,
				textLayer: o,
				continueCallback: function(c) {
					c();
				}
			};
			f.width = p.width;
			f.height = p.height;
			e.render(t).then(function() {
				ja(c, d + 1);
			},
			function(c) {
				console.log(c);
			});
		} else ja(c, d + 1);
	}) : window.print());
};
ia && self.addEventListener("message",
function(g) {
	g = g.data;
	if (g.cmd !== "undefined") switch (g.cmd) {
	case "loadImageResource":
		var c = new XMLHttpRequest;
		c.open("GET", "../../" + g.src);
		c.mozResponseType = c.responseType = "arraybuffer";
		c.onreadystatechange = function() {
			if (c.readyState == 4 && c.status == 200) {
				for (var d = new Uint8Array(this.response), e = d.length, f = Array(e); e--;) f[e] = String.fromCharCode(d[e]);
				self.postMessage({
					status: "ImageResourceLoaded",
					blob: f.join("")
				});
				self.close();
			}
		};
		c.send(o);
	}
},
r);

});