var jwObj = null;
/*
 * 初始化视频播放器,，默认尺寸为 640x360(16:9)
 * 
 * containerId 绑定的div id , 不带  #
 * parentFolder 视频文件的父亲目录路径（相对路径）
 * autostart 自动播放标志
 * seekTime 跳转时间点，单位为：秒
 * onTimeCallback 视频播放时定时回调函数，回调参数为JSON ， {"position" : 5}
 */
function initPlay(containerId, options) {
	//-------------------传入参数start-----------------------------------------------
	var defaultWidth = options.defaultWidth;//播放器宽度
	var defaultHeight = options.defaultHeight;//播放器高度
	var allowseek = options.allowseek;//是否可拖拽
	var seekTime = options.seekTime;//定位时间点
	var onTimeCallback = options.onTimeCallback;//播放过程中回调函数
	var onCompleteCallback = options.onCompleteCallback;//播放结束回调函数
	var autostart = options.autostart;//是否自动开始播放
	var localImage = options.videoPic;//视频缩略图
	var itemId = options.itemId;
	var logurl = options.logurl;
	var studyMode = false === options.studyMode ? false : true;
	var resourcePath = options.resourcePath;
	var videoUrl = options.videoUrl;
	var formal = false === options.formal ? 0 : 1;
	//播放器尺寸
	var width = 640;
	var height = 360;
	if (defaultWidth != null && defaultHeight != null) {
		width = defaultWidth;
		height = defaultHeight;
	}
	//是否可拖拽
	var enabledDragableSlider = true;
	if (allowseek != null) {
		enabledDragableSlider = allowseek;
	}
	var isMobile = jwplayer.utils.isMobile();
	var isIE8 = jwplayer.utils.isIETrident(8);
	var files = [];
	var playlist = [];

	var paramTracks = new Array();

	var videoTemp = {
		'file' : resourcePath + videoUrl,
		'label' : '默认',
		'default' : true
	};
	files.push(videoTemp);
	playlist.push( {
		title : '公网',
		image : localImage,
		sources : files,
		tracks : paramTracks
	});

	jwObj = jwplayer(containerId).setup( {
		allowseek : enabledDragableSlider,
		allowsource : true,
		controls : true,
		primary : isMobile ? "html5" : "html5,flash",
		width : width,
		height : height,
		autostart : autostart,
		playbackrate : false,
		startparam : 'start',
		playlist : playlist,
		logurl : logurl ? Logger.getLogUrl(itemId) + "&fm=" + formal : "",
		captions : {
			back : false,
			color : 'ffffff',
			fontsize : 16
		},
		starttime : (seekTime / 1000) || 0
	}).onReady(function() {

	}).onTime(function(evt) {
		if (!studyMode)
			return;
		if (onTimeCallback != null) {
			onTimeCallback( {//回调，更新学习记录
				"position" : evt.position
			});
		}
	}).onComplete(function() {
		if (!studyMode)
			return;
		if (onCompleteCallback != null) {
			onCompleteCallback();//播放结束回调
		}
	}).onHeart(function(evt) {
		if (!studyMode)
			return;
		Logger.heart(evt);
	});
}

function initPreviewPlay(containerId, localImage, flv_url, defaultWidth,
		defaultHeight, resourcePath, auto, spocMediaHost, networkInSchool) {
	var isMobile = jwplayer.utils.isMobile();
	var isIE8 = jwplayer.utils.isIETrident(8);
	spocMediaHost = spocMediaHost || "";
	var inSchool = networkInSchool || "0";

	if (flv_url.indexOf("http:") < 0) {
		if ("1" == inSchool && spocMediaHost.length > 0) {
			flv_url = spocMediaHost + flv_url;
		} else {
			flv_url = resourcePath + flv_url;
		}
	} else {
		if ((isMobile || !isIE8) && flv_url.indexOf(".chuanke.com") > 0
				&& flv_url.indexOf(".flv") > 0) {
			flv_url = flv_url.replace(".enc.flv", ".flv");
			flv_url = flv_url.replace(".flv", ".mp4");
		}

		if ("1" == inSchool && spocMediaHost.length > 0) {
			flv_url = spocMediaHost + getThirdpartyUrl(flv_url);
		}
	}
	if (localImage.indexOf("http:") < 0) {
		if ("1" == inSchool && spocMediaHost.length > 0) {
			localImage = spocMediaHost + localImage;
		} else {
			localImage = resourcePath + localImage;
		}
	} else {
		if ("1" == inSchool && spocMediaHost.length > 0) {
			localImage = spocMediaHost + getThirdpartyUrl(localImage);
		}
	}

	//播放器尺寸
	var width = 640;
	var height = 360;
	//是否可拖拽
	var enabledDragableSlider = true;

	var files = new Array();
	var temp = {
		'file' : flv_url,
		'label' : '预览'
	};
	files.push(temp);

	if (defaultWidth != null && defaultHeight != null) {
		width = defaultWidth;
		height = defaultHeight;
	}

	auto = typeof (auto) == "undefined" ? true : auto;

	jwObj = jwplayer(containerId).setup( {
		controls : true,
		allowseek : true,
		primary : isMobile ? "html5" : "html5,flash",
		width : width,
		height : height,
		autostart : auto,
		playbackrate : false,
		startparam : 'start',
		image : localImage,
		sources : files
	}).onReady(function() {

	}).onTime(function() {

	}).onComplete(function() {

	}).onShotFinish(function(event) {

	});
}

$(document)
		.on(
				"keydown",
				function(event) {
					var e = event.srcElement || event.target;
					if (e
							&& (e.tagName == "INPUT" || e.tagName == "TEXTAREA" || e.contentEditable == "true")) {
						return;
					}
					if (event.keyCode == 32) {
						jwObj.pause();
						event.stopPropagation();
						event.preventDefault();
					} else if (event.keyCode == 37) {
						jwObj.seek(jwObj.getPosition() - 5);
					} else if (event.keyCode == 39) {
						jwObj.seek(jwObj.getPosition() + 5);
					}
				});
