/**
 * Created by 01312170 on 14-8-21.
 */
(function ($) {
    var pageMarkMath = {
        formatPage: function (current, total, fb, mb, lb) {
            var _r = [];
            //中间块 大小
            var _t = Math.floor(mb / 2);
            //保留 首位
            for (var i = 1; i < 1 + fb; i++) {
                _r.push(i);
            }
            //保留 末位
            for (var i = total; i > total - lb; i--) {
                _r.push(i);
            }

            for (var i = current - _t; i <= current + _t; i++) {
                if (1 <= i && i <= total) {
                    _r.push(i);
                }
            }

            for (var i = current - _t; i <= current + _t; i++) {
                if (1 <= i && i <= total) {
                    _r.push(i);
                }
            }
            _r = pageMarkMath.unique(_r);
            pageMarkMath.sort(_r);
            _r = pageMarkMath.linkAppend(_r);
            return _r;
        },
        unique: function (arr) {
            arr = arr || [];
            var ret = [];
            var hash = {};
            for (var i = 0; i < arr.length; i++) {
                var item = arr[i];
                var key = typeof(item) + item
                if (hash[key] !== 1) {
                    ret.push(item);
                    hash[key] = 1
                }
            }
            return ret;
        },
        sort: function (arr) {
            return arr.sort(function (a, b) {
                return a - b;
            });
        },
        linkAppend: function (arr) {
            var _r = [];
            for (var i = 0; i < arr.length; i++) {
                _r.push(arr[i]);
                if (typeof arr[i + 1] != "undefined" && arr[i + 1] - arr[i] == 2) {
                    _r.push(arr[i] + 1)
                }
            }
            return _r;
        },
        getRID: function () {
            var length = 0;
            while (length == 0) {
                var _id = Math.random();
                _id = (_id + "").substring(2, 10);

                if ($("#" + _id).length == 0) {
                    return _id;
                }
            }
        }
    }

    var pageMark = function (target, params) {
        var $target = $(target);
        var id = $target.attr("id");
        var def = {
            current: 1,
            total: 10,
            block_a: 1,
            block_b: 5,
            block_c: 1,
            onClicked: null
        };
        var builder = {
            mark: function (current, total, tb, bb, lb) {
                var aPage = pageMarkMath.formatPage(current, total, tb, bb, lb);
                var html = [];

                html.push('<div>');
                if (methods.debug || current > 0) {
                    html.push('<ul class="clearfix">');
                    html.push('<li class="page-prev"><a href="javascript:void(0)">&lsaquo;</a></li>');

                    for (var i = 0; i < aPage.length; i++) {

                        if (current == aPage[i]) {
                            html.push('<li class="page-num current"><a href="javascript:void(0)" pageNum="' + aPage[i] + '">' + aPage[i] + '</a></li>');
                        } else {
                            html.push('<li class="page-num"><a href="javascript:void(0)" pageNum="' + aPage[i] + '">' + aPage[i] + '</a></li>');
                        }
                        if (aPage[i] < aPage[i + 1] - 1) {
                            html.push('<li class="page-num"><a href="javascript:void(0)" class="page-dot">...</a></li>');
                        }
                    }
                    html.push('<li class="page-next"><a href="javascript:void(0)">&rsaquo;</a></li>');
                    html.push('<li class="page-action">');
                    html.push('<input type="text" class="input-text input-page" title="Enter Search" _type="changeIndex">');
                    html.push('<span class="page-total">/' + p.total + '页</span>');
                    html.push('</li>');
                    html.push('</ul>')
                }
                html.push('</div>')
                return html;
            }
        }
        var methods = {
            debug: false,
            init: function (a) {
                methods.reload(a);
            },
            reload: function (a) {
                p.current = parseInt(a.current || def.current);
                p.total = parseInt(a.total || def.total);
                p.block_a = parseInt(a.block_a || def.block_a);
                p.block_b = parseInt(a.block_b || def.block_b);
                var arr_html = [];
                if (methods.debug || p.total > 1) {
                    arr_html = builder.mark(p.current, p.total, p.block_a, p.block_b, p.block_c);
                }
                arr_html.length - 1;
                arr_html.shift();
                $target.html(arr_html.join(""));
                eve.pageClick($target);
                eve.pagePreClick($target);
                eve.pageNextClick($target);
                eve.pageInputKeyUp($target);
            }
        }

        var eve = {
            pageClick: function (target) {
                $(".page-num", target).on("click", function () {
                    var obj = $(this);
                    var num = parseInt($(">a", obj).text() || 1)||1;
                    if (methods.debug || num != p.current)
                        p.onClicked && p.onClicked(num, target);
                })
            }, pagePreClick: function (target) {
                $(".page-prev", target).on("click", function () {
                    var num = p.current - 1;
                    if (num < 1) {
                        num = 1;
                    }
                    if (methods.debug || num != p.current)
                        p.onClicked && p.onClicked(num, target);
                })
            }, pageNextClick: function (target) {
                $(".page-next", target).on("click", function () {
                    var num = p.current + 1;
                    if (num > p.total) {
                        num = p.total;
                    }
                    if (methods.debug || num != p.current)
                        p.onClicked && p.onClicked(num, target);
                })
            }, pageInputKeyUp: function (target) {
                $('[_type="changeIndex"]', target).on("keyup", function (event) {
                    var $this = $(this);
                    if ($.trim($this.val() || "").length > 0) {
                        var num = parseInt($this.val() || "");
                        if (isNaN(num)) {
                            num = 0;
                        }
                        if (num > p.total) {
                            num = p.total;
                        }
                        if (num < 1) {
                            num = 1
                        }
                        if (event.keyCode == 13) {
                            if (methods.debug || num != p.current)
                                p.onClicked && p.onClicked(num, target);
                        }
                    }
                })
            }
        }
        var pub = {
            reload: function (a) {
                p = $.extend(p, a)
                methods.reload(p)
            }
        }
        var p = $.extend(def, params);
        methods.init(p)
        return pub;
    }

    $.fn.pageMark = function (action, params) {
        params = params || action;
        var $target = $(this);
        if (!$target.hasClass("pagination")) {
            $target.addClass("pagination");
        }
        if (typeof $target == "undefined") {
            return null;
        }
        var id = $target.attr("id");
        if (typeof id == "undefined") {
            id = pageMarkMath.getRID()
            $target.attr("id", id);
        }
        gM.log($target.data("pageMark"))
        if (typeof $target.data("pageMark") == "undefined") {
            $target.data("pageMark", pageMark($target, params));
        }
        var pmk = $target.data("pageMark");
        if (typeof action != "undefined" && typeof action == "string") {
            pmk[action].call('', params)
        }
        return pmk;
    }
}(jQuery))
