var submitFlag = false;
$(function () {
    $('.content .access-form input[placeholder]').defaultValue();

    //登陆页 回车处理
    $("#login_box").on("keyup", "#loginName", function (event) {
        if (event.keyCode == 13) {
            $("#login_box #password").focus();
        }
    });
    $("#login_box").on("keyup", "#password", function (event) {
        if (event.keyCode == 13) {
            if ($('#check_code:visible').length > 0) {
                $("#login_box #checkCode").focus();
            } else {
                $("#userLogin").trigger("click");
            }
        }
    });
    $("#login_box").on("keyup", "#checkCode", function (event) {
        if (event.keyCode == 13) {
            $("#userLogin").trigger("click");
        }
    });

    //注册页 回车处理
    $("#register_box").on("keyup", "#loginName", function (event) {
        if (event.keyCode == 13) {
            $("#register_box #password").focus();
        }
    });
    $("#register_box").on("keyup", "#password", function (event) {
        if (event.keyCode == 13) {
            $("#register_box #confirmPassword").focus();
        }
    });
    $("#register_box").on("keyup", "#confirmPassword", function (event) {
        if (event.keyCode == 13) {
            $("#register_box #checkCode").focus();
        }
    });
    $("#register_box").on("keyup", "#checkCode", function (event) {
        if (event.keyCode == 13) {
            $("#userRegister").trigger("click");
        }
    });

    var loginNum = 0;
    $("#userLogin").click(function () {
        var loginType = "0";
        var password = $.trim($("#password").val());
        var loginName = $.trim($("#loginName").val());
        if (loginName.length == 0) {
            $.dialog.error("登录账号不能为空！", 2);
            return;
        }

        if (password.length == 0) {
            $.dialog.error("密码不能为空！", 2);
            return;
        }
        password = $.md5(password);

        var isCheckCode = 0;
        var checkCode;
        if ($('#check_code:visible').length > 0) {
            checkCode = $("#checkCode").val();
            if (!checkCode) {
                $.dialog.error("请输入验证码！", 2);
                return;
            }
            $('#checkCode').val('');
            isCheckCode = 1; //有验证码
        }

        var historyUrl = $("#historyUrl").val();
        var lang = $(".dk-selected").find("span").attr("lang");
        if (submitFlag == false) {
            $(this).empty().text("正在登录...");
            submitFlag = true;
        } else {
            return;
        }

        $.ajax({
            type: 'post',
            datatype: "json",
            url: CONTEXTPATH + "/home/doLogin.mooc",
            data: {
                loginName: loginName,
                password: password,
                loginType: loginType,
                isCheckCode: isCheckCode,
                checkCode: checkCode,
                historyUrl: historyUrl,
                lang: lang
            },
            success: function (result) {
                submitFlag = false;
                if (result.retCode == "success") {
                    loginSuccessHref(result);
                } else {
                    submitFlag = false;
                    $("#userLogin").empty().text("登录");
                    $.dialog.error(result.retMsg, 2);
                    loginNum++;
                    if (loginNum >= 3) {
                        initImage();
                    }
                }
            },
            error: function () {
            }
        })
    });

    //初始化页面
    if ($('#check_code:visible').length > 0) {
        initImage();
    }

    //图片切换
    $('#changeImage').click(function(){
        initImage();
    });

    //用户注册
    $("#userRegister").click(function () {
        var loginName = $.trim($("#loginName").val());
        if (loginName.length == 0) {
            $.dialog.error("登录账号不能为空！", 2);
            return;
        }
        if (loginName.length < 4 || loginName.length > 18) {
            $.dialog.error("账号长度需要在4-18位！", 2);
            return;
        }

        var password = $.trim($("#password").val());
        if (password.length == 0) {
            $.dialog.error("密码不能为空！", 2);
            return;
        }
        if (password.length < 6 || password.length > 18) {
            $.dialog.error("密码长度需要在6-18位！", 2);
            return;
        }

        var confirmPassword = $.trim($("#confirmPassword").val()); //确认密码
        if (confirmPassword.length == 0) {
            $.dialog.error("确认密码不能为空！", 2);
            return;
        } else {
            if (password != confirmPassword) {
                $.dialog.error("两次输入密码不一致！", 2);
                return
            }
        }

        var checkCode = $("#checkCode").val();
        if (!checkCode) {
            $.dialog.error("请输入验证码！", 2);
            return;
        }

        if (submitFlag == false) {
            $(this).find("span").empty().text("正在提交中...");
            submitFlag = true;
        } else {
            return;
        }
        $.ajax({
            type: "post",
            url: CONTEXTPATH + "/home/doRegister.mooc",
            data: {
                loginName: loginName,
                password: password,
                checkCode: checkCode
            },
            success: function (response) {
                submitFlag = false;
                if (response.returnCode == 'success') {
                    $.dialog.success("注册成功！");
                    location.href = CONTEXTPATH + "/portal/mycourse/index.mooc";
                } else {
                    $("#userRegister").find("span").empty().text("注册");
                    if (response.returnCode == '610136') {
                        $.dialog.error("账号已存在！");
                    } else if (response.returnCode == '610012') {//图片验证码
                        $.dialog.error("验证码不正确！");
                    } else {
                        $.dialog.error(response.retMsg);
                    }
                }
            }
        })
    })
})

function initImage() {
    var url = CONTEXTPATH + "/home/changeImage.mooc";
    $.ajax({
        type: 'post',
        url: url,
        success: function (data) {
            $('#changeImage').html(data).parents(".input-group").removeClass("publicTip");
        }
    })
}

function loginSuccessHref(result) {
    var _newUrl = result.historyUrl;
    if (_newUrl == null || _newUrl.length == 0) {
        _newUrl = '/portal/mycourse/index.mooc';
    }
    var dignity = result.dignity;
    if (dignity == 10) { //超管
        _newUrl = "/home/admin.mooc";
    }
    location.href = (CONTEXTPATH + _newUrl);
}