<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@include file="/WEB-INF/jsp/includes.jsp" %>
<input type="hidden" id="oldPasswordHide" value="${userInfo.password}"/>

<div class="step-content p-pwd-set">
    <div class=" ">
        <div class="input-group">
            <label class="input-label"><b>*</b>当前密码</label>
            <input id="oldPassword" maxlength="18" type="password" class="input-text"/>
            <span class="public-tip"><i class=""></i></span>
        </div>
        <div class="input-group">
            <label class="input-label"><b>*</b>新密码</label>
            <input id="newPassword" maxlength="18" type="password" class="input-text"/>

            <div class="psw-tip normal">
                <p class="psw-tip-text clearfix" style="display: none;">
                    <span class="pt-left">弱</span>
                    <span class="pt-right">强</span>
                </p>
                <i class="icon-strength" style="display: none;"></i>
            </div>
            <span class="public-tip">
                <i class="icon-tip"></i>请输入6-18个字符
            </span>
        </div>
        <div class="input-group">
            <label class="input-label"><b>*</b>确认密码</label>
            <input id="newPassword2" maxlength="18" type="password" class="input-text"/>
            <span class="public-tip"><i class=""></i></span>
        </div>

        <div class="input-group">
            <label class="input-label">&nbsp; </label>
            <a class="btn-icon"id="savePassword" href="javascript:void(0)"><i class="icon-btn"><i class="i-save"></i></i>保存</a>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $("#oldPassword").change(function () {
            var op = $.trim($("#oldPassword").val());
            var oph = $.trim($("#oldPasswordHide").val());
            if ($.md5(op).toLowerCase() == oph.toLowerCase()) {
                $("#oldPassword").parent().children("span.public-tip").children("i").removeClass().addClass("icon-mark right-mark");
            } else {
                $("#oldPassword").parent().children("span.public-tip").children("i").removeClass().addClass("icon-mark error-mark");
            }
        });

        $("#newPassword").bind("input propertychange", function () {
            var opn = $.trim($("#newPassword").val());
            if (opn.length > 0) {
                $(".p-pwd-set .psw-tip .psw-tip-text").show();
                $(".p-pwd-set .psw-tip .icon-strength").show();
            } else {
                $(".p-pwd-set .psw-tip .psw-tip-text").hide();
                $(".p-pwd-set .psw-tip .icon-strength").hide();
            }
            if (opn.length >= 6) {
                var modes = checkStrong(opn);
                if (modes == 1) {
                    $("#newPassword").parent().children("div.psw-tip").removeClass("normal middle strong").addClass("normal");
                } else if (modes == 2) {
                    $("#newPassword").parent().children("div.psw-tip").removeClass("normal middle strong").addClass("middle");
                } else if (modes >= 3) {
                    $("#newPassword").parent().children("div.psw-tip").removeClass("normal middle strong").addClass("strong");
                }
            }
        });

        $("#savePassword").click(function () {
            var op = $.trim($("#oldPassword").val());
            var oph = $.trim($("#oldPasswordHide").val());
            var opn2 = $.trim($("#newPassword2").val());
            var opn = $.trim($("#newPassword").val());
            if (op == null || op == "") {
                $.dialog.error("当前密码不能为空！");
                return;
            }
            if ($.md5(op).toLowerCase() != oph.toLowerCase()) {
                $.dialog.error("当前密码不正确！");
                return;
            }
            if (opn == null || opn == "") {
                $.dialog.error("密码不能为空！");
                return;
            }
            if (opn2 == null || opn2 == "") {
                $.dialog.error('确认密码不能为空！');
                return;
            }
            if (opn != opn2) {
                $.dialog.error("两次输入密码不一致！");
                return;
            }
            if (opn.length < 6 || opn2.length < 6) {
                $.dialog.error("输入密码不能低于6位！");
                return;
            }
            $.ajax({
                type: "post",
                url: CONTEXTPATH + "/portal/save/password.mooc",
                dataType: "json",
                data: {
                    oldPass: $.md5(op),
                    newPass: opn,
                    newPass2: opn2
                },
                success: function (response) {
                    if (response.errorMsg) {
                        $.dialog.tips(response.errorMsg);
                    } else {
                        $.dialog.success("设置成功！");
                    }
                },
                error: function () {

                }
            });
        });
    });
</script>