<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@include file="/WEB-INF/jsp/includes.jsp"%>
<input type="hidden" value="mycourse" id="currentMenu"/>

<div class="layout-wrap layout-test-main">
	<div class="layout clearfix">
		<div class="side-layout">
			<ul class="section-list">
				<c:forEach items="${unitList}" var="unitMap">
					<c:set var="isLock" value="${unitMap['isLock']}"/>
					<c:set var="isOver" value="${unitMap['isOver']}"/>
					<c:set var="unit" value="${unitMap['unit']}"/>
					<li class="unit-li ${isLock?'status-lock':(isOver?'status-right':'status-underway') } <c:if test="${lastUnitId==unit.unitId}">selected</c:if>" unitId="${unit.unitId}">
						<span class="section-name">${unit.unitNo }</span>
						<i class="icon-ttm icon-status"></i>
					</li>
				</c:forEach>
			</ul>
		</div>
		<div id="itemDiv"></div>
	</div>
</div>
<script type="text/javascript">
$(function(){
	
	queryItemList(${lastUnitId});
	
	$(".unit-li").click(function(){
		if ($(this).hasClass("status-lock")){
			return;
		}
		var unitId = $(this).attr("unitId");
		$(".unit-li").removeClass("selected");
		$(this).addClass("selected");
		queryItemList(unitId);
	});
});
function queryItemList(unitId){
	$.ajax({
		type:"post",
		url:CONTEXTPATH+"/portal/mycourse/item/list.mooc",
		data:{
			unitId:unitId
		},
		dataType:"html",
		success:function(resHtml){
			$("#itemDiv").html(resHtml);
		}
	});
}
</script>