var __READER_EVENT_CALLBACK = {};

(function($) {
    $.fn.reader = function (options) {
        var getScriptPath = function(scriptName) {
            var scripts = document.getElementsByTagName("script");
            for (var i=0; i<scripts.length; i++) {
                var src = scripts[i].src;
                if (src && src.indexOf(scriptName) >= 0) {
                    return src.substr(0, src.indexOf(scriptName));
                }
            }
            return "";
        };
        function getFlashObject() {
            var flashObj = document[id] || window[id];
            return flashObj;
        }
        var renderMode = "none";

        var basePath = getScriptPath("reader.js");
        var $this = this;
        var readerId=Math.floor(Math.random() * 999999999);
        var id = options.id || readerId;
        var viewerId = id+"_wrapper";
        var shotUrl = options.shoturl || "";
        var lgoUrl = options.logurl || "";

        options.width = options.width || 800;
        options.height = options.height || 600;

        __READER_EVENT_CALLBACK["PAGECHANG_"+options.docid] = options.pageChange || null;
        __READER_EVENT_CALLBACK["FINISH_"+options.docid] = options.finish || null;
        __READER_EVENT_CALLBACK["SHOTFINISH_"+options.docid] = options.shotFinish || null;
        __READER_EVENT_CALLBACK["HEART_"+options.docid] = options.heart || null;
        
        var ua = navigator.userAgent.toLowerCase();
        if (ua.match(/iphone/i) || ua.match(/ipod/i) || ua.match(/ipad/i)) {
            renderMode = "html";
            $this.html('<link rel="stylesheet" href="'+basePath+'html/css/reader.css" type="text/css"/><div id="'+viewerId+'" style="width:'+options.width+'px;height:'+options.height+'px;"></div>');
            $('#'+viewerId).FlexPaperViewer({
                config : {
                    DOC : escape('{'+options.docurl + '?viewer=html&resid=' + options.docid +'&format={format}&start=[*,0],{numPages}}'),
                    Scale : 1,
                    ZoomTransition : 'easeOut',
                    ZoomTime : 0.5,
                    ZoomInterval : 0.2,
                    FitPageOnLoad : true,
                    FitWidthOnLoad : true,
                    FullScreenAsMaxWindow : false,
                    ProgressiveLoading : true,
                    MinZoomSize : 0.2,
                    MaxZoomSize : 5,
                    SearchMatchAll : false,
                    SearchServiceUrl : '',
                    InitViewMode : 'Portrait',
                    RenderingOrder : 'html',
                    ViewModeToolsVisible : true,
                    ZoomToolsVisible : false,
                    NavToolsVisible : true,
                    CursorToolsVisible : false,
                    SearchToolsVisible : false,
                    DocSizeQueryService : '',
                    jsDirectory : basePath + 'html/js/',
                    localeDirectory : basePath + 'html/locale/',
                    JSONDataType : 'jsonp',
                    localeChain: 'zh_CN',
                    StartAtPage:options.pageno || 1
                }
            });

            $('#'+viewerId).bind('onDocumentLoaded', function(e, totalPages) {
                $this.totalPages = totalPages;
                wsPageChange(getDocViewer(viewerId).getCurrPage(), options.docid, options.extparams, $this.getTotalPages());
            });
            $('#'+viewerId).bind('onCurrentPageChanged', function(e, pagenum) {
                wsPageChange(pagenum, options.docid, options.extparams, $this.getTotalPages());
            });

        } else {
            renderMode = "falsh";
            var flashOptions = {};
            flashOptions.id = id;
            flashOptions.swf = basePath+"reader.swf?2490";
            flashOptions.width = options.width || 800;
            flashOptions.height = options.height || 600;
            flashOptions.encodeParams = false;
            flashOptions.allowFullScreen = true;
            flashOptions.flashvars = {
                docurl:encodeURIComponent(options.docurl || ""),
                docid:encodeURIComponent(options.docid),
                callbackurl:encodeURIComponent(options.callbackurl || ""),
                shoturl:encodeURIComponent(shotUrl),
                logurl:encodeURIComponent(lgoUrl),
                extparams:encodeURIComponent(options.extparams || ""),
                pn:options.pageno || 0,
                doctype:(options.slideshow || false) ? "ppt" : "",
                endpage:options.endpage || false
            }

            $this.flash(flashOptions);
            $this.mousewheel(function(event) {
                var delta = -50;
                if (event.deltaY < 0) {
                    delta = 50;
                }

                var flashObj = getFlashObject();
                flashObj.NS_IK_doMouseWheel(delta);
                event.preventDefault && event.preventDefault();
                event.returnValue=false;
                event.stopPropagation && event.stopPropagation();
                return false;
            });
        }

        $this.screenshot = function() {
            if (renderMode == "falsh") {
                getFlashObject().wsScreenshot();
            } else {
                throw 'Not suuported';
            }
        }

        $this.gotoPage = function(pageNo) {
            if (renderMode == "falsh") {
                getFlashObject().wsGotoPage(pageNo);
            } else {
                getDocViewer(viewerId).gotoPage(pageNo);
            }
        }

        $this.getTotalPages = function() {
            if (renderMode == "falsh") {
                return getFlashObject().wsGetTotalPage();
            } else {
                return $this.totalPages;
            }
        }

        $this.resize = function(width, height) {
            if (renderMode == "falsh") {
                $("#"+id).css({'width':width,'height':height})
            } else {

            }
        }

        return $this;
    };
}(jQuery));

function wsPageChange(pageno, docid, params, totalpage) {
    for (var item in __READER_EVENT_CALLBACK) {
        if (pageno == totalpage) {
            if (item.indexOf("FINISH_") == -1) continue;
            if (item != "FINISH_"+docid) continue;
            if (__READER_EVENT_CALLBACK[item] == null) continue;
            __READER_EVENT_CALLBACK[item](docid);
            break;
        }
        if (item.indexOf("PAGECHANG_") == -1) continue;
        if (item != "PAGECHANG_"+docid) continue;
        if (__READER_EVENT_CALLBACK[item] == null) continue;
        __READER_EVENT_CALLBACK[item](pageno, docid, params, totalpage);
        break;
    }
}

function wsScreenshotFinish(docid, data) {
    if (typeof data == "string") {
        data = $.parseJSON(data);
    }

    for (var item in __READER_EVENT_CALLBACK) {
        if (item.indexOf("SHOTFINISH_") == -1) continue;
        if (item != "SHOTFINISH_"+docid) continue;
        if (__READER_EVENT_CALLBACK[item] == null) continue;
        __READER_EVENT_CALLBACK[item](docid, data);
        break;
    }
}

function wsHeart(docid, data) {
    if (typeof data == "string") {
        data = $.parseJSON(data);
    }

    for (var item in __READER_EVENT_CALLBACK) {
        if (item.indexOf("HEART_") == -1) continue;
        if (item != "HEART_"+docid) continue;
        if (__READER_EVENT_CALLBACK[item] == null) continue;
        __READER_EVENT_CALLBACK[item](docid, data);
        break;
    }
}

window.$FlexPaper = window.getDocViewer = window["$FlexPaper"] = function(id) {
    var instance = (id === "undefined") ? "" : id;

    if (window['ViewerMode'] == 'flash') {
        return window["FlexPaperViewer_Instance" + instance].getApi();
    } else if (window['ViewerMode'] == 'html') {
        return window["FlexPaperViewer_Instance" + instance];
    }
};

/**
 *
 * FlexPaper embedding (name of placeholder, config)
 *
 */
window.FlexPaperViewerEmbedding = window.$f = function(id, args) {
    this.id = id;

    var userAgent = navigator.userAgent.toLowerCase();
    var browser = window["eb.browser"] = {
        version: (userAgent.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/) || [])[1],
        safari: /webkit/.test(userAgent),
        opera: /opera/.test(userAgent),
        msie: /msie/.test(userAgent) && !/opera/.test(userAgent),
        mozilla: /mozilla/.test(userAgent) && !/(compatible|webkit)/.test(userAgent),
        chrome: /chrome/.test(userAgent)
    };

    var platform = window["eb.platform"] = {
        win: /win/.test(userAgent),
        mac: /mac/.test(userAgent),
        touchdevice: (function() {
            try {
                return 'ontouchstart' in document.documentElement;
            } catch (e) {
                return false;
            }
        })(),
        ios: ((userAgent.match(/iphone/i)) || (userAgent.match(/ipod/i)) || (userAgent.match(/ipad/i)))
    };

    var config = args.config;
    var _SWFFile, _PDFFile, _IMGFiles, _SVGFiles, _IMGFiles_thumbs = "",
        _IMGFiles_highres = "",
        _JSONFile = "",
        _jsDirectory = "",
        _cssDirectory = "",
        _localeDirectory = "";
    _WMode = (config.WMode != null || config.wmmode != null ? config.wmmode || config.WMode : "direct");
    var _uDoc = ((config.DOC != null) ? unescape(config.DOC) : null);
    var instance = "FlexPaperViewer_Instance" + ((id === "undefined") ? "" : id);
    var _JSONDataType = (config.JSONDataType != null) ? config.JSONDataType : "json";

    if (_uDoc != null) {
        _SWFFile = translateUrlByFormat(_uDoc, "swf");
        _PDFFile = translateUrlByFormat(_uDoc, "pdf");
        _JSONFile = translateUrlByFormat(_uDoc, _JSONDataType);
        _IMGFiles = translateUrlByFormat(_uDoc, "jpg");
        _SVGFiles = translateUrlByFormat(_uDoc, "svg");
        _IMGFiles_thumbs = translateUrlByFormat(_uDoc, "jpg");
        _IMGFiles_highres = translateUrlByFormat(_uDoc, "jpgpageslice");
    }

    _SWFFile = (config.SwfFile != null ? config.SwfFile : _SWFFile);
    _SWFFile = (config.SWFFile != null ? config.SWFFile : _SWFFile);
    _PDFFile = (config.PDFFile != null ? config.PDFFile : _PDFFile);
    _IMGFiles = (config.IMGFiles != null ? config.IMGFiles : _IMGFiles);
    _IMGFiles = (config.PageImagePattern != null ? config.PageImagePattern : _IMGFiles);
    _SVGFiles = (config.SVGFiles != null ? config.SVGFiles : _SVGFiles);
    _IMGFiles_thumbs = (config.ThumbIMGFiles != null ? config.ThumbIMGFiles : _IMGFiles_thumbs);
    _IMGFiles_highres = (config.HighResIMGFiles != null ? config.HighResIMGFiles : _IMGFiles_highres);
    _JSONFile = (config.JSONFile != null ? config.JSONFile : _JSONFile);
    _jsDirectory = (config.jsDirectory != null ? config.jsDirectory : detectjsdir());
    _cssDirectory = (config.cssDirectory != null ? config.cssDirectory : detectcssdir());
    _localeDirectory = (config.localeDirectory != null ? config.localeDirectory : "locale/");
    if (_SWFFile != null && _SWFFile.indexOf("{") == 0 && _SWFFile.indexOf("[*,") > 0 && _SWFFile.indexOf("]") > 0) {
        _SWFFile = escape(_SWFFile);
    } // split file fix

    window[instance] = flashembed(id, {
        src: _jsDirectory + "../FlexPaperViewer.swf",
        version: [10, 0],
        expressInstall: "js/expressinstall.swf",
        wmode: _WMode
    }, {
        ElementId: id,
        SwfFile: _SWFFile,
        PdfFile: _PDFFile,
        IMGFiles: _IMGFiles,
        SVGFiles: _SVGFiles,
        JSONFile: _JSONFile,
        ThumbIMGFiles: _IMGFiles_thumbs,
        HighResIMGFiles: _IMGFiles_highres,
        useCustomJSONFormat: config.useCustomJSONFormat,
        JSONPageDataFormat: config.JSONPageDataFormat,
        JSONDataType: _JSONDataType,
        Scale: (config.Scale != null) ? config.Scale : 0.8,
        ZoomTransition: (config.ZoomTransition != null) ? config.ZoomTransition : 'easeOut',
        ZoomTime: (config.ZoomTime != null) ? config.ZoomTime : 0.5,
        ZoomInterval: (config.ZoomInterval) ? config.ZoomInterval : 0.1,
        FitPageOnLoad: (config.FitPageOnLoad != null) ? config.FitPageOnLoad : false,
        FitWidthOnLoad: (config.FitWidthOnLoad != null) ? config.FitWidthOnLoad : false,
        FullScreenAsMaxWindow: (config.FullScreenAsMaxWindow != null) ? config.FullScreenAsMaxWindow : false,
        ProgressiveLoading: (config.ProgressiveLoading != null) ? config.ProgressiveLoading : false,
        MinZoomSize: (config.MinZoomSize != null) ? config.MinZoomSize : 0.2,
        MaxZoomSize: (config.MaxZoomSize != null) ? config.MaxZoomSize : 5,
        SearchMatchAll: (config.SearchMatchAll != null) ? config.SearchMatchAll : false,
        SearchServiceUrl: config.SearchServiceUrl,
        InitViewMode: config.InitViewMode,
        BitmapBasedRendering: (config.BitmapBasedRendering != null) ? config.BitmapBasedRendering : false,
        StartAtPage: (config.StartAtPage != null && config.StartAtPage.toString().length > 0 && !isNaN(config.StartAtPage)) ? config.StartAtPage : 1,
        PrintPaperAsBitmap: (config.PrintPaperAsBitmap != null) ? config.PrintPaperAsBitmap : ((browser.safari) ? true : false),
        AutoAdjustPrintSize: (config.AutoAdjustPrintSize != null) ? config.AutoAdjustPrintSize : true,

        EnableCornerDragging: ((config.EnableCornerDragging != null) ? config.EnableCornerDragging : true), // FlexPaper Zine parameter
        BackgroundColor: config.BackgroundColor, // FlexPaper Zine parameter
        PanelColor: config.PanelColor, // FlexPaper Zine parameter
        BackgroundAlpha: config.BackgroundAlpha, // FlexPaper Zine parameter
        UIConfig: config.UIConfig, // FlexPaper Zine parameter

        PrintToolsVisible: ((config.PrintToolsVisible != null) ? config.PrintToolsVisible : false),
        ViewModeToolsVisible: ((config.ViewModeToolsVisible != null) ? config.ViewModeToolsVisible : true),
        ZoomToolsVisible: ((config.ZoomToolsVisible != null) ? config.ZoomToolsVisible : true),
        NavToolsVisible: ((config.NavToolsVisible != null) ? config.NavToolsVisible : true),
        CursorToolsVisible: ((config.SearchToolsVisible != null) ? config.CursorToolsVisible : true),
        SearchToolsVisible: ((config.SearchToolsVisible != null) ? config.SearchToolsVisible : true),
        AnnotationToolsVisible: ((config.AnnotationToolsVisible != null) ? config.AnnotationToolsVisible : true), // Annotations viewer parameter

        StickyTools: config.StickyTools,
        Toolbar: config.Toolbar,
        BottomToolbar: config.BottomToolbar,
        DocSizeQueryService: config.DocSizeQueryService,

        RenderingOrder: config.RenderingOrder,

        localeChain: (config.localeChain != null) ? config.localeChain : "en_US",
        jsDirectory: _jsDirectory,
        cssDirectory: _cssDirectory,
        localeDirectory: _localeDirectory,
        key: config.key
    });
};

function detectjsdir() {
    if (jQuery('script[src$="flexpaper.js"]').length > 0) {
        return jQuery('script[src$="flexpaper.js"]').attr('src').replace('flexpaper.js', '');
    } else {
        return "js/"
    }
}

function detectcssdir() {
    if (jQuery('script[src$="flexpaper.css"]').length > 0) {
        return jQuery('link[href="flexpaper.css"]').href('src').replace('flexpaper.css', '');
    } else {
        return "css/"
    }
}

function translateUrlByDocument(url, document) {
    return (url != null && url.indexOf('{doc}') > 0 ? url.replace("{doc}", document) : null);
}

function translateUrlByFormat(url, format) {
    if (url.indexOf("{") == 0 && format != "swf") { // loading in split file mode
        url = url.substring(1, url.lastIndexOf(","));

        if (format != "pdf") {
            url = url.replace("[*,0]", "{page}")
        }
    }

    if (format == "jpgpageslice") {
        url = url + "§or={sector}";
    }

    return (url != null && url.indexOf('{format}') > 0 ? url.replace("{format}", format) : null);
}

/**
 *
 * FlexPaper embedding functionality. Based on FlashEmbed
 *
 */

(function() {

    var IE = document.all,
        URL = 'http://www.adobe.com/go/getflashplayer',
        JQUERY = typeof jQuery == 'function',
        RE = /(\d+)[^\d]+(\d+)[^\d]*(\d*)/,
        MOBILE = (function() {
            try {
                return 'ontouchstart' in document.documentElement;
            } catch (e) {
                return false;
            }
        })(),
        GLOBAL_OPTS = {
            // very common opts
            width: '100%',
            height: '100%',
            id: "_" + ("" + Math.random()).slice(9),

            // flashembed defaults
            allowfullscreen: true,
            allowscriptaccess: 'always',
            quality: 'high',
            allowFullScreenInteractive: true,

            // flashembed specific options
            version: [10, 0],
            onFail: null,
            expressInstall: null,
            w3c: false,
            cachebusting: false
        };

    window.isTouchScreen = MOBILE;

    if (window.attachEvent) {
        window.attachEvent("onbeforeunload", function() {
            __flash_unloadHandler = function() {};
            __flash_savedUnloadHandler = function() {};
        });
    }

    // simple extend
    function extend(to, from) {
        if (from) {
            for (var key in from) {
                if (from.hasOwnProperty(key)) {
                    to[key] = from[key];
                }
            }
        }
        return to;
    }

    // used by Flash to dispatch a event properly
    window.dispatchJQueryEvent = function(elementId, eventName, args) {
        jQuery('#' + elementId).trigger(eventName, args);
    }

    // used by asString method
    function map(arr, func) {
        var newArr = [];
        for (var i in arr) {
            if (arr.hasOwnProperty(i)) {
                newArr[i] = func(arr[i]);
            }
        }
        return newArr;
    }

    window.flashembed = function(root, opts, conf) {
        // root must be found / loaded
        if (typeof root == 'string') {
            root = document.getElementById(root.replace("#", ""));
        }

        // not found
        if (!root) {
            return;
        }

        root.onclick = function() {
            return false;
        }

        if (typeof opts == 'string') {
            opts = {
                src: opts
            };
        }

        return new Flash(root, extend(extend({}, GLOBAL_OPTS), opts), conf);
    };

    // flashembed "static" API
    var f = extend(window.flashembed, {

        conf: GLOBAL_OPTS,

        getVersion: function() {
            var fo, ver;

            try {
                ver = navigator.plugins["Shockwave Flash"].description.slice(16);
            } catch (e) {

                try {
                    fo = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");
                    ver = fo && fo.GetVariable("$version");

                } catch (err) {
                    try {
                        fo = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.6");
                        ver = fo && fo.GetVariable("$version");
                    } catch (err2) {}
                }
            }

            ver = RE.exec(ver);
            return ver ? [ver[1], ver[3]] : [0, 0];
        },

        asString: function(obj) {

            if (obj === null || obj === undefined) {
                return null;
            }
            var type = typeof obj;
            if (type == 'object' && obj.push) {
                type = 'array';
            }

            switch (type) {

                case 'string':
                    obj = obj.replace(new RegExp('(["\\\\])', 'g'), '\\$1');

                    // flash does not handle %- characters well. transforms "50%" to "50pct" (a dirty hack, I admit)
                    obj = obj.replace(/^\s?(\d+\.?\d+)%/, "$1pct");
                    return '"' + obj + '"';

                case 'array':
                    return '[' + map(obj, function(el) {
                        return f.asString(el);
                    }).join(',') + ']';

                case 'function':
                    return '"function()"';

                case 'object':
                    var str = [];
                    for (var prop in obj) {
                        if (obj.hasOwnProperty(prop)) {
                            str.push('"' + prop + '":' + f.asString(obj[prop]));
                        }
                    }
                    return '{' + str.join(',') + '}';
            }

            // replace ' --> "  and remove spaces
            return String(obj).replace(/\s/g, " ").replace(/\'/g, "\"");
        },

        getHTML: function(opts, conf) {

            opts = extend({}, opts);
            opts.id = opts.id + (" " + Math.random()).slice(9);

            /******* OBJECT tag and it's attributes *******/
            var html = '<object width="' + opts.width + '" height="' + opts.height + '" id="' + opts.id + '" name="' + opts.id + '"';

            if (opts.cachebusting) {
                opts.src += ((opts.src.indexOf("?") != -1 ? "&" : "?") + Math.random());
            }

            if (opts.w3c || !IE) {
                html += ' data="' + opts.src + '" type="application/x-shockwave-flash"';
            } else {
                html += ' classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"';
            }

            html += '>';

            /******* nested PARAM tags *******/
            if (opts.w3c || IE) {
                html += '<param name="movie" value="' + opts.src + '" />';
            }

            // not allowed params
            opts.width = opts.height = opts.id = opts.w3c = opts.src = null;
            opts.onFail = opts.version = opts.expressInstall = null;

            for (var key in opts) {
                if (opts[key]) {
                    html += '<param name="' + key + '" value="' + opts[key] + '" />';
                }
            }

            /******* FLASHVARS *******/
            var vars = "";

            if (conf) {
                for (var k in conf) {
                    if ((typeof conf[k] != "undefined") && (typeof conf[k] != "unknown") && k != 'Toolbar' && k != 'BottomToolbar') {
                        var val = conf[k];
                        if (k == "JSONFile") {
                            val = escape(val);
                        }
                        vars += k + '=' + (/function|object/.test(typeof val) ? f.asString(val) : val) + '&';
                    }
                }
                vars = vars.slice(0, - 1);
                html += '<param name="flashvars" value=\'' + vars + '\' />';
            }

            html += "</object>";

            return html;
        },

        isSupported: function(ver) {
            return VERSION[0] > ver[0] || VERSION[0] == ver[0] && VERSION[1] >= ver[1];
        }

    });

    var VERSION = f.getVersion();

    function Flash(root, opts, conf) {
        var browser = window["eb.browser"];
        var platform = window["eb.platform"];

        var supportsHTML4 = (browser.mozilla && browser.version.split(".")[0] >= 3) || (browser.chrome) || (browser.msie && browser.version.split(".")[0] >= 8) || (browser.safari) || (browser.opera);

        // Default to a rendering mode if its not set
        if (!conf.RenderingOrder && conf.SwfFile != null) {
            conf.RenderingOrder = "flash";
        }
        if (!conf.RenderingOrder && conf.JSONFile != null && conf.JSONFile) {
            conf.RenderingOrder = "html";
        }
        if (!conf.RenderingOrder && conf.PdfFile != null) {
            conf.RenderingOrder = "html5";
        }

        // version is ok
        if ((conf.RenderingOrder.indexOf('flash') == 0 || (conf.RenderingOrder.indexOf('flash') > 0 && !supportsHTML4)) && f.isSupported(opts.version)) {
            if (conf.Toolbar) {
                var wrapper = jQuery(root).wrap("<div style='" + jQuery(root).attr('style') + "'></div>").parent();
                jQuery(root).css({
                    left: '0px',
                    top: '0px',
                    position: 'relative',
                    width: '100%',
                    height: '100%'
                }).addClass('flexpaper_viewer');

                wrapper.prepend(jQuery(conf.Toolbar));
            }

            window['ViewerMode'] = 'flash';
            root.innerHTML = f.getHTML(opts, conf);

            if (conf.BottomToolbar && conf.AnnotationToolsVisible != false) {
                jQuery.get(conf.BottomToolbar, function(toolbarData) {
                    wrapper.append(toolbarData);
                });
            }

            if (conf.Toolbar) {
                // initialize event handlers for flash
                jQuery.getScript(conf.jsDirectory + 'flexpaper_flashhandlers_htmlui.js', function() {
                    FLEXPAPER.bindFlashEventHandlers(root);
                });
            }

            // express install
        } else if ((conf.RenderingOrder.indexOf('flash') == 0) && opts.expressInstall && f.isSupported([6, 65])) {
            window['ViewerMode'] = 'flash';

            if (conf.Toolbar) {
                var wrapper = jQuery(root).wrap("<div style='" + jQuery(root).attr('style') + "'></div>").parent();
                jQuery(root).css({
                    left: '0px',
                    top: '0px',
                    position: 'relative',
                    width: '100%',
                    height: '100%'
                }).addClass('flexpaper_viewer');

                wrapper.prepend(jQuery(conf.Toolbar));
            }

            root.innerHTML = f.getHTML(extend(opts, {
                src: opts.expressInstall
            }), {
                MMredirectURL: location.href,
                MMplayerType: 'PlugIn',
                MMdoctitle: document.title
            });

            if (conf.BottomToolbar && conf.AnnotationToolsVisible != false) {
                jQuery.get(conf.BottomToolbar, function(toolbarData) {
                    wrapper.append(toolbarData);
                });
            }

            if (conf.Toolbar) {
                // initialize event handlers for flash
                jQuery.getScript(conf.jsDirectory + 'flexpaper_flashhandlers_htmlui.js', function() {
                    FLEXPAPER.bindFlashEventHandlers(root);
                });
            }

        } else { //use html viewer or die
            window['ViewerMode'] = 'html';
            //jQuery.noConflict();
            if (true) {
                jQuery(document).ready(function() {
                    if (conf.Toolbar) {
                        jQuery.fn.showFullScreen = function() {
                            $FlexPaper(jQuery(this).attr('id')).openFullScreen();
                        }
                    }

                    jQuery.getScript(conf.jsDirectory + 'FlexPaperViewer.js', function() {
                        var viewerId = jQuery(root).attr('id');
                        var supportsPDFJS = (browser.mozilla && browser.version.split(".")[0] >= 4) || (browser.chrome && browser.version.split(".") >= 535) || (browser.msie && browser.version.split(".")[0] >= 10) || (browser.safari && browser.version.split(".")[0] >= 534 && !platform.ios);

                        // If rendering order isnt set but the formats are supplied then assume the rendering order.
                        if (!conf.RenderingOrder) {
                            conf.RenderingOrder = "";
                            if (conf.PdfFile != null) {
                                conf.RenderingOrder = "html5";
                            }
                            if (conf.SwfFile != null) {
                                conf.RenderingOrder += (conf.RenderingOrder.length > 0 ? "," : "") + "flash"
                            }
                            if (conf.JSONFile != null) {
                                conf.RenderingOrder += (conf.RenderingOrder.length > 0 ? "," : "") + "html"
                            }
                        }

                        var oRenderingList = conf.RenderingOrder.split(",");
                        var pageRenderer = null;

                        // if PDFJS isn't supported and the html formats are supplied, then use these as primary format
                        if (oRenderingList && oRenderingList.length == 1 && conf.JSONFile != null && conf.JSONFile.length > 0 && conf.IMGFiles != null && conf.IMGFiles.length > 0 && !supportsPDFJS) {
                            oRenderingList[1] = conf.RenderingOrder[0];
                            oRenderingList[0] = 'html';
                        }

                        if (conf.PdfFile != null && conf.PdfFile.length > 0 && conf.RenderingOrder.split(",").length >= 1 && supportsPDFJS && (oRenderingList[0] == 'html5' || (oRenderingList.length > 1 && oRenderingList[0] == 'flash' && oRenderingList[1] == 'html5')) && !(platform.touchdevice && oRenderingList.length > 1 && oRenderingList[1] == 'html')) {
                            pageRenderer = new CanvasPageRenderer(viewerId, conf.PdfFile, conf.jsDirectory, {
                                jsonfile: conf.JSONFile,
                                pageImagePattern: conf.IMGFiles,
                                pageThumbImagePattern: conf.ThumbIMGFiles,
                                compressedJSONFormat: !conf.useCustomJSONFormat,
                                JSONPageDataFormat: conf.JSONPageDataFormat,
                                JSONDataType: conf.JSONDataType
                            });
                        } else {
                            pageRenderer = new ImagePageRenderer(
                                viewerId, {
                                    jsonfile: conf.JSONFile,
                                    pageImagePattern: conf.IMGFiles,
                                    pageThumbImagePattern: conf.ThumbIMGFiles,
                                    pageHighResImagePattern: conf.HighResIMGFiles,
                                    pageSVGImagePattern: conf.SVGFiles,
                                    compressedJSONFormat: !conf.useCustomJSONFormat,
                                    JSONPageDataFormat: conf.JSONPageDataFormat,
                                    JSONDataType: conf.JSONDataType,
                                    SVGMode: conf.RenderingOrder.toLowerCase().indexOf('svg') >= 0
                                },
                                conf.jsDirectory);
                        }

                        var instance = "FlexPaperViewer_Instance" + ((viewerId === "undefined") ? "" : viewerId);
                        window[instance] = new FlexPaperViewer_HTML({
                            rootid: viewerId,
                            Toolbar: ((conf.Toolbar != null) ? conf.Toolbar : null),
                            BottomToolbar: ((conf.BottomToolbar != null) ? conf.BottomToolbar : null),
                            instanceid: instance,
                            document: {
                                SWFFile: conf.SwfFile,
                                IMGFiles: conf.IMGFiles,
                                ThumbIMGFiles: conf.ThumbIMGFiles,
                                JSONFile: conf.JSONFile,
                                PDFFile: conf.PdfFile,
                                Scale: conf.Scale,
                                FitPageOnLoad: conf.FitPageOnLoad,
                                FitWidthOnLoad: conf.FitWidthOnLoad,
                                MinZoomSize: conf.MinZoomSize,
                                MaxZoomSize: conf.MaxZoomSize,
                                SearchMatchAll: conf.SearchMatchAll,
                                InitViewMode: conf.InitViewMode,
                                StartAtPage: conf.StartAtPage,
                                RenderingOrder: conf.RenderingOrder,
                                useCustomJSONFormat: conf.useCustomJSONFormat,
                                JSONPageDataFormat: conf.JSONPageDataFormat,
                                JSONDataType: conf.JSONDataType,
                                ZoomInterval: conf.ZoomInterval,
                                PrintToolsVisible: conf.PrintToolsVisible,
                                ViewModeToolsVisible: conf.ViewModeToolsVisible,
                                ZoomToolsVisible: conf.ZoomToolsVisible,
                                NavToolsVisible: conf.NavToolsVisible,
                                CursorToolsVisible: conf.CursorToolsVisible,
                                SearchToolsVisible: conf.SearchToolsVisible,
                                AnnotationToolsVisible: conf.AnnotationToolsVisible,
                                StickyTools: conf.StickyTools,
                                PrintPaperAsBitmap: conf.PrintPaperAsBitmap,
                                AutoAdjustPrintSize: conf.AutoAdjustPrintSize,
                                EnableCornerDragging: conf.EnableCornerDragging,
                                UIConfig: conf.UIConfig,
                                BackgroundColor: conf.BackgroundColor, // FlexPaper Zine parameter
                                PanelColor: conf.PanelColor, // FlexPaper Zine parameter

                                localeChain: conf.localeChain
                            },
                            renderer: pageRenderer,
                            key: conf.key,
                            jsDirectory: conf.jsDirectory,
                            localeDirectory: conf.localeDirectory,
                            cssDirectory: conf.cssDirectory,
                            docSizeQueryService: conf.DocSizeQueryService
                        });

                        window[instance].initialize();
                        window[instance].bindEvents();

                        window[instance]['load'] = window[instance].loadFromUrl;
                        window[instance]['loadDoc'] = window[instance].loadDoc;
                        window[instance]['fitWidth'] = window[instance].fitwidth;
                        window[instance]['fitHeight'] = window[instance].fitheight;
                        window[instance]['gotoPage'] = window[instance].gotoPage;
                        window[instance]['getCurrPage'] = window[instance].getCurrPage;
                        window[instance]['getTotalPages'] = window[instance].getTotalPages;
                        window[instance]['nextPage'] = window[instance].next;
                        window[instance]['prevPage'] = window[instance].previous;
                        window[instance]['setZoom'] = window[instance].Zoom;
                        window[instance]['Zoom'] = window[instance].Zoom;
                        window[instance]['openFullScreen'] = window[instance].openFullScreen;
                        window[instance]['sliderChange'] = window[instance].sliderChange;
                        window[instance]['searchText'] = window[instance].searchText;
                        window[instance]['resize'] = window[instance].resize;
                        window[instance]['rotate'] = window[instance].rotate;
                        //window[instance]['nextSearchMatch'] = window[instance].nextSearchMatch; //TBD
                        //window[instance]['prevSearchMatch'] = window[instance].nextSearchMatch; //TBD
                        window[instance]['switchMode'] = window[instance].switchMode;
                        window[instance]['printPaper'] = window[instance].printPaper;
                        //window[instance]['highlight'] = window[instance].highlight; //TBD
                        //window[instance]['postSnapshot'] = window[instance].postSnapshot; //TBD
                        window[instance]['setCurrentCursor'] = window[instance].setCurrentCursor;
                        window[instance]['showFullScreen'] = window[instance].openFullScreen;

                        pageRenderer.initialize(function() {
                            //console.profile('FlexPaper init-postinit');
                            window[instance].document.numPages = pageRenderer.getNumPages();
                            window[instance].document.dimensions = pageRenderer.getDimensions();
                            window[instance].show();

                            jQuery(root).trigger('onDocumentLoaded', pageRenderer.getNumPages());
                        });
                    });
                });
            } else {
                // fail #2.1 custom content inside container
                if (!root.innerHTML.replace(/\s/g, '')) {
                    var pageHost = ((document.location.protocol == "https:") ? "https://" : "http://");

                    root.innerHTML = "<h2>Your browser is not compatible with FlexPaper</h2>" + "<h3>Upgrade to a newer browser or download Adobe Flash Player 10 or higher.</h3>" + "<p>Click on the icon below to download the latest version of Adobe Flash" + "<a href='http://www.adobe.com/go/getflashplayer'><img src='" + pageHost + "www.adobe.com/images/shared/download_buttons/get_flash_player.gif' alt='Get Adobe Flash player' /></a>";

                    if (root.tagName == 'A') {
                        root.onclick = function() {
                            location.href = URL;
                        };
                    }
                }

                // onFail
                if (opts.onFail) {
                    var ret = opts.onFail.call(this);
                    if (typeof ret == 'string') {
                        root.innerHTML = ret;
                    }
                }
            }
        }

        // http://flowplayer.org/forum/8/18186#post-18593
        if (IE) {
            window[opts.id] = document.getElementById(opts.id);
        }

        // API methods for callback
        extend(this, {

            getRoot: function() {
                return root;
            },

            getOptions: function() {
                return opts;
            },


            getConf: function() {
                return conf;
            },

            getApi: function() {
                return root.firstChild;
            }

        });
    }

    // setup jquery support
    if (JQUERY) {
        jQuery.fn.flashembed = function(opts, conf) {
            return this.each(function() {
                jQuery(this).data("flashembed", flashembed(this, opts, conf));
            });
        };

        jQuery.fn.FlexPaperViewer = function(args) {
            var embed = new FlexPaperViewerEmbedding(this.attr('id'), args);
            this.element = jQuery('#' + embed.id);
            return this.element;
        };
    } else {
        throw new Error("jQuery missing!");
    }
})();

function getIEversion()
// Returns the version of Internet Explorer or a -1
// (indicating the use of another browser).
{
    var rv = -1; // Return value assumes failure.
    if (navigator.appName == 'Microsoft Internet Explorer') {
        var ua = navigator.userAgent;
        var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null) rv = parseFloat(RegExp.$1);
    }
    return rv;
}


window.unsupportedPDFJSieversion = getIEversion() > 0 && getIEversion() < 9;
// Checking if the typed arrays are supported
(function checkTypedArrayCompatibility() {
    if (typeof Uint8Array !== 'undefined') {
        // some mobile versions do not support subarray (e.g. safari 5 / iOS)
        if (typeof Uint8Array.prototype.subarray === 'undefined') {
            Uint8Array.prototype.subarray = function subarray(start, end) {
                return new Uint8Array(this.slice(start, end));
            };
            Float32Array.prototype.subarray = function subarray(start, end) {
                return new Float32Array(this.slice(start, end));
            };
        }

        // some mobile version might not support Float64Array
        if (typeof Float64Array === 'undefined') window.Float64Array = Float32Array;

        return;
    }

    function subarray(start, end) {
        return new TypedArray(this.slice(start, end));
    }

    function setArrayOffset(array, offset) {
        if (arguments.length < 2) offset = 0;
        for (var i = 0, n = array.length; i < n; ++i, ++offset)
            this[offset] = array[i] & 0xFF;
    }

    function TypedArray(arg1) {
        var result;
        if (typeof arg1 === 'number') {
            result = [];
            for (var i = 0; i < arg1; ++i)
                result[i] = 0;
        } else if ('slice' in arg1) {
            result = arg1.slice(0);
        } else {
            result = [];
            for (var i = 0, n = arg1.length; i < n; ++i) {
                result[i] = arg1[i];
            }
        }

        result.subarray = subarray;
        result.buffer = result;
        result.byteLength = result.length;
        result.set = setArrayOffset;

        if (typeof arg1 === 'object' && arg1.buffer) result.buffer = arg1.buffer;

        return result;
    }

    window.Uint8Array = TypedArray;

    // we don't need support for set, byteLength for 32-bit array
    // so we can use the TypedArray as well
    window.Uint32Array = TypedArray;
    window.Int32Array = TypedArray;
    window.Uint16Array = TypedArray;
    window.Float32Array = TypedArray;
    window.Float64Array = TypedArray;
})();

// Object.create() ?
(function checkObjectCreateCompatibility() {
    if (typeof Object.create !== 'undefined') return;

    Object.create = function objectCreate(proto) {
        function Constructor() {}
        Constructor.prototype = proto;
        return new Constructor();
    };
})();

// Object.defineProperty() ?
(function checkObjectDefinePropertyCompatibility() {
    if (typeof Object.defineProperty !== 'undefined') {
        var definePropertyPossible = true;
        try {
            // some browsers (e.g. safari) cannot use defineProperty() on DOM objects
            // and thus the native version is not sufficient
            Object.defineProperty(new Image(), 'id', {
                value: 'test'
            });
            // ... another test for android gb browser for non-DOM objects
            eval("var Test = function Test() {};Test.prototype = { get id() { } };Object.defineProperty(new Test(), 'id',{ value: '', configurable: true, enumerable: true, writable: false });");
        } catch (e) {
            definePropertyPossible = false;
        }
        if (definePropertyPossible) return;
    }

    Object.defineProperty = function objectDefineProperty(obj, name, def) {
        if (window.unsupportedPDFJSieversion) {
            return;
        }
        delete obj[name];
        if ('get' in def) obj.__defineGetter__(name, def['get']);
        if ('set' in def) obj.__defineSetter__(name, def['set']);
        if ('value' in def) {
            obj.__defineSetter__(name, function objectDefinePropertySetter(value) {
                this.__defineGetter__(name, function objectDefinePropertyGetter() {
                    return value;
                });
                return value;
            });
            obj[name] = def.value;
        }
    };
})();

// Object.keys() ?
(function checkObjectKeysCompatibility() {
    if (typeof Object.keys !== 'undefined') return;

    Object.keys = function objectKeys(obj) {
        var result = [];
        for (var i in obj) {
            if (obj.hasOwnProperty(i)) result.push(i);
        }
        return result;
    };
})();

// No readAsArrayBuffer ?
(function checkFileReaderReadAsArrayBuffer() {
    if (typeof FileReader === 'undefined') return; // FileReader is not implemented
    var frPrototype = FileReader.prototype;
    // Older versions of Firefox might not have readAsArrayBuffer
    if ('readAsArrayBuffer' in frPrototype) return; // readAsArrayBuffer is implemented
    Object.defineProperty(frPrototype, 'readAsArrayBuffer', {
        value: function fileReaderReadAsArrayBuffer(blob) {
            var fileReader = new FileReader();
            var originalReader = this;
            fileReader.onload = function fileReaderOnload(evt) {
                var data = evt.target.result;
                var buffer = new ArrayBuffer(data.length);
                var uint8Array = new Uint8Array(buffer);

                for (var i = 0, ii = data.length; i < ii; i++)
                    uint8Array[i] = data.charCodeAt(i);

                Object.defineProperty(originalReader, 'result', {
                    value: buffer,
                    enumerable: true,
                    writable: false,
                    configurable: true
                });

                var event = document.createEvent('HTMLEvents');
                event.initEvent('load', false, false);
                originalReader.dispatchEvent(event);
            };
            fileReader.readAsBinaryString(blob);
        }
    });
})();

// No XMLHttpRequest.response ?
(function checkXMLHttpRequestResponseCompatibility() {
    var xhrPrototype = XMLHttpRequest.prototype;
    if (!('overrideMimeType' in xhrPrototype)) {
        // IE10 might have response, but not overrideMimeType
        Object.defineProperty(xhrPrototype, 'overrideMimeType', {
            value: function xmlHttpRequestOverrideMimeType(mimeType) {}
        });
    }
    if ('response' in xhrPrototype || 'mozResponseArrayBuffer' in xhrPrototype || 'mozResponse' in xhrPrototype || 'responseArrayBuffer' in xhrPrototype) return;
    // IE9 ?
    if (typeof VBArray !== 'undefined') {
        Object.defineProperty(xhrPrototype, 'response', {
            get: function xmlHttpRequestResponseGet() {
                return new Uint8Array(new VBArray(this.responseBody).toArray());
            }
        });
        return;
    }

    // other browsers
    function responseTypeSetter() {
        // will be only called to set "arraybuffer"
        this.overrideMimeType('text/plain; charset=x-user-defined');
    }
    if (typeof xhrPrototype.overrideMimeType === 'function') {
        Object.defineProperty(xhrPrototype, 'responseType', {
            set: responseTypeSetter
        });
    }

    function responseGetter() {
        var text = this.responseText;
        var i, n = text.length;
        var result = new Uint8Array(n);
        for (i = 0; i < n; ++i)
            result[i] = text.charCodeAt(i) & 0xFF;
        return result;
    }
    Object.defineProperty(xhrPrototype, 'response', {
        get: responseGetter
    });
})();

// window.btoa (base64 encode function) ?
(function checkWindowBtoaCompatibility() {
    if ('btoa' in window) return;

    var digits = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

    window.btoa = function windowBtoa(chars) {
        var buffer = '';
        var i, n;
        for (i = 0, n = chars.length; i < n; i += 3) {
            var b1 = chars.charCodeAt(i) & 0xFF;
            var b2 = chars.charCodeAt(i + 1) & 0xFF;
            var b3 = chars.charCodeAt(i + 2) & 0xFF;
            var d1 = b1 >> 2,
                d2 = ((b1 & 3) << 4) | (b2 >> 4);
            var d3 = i + 1 < n ? ((b2 & 0xF) << 2) | (b3 >> 6) : 64;
            var d4 = i + 2 < n ? (b3 & 0x3F) : 64;
            buffer += (digits.charAt(d1) + digits.charAt(d2) + digits.charAt(d3) + digits.charAt(d4));
        }
        return buffer;
    };
})();

// Function.prototype.bind ?
(function checkFunctionPrototypeBindCompatibility() {
    if (typeof Function.prototype.bind !== 'undefined') return;

    Function.prototype.bind = function functionPrototypeBind(obj) {
        var fn = this,
            headArgs = Array.prototype.slice.call(arguments, 1);
        var bound = function functionPrototypeBindBound() {
            var args = Array.prototype.concat.apply(headArgs, arguments);
            return fn.apply(obj, args);
        };
        return bound;
    };
})();

// IE9/10 text/html data URI
(function checkDataURICompatibility() {
    if (!('documentMode' in document) || document.documentMode !== 9 && document.documentMode !== 10) return;
    // overriding the src property
    var originalSrcDescriptor = Object.getOwnPropertyDescriptor(
        HTMLIFrameElement.prototype, 'src');
    Object.defineProperty(HTMLIFrameElement.prototype, 'src', {
        get: function htmlIFrameElementPrototypeSrcGet() {
            return this.$src;
        },
        set: function htmlIFrameElementPrototypeSrcSet(src) {
            this.$src = src;
            if (src.substr(0, 14) != 'data:text/html') {
                originalSrcDescriptor.set.call(this, src);
                return;
            }
            // for text/html, using blank document and then
            // document's open, write, and close operations
            originalSrcDescriptor.set.call(this, 'about:blank');
            setTimeout((function htmlIFrameElementPrototypeSrcOpenWriteClose() {
                var doc = this.contentDocument;
                doc.open('text/html');
                doc.write(src.substr(src.indexOf(',') + 1));
                doc.close();
            }).bind(this), 0);
        },
        enumerable: true
    });
})();

// HTMLElement dataset property
(function checkDatasetProperty() {
    if (window.unsupportedPDFJSieversion) {
        return;
    }
    var div = document.createElement('div');
    if ('dataset' in div) return; // dataset property exists

    Object.defineProperty(HTMLElement.prototype, 'dataset', {
        get: function() {
            if (this._dataset) return this._dataset;

            var dataset = {};
            for (var j = 0, jj = this.attributes.length; j < jj; j++) {
                var attribute = this.attributes[j];
                if (attribute.name.substring(0, 5) != 'data-') continue;
                var key = attribute.name.substring(5).replace(/\-([a-z])/g,

                    function(all, ch) {
                        return ch.toUpperCase();
                    });
                dataset[key] = attribute.value;
            }

            Object.defineProperty(this, '_dataset', {
                value: dataset,
                writable: false,
                enumerable: false
            });
            return dataset;
        },
        enumerable: true
    });
})();

// HTMLElement classList property
(function checkClassListProperty() {
    if (window.unsupportedPDFJSieversion) {
        return;
    }
    var div = document.createElement('div');
    if ('classList' in div) return; // classList property exists

    function changeList(element, itemName, add, remove) {
        var s = element.className || '';
        var list = s.split(/\s+/g);
        if (list[0] === '') list.shift();
        var index = list.indexOf(itemName);
        if (index < 0 && add) list.push(itemName);
        if (index >= 0 && remove) list.splice(index, 1);
        element.className = list.join(' ');
    }

    var classListPrototype = {
        add: function(name) {
            changeList(this.element, name, true, false);
        },
        remove: function(name) {
            changeList(this.element, name, false, true);
        },
        toggle: function(name) {
            changeList(this.element, name, true, true);
        }
    };

    Object.defineProperty(HTMLElement.prototype, 'classList', {
        get: function() {
            if (this._classList) return this._classList;

            var classList = Object.create(classListPrototype, {
                element: {
                    value: this,
                    writable: false,
                    enumerable: true
                }
            });
            Object.defineProperty(this, '_classList', {
                value: classList,
                writable: false,
                enumerable: false
            });
            return classList;
        },
        enumerable: true
    });
})();

// Check console compatability
(function checkConsoleCompatibility() {
    if (!('console' in window)) {
        window.console = {
            log: function() {},
            error: function() {}
        };
    } else {
        try {
            if (!('bind' in console.log)) {
                // native functions in IE9 might not have bind
                console.log = (function(fn) {
                    return function(msg) {
                        return fn(msg);
                    };
                })(console.log);
                console.error = (function(fn) {
                    return function(msg) {
                        return fn(msg);
                    };
                })(console.error);
            }
        } catch (e) {
        }
    }
})();

// Check onclick compatibility in Opera
(function checkOnClickCompatibility() {
    // workaround for reported Opera bug DSK-354448:
    // onclick fires on disabled buttons with opaque content
    function ignoreIfTargetDisabled(event) {
        if (isDisabled(event.target)) {
            event.stopPropagation();
        }
    }

    function isDisabled(node) {
        return node.disabled || (node.parentNode && isDisabled(node.parentNode));
    }
    if (navigator.userAgent.indexOf('Opera') != -1) {
        // use browser detection since we cannot feature-check this bug
        document.addEventListener('click', ignoreIfTargetDisabled, true);
    }
})();

// Checks if navigator.language is supported
(function checkNavigatorLanguage() {
    if (window.unsupportedPDFJSieversion) {
        return;
    }
    if ('language' in navigator) return;
    Object.defineProperty(navigator, 'language', {
        get: function navigatorLanguage() {
            var language = navigator.userLanguage || 'en-US';
            return language.substring(0, 2).toLowerCase() + language.substring(2).toUpperCase();
        },
        enumerable: true
    });
})();

// jquery.extensions
(function($){var $scrollTo=$.scrollTo=function(target,duration,settings){$(window).scrollTo(target,duration,settings)};$scrollTo.defaults={axis:"xy",duration:parseFloat($.fn.jquery)>=1.3?0:1};$scrollTo.window=function(scope){return $(window)._scrollable()};$.fn._scrollable=function(){return this.map(function(){var elem=this,isWin=!elem.nodeName||$.inArray(elem.nodeName.toLowerCase(),["iframe","#document","html","body"])!=-1;if(!isWin)return elem;var doc=(elem.contentWindow||elem).document||elem.ownerDocument||
    elem;return $.browser.safari||doc.compatMode=="BackCompat"?doc.body:doc.documentElement})};$.fn.scrollTo=function(target,duration,settings){if(typeof duration=="object"){settings=duration;duration=0}if(typeof settings=="function")settings={onAfter:settings};if(target=="max")target=9E9;settings=$.extend({},$scrollTo.defaults,settings);duration=duration||settings.speed||settings.duration;settings.queue=settings.queue&&settings.axis.length>1;if(settings.queue)duration/=2;settings.offset=both(settings.offset);
    settings.over=both(settings.over);return this._scrollable().each(function(){var elem=this,$elem=$(elem),targ=target,toff,attr={},win=$elem.is("html,body");switch(typeof targ){case "number":case "string":if(/^([+-]=)?\d+(\.\d+)?(px|%)?$/.test(targ)){targ=both(targ);break}targ=$(targ,this);case "object":if(targ.is||targ.style)toff=(targ=$(targ)).offset()}$.each(settings.axis.split(""),function(i,axis){var Pos=axis=="x"?"Left":"Top",pos=Pos.toLowerCase(),key="scroll"+Pos,old=elem[key],max=$scrollTo.max(elem,
        axis);if(toff){attr[key]=toff[pos]+(win?0:old-$elem.offset()[pos]);if(settings.margin){attr[key]-=parseInt(targ.css("margin"+Pos))||0;attr[key]-=parseInt(targ.css("border"+Pos+"Width"))||0}attr[key]+=settings.offset[pos]||0;if(settings.over[pos])attr[key]+=targ[axis=="x"?"width":"height"]()*settings.over[pos]}else{var val=targ[pos];if(val)attr[key]=val.slice&&val.slice(-1)=="%"?parseFloat(val)/100*max:val}if(/^\d+$/.test(attr[key]))attr[key]=attr[key]<=0?0:Math.min(attr[key],max);if(!i&&settings.queue){if(old!=
        attr[key])animate(settings.onAfterFirst);delete attr[key]}});animate(settings.onAfter);function animate(callback){$elem.animate(attr,duration,settings.easing,callback&&function(){callback.call(this,target,settings)})}}).end()};$scrollTo.max=function(elem,axis){var Dim=axis=="x"?"Width":"Height",scroll="scroll"+Dim;if(!$(elem).is("html,body"))return elem[scroll]-$(elem)[Dim.toLowerCase()]();var size="client"+Dim,html=elem.ownerDocument.documentElement,body=elem.ownerDocument.body;return Math.max(html[scroll],
    body[scroll])-Math.min(html[size],body[size])};function both(val){return typeof val=="object"?val:{top:val,left:val}}})(jQuery);
(function(factory){if(typeof define==="function"&&define.amd)define(["jquery"],factory);else factory(jQuery)})(function($){var d=[],doc=$(document),ua=navigator.userAgent.toLowerCase(),wndw=$(window),w=[];var browser={ieQuirks:null,msie:/msie/.test(ua)&&!/opera/.test(ua),opera:/opera/.test(ua)};browser.ie6=browser.msie&&/msie 6./.test(ua)&&typeof window["XMLHttpRequest"]!=="object";browser.ie7=browser.msie&&/msie 7.0/.test(ua);$.smodal=function(data,options){return $.smodal.impl.init(data,options)};
    $.smodal.close=function(){$.smodal.impl.close()};$.smodal.focus=function(pos){$.smodal.impl.focus(pos)};$.smodal.setContainerDimensions=function(){$.smodal.impl.setContainerDimensions()};$.smodal.setPosition=function(){$.smodal.impl.setPosition()};$.smodal.update=function(height,width){$.smodal.impl.update(height,width)};$.fn.smodal=function(options){return $.smodal.impl.init(this,options)};$.smodal.defaults={appendTo:"body",focus:true,opacity:50,overlayId:"simplemodal-overlay",overlayCss:{},containerId:"simplemodal-container",
        containerCss:{},dataId:"simplemodal-data",dataCss:{},minHeight:null,minWidth:null,maxHeight:null,maxWidth:null,autoResize:false,autoPosition:true,zIndex:1E3,close:true,closeHTML:'<a class="modalCloseImg" title="Close"></a>',closeClass:"simplemodal-close",escClose:true,overlayClose:false,fixed:true,position:null,persist:false,modal:true,onOpen:null,onShow:null,onClose:null};$.smodal.impl={d:{},init:function(data,options){var s=this;if(s.d.data)return false;browser.ieQuirks=browser.msie&&!$.support.boxModel;
        s.o=$.extend({},$.smodal.defaults,options);s.zIndex=s.o.zIndex;s.occb=false;if(typeof data==="object"){data=data instanceof $?data:$(data);s.d.placeholder=false;if(data.parent().parent().size()>0){data.before($("<span></span>").attr("id","simplemodal-placeholder").css({display:"none"}));s.d.placeholder=true;s.display=data.css("display");if(!s.o.persist)s.d.orig=data.clone(true)}}else if(typeof data==="string"||typeof data==="number")data=$("<div></div>").html(data);else{alert("SimpleModal Error: Unsupported data type: "+
            typeof data);return s}s.create(data);data=null;s.open();if($.isFunction(s.o.onShow))s.o.onShow.apply(s,[s.d]);return s},create:function(data){var s=this;s.getDimensions();if(s.o.modal&&browser.ie6)s.d.iframe=$('<iframe src="javascript:false;"></iframe>').css($.extend(s.o.iframeCss,{display:"none",opacity:0,position:"fixed",height:w[0],width:w[1],zIndex:s.o.zIndex,top:0,left:0})).appendTo(s.o.appendTo);s.d.overlay=$("<div></div>").attr("id",s.o.overlayId).addClass("simplemodal-overlay").css($.extend(s.o.overlayCss,
        {display:"none",opacity:s.o.opacity/100,height:s.o.modal?d[0]:0,width:s.o.modal?d[1]:0,position:"fixed",left:0,top:0,zIndex:s.o.zIndex+1})).appendTo(s.o.appendTo);s.d.container=$("<div></div>").attr("id",s.o.containerId).addClass("simplemodal-container").css($.extend({position:s.o.fixed?"fixed":"absolute"},s.o.containerCss,{display:"none",zIndex:s.o.zIndex+2})).append(s.o.close&&s.o.closeHTML?$(s.o.closeHTML).addClass(s.o.closeClass):"").appendTo(s.o.appendTo);s.d.wrap=$("<div></div>").attr("tabIndex",
        -1).addClass("simplemodal-wrap").css({height:"100%",outline:0,width:"100%"}).appendTo(s.d.container);s.d.data=data.attr("id",data.attr("id")||s.o.dataId).addClass("simplemodal-data").css($.extend(s.o.dataCss,{display:"none"})).appendTo("body");data=null;s.setContainerDimensions();s.d.data.appendTo(s.d.wrap);if(browser.ie6||browser.ieQuirks)s.fixIE()},bindEvents:function(){var s=this;$("."+s.o.closeClass).bind("click.simplemodal",function(e){e.preventDefault();s.close()});if(s.o.modal&&s.o.close&&
        s.o.overlayClose)s.d.overlay.bind("click.simplemodal",function(e){e.preventDefault();s.close()});doc.bind("keydown.simplemodal",function(e){if(s.o.modal&&e.keyCode===9)s.watchTab(e);else if(s.o.close&&s.o.escClose&&e.keyCode===27){e.preventDefault();s.close()}});wndw.bind("resize.simplemodal orientationchange.simplemodal",function(){s.getDimensions();s.o.autoResize?s.setContainerDimensions():s.o.autoPosition&&s.setPosition();if(browser.ie6||browser.ieQuirks)s.fixIE();else if(s.o.modal){s.d.iframe&&
    s.d.iframe.css({height:w[0],width:w[1]});s.d.overlay.css({height:d[0],width:d[1]})}})},unbindEvents:function(){$("."+this.o.closeClass).unbind("click.simplemodal");doc.unbind("keydown.simplemodal");wndw.unbind(".simplemodal");this.d.overlay.unbind("click.simplemodal")},fixIE:function(){var s=this,p=s.o.position;$.each([s.d.iframe||null,!s.o.modal?null:s.d.overlay,s.d.container.css("position")==="fixed"?s.d.container:null],function(i,el){if(el){var bch="document.body.clientHeight",bcw="document.body.clientWidth",
        bsh="document.body.scrollHeight",bsl="document.body.scrollLeft",bst="document.body.scrollTop",bsw="document.body.scrollWidth",ch="document.documentElement.clientHeight",cw="document.documentElement.clientWidth",sl="document.documentElement.scrollLeft",st="document.documentElement.scrollTop",s=el[0].style;s.position="absolute";if(i<2){s.removeExpression("height");s.removeExpression("width");s.setExpression("height",""+bsh+" > "+bch+" ? "+bsh+" : "+bch+' + "px"');s.setExpression("width",""+bsw+" > "+
        bcw+" ? "+bsw+" : "+bcw+' + "px"')}else{var te,le;if(p&&p.constructor===Array){var top=p[0]?typeof p[0]==="number"?p[0].toString():p[0].replace(/px/,""):el.css("top").replace(/px/,"");te=top.indexOf("%")===-1?top+" + (t = "+st+" ? "+st+" : "+bst+') + "px"':parseInt(top.replace(/%/,""))+" * (("+ch+" || "+bch+") / 100) + (t = "+st+" ? "+st+" : "+bst+') + "px"';if(p[1]){var left=typeof p[1]==="number"?p[1].toString():p[1].replace(/px/,"");le=left.indexOf("%")===-1?left+" + (t = "+sl+" ? "+sl+" : "+bsl+
        ') + "px"':parseInt(left.replace(/%/,""))+" * (("+cw+" || "+bcw+") / 100) + (t = "+sl+" ? "+sl+" : "+bsl+') + "px"'}}else{te="("+ch+" || "+bch+") / 2 - (this.offsetHeight / 2) + (t = "+st+" ? "+st+" : "+bst+') + "px"';le="("+cw+" || "+bcw+") / 2 - (this.offsetWidth / 2) + (t = "+sl+" ? "+sl+" : "+bsl+') + "px"'}s.removeExpression("top");s.removeExpression("left");s.setExpression("top",te);s.setExpression("left",le)}}})},focus:function(pos){var s=this,p=pos&&$.inArray(pos,["first","last"])!==-1?pos:
        "first";var input=$(":input:enabled:visible:"+p,s.d.wrap);setTimeout(function(){input.length>0?input.focus():s.d.wrap.focus()},10)},getDimensions:function(){var s=this,h=typeof window.innerHeight==="undefined"?wndw.height():window.innerHeight;d=[doc.height(),doc.width()];w=[h,wndw.width()]},getVal:function(v,d){return v?typeof v==="number"?v:v==="auto"?0:v.indexOf("%")>0?parseInt(v.replace(/%/,""))/100*(d==="h"?w[0]:w[1]):parseInt(v.replace(/px/,"")):null},update:function(height,width){var s=this;
        if(!s.d.data)return false;s.d.origHeight=s.getVal(height,"h");s.d.origWidth=s.getVal(width,"w");s.d.data.hide();height&&s.d.container.css("height",height);width&&s.d.container.css("width",width);s.setContainerDimensions();s.d.data.show();s.o.focus&&s.focus();s.unbindEvents();s.bindEvents()},setContainerDimensions:function(){var s=this,badIE=browser.ie6||browser.ie7;var ch=s.d.origHeight?s.d.origHeight:browser.opera?s.d.container.height():s.getVal(badIE?s.d.container[0].currentStyle["height"]:s.d.container.css("height"),
        "h"),cw=s.d.origWidth?s.d.origWidth:browser.opera?s.d.container.width():s.getVal(badIE?s.d.container[0].currentStyle["width"]:s.d.container.css("width"),"w"),dh=s.d.data.outerHeight(true),dw=s.d.data.outerWidth(true);s.d.origHeight=s.d.origHeight||ch;s.d.origWidth=s.d.origWidth||cw;var mxoh=s.o.maxHeight?s.getVal(s.o.maxHeight,"h"):null,mxow=s.o.maxWidth?s.getVal(s.o.maxWidth,"w"):null,mh=mxoh&&mxoh<w[0]?mxoh:w[0],mw=mxow&&mxow<w[1]?mxow:w[1];var moh=s.o.minHeight?s.getVal(s.o.minHeight,"h"):"auto";
        if(!ch)if(!dh)ch=moh;else if(dh>mh)ch=mh;else if(s.o.minHeight&&moh!=="auto"&&dh<moh)ch=moh;else ch=dh;else ch=s.o.autoResize&&ch>mh?mh:ch<moh?moh:ch;var mow=s.o.minWidth?s.getVal(s.o.minWidth,"w"):"auto";if(!cw)if(!dw)cw=mow;else if(dw>mw)cw=mw;else if(s.o.minWidth&&mow!=="auto"&&dw<mow)cw=mow;else cw=dw;else cw=s.o.autoResize&&cw>mw?mw:cw<mow?mow:cw;s.d.container.css({height:ch,width:cw});s.d.wrap.css({overflow:dh>ch||dw>cw?"auto":"visible"});s.o.autoPosition&&s.setPosition()},setPosition:function(){var s=
        this,top,left,hc=w[0]/2-s.d.container.outerHeight(true)/2,vc=w[1]/2-s.d.container.outerWidth(true)/2,st=s.d.container.css("position")!=="fixed"?wndw.scrollTop():0;if(s.o.position&&Object.prototype.toString.call(s.o.position)==="[object Array]"){top=st+(s.o.position[0]||hc);left=s.o.position[1]||vc}else{top=st+hc;left=vc}s.d.container.css({left:left,top:top})},watchTab:function(e){var s=this;if($(e.target).parents(".simplemodal-container").length>0){s.inputs=$(":input:enabled:visible:first, :input:enabled:visible:last",
        s.d.data[0]);if(!e.shiftKey&&e.target===s.inputs[s.inputs.length-1]||e.shiftKey&&e.target===s.inputs[0]||s.inputs.length===0){e.preventDefault();var pos=e.shiftKey?"last":"first";s.focus(pos)}}else{e.preventDefault();s.focus()}},open:function(){var s=this;s.d.iframe&&s.d.iframe.show();if($.isFunction(s.o.onOpen))s.o.onOpen.apply(s,[s.d]);else{s.d.overlay.show();s.d.container.show();s.d.data.show()}s.o.focus&&s.focus();s.bindEvents()},close:function(){var s=this;if(!s.d.data)return false;s.unbindEvents();
        if($.isFunction(s.o.onClose)&&!s.occb){s.occb=true;s.o.onClose.apply(s,[s.d])}else{if(s.d.placeholder){var ph=$("#simplemodal-placeholder");if(s.o.persist)ph.replaceWith(s.d.data.removeClass("simplemodal-data").css("display",s.display));else{s.d.data.hide().remove();ph.replaceWith(s.d.orig)}}else s.d.data.hide().remove();s.d.container.hide().remove();s.d.overlay.hide();s.d.iframe&&s.d.iframe.hide().remove();s.d.overlay.remove();s.d={}}}}});
(function(b,a,c){b.fn.jScrollPane=function(e){function d(D,O){var ay,Q=this,Y,aj,v,al,T,Z,y,q,az,aE,au,i,I,h,j,aa,U,ap,X,t,A,aq,af,am,G,l,at,ax,x,av,aH,f,L,ai=true,P=true,aG=false,k=false,ao=D.clone(false,false).empty(),ac=b.fn.mwheelIntent?"mwheelIntent.jsp":"mousewheel.jsp";aH=D.css("paddingTop")+" "+D.css("paddingRight")+" "+D.css("paddingBottom")+" "+D.css("paddingLeft");f=(parseInt(D.css("paddingLeft"),10)||0)+(parseInt(D.css("paddingRight"),10)||0);function ar(aQ){var aL,aN,aM,aJ,aI,aP,aO=false,aK=false;ay=aQ;if(Y===c){aI=D.scrollTop();aP=D.scrollLeft();D.css({overflow:"hidden",padding:0});aj=D.innerWidth()+f;v=D.innerHeight();D.width(aj);Y=b('<div class="jspPane" />').css("padding",aH).append(D.children());al=b('<div class="jspContainer" />').css({width:aj+"px",height:v+"px"}).append(Y).appendTo(D)}else{D.css("width","");aO=ay.stickToBottom&&K();aK=ay.stickToRight&&B();aJ=D.innerWidth()+f!=aj||D.outerHeight()!=v;if(aJ){aj=D.innerWidth()+f;v=D.innerHeight();al.css({width:aj+"px",height:v+"px"})}if(!aJ&&L==T&&Y.outerHeight()==Z){D.width(aj);return}L=T;Y.css("width","");D.width(aj);al.find(">.jspVerticalBar,>.jspHorizontalBar").remove().end()}Y.css("overflow","auto");if(aQ.contentWidth){T=aQ.contentWidth}else{T=Y[0].scrollWidth}Z=Y[0].scrollHeight;Y.css("overflow","");y=T/aj;q=Z/v;az=q>1;aE=y>1;if(!(aE||az)){D.removeClass("jspScrollable");Y.css({top:0,width:al.width()-f});n();E();R();w()}else{D.addClass("jspScrollable");aL=ay.maintainPosition&&(I||aa);if(aL){aN=aC();aM=aA()}aF();z();F();if(aL){N(aK?(T-aj):aN,false);M(aO?(Z-v):aM,false)}J();ag();an();if(ay.enableKeyboardNavigation){S()}if(ay.clickOnTrack){p()}C();if(ay.hijackInternalLinks){m()}}if(ay.autoReinitialise&&!av){av=setInterval(function(){ar(ay)},ay.autoReinitialiseDelay)}else{if(!ay.autoReinitialise&&av){clearInterval(av)}}aI&&D.scrollTop(0)&&M(aI,false);aP&&D.scrollLeft(0)&&N(aP,false);D.trigger("jsp-initialised",[aE||az])}function aF(){if(az){al.append(b('<div class="jspVerticalBar" />').append(b('<div class="jspCap jspCapTop" />'),b('<div class="jspTrack" />').append(b('<div class="jspDrag" />').append(b('<div class="jspDragTop" />'),b('<div class="jspDragBottom" />'))),b('<div class="jspCap jspCapBottom" />')));U=al.find(">.jspVerticalBar");ap=U.find(">.jspTrack");au=ap.find(">.jspDrag");if(ay.showArrows){aq=b('<a class="jspArrow jspArrowUp" />').bind("mousedown.jsp",aD(0,-1)).bind("click.jsp",aB);af=b('<a class="jspArrow jspArrowDown" />').bind("mousedown.jsp",aD(0,1)).bind("click.jsp",aB);if(ay.arrowScrollOnHover){aq.bind("mouseover.jsp",aD(0,-1,aq));af.bind("mouseover.jsp",aD(0,1,af))}ak(ap,ay.verticalArrowPositions,aq,af)}t=v;al.find(">.jspVerticalBar>.jspCap:visible,>.jspVerticalBar>.jspArrow").each(function(){t-=b(this).outerHeight()});au.hover(function(){au.addClass("jspHover")},function(){au.removeClass("jspHover")}).bind("mousedown.jsp",function(aI){b("html").bind("dragstart.jsp selectstart.jsp",aB);au.addClass("jspActive");var s=aI.pageY-au.position().top;b("html").bind("mousemove.jsp",function(aJ){V(aJ.pageY-s,false)}).bind("mouseup.jsp mouseleave.jsp",aw);return false});o()}}function o(){ap.height(t+"px");I=0;X=ay.verticalGutter+ap.outerWidth();Y.width(aj-X-f);try{if(U.position().left===0){Y.css("margin-left",X+"px")}}catch(s){}}function z(){if(aE){al.append(b('<div class="jspHorizontalBar" />').append(b('<div class="jspCap jspCapLeft" />'),b('<div class="jspTrack" />').append(b('<div class="jspDrag" />').append(b('<div class="jspDragLeft" />'),b('<div class="jspDragRight" />'))),b('<div class="jspCap jspCapRight" />')));am=al.find(">.jspHorizontalBar");G=am.find(">.jspTrack");h=G.find(">.jspDrag");if(ay.showArrows){ax=b('<a class="jspArrow jspArrowLeft" />').bind("mousedown.jsp",aD(-1,0)).bind("click.jsp",aB);x=b('<a class="jspArrow jspArrowRight" />').bind("mousedown.jsp",aD(1,0)).bind("click.jsp",aB);
    if(ay.arrowScrollOnHover){ax.bind("mouseover.jsp",aD(-1,0,ax));x.bind("mouseover.jsp",aD(1,0,x))}ak(G,ay.horizontalArrowPositions,ax,x)}h.hover(function(){h.addClass("jspHover")},function(){h.removeClass("jspHover")}).bind("mousedown.jsp",function(aI){b("html").bind("dragstart.jsp selectstart.jsp",aB);h.addClass("jspActive");var s=aI.pageX-h.position().left;b("html").bind("mousemove.jsp",function(aJ){W(aJ.pageX-s,false)}).bind("mouseup.jsp mouseleave.jsp",aw);return false});l=al.innerWidth();ah()}}function ah(){al.find(">.jspHorizontalBar>.jspCap:visible,>.jspHorizontalBar>.jspArrow").each(function(){l-=b(this).outerWidth()});G.width(l+"px");aa=0}function F(){if(aE&&az){var aI=G.outerHeight(),s=ap.outerWidth();t-=aI;b(am).find(">.jspCap:visible,>.jspArrow").each(function(){l+=b(this).outerWidth()});l-=s;v-=s;aj-=aI;G.parent().append(b('<div class="jspCorner" />').css("width",aI+"px"));o();ah()}if(aE){Y.width((al.outerWidth()-f)+"px")}Z=Y.outerHeight();q=Z/v;if(aE){at=Math.ceil(1/y*l);if(at>ay.horizontalDragMaxWidth){at=ay.horizontalDragMaxWidth}else{if(at<ay.horizontalDragMinWidth){at=ay.horizontalDragMinWidth}}h.width(at+"px");j=l-at;ae(aa)}if(az){A=Math.ceil(1/q*t);if(A>ay.verticalDragMaxHeight){A=ay.verticalDragMaxHeight}else{if(A<ay.verticalDragMinHeight){A=ay.verticalDragMinHeight}}au.height(A+"px");i=t-A;ad(I)}}function ak(aJ,aL,aI,s){var aN="before",aK="after",aM;if(aL=="os"){aL=/Mac/.test(navigator.platform)?"after":"split"}if(aL==aN){aK=aL}else{if(aL==aK){aN=aL;aM=aI;aI=s;s=aM}}aJ[aN](aI)[aK](s)}function aD(aI,s,aJ){return function(){H(aI,s,this,aJ);this.blur();return false}}function H(aL,aK,aO,aN){aO=b(aO).addClass("jspActive");var aM,aJ,aI=true,s=function(){if(aL!==0){Q.scrollByX(aL*ay.arrowButtonSpeed)}if(aK!==0){Q.scrollByY(aK*ay.arrowButtonSpeed)}aJ=setTimeout(s,aI?ay.initialDelay:ay.arrowRepeatFreq);aI=false};s();aM=aN?"mouseout.jsp":"mouseup.jsp";aN=aN||b("html");aN.bind(aM,function(){aO.removeClass("jspActive");aJ&&clearTimeout(aJ);aJ=null;aN.unbind(aM)})}function p(){w();if(az){ap.bind("mousedown.jsp",function(aN){if(aN.originalTarget===c||aN.originalTarget==aN.currentTarget){var aL=b(this),aO=aL.offset(),aM=aN.pageY-aO.top-I,aJ,aI=true,s=function(){var aR=aL.offset(),aS=aN.pageY-aR.top-A/2,aP=v*ay.scrollPagePercent,aQ=i*aP/(Z-v);if(aM<0){if(I-aQ>aS){Q.scrollByY(-aP)}else{V(aS)}}else{if(aM>0){if(I+aQ<aS){Q.scrollByY(aP)}else{V(aS)}}else{aK();return}}aJ=setTimeout(s,aI?ay.initialDelay:ay.trackClickRepeatFreq);aI=false},aK=function(){aJ&&clearTimeout(aJ);aJ=null;b(document).unbind("mouseup.jsp",aK)};s();b(document).bind("mouseup.jsp",aK);return false}})}if(aE){G.bind("mousedown.jsp",function(aN){if(aN.originalTarget===c||aN.originalTarget==aN.currentTarget){var aL=b(this),aO=aL.offset(),aM=aN.pageX-aO.left-aa,aJ,aI=true,s=function(){var aR=aL.offset(),aS=aN.pageX-aR.left-at/2,aP=aj*ay.scrollPagePercent,aQ=j*aP/(T-aj);if(aM<0){if(aa-aQ>aS){Q.scrollByX(-aP)}else{W(aS)}}else{if(aM>0){if(aa+aQ<aS){Q.scrollByX(aP)}else{W(aS)}}else{aK();return}}aJ=setTimeout(s,aI?ay.initialDelay:ay.trackClickRepeatFreq);aI=false},aK=function(){aJ&&clearTimeout(aJ);aJ=null;b(document).unbind("mouseup.jsp",aK)};s();b(document).bind("mouseup.jsp",aK);return false}})}}function w(){if(G){G.unbind("mousedown.jsp")}if(ap){ap.unbind("mousedown.jsp")}}function aw(){b("html").unbind("dragstart.jsp selectstart.jsp mousemove.jsp mouseup.jsp mouseleave.jsp");if(au){au.removeClass("jspActive")}if(h){h.removeClass("jspActive")}}function V(s,aI){if(!az){return}if(s<0){s=0}else{if(s>i){s=i}}if(aI===c){aI=ay.animateScroll}if(aI){Q.animate(au,"top",s,ad)}else{au.css("top",s);ad(s)}}function ad(aI){if(aI===c){aI=au.position().top}al.scrollTop(0);I=aI;var aL=I===0,aJ=I==i,aK=aI/i,s=-aK*(Z-v);if(ai!=aL||aG!=aJ){ai=aL;aG=aJ;D.trigger("jsp-arrow-change",[ai,aG,P,k])}u(aL,aJ);Y.css("top",s);D.trigger("jsp-scroll-y",[-s,aL,aJ]).trigger("scroll")}function W(aI,s){if(!aE){return}if(aI<0){aI=0}else{if(aI>j){aI=j}}if(s===c){s=ay.animateScroll}if(s){Q.animate(h,"left",aI,ae)
}else{h.css("left",aI);ae(aI)}}function ae(aI){if(aI===c){aI=h.position().left}al.scrollTop(0);aa=aI;var aL=aa===0,aK=aa==j,aJ=aI/j,s=-aJ*(T-aj);if(P!=aL||k!=aK){P=aL;k=aK;D.trigger("jsp-arrow-change",[ai,aG,P,k])}r(aL,aK);Y.css("left",s);D.trigger("jsp-scroll-x",[-s,aL,aK]).trigger("scroll")}function u(aI,s){if(ay.showArrows){aq[aI?"addClass":"removeClass"]("jspDisabled");af[s?"addClass":"removeClass"]("jspDisabled")}}function r(aI,s){if(ay.showArrows){ax[aI?"addClass":"removeClass"]("jspDisabled");x[s?"addClass":"removeClass"]("jspDisabled")}}function M(s,aI){var aJ=s/(Z-v);V(aJ*i,aI)}function N(aI,s){var aJ=aI/(T-aj);W(aJ*j,s)}function ab(aV,aQ,aJ){var aN,aK,aL,s=0,aU=0,aI,aP,aO,aS,aR,aT;try{aN=b(aV)}catch(aM){return}aK=aN.outerHeight();aL=aN.outerWidth();al.scrollTop(0);al.scrollLeft(0);while(!aN.is(".jspPane")){s+=aN.position().top;aU+=aN.position().left;aN=aN.offsetParent();if(/^body|html$/i.test(aN[0].nodeName)){return}}aI=aA();aO=aI+v;if(s<aI||aQ){aR=s-ay.verticalGutter}else{if(s+aK>aO){aR=s-v+aK+ay.verticalGutter}}if(aR){M(aR,aJ)}aP=aC();aS=aP+aj;if(aU<aP||aQ){aT=aU-ay.horizontalGutter}else{if(aU+aL>aS){aT=aU-aj+aL+ay.horizontalGutter}}if(aT){N(aT,aJ)}}function aC(){return -Y.position().left}function aA(){return -Y.position().top}function K(){var s=Z-v;return(s>20)&&(s-aA()<10)}function B(){var s=T-aj;return(s>20)&&(s-aC()<10)}function ag(){al.unbind(ac).bind(ac,function(aL,aM,aK,aI){var aJ=aa,s=I;Q.scrollBy(aK*ay.mouseWheelSpeed,-aI*ay.mouseWheelSpeed,false);return aJ==aa&&s==I})}function n(){al.unbind(ac)}function aB(){return false}function J(){Y.find(":input,a").unbind("focus.jsp").bind("focus.jsp",function(s){ab(s.target,false)})}function E(){Y.find(":input,a").unbind("focus.jsp")}function S(){var s,aI,aK=[];aE&&aK.push(am[0]);az&&aK.push(U[0]);Y.focus(function(){D.focus()});D.attr("tabindex",0).unbind("keydown.jsp keypress.jsp").bind("keydown.jsp",function(aN){if(aN.target!==this&&!(aK.length&&b(aN.target).closest(aK).length)){return}var aM=aa,aL=I;switch(aN.keyCode){case 40:case 38:case 34:case 32:case 33:case 39:case 37:s=aN.keyCode;aJ();break;case 35:M(Z-v);s=null;break;case 36:M(0);s=null;break}aI=aN.keyCode==s&&aM!=aa||aL!=I;return !aI}).bind("keypress.jsp",function(aL){if(aL.keyCode==s){aJ()}return !aI});if(ay.hideFocus){D.css("outline","none");if("hideFocus" in al[0]){D.attr("hideFocus",true)}}else{D.css("outline","");if("hideFocus" in al[0]){D.attr("hideFocus",false)}}function aJ(){var aM=aa,aL=I;switch(s){case 40:Q.scrollByY(ay.keyboardSpeed,false);break;case 38:Q.scrollByY(-ay.keyboardSpeed,false);break;case 34:case 32:Q.scrollByY(v*ay.scrollPagePercent,false);break;case 33:Q.scrollByY(-v*ay.scrollPagePercent,false);break;case 39:Q.scrollByX(ay.keyboardSpeed,false);break;case 37:Q.scrollByX(-ay.keyboardSpeed,false);break}aI=aM!=aa||aL!=I;return aI}}function R(){D.attr("tabindex","-1").removeAttr("tabindex").unbind("keydown.jsp keypress.jsp")}function C(){if(location.hash&&location.hash.length>1){var aK,aI,aJ=escape(location.hash.substr(1));try{aK=b("#"+aJ+', a[name="'+aJ+'"]')}catch(s){return}if(aK.length&&Y.find(aJ)){if(al.scrollTop()===0){aI=setInterval(function(){if(al.scrollTop()>0){ab(aK,true);b(document).scrollTop(al.position().top);clearInterval(aI)}},50)}else{ab(aK,true);b(document).scrollTop(al.position().top)}}}}function m(){if(b(document.body).data("jspHijack")){return}b(document.body).data("jspHijack",true);b(document.body).delegate("a[href*=#]","click",function(s){var aI=this.href.substr(0,this.href.indexOf("#")),aK=location.href,aO,aP,aJ,aM,aL,aN;if(location.href.indexOf("#")!==-1){aK=location.href.substr(0,location.href.indexOf("#"))}if(aI!==aK){return}aO=escape(this.href.substr(this.href.indexOf("#")+1));aP;try{aP=b("#"+aO+', a[name="'+aO+'"]')}catch(aQ){return}if(!aP.length){return}aJ=aP.closest(".jspScrollable");aM=aJ.data("jsp");aM.scrollToElement(aP,true);if(aJ[0].scrollIntoView){aL=b(a).scrollTop();aN=aP.offset().top;if(aN<aL||aN>aL+b(a).height()){aJ[0].scrollIntoView()}}s.preventDefault()
})}function an(){var aJ,aI,aL,aK,aM,s=false;al.unbind("touchstart.jsp touchmove.jsp touchend.jsp click.jsp-touchclick").bind("touchstart.jsp",function(aN){var aO=aN.originalEvent.touches[0];aJ=aC();aI=aA();aL=aO.pageX;aK=aO.pageY;aM=false;s=true}).bind("touchmove.jsp",function(aQ){if(!s){return}var aP=aQ.originalEvent.touches[0],aO=aa,aN=I;Q.scrollTo(aJ+aL-aP.pageX,aI+aK-aP.pageY);aM=aM||Math.abs(aL-aP.pageX)>5||Math.abs(aK-aP.pageY)>5;return aO==aa&&aN==I}).bind("touchend.jsp",function(aN){s=false}).bind("click.jsp-touchclick",function(aN){if(aM){aM=false;return false}})}function g(){var s=aA(),aI=aC();D.removeClass("jspScrollable").unbind(".jsp");D.replaceWith(ao.append(Y.children()));ao.scrollTop(s);ao.scrollLeft(aI);if(av){clearInterval(av)}}b.extend(Q,{reinitialise:function(aI){aI=b.extend({},ay,aI);ar(aI)},scrollToElement:function(aJ,aI,s){ab(aJ,aI,s)},scrollTo:function(aJ,s,aI){N(aJ,aI);M(s,aI)},scrollToX:function(aI,s){N(aI,s)},scrollToY:function(s,aI){M(s,aI)},scrollToPercentX:function(aI,s){N(aI*(T-aj),s)},scrollToPercentY:function(aI,s){M(aI*(Z-v),s)},scrollBy:function(aI,s,aJ){Q.scrollByX(aI,aJ);Q.scrollByY(s,aJ)},scrollByX:function(s,aJ){var aI=aC()+Math[s<0?"floor":"ceil"](s),aK=aI/(T-aj);W(aK*j,aJ)},scrollByY:function(s,aJ){var aI=aA()+Math[s<0?"floor":"ceil"](s),aK=aI/(Z-v);V(aK*i,aJ)},positionDragX:function(s,aI){W(s,aI)},positionDragY:function(aI,s){V(aI,s)},animate:function(aI,aL,s,aK){var aJ={};aJ[aL]=s;aI.animate(aJ,{duration:ay.animateDuration,easing:ay.animateEase,queue:false,step:aK})},getContentPositionX:function(){return aC()},getContentPositionY:function(){return aA()},getContentWidth:function(){return T},getContentHeight:function(){return Z},getPercentScrolledX:function(){return aC()/(T-aj)},getPercentScrolledY:function(){return aA()/(Z-v)},getIsScrollableH:function(){return aE},getIsScrollableV:function(){return az},getContentPane:function(){return Y},scrollToBottom:function(s){V(i,s)},hijackInternalLinks:b.noop,destroy:function(){g()}});ar(O)}e=b.extend({},b.fn.jScrollPane.defaults,e);b.each(["mouseWheelSpeed","arrowButtonSpeed","trackClickSpeed","keyboardSpeed"],function(){e[this]=e[this]||e.speed});return this.each(function(){var f=b(this),g=f.data("jsp");if(g){g.reinitialise(e)}else{b("script",f).filter('[type="text/javascript"],:not([type])').remove();g=new d(f,e);f.data("jsp",g)}})};b.fn.jScrollPane.defaults={showArrows:false,maintainPosition:true,stickToBottom:false,stickToRight:false,clickOnTrack:true,autoReinitialise:false,autoReinitialiseDelay:500,verticalDragMinHeight:0,verticalDragMaxHeight:99999,horizontalDragMinWidth:0,horizontalDragMaxWidth:99999,contentWidth:c,animateScroll:false,animateDuration:300,animateEase:"linear",hijackInternalLinks:false,verticalGutter:4,horizontalGutter:4,mouseWheelSpeed:0,arrowButtonSpeed:0,arrowRepeatFreq:50,arrowScrollOnHover:false,trackClickSpeed:0,trackClickRepeatFreq:70,verticalArrowPositions:"split",horizontalArrowPositions:"split",enableKeyboardNavigation:true,hideFocus:false,keyboardSpeed:0,initialDelay:300,speed:30,scrollPagePercent:0.8}})(jQuery,this);
(function($){var isTouchDevice=function(){try{return"ontouchstart"in document.documentElement}catch(e){return false}}();$.fn.doubletap=function(onDoubleTapCallback,onTapCallback,delay){var eventName,action;delay=delay==null?500:delay;eventName=isTouchDevice==true?"touchend":"click";$(this).bind(eventName,function(event){event.preventDefault();var now=(new Date).getTime();var lastTouch=$(this).data("lastTouch")||now+1;var delta=now-lastTouch;clearTimeout(action);if(delta<delay&&delta>0){if(onDoubleTapCallback!=
    null&&typeof onDoubleTapCallback=="function")onDoubleTapCallback(event)}else{$(this).data("lastTouch",now);action=setTimeout(function(evt){if(onTapCallback!=null&&typeof onTapCallback=="function")onTapCallback(evt);clearTimeout(action)},delay,[event])}$(this).data("lastTouch",now)})}})(jQuery);
(function($){$.fn.touchwipe=function(settings){var config={min_move_x:20,min_move_y:20,wipeLeft:function(){},wipeRight:function(){},wipeUp:function(){},wipeDown:function(){},preventDefaultEvents:true};if(settings)$.extend(config,settings);var _this=this;this.config=config;this.each(function(){var startX;var startY;var isMoving=false;function cancelTouch(){this.removeEventListener("touchmove",onTouchMove);startX=null;isMoving=false}function onTouchMove(e){if(e.touches.length>1)isMoving=false;if(_this.config.preventDefaultEvents)e.preventDefault();
    if(isMoving && (jQuery(_this).data("pageMv")==null || (jQuery(_this).data("pageMv") && jQuery(_this).data('pageMv').length == 0))){var x=e.touches[0].pageX;var y=e.touches[0].pageY;var dx=startX-x;var dy=startY-y;if(Math.abs(dx)>=config.min_move_x){cancelTouch();if(dx>0)config.wipeLeft();else config.wipeRight()}else if(Math.abs(dy)>=config.min_move_y){cancelTouch();if(dy>0)config.wipeDown();else config.wipeUp()}}}function onTouchStart(e){if(e.touches.length==1){startX=e.touches[0].pageX;startY=e.touches[0].pageY;isMoving=true;this.addEventListener("touchmove",onTouchMove,false)}}
    if("ontouchstart"in document.documentElement)this.addEventListener("touchstart",onTouchStart,false)});return this}})(jQuery);
//fgnass.github.com/spin.js#v1.2.5
(function(a,b,c){function g(a,c){var d=b.createElement(a||"div"),e;for(e in c)d[e]=c[e];return d}function h(a){for(var b=1,c=arguments.length;b<c;b++)a.appendChild(arguments[b]);return a}function j(a,b,c,d){var g=["opacity",b,~~(a*100),c,d].join("-"),h=.01+c/d*100,j=Math.max(1-(1-a)/b*(100-h),a),k=f.substring(0,f.indexOf("Animation")).toLowerCase(),l=k&&"-"+k+"-"||"";return e[g]||(i.insertRule("@"+l+"keyframes "+g+"{"+"0%{opacity:"+j+"}"+h+"%{opacity:"+a+"}"+(h+.01)+"%{opacity:1}"+(h+b)%100+"%{opacity:"+a+"}"+"100%{opacity:"+j+"}"+"}",0),e[g]=1),g}function k(a,b){var e=a.style,f,g;if(e[b]!==c)return b;b=b.charAt(0).toUpperCase()+b.slice(1);for(g=0;g<d.length;g++){f=d[g]+b;if(e[f]!==c)return f}}function l(a,b){for(var c in b)a.style[k(a,c)||c]=b[c];return a}function m(a){for(var b=1;b<arguments.length;b++){var d=arguments[b];for(var e in d)a[e]===c&&(a[e]=d[e])}return a}function n(a){var b={x:a.offsetLeft,y:a.offsetTop};while(a=a.offsetParent)b.x+=a.offsetLeft,b.y+=a.offsetTop;return b}var d=["webkit","Moz","ms","O"],e={},f,i=function(){var a=g("style");return h(b.getElementsByTagName("head")[0],a),a.sheet||a.styleSheet}(),o={lines:12,length:7,width:5,radius:10,rotate:0,color:"#000",speed:1,trail:100,opacity:.25,fps:20,zIndex:2e9,className:"spinner",top:"auto",left:"auto"},p=function q(a){if(!this.spin)return new q(a);this.opts=m(a||{},q.defaults,o)};p.defaults={},m(p.prototype,{spin:function(a){this.stop();var b=this,c=b.opts,d=b.el=l(g(0,{className:c.className}),{position:"relative",zIndex:c.zIndex}),e=c.radius+c.length+c.width,h,i;a&&(a.insertBefore(d,a.firstChild||null),i=n(a),h=n(d),l(d,{left:(c.left=="auto"?i.x-h.x+(a.offsetWidth>>1):c.left+e)+"px",top:(c.top=="auto"?i.y-h.y+(a.offsetHeight>>1):c.top+e)+"px"})),d.setAttribute("aria-role","progressbar"),b.lines(d,b.opts);if(!f){var j=0,k=c.fps,m=k/c.speed,o=(1-c.opacity)/(m*c.trail/100),p=m/c.lines;!function q(){j++;for(var a=c.lines;a;a--){var e=Math.max(1-(j+a*p)%m*o,c.opacity);b.opacity(d,c.lines-a,e,c)}b.timeout=b.el&&setTimeout(q,~~(1e3/k))}()}return b},stop:function(){var a=this.el;return a&&(clearTimeout(this.timeout),a.parentNode&&a.parentNode.removeChild(a),this.el=c),this},lines:function(a,b){function e(a,d){return l(g(),{position:"absolute",width:b.length+b.width+"px",height:b.width+"px",background:a,boxShadow:d,transformOrigin:"left",transform:"rotate("+~~(360/b.lines*c+b.rotate)+"deg) translate("+b.radius+"px"+",0)",borderRadius:(b.width>>1)+"px"})}var c=0,d;for(;c<b.lines;c++)d=l(g(),{position:"absolute",top:1+~(b.width/2)+"px",transform:b.hwaccel?"translate3d(0,0,0)":"",opacity:b.opacity,animation:f&&j(b.opacity,b.trail,c,b.lines)+" "+1/b.speed+"s linear infinite"}),b.shadow&&h(d,l(e("#000","0 0 4px #000"),{top:"2px"})),h(a,h(d,e(b.color,"0 0 1px rgba(0,0,0,.1)")));return a},opacity:function(a,b,c){b<a.childNodes.length&&(a.childNodes[b].style.opacity=c)}}),!function(){function a(a,b){return g("<"+a+' xmlns="urn:schemas-microsoft.com:vml" class="spin-vml">',b)}var b=l(g("group"),{behavior:"url(#default#VML)"});!k(b,"transform")&&b.adj?(i.addRule(".spin-vml","behavior:url(#default#VML)"),p.prototype.lines=function(b,c){function f(){return l(a("group",{coordsize:e+" "+e,coordorigin:-d+" "+ -d}),{width:e,height:e})}function k(b,e,g){h(i,h(l(f(),{rotation:360/c.lines*b+"deg",left:~~e}),h(l(a("roundrect",{arcsize:1}),{width:d,height:c.width,left:c.radius,top:-c.width>>1,filter:g}),a("fill",{color:c.color,opacity:c.opacity}),a("stroke",{opacity:0}))))}var d=c.length+c.width,e=2*d,g=-(c.width+c.length)*2+"px",i=l(f(),{position:"absolute",top:g,left:g}),j;if(c.shadow)for(j=1;j<=c.lines;j++)k(j,-2,"progid:DXImageTransform.Microsoft.Blur(pixelradius=2,makeshadow=1,shadowopacity=.3)");for(j=1;j<=c.lines;j++)k(j);return h(b,i)},p.prototype.opacity=function(a,b,c,d){var e=a.firstChild;d=d.shadow&&d.lines||0,e&&b+d<e.childNodes.length&&(e=e.childNodes[b+d],e=e&&e.firstChild,e=e&&e.firstChild,e&&(e.opacity=c))}):f=k(b,"animation")}(),a.Spinner=p})(window,document);
(function($){$.transit={version:"0.1.3",propertyMap:{marginLeft:"margin",marginRight:"margin",marginBottom:"margin",marginTop:"margin",paddingLeft:"padding",paddingRight:"padding",paddingBottom:"padding",paddingTop:"padding"},enabled:true,useTransitionEnd:false};var div=document.createElement("div");var support={};function getVendorPropertyName(prop){if(prop in div.style)return prop;var prefixes=["Moz","Webkit","O","ms"];var prop_=prop.charAt(0).toUpperCase()+prop.substr(1);if(prop in div.style)return prop;
    for(var i=0;i<prefixes.length;++i){var vendorProp=prefixes[i]+prop_;if(vendorProp in div.style)return vendorProp}}function checkTransform3dSupport(){div.style[support.transform]="";div.style[support.transform]="rotateY(90deg)";return div.style[support.transform]!==""}var isChrome=navigator.userAgent.toLowerCase().indexOf("chrome")>-1;support.transition=getVendorPropertyName("transition");support.transitionDelay=getVendorPropertyName("transitionDelay");support.transform=getVendorPropertyName("transform");
    support.transformOrigin=getVendorPropertyName("transformOrigin");support.transform3d=checkTransform3dSupport();$.extend($.support,support);var eventNames={"MozTransition":"transitionend","OTransition":"oTransitionEnd","WebkitTransition":"webkitTransitionEnd","msTransition":"MSTransitionEnd"};var transitionEnd=support.transitionEnd=eventNames[support.transition]||null;div=null;$.cssEase={"_default":"ease","in":"ease-in","out":"ease-out","in-out":"ease-in-out","snap":"cubic-bezier(0,1,.5,1)"};$.cssHooks.transform=
    {get:function(elem){return $(elem).data("transform")},set:function(elem,v){var value=v;if(!(value instanceof Transform))value=new Transform(value);if(support.transform==="WebkitTransform"&&!eb.browser.safari)elem.style[support.transform]=value.toString(true);else elem.style[support.transform]=value.toString();$(elem).data("transform",value)}};$.cssHooks.transformOrigin={get:function(elem){return elem.style[support.transformOrigin]},set:function(elem,value){elem.style[support.transformOrigin]=value}};
    $.cssHooks.transition={get:function(elem){return elem.style[support.transition]},set:function(elem,value){elem.style[support.transition]=value}};registerCssHook("scale");registerCssHook("translate");registerCssHook("rotate");registerCssHook("rotateX");registerCssHook("rotateY");registerCssHook("rotate3d");registerCssHook("perspective");registerCssHook("skewX");registerCssHook("skewY");registerCssHook("x",true);registerCssHook("y",true);function Transform(str){if(typeof str==="string")this.parse(str);
        return this}Transform.prototype={setFromString:function(prop,val){var args=typeof val==="string"?val.split(","):val.constructor===Array?val:[val];args.unshift(prop);Transform.prototype.set.apply(this,args)},set:function(prop){var args=Array.prototype.slice.apply(arguments,[1]);if(this.setter[prop])this.setter[prop].apply(this,args);else this[prop]=args.join(",")},get:function(prop){if(this.getter[prop])return this.getter[prop].apply(this);else return this[prop]||0},setter:{rotate:function(theta){this.rotate=
        unit(theta,"deg")},rotateX:function(theta){this.rotateX=unit(theta,"deg")},rotateY:function(theta){this.rotateY=unit(theta,"deg")},scale:function(x,y){if(y===undefined)y=x;this.scale=x+","+y},skewX:function(x){this.skewX=unit(x,"deg")},skewY:function(y){this.skewY=unit(y,"deg")},perspective:function(dist){this.perspective=unit(dist,"px")},x:function(x){this.set("translate",x,null)},y:function(y){this.set("translate",null,y)},translate:function(x,y){if(this._translateX===undefined)this._translateX=
        0;if(this._translateY===undefined)this._translateY=0;if(x!==null)this._translateX=unit(x,"px");if(y!==null)this._translateY=unit(y,"px");this.translate=this._translateX+","+this._translateY}},getter:{x:function(){return this._translateX||0},y:function(){return this._translateY||0},scale:function(){var s=(this.scale||"1,1").split(",");if(s[0])s[0]=parseFloat(s[0]);if(s[1])s[1]=parseFloat(s[1]);return s[0]===s[1]?s[0]:s},rotate3d:function(){var s=(this.rotate3d||"0,0,0,0deg").split(",");for(var i=0;i<=
        3;++i)if(s[i])s[i]=parseFloat(s[i]);if(s[3])s[3]=unit(s[3],"deg");return s}},parse:function(str){var self=this;str.replace(/([a-zA-Z0-9]+)\((.*?)\)/g,function(x,prop,val){self.setFromString(prop,val)})},toString:function(use3d){var re=[];for(var i in this)if(this.hasOwnProperty(i)){if(!support.transform3d&&(i==="rotateX"||i==="rotateY"||i==="perspective"||i==="transformOrigin"))continue;if(i[0]!=="_")if(use3d&&i==="scale")re.push(i+"3d("+this[i]+",1)");else if(use3d&&i==="translate")re.push(i+"3d("+
        this[i]+",0)");else re.push(i+"("+this[i]+")")}return re.join(" ")}};function callOrQueue(self,queue,fn){if(queue===true)self.queue(fn);else if(queue)self.queue(queue,fn);else fn()}function getProperties(props){var re=[];$.each(props,function(key){key=$.camelCase(key);key=$.transit.propertyMap[key]||key;key=uncamel(key);if($.inArray(key,re)===-1)re.push(key)});return re}function getTransition(properties,duration,easing,delay){var props=getProperties(properties);if($.cssEase[easing])easing=$.cssEase[easing];
        var attribs=""+toMS(duration)+" "+easing;if(parseInt(delay,10)>0)attribs+=" "+toMS(delay);var transitions=[];$.each(props,function(i,name){transitions.push(name+" "+attribs)});return transitions.join(", ")}$.fn.transition=$.fn.transit=function(properties,duration,easing,callback){var self=this;var delay=0;var queue=true;if(typeof duration==="function"){callback=duration;duration=undefined}if(typeof easing==="function"){callback=easing;easing=undefined}if(typeof properties.easing!=="undefined"){easing=
        properties.easing;delete properties.easing}if(typeof properties.duration!=="undefined"){duration=properties.duration;delete properties.duration}if(typeof properties.complete!=="undefined"){callback=properties.complete;delete properties.complete}if(typeof properties.queue!=="undefined"){queue=properties.queue;delete properties.queue}if(typeof properties.delay!=="undefined"){delay=properties.delay;delete properties.delay}if(typeof duration==="undefined")duration=$.fx.speeds._default;if(typeof easing===
        "undefined")easing=$.cssEase._default;duration=toMS(duration);var transitionValue=getTransition(properties,duration,easing,delay);var work=$.transit.enabled&&support.transition;var i=work?parseInt(duration,10)+parseInt(delay,10):0;if(i===0){var fn=function(next){self.css(properties);if(callback)callback.apply(self);if(next)next()};callOrQueue(self,queue,fn);return self}var oldTransitions={};var run=function(nextCall){var bound=false;var cb=function(){if(bound)self.unbind(transitionEnd,cb);if(i>0)self.each(function(){this.style[support.transition]=
        oldTransitions[this]||null});if(typeof callback==="function")callback.apply(self);if(typeof nextCall==="function")nextCall()};if(i>0&&transitionEnd&&$.transit.useTransitionEnd){bound=true;self.bind(transitionEnd,cb)}else window.setTimeout(cb,i);self.each(function(){if(i>0)this.style[support.transition]=transitionValue;$(this).css(properties)})};var deferredRun=function(next){var i=0;this.offsetWidth;run(next)};callOrQueue(self,queue,deferredRun);return this};function registerCssHook(prop,isPixels){if(!isPixels)$.cssNumber[prop]=
        true;$.transit.propertyMap[prop]=support.transform;$.cssHooks[prop]={get:function(elem){var t=$(elem).css("transform");if(!(t instanceof Transform))t=new Transform;return t.get(prop)},set:function(elem,value){var t=$(elem).css("transform");if(!(t instanceof Transform))t=new Transform;t.setFromString(prop,value);$(elem).css({transform:t})}}}function uncamel(str){return str.replace(/([A-Z])/g,function(letter){return"-"+letter.toLowerCase()})}function unit(i,units){if(typeof i==="string"&&!i.match(/^[\-0-9\.]+$/))return i;
    else return""+i+units}function toMS(duration){var i=duration;if($.fx.speeds[i])i=$.fx.speeds[i];return unit(i,"ms")}$.transit.getTransitionValue=getTransition})(jQuery);
