/**
 * Created by 01112291 on 16-3-8.
 */
var submitFlag = false;
var submitEditFlag = false;
$(function(){
    /*添加章*/
    $("#add-unit").click(function(){
        $(this).parents(".chapter-title").find(".form-action").show();
    })

    //保存章信息
    $("#save-unit").click(function(){
        var unitNo = $.trim($("#unitNo").val());
        var unitName = $.trim($("#unitName").val());
        if (unitNo.length == 0) {
            $.dialog.error("章序号不能为空!");
            return;
        }
        if (unitName.length == 0) {
            $.dialog.error("章名称不能为空!");
            return;
        }
        if (submitFlag==false){
            $(this).empty().text("提交中");
            submitFlag = true;
        } else {
            return;
        }
        $.ajax({
            type: "post",
            url: CONTEXTPATH+"/platform/unit/doSaveUnit.mooc",
            data: {
                unitId: 0,
                unitNo: unitNo,
                unitName: unitName
            },
            success: function (result) {
                submitFlag = true;
                if (result.retCode=="success"){
                    $.dialog.success("操作成功！");
                    location.href=CONTEXTPATH+"/platform/queryunit.mooc";
                } else {
                    $(this).empty().text("添加");
                    $.dialog.error("操作失败！"+result.retCode);
                }
            }
        })
    })

    /**
     * 章的删除
     */
    $(".icon-del").click(function(){
        var unitId = $(this).parents(".link-group").attr("unitId");
        $.dialog.confirm("确定要删除吗?", function () {
            $.ajax({
                type:'post',
                data:{
                    unitId:unitId
                },
                url:CONTEXTPATH+"/platform/unit/delUnit.mooc",
                success:function(result){
                    if (result.retCode=="success"){
                        $.dialog.success("操作成功！");
                        location.href=CONTEXTPATH+"/platform/queryunit.mooc";
                    } else {
                        $.dialog.error("操作失败！");
                    }
                }
            })
        }, function () {
            $.dialog.close();
        });
    })

    /**
     * 添加章-取消操作
     */
    $(".cancel-unit-add").click(function(){
        var $chapterTitle = $(this).parents(".chapter-title");
        if($chapterTitle.length > 0){
            $chapterTitle.find(".chapter-title-content").show();
            $chapterTitle.find(".form-action").hide();
        }
    })

    /**
     * 编辑章-取消操作
     */
    $(".cancel-unit-edit").click(function(){
        var $chapterTitle = $(this).parents(".chapter-title");
        if($chapterTitle.length > 0){
            $chapterTitle.find(".form-action").hide();
            $chapterTitle.find(".chapter-title-content").show();
        }
    })

    /**
     * 添加视频
     */
    $(".add-item").click(function(){
        var unitId = $(this).attr("unitId");
        location.href=CONTEXTPATH+"/platform/unit/"+unitId+"/item.mooc";
    })

    /**
     * 删除视频
     */
    $(".deleteItem").click(function(){
        var itemId = $(this).parents(".link-group").attr("itemId");
        $.dialog.confirm("确定要删除吗?", function () {
            $.ajax({
                type:'post',
                data:{
                    itemId:itemId
                },
                url:CONTEXTPATH+"/platform/item/delItem.mooc",
                success:function(result){
                    if (result.retCode=="success"){
                        $.dialog.success("操作成功！");
                        location.href=CONTEXTPATH+"/platform/queryunit.mooc";
                    } else {
                        $.dialog.error("操作失败");
                    }
                }
            })
        }, function () {
            $.dialog.close();
        });
    })

    /**
     * 章编辑
     */
    $(".icon-edit").click(function(){
        var $chapterTitle = $(this).parents(".view-chapter");
        $chapterTitle.find(".chapter-title-content").hide();
        $chapterTitle.find(".form-action").show();
    })

    /**
     * 章编辑-提交
     */
    $(".btn-modify").click(function(){
        var unitId = $(this).attr("unitId");
        var unitNo = $(this).parents(".form-action").find(".unitNo").val();
        var unitName = $(this).parents(".form-action").find(".unitName").val();
        if (unitNo.length == 0) {
            $.dialog.error("章序号不能为空!");
            return;
        }
        if (unitName.length == 0) {
            $.dialog.error("章名称不能为空!");
            return;
        }
        if (submitEditFlag==false){
            $(this).empty().text("提交中");
            submitEditFlag = true;
        } else {
            return;
        }
        $.ajax({
            type:'post',
            data:{
                unitId:unitId,
                unitNo:unitNo,
                unitName:unitName
            },
            url:CONTEXTPATH+"/platform/unit/updateUnit.mooc",
            success:function(result){
                submitEditFlag = true;
                if (result.retCode=="success"){
                    $.dialog.success("操作成功！");
                    location.href=CONTEXTPATH+"/platform/queryunit.mooc";
                } else {
                    $.dialog.error("操作失败！");
                }
            }
        })
    })

    /**
     * 编辑-视频
     */
    $(".editItem").click(function(){
        var itemId = $(this).parents(".link-group").attr("itemId");
        var unitId = $(this).parents(".view-chapter").attr("unitId");
        location.href=CONTEXTPATH+"/platform/unit/"+unitId+"/item.mooc?itemId="+itemId;
    })

    /**
    *章拖拽
    */
    $(".chapter-sortable").sortable({
        placeholder : "ui-state-highlight",
        cursor : 'move',
        handle : '.icon-drag',
        stop : function(event, ui) {
            var unitIds = "";
            var displayOrders = "";
            var i = 1;
            ui.item.parent().children('.viewChapter').each(function () {
                var unitId = $(this).attr('unitId');
                unitIds = unitIds + (i == 1 ? unitId : "," + unitId);
                displayOrders = displayOrders + (i == 1 ? i : "," + i);
                $(this).attr('displayOrder', i);
                i++;
            });
            $.ajax({
                type: 'post',
                url: CONTEXTPATH + "/platform/unit/sort.mooc",
                datatype: "json",
                data: {
                    unitIds: unitIds,
                    displayOrders: displayOrders
                },
                success: function (result) {
                    if (result.retCode=="success"){
                        $.dialog.success("操作成功！");
                    } else {
                        $.dialog.error("操作失败！");
                    }
                }
            });
        }
    });

    /**
     * 视频拖拽
     */
    $(".lecture-sortable").sortable({
        placeholder : "ui-state-highlight",
        cursor : 'move',
        handle : '.icon-drag01',
        connectWith : ".lecture-sortable",
        containment : ".main-cai",
        stop : function(event, ui) {
            var i = 1;
            var itemChildIds = "";
            var displayOrders = "";
            var itemId = ui.item.attr('itemId');
            var unitId = ui.item.parents('.viewChapter').attr('unitId');//新的所在的unitId
            ui.item.parent().children('.view-lecture').each(function () {
                var itemIds = $(this).attr('itemId');
                itemChildIds = itemChildIds + (i == 1 ? itemIds : "," + itemIds);
                displayOrders = displayOrders + (i == 1 ? i : "," + i);
                $(this).attr('displayOrder', i)
                i++;
            });
            $.ajax({
                type: 'post',
                url: CONTEXTPATH + "/platform/item/sort.mooc",
                datatype: "json",
                data: {
                    unitId: unitId,
                    itemChildIds: itemChildIds,
                    displayOrders: displayOrders,
                    itemId: itemId
                },
                success: function (result) {
                    if (result.retCode=="success"){
                        $.dialog.success("操作成功！");
                    } else {
                        $.dialog.error("操作失败！");
                    }
                }
            });
        }
    });

    //item重新命名
    var dialog =null;
    $(".renameItem").click(function(){
        var itemId = $(this).attr("itemId");
        var itemName = $(this).parents(".cai-item").find(".video-text").html();
        dialog = $.dialog({
            title: "提示",
            content: $("#updateItemDialog")[0],
            width: "650px",
            lock: true
        });
        $("#updateItem").attr("itemId",itemId);
        $("#oldItemName").html("原名称："+itemName);
        $("#itemName").val(itemName);
    })

    $("#updateItem").click(function(){
        var itemId = $(this).attr("itemId");
        var newItemName = $("#itemName").val();
        if (newItemName==null || newItemName==""){
            $.dialog.error("请输入新的名称！");
            return false;
        }
        $.ajax({
            type:'post',
            data:{
                itemId:itemId,
                itemName:newItemName
            },
            url:CONTEXTPATH+"/platform/item/updateItem.mooc",
            success:function(result){
                if (result.retCode=="success"){
                    $.dialog.success("操作成功！");
                    dialog.close();
                    location.href=CONTEXTPATH+"/platform/queryunit.mooc";
                } else {
                    $.dialog.error("操作失败！");
                }
            }
        })
    })

    //取消
    $(".cancelDialog").click(function(){
        dialog.close();
    })
})