/*
 * Decompiled with CFR 0.152.
 */
package edu.sjtu.jaccount;

import edu.sjtu.jaccount.JACrypt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class JAccountManager {
    private String uaBaseURL = "https://jaccount.sjtu.edu.cn/jaccount/";
    private String siteID;
    public boolean hasTicketInURL;
    protected Hashtable userProfile;
    private static long elapsedTimestamp = 120000L;
    private String ticketFromServer;
    private String returnURL;
    private byte[] siteKey = null;

    public JAccountManager(String sid, String keyDir) {
        this.siteID = sid;
        try {
            int c;
            String sep = System.getProperty("file.separator");
            String keyFile = String.valueOf(keyDir) + sep + "jakey" + sep + sid.toLowerCase() + "_desede.key";
            FileInputStream fis = new FileInputStream(keyFile);
            byte[] key = new byte[24];
            while ((c = fis.read(key)) != -1) {
                if (c != 24) continue;
                this.siteKey = key;
            }
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String loadServerIP() {
        String serverIP = new String();
        return serverIP;
    }

    public Hashtable checkLogin(HttpServletRequest request, HttpServletResponse response, HttpSession session, String returnURL) {
        if (this.hasValidTicket(request, session)) {
            this.setSiteCookie(response);
            this.hasTicketInURL = true;
            return this.userProfile;
        }
        if (this.isSiteCookieValid(request)) {
            return this.userProfile;
        }
        this.hasTicketInURL = false;
        try {
            String scheme = request.getScheme();
            int port = request.getServerPort();
            String rurl = String.valueOf(scheme) + "://" + request.getServerName();
            if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
                rurl = String.valueOf(rurl) + ":" + port;
            }
            rurl = String.valueOf(rurl) + returnURL;
            response.sendRedirect(String.valueOf(this.uaBaseURL) + "jalogin?sid=" + this.siteID + "&returl=" + this.encrypt(rurl) + "&se=" + this.encrypt(session.getId()) + "&v=20110607");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Hashtable checkLogin(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        if (this.hasValidTicket(request, session)) {
            this.setSiteCookie(response);
            return this.userProfile;
        }
        if (this.isSiteCookieValid(request)) {
            return this.userProfile;
        }
        return null;
    }

    protected String decrypt(String src) {
        if (this.siteKey == null) {
            return null;
        }
        return new JACrypt().tripleDESDecrypt(src, this.siteKey);
    }

    protected String encrypt(String src) {
        if (this.siteKey == null) {
            return null;
        }
        return new JACrypt().tripleDESEncrypt(src, this.siteKey, true);
    }

    protected boolean hasValidTicket(HttpServletRequest request, HttpSession session) {
        block6: {
            String ticket;
            block7: {
                ticket = request.getParameter("jatkt");
                if (ticket == null || ticket.length() == 0) {
                    return false;
                }
                String decry = this.decrypt(ticket);
                this.userProfile = this.parseUserProfile(decry);
                if (this.userProfile == null) {
                    return false;
                }
                String ses = (String)this.userProfile.get("ja3rdpartySessionID");
                if (ses == null || !ses.equals(session.getId())) {
                    return false;
                }
                String ts = (String)this.userProfile.get("jaThisLoginTime");
                try {
                    Long timestamp = new Long(ts);
                    if (!JAccountManager.isTimestampValid(timestamp)) break block6;
                    if (this.validate(this.userProfile)) break block7;
                    return false;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            this.ticketFromServer = ticket;
            this.returnURL = (String)this.userProfile.get("jaReturnUrl");
            return true;
        }
        return false;
    }

    public boolean isSiteCookieValid(HttpServletRequest request) {
        Cookie[] cks = request.getCookies();
        String siteCookieValue = new String();
        int i = 0;
        while (cks != null && i < cks.length) {
            if (cks[i].getName() != null && cks[i].getName().compareTo("JASiteCookie") == 0) {
                siteCookieValue = cks[i].getValue();
                if ((siteCookieValue = this.decrypt(siteCookieValue)) == null) {
                    return false;
                }
                this.userProfile = this.parseUserProfile(siteCookieValue);
                return this.userProfile != null;
            }
            ++i;
        }
        return false;
    }

    protected static synchronized boolean isTimestampValid(Long timestamp) {
        long ts = timestamp;
        boolean valid = false;
        if (ts - System.currentTimeMillis() < elapsedTimestamp) {
            valid = true;
        }
        return valid;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response, String returnURL) {
        block4: {
            try {
                String lo = request.getParameter("logout");
                if (lo == null || !lo.equals("1")) break block4;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Cookie ck = new Cookie("JASiteCookie", "");
        ck.setMaxAge(0);
        response.addCookie(ck);
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String rurl = String.valueOf(scheme) + "://" + request.getServerName();
        if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
            rurl = String.valueOf(rurl) + ":" + port;
        }
        rurl = String.valueOf(rurl) + returnURL;
        response.sendRedirect(String.valueOf(this.uaBaseURL) + "ulogout?sid=" + this.siteID + "&returl=" + this.encrypt(rurl));
        return false;
    }

    protected Hashtable parseUserProfile(String ticket) {
        if (ticket == null) {
            return null;
        }
        Hashtable<String, String> ret = new Hashtable<String, String>(10);
        StringTokenizer st = new StringTokenizer(ticket, "\n");
        int seq = 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int idx = token.indexOf("=");
            if (idx == -1) continue;
            String name = token.substring(0, idx);
            String value = token.substring(idx + 1);
            if (name == null || seq == 1 && !name.equals("jaThisLoginTime") || seq == 2 && !name.equals("jaLastLoginTime")) {
                ret = null;
                break;
            }
            ++seq;
            ret.put(name, value);
        }
        return ret;
    }

    public void redirectWithoutTicket(HttpServletResponse response) {
        try {
            response.sendRedirect(this.returnURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setSiteCookie(HttpServletResponse response) {
        Cookie ck = new Cookie("JASiteCookie", this.ticketFromServer);
        ck.setMaxAge(-1);
        response.addCookie(ck);
    }

    public Hashtable checkLogin(HttpServletRequest request, HttpServletResponse response, HttpSession session, String returnURL, boolean shouldauth) {
        if (this.hasValidTicket(request, session)) {
            this.setSiteCookie(response);
            this.hasTicketInURL = true;
            return this.userProfile;
        }
        String tkt = request.getParameter("jatkt");
        if (tkt != null && tkt.equals("rejected")) {
            this.hasTicketInURL = false;
            return null;
        }
        if (this.isSiteCookieValid(request)) {
            return this.userProfile;
        }
        this.hasTicketInURL = false;
        try {
            String scheme = request.getScheme();
            int port = request.getServerPort();
            String rurl = String.valueOf(scheme) + "://" + request.getServerName();
            if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
                rurl = String.valueOf(rurl) + ":" + port;
            }
            rurl = String.valueOf(rurl) + returnURL;
            response.sendRedirect("http://jaccount.sjtu.edu.cn/jaccount/jalogin?sid=" + this.siteID + "&returl=" + this.encrypt(rurl) + "&se=" + this.encrypt(session.getId()) + "&shouldauth=" + new Boolean(shouldauth).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validate(Hashtable<String, String> userProfile) {
        String verifier = userProfile.get("verifier");
        if (verifier == null) return false;
        if (verifier.length() == 0) {
            return false;
        }
        try {
            URL url = new URL(this.uaBaseURL.concat("jacheckverifier?verifier=" + verifier));
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.getOutputStream().close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            try {
                String line = reader.readLine();
                if (line == null) return false;
                if (!line.equals(userProfile.get("uid"))) return false;
                return true;
            }
            finally {
                reader.close();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

