/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.HashMap;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ErrorTracker;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.FontFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFontFactory {
    private boolean hasEmbeddedFonts = false;
    private boolean hasNonEmbeddedCIDFonts = false;
    private String fontsInFile;
    private StringBuilder nonEmbeddedCIDFonts = new StringBuilder(200);
    private String baseFont = "";
    private String rawFontName = null;
    private String subFont = null;
    private int origfontType;
    private HashMap fontsLoaded = new HashMap(50);
    PdfObjectReader currentPdfFile;

    public PdfFontFactory(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public PdfFont createFont(PdfObject pdfObject, String string, ObjectStore objectStore, boolean bl, ErrorTracker errorTracker, boolean bl2) throws PdfException {
        PdfFont pdfFont = null;
        this.baseFont = "";
        this.rawFontName = null;
        this.subFont = null;
        int n = -1;
        this.origfontType = -1;
        PdfObject pdfObject2 = pdfObject.getDictionary(-1547306032);
        boolean bl3 = PdfFontFactory.isFontEmbedded(pdfObject);
        boolean bl4 = true;
        while (bl4) {
            bl4 = false;
            if (FontMappings.fontSubstitutionTable != null && !bl3 && pdfObject.getParameterConstant(1147962727) != 1228944679) {
                n = this.getFontMapping(pdfObject, string, n, pdfObject2);
            }
            if (n == -1 && (n = pdfObject.getParameterConstant(1147962727)) == 1228944676) {
                PdfObject pdfObject3 = pdfObject.getDictionary(-1547306032);
                this.origfontType = n = pdfObject3.getParameterConstant(1147962727);
            }
            if (n == -1) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Font type not supported");
                }
                pdfFont = new PdfFont(this.currentPdfFile);
            }
            if (n == 1228944677 || n == -1684566724) {
                n = PdfFontFactory.scanForOpenType(pdfObject, this.currentPdfFile, n);
            }
            try {
                pdfFont = FontFactory.createFont(n, this.currentPdfFile, this.subFont, bl2);
                if (FontMappings.defaultFont != null) {
                    pdfFont.setDefaultDisplayFont(FontMappings.defaultFont);
                }
                pdfFont.createFont(pdfObject, string, bl, objectStore, this.fontsLoaded);
                if (!(n != -1684566726 && n != -1684566724 || bl3 || this.subFont != null)) {
                    this.subFont = pdfFont.getSubstituteFont();
                    if (this.subFont == null) {
                        this.hasNonEmbeddedCIDFonts = true;
                        if (this.nonEmbeddedCIDFonts.length() > 0) {
                            this.nonEmbeddedCIDFonts.append(',');
                        }
                        this.nonEmbeddedCIDFonts.append(this.baseFont);
                    }
                }
                pdfFont.setRawFontName(this.rawFontName);
                if (n == 1228944677 && pdfFont.is1C() && pdfObject.getInt(1283093660) == 32 && pdfObject.getInt(1283093660) == pdfObject.getInt(795440262)) {
                    if (bl3) {
                        bl4 = true;
                        bl3 = false;
                    } else {
                        pdfFont.isFontEmbedded = false;
                    }
                }
                if (pdfFont.isFontEmbedded || !bl3) continue;
                bl4 = true;
                bl3 = false;
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + StandardFonts.getFontypeAsString(n));
                }
                errorTracker.addPageFailureMessage("Problem " + exception + " reading Font type " + StandardFonts.getFontypeAsString(n));
            }
        }
        this.setDetails(string, pdfFont, n, pdfObject2);
        return pdfFont;
    }

    private void setDetails(String string, PdfFont pdfFont, int n, PdfObject pdfObject) {
        String string2;
        String string3 = pdfFont.getFontName();
        if (string3.indexOf(35) != -1) {
            string3 = StringUtils.convertHexChars(string3);
        }
        if (pdfFont.isFontSubstituted()) {
            string2 = string + "  " + string3 + "  " + StandardFonts.getFontypeAsString(this.origfontType) + "  Substituted (" + this.subFont + ' ' + StandardFonts.getFontypeAsString(n) + ')';
        } else if (pdfFont.isFontEmbedded) {
            this.hasEmbeddedFonts = true;
            string2 = pdfFont.is1C() && pdfObject == null ? string + "  " + string3 + " Type1C  Embedded" : string + "  " + string3 + "  " + StandardFonts.getFontypeAsString(n) + "  Embedded";
        } else {
            string2 = string + "  " + string3 + "  " + StandardFonts.getFontypeAsString(n);
        }
        this.fontsInFile = this.fontsInFile == null ? string2 : string2 + '\n' + this.fontsInFile;
    }

    private static int scanForOpenType(PdfObject pdfObject, PdfObjectReader pdfObjectReader, int n) {
        if (n == -1684566724) {
            byte[] byArray;
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            PdfObject pdfObject4 = pdfObject.getDictionary(-1547306032);
            if (pdfObject != null && (pdfObject3 = pdfObject4.getDictionary(-1044665361)) != null && (pdfObject2 = pdfObject3.getDictionary(2021292334)) != null && (byArray = pdfObjectReader.readStream(pdfObject2, true, true, false, false, false, pdfObject2.getCacheName(pdfObjectReader.getObjectReader()))) != null && byArray.length > 3 && byArray[0] == 79 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 79) {
                n = -1684566726;
            }
        } else {
            byte[] byArray;
            PdfObject pdfObject5;
            PdfObject pdfObject6 = pdfObject.getDictionary(-1044665361);
            if (pdfObject6 != null && (pdfObject5 = pdfObject6.getDictionary(2021292335)) != null && (byArray = pdfObjectReader.readStream(pdfObject5, true, true, false, false, false, pdfObject5.getCacheName(pdfObjectReader.getObjectReader()))) != null && byArray.length > 3 && byArray[0] == 79 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 79) {
                n = 1217103210;
            }
        }
        return n;
    }

    private int getFontMapping(PdfObject pdfObject, String string, int n, PdfObject pdfObject2) throws PdfException {
        String string2;
        String string3 = pdfObject2 == null ? pdfObject.getName(678461817) : pdfObject2.getName(678461817);
        if (string3 == null) {
            string3 = pdfObject.getName(506543413);
        }
        if (string3 == null) {
            string3 = string;
        }
        if ((string2 = this.getFontSub(string3)) != null && pdfObject2 == null) {
            if (string2.equals("/Type1") || string2.equals("/Type1C") || string2.equals("/MMType1")) {
                n = 1228944677;
            } else if (string2.equals("/TrueType")) {
                n = 1217103210;
            } else if (string2.equals("/Type3")) {
                n = 1228944679;
            } else {
                throw new RuntimeException("Unknown font type " + string2 + " used for font substitution");
            }
            this.origfontType = pdfObject.getParameterConstant(1147962727);
        } else if (FontMappings.enforceFontSubstitution) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("baseFont=" + this.baseFont + " fonts added= " + FontMappings.fontSubstitutionTable);
            }
            throw new PdfFontException("No substitute Font found for font=" + this.baseFont + '<');
        }
        return n;
    }

    public String getFontSub(String string) throws PdfException {
        if (string.indexOf(35) != -1) {
            string = StringUtils.convertHexChars(string);
        }
        this.rawFontName = string;
        this.baseFont = string.toLowerCase();
        int n = this.baseFont.indexOf(43);
        if (n == 6) {
            this.baseFont = this.baseFont.substring(7);
        }
        String string2 = this.baseFont;
        this.subFont = (String)FontMappings.fontSubstitutionLocation.get(string2);
        String string3 = (String)FontMappings.fontSubstitutionTable.get(string2);
        if (PdfDecoder.isRunningOnMac && string2.equals("zapfdingbats")) {
            string2 = "No match found";
        }
        if (string3 == null) {
            String string4;
            HashMap<String, String> hashMap = new HashMap<String, String>(50);
            while ((string4 = (String)FontMappings.fontSubstitutionAliasTable.get(string2)) != null) {
                string2 = string4;
                String string5 = (String)FontMappings.fontSubstitutionTable.get(string2);
                if (string5 != null) {
                    string3 = string5;
                    this.subFont = (String)FontMappings.fontSubstitutionLocation.get(string2);
                }
                if (hashMap.containsKey(string2)) {
                    StringBuilder stringBuilder = new StringBuilder("[PDF] Circular font mapping for fonts");
                    for (Object k : hashMap.keySet()) {
                        stringBuilder.append(' ');
                        stringBuilder.append(k);
                    }
                    throw new PdfException(stringBuilder.toString());
                }
                hashMap.put(string4, "x");
            }
        }
        return string3;
    }

    private static boolean isFontEmbedded(PdfObject pdfObject) {
        PdfObject pdfObject2;
        int n = pdfObject.getParameterConstant(1147962727);
        if (n == 1228944676) {
            pdfObject = pdfObject.getDictionary(-1547306032);
        }
        if ((pdfObject2 = pdfObject.getDictionary(-1044665361)) == null) {
            return false;
        }
        return pdfObject2.hasStream();
    }

    public String getnonEmbeddedCIDFonts() {
        return this.nonEmbeddedCIDFonts.toString();
    }

    public String getFontsInFile() {
        return this.fontsInFile;
    }

    public void resetfontsInFile() {
        this.fontsInFile = "";
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public boolean hasNonEmbeddedCIDFonts() {
        return this.hasNonEmbeddedCIDFonts;
    }

    public String getMapFont() {
        return this.subFont;
    }
}

