/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public class PdfKeyPairsIterator {
    private byte[][] keys;
    private byte[][] values;
    private PdfObject[] objs;
    int maxCount;
    int current = 0;

    public PdfKeyPairsIterator(byte[][] byArray, byte[][] byArray2, PdfObject[] pdfObjectArray) {
        this.keys = byArray;
        this.values = byArray2;
        this.objs = pdfObjectArray;
        if (byArray != null) {
            this.maxCount = byArray.length;
        }
        this.current = 0;
    }

    public int getTokenCount() {
        return this.maxCount;
    }

    public void nextPair() {
        if (this.current < this.maxCount) {
            ++this.current;
        } else {
            throw new RuntimeException("No keys left in PdfKeyPairsIterator");
        }
    }

    public String getNextKeyAsString() {
        return new String(this.keys[this.current]);
    }

    public int getNextKeyAsNumber() {
        int n = this.keys[this.current].length;
        boolean bl = this.isNextKeyANumber();
        if (!bl) {
            if (this.keys[this.current].length != 1) {
                throw new RuntimeException("Unexpected value in getNextKeyAsNumber >" + new String(this.keys[this.current]) + '<');
            }
            return this.keys[this.current][0] & 0xFF;
        }
        return NumberUtils.parseInt(0, n, this.keys[this.current]);
    }

    public boolean isNextKeyANumber() {
        int n = this.keys[this.current].length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = this.keys[this.current][i];
            if (by >= 48 && by <= 57) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public boolean hasMorePairs() {
        return this.current < this.maxCount;
    }

    public String getNextValueAsString() {
        if (this.values[this.current] == null) {
            return null;
        }
        return new String(this.values[this.current]);
    }

    public PdfObject getNextValueAsDictionary() {
        return this.objs[this.current];
    }
}

