/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ArrayDecoder
extends ObjectDecoder {
    private float[] floatValues = null;
    private int[] intValues = null;
    private double[] doubleValues = null;
    private byte[][] mixedValues = null;
    private byte[][] keyValues = null;
    private byte[][] stringValues = null;
    private boolean[] booleanValues = null;
    private Object[] objectValues = null;
    private int i;
    private int endPoint;
    private int type;
    private int keyReached = -1;
    private Object[] objectValuesArray = null;

    public ArrayDecoder(PdfFileReader pdfFileReader, int n, int n2, int n3) {
        super(pdfFileReader);
        this.i = n;
        this.endPoint = n2;
        this.type = n3;
    }

    public ArrayDecoder(PdfFileReader pdfFileReader, int n, int n2, int n3, Object[] objectArray, int n4) {
        super(pdfFileReader);
        this.i = n;
        this.endPoint = n2;
        this.type = n3;
        this.objectValuesArray = objectArray;
        this.keyReached = n4;
    }

    public int readArray(boolean bl, byte[] byArray, PdfObject pdfObject, int n) {
        boolean bl2;
        if ((this.type != 14 || byArray[this.i] != 60) && byArray[this.i] != 91 && byArray[this.i] != 60) {
            ++this.i;
        }
        if (byArray[this.i] == 91 && byArray[this.i + 1] == 93) {
            return this.i + 1;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        boolean bl3 = false;
        boolean bl4 = n == 456733763 || n == 1044338049;
        int n2 = 0;
        int n3 = 0;
        while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32) {
            ++this.i;
        }
        if (byArray[this.i] == 37) {
            this.skipComment(byArray);
        }
        int n4 = this.i;
        int n5 = this.i;
        byte[] byArray2 = byArray;
        boolean bl5 = bl2 = byArray[this.i] != 91 && byArray[this.i] != 40 && n != 489767739 && n != 9250 && byArray[0] != 0;
        if (byArray[this.i] == 110 && byArray[this.i + 1] == 117 && byArray[this.i + 2] == 108 && byArray[this.i + 2] == 108) {
            bl2 = false;
            n3 = 1;
        }
        if (bl2) {
            bl2 = this.handleIndirect(this.endPoint, byArray, false);
        }
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = true;
        int n6 = -1;
        if ((byArray[this.i] == 47 || byArray[this.i] == 40 || byArray[this.i] == 60 || byArray[this.i] == 60 && byArray[this.i + 1] == 102 && byArray[this.i + 2] == 101 && byArray[this.i + 3] == 102 && byArray[this.i + 4] == 102) && this.type != 20 && n != 9250) {
            n3 = 1;
            bl6 = true;
        } else {
            int n7;
            int n8;
            int n9;
            int n10 = -1;
            if (bl2) {
                n9 = this.i;
                while (byArray[this.i] != 10 && byArray[this.i] != 13 && byArray[this.i] != 32 && byArray[this.i] != 47 && byArray[this.i] != 60 && byArray[this.i] != 62) {
                    ++this.i;
                }
                n8 = NumberUtils.parseInt(n4, this.i, byArray);
                while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32 || byArray[this.i] == 47 || byArray[this.i] == 60) {
                    ++this.i;
                }
                n4 = this.i;
                while (byArray[this.i] != 10 && byArray[this.i] != 13 && byArray[this.i] != 32 && byArray[this.i] != 47 && byArray[this.i] != 60 && byArray[this.i] != 62) {
                    ++this.i;
                }
                n7 = NumberUtils.parseInt(n4, this.i, byArray);
                while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32 || byArray[this.i] == 47 || byArray[this.i] == 60) {
                    ++this.i;
                }
                if (byArray[this.i] != 82) {
                    throw new RuntimeException(padding + "4. Unexpected value " + (char)byArray[this.i] + " in file - please send to IDRsolutions for analysis");
                }
                if (bl && !bl4) {
                    return this.i;
                }
                byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n8, n7), n8, n7);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
                    }
                    return byArray.length;
                }
                n5 = 0;
                while (byArray2[n5] != 91) {
                    if (byArray2[n5] == 37) {
                        while (byArray2[++n5] != 13 && byArray2[n5] != 10) {
                        }
                        while (byArray2[n5] == 13 || byArray2[n5] == 10) {
                            ++n5;
                        }
                        --n5;
                    }
                    if (byArray2[n5] == 110 && byArray2[n5 + 1] == 117 && byArray2[n5 + 2] == 108 && byArray2[n5 + 3] == 108) break;
                    if (byArray2[n5] == 47) {
                        --n5;
                        bl7 = true;
                        break;
                    }
                    if (byArray2[n5] == 60 && byArray2[n5 + 1] == 60 || n5 + 4 < byArray2.length && byArray2[n5 + 3] == 60 && byArray2[n5 + 4] == 60) {
                        n10 = this.i;
                        n5 = n9;
                        byArray2 = byArray;
                        break;
                    }
                    ++n5;
                }
            }
            if (n5 < 0) {
                n5 = 0;
            }
            n9 = 0;
            while (byArray2[n5] == 10 || byArray2[n5] == 13 || byArray2[n5] == 32 || byArray2[n5] == 91 && n9 == 0) {
                if (byArray2[n5] == 91) {
                    n9 = 1;
                }
                ++n5;
            }
            n6 = n5;
            n7 = 1;
            int n11 = byArray2.length;
            while (n6 < n11 && byArray2[n6] != 93) {
                int n12;
                boolean bl9 = false;
                while (byArray2[n6] == 60 && byArray2[n6 + 1] == 60) {
                    n12 = 1;
                    ++n3;
                    while (n12 > 0) {
                        if (byArray2[++n6] == 60 && byArray2[n6 + 1] == 60) {
                            ++n6;
                            ++n12;
                            continue;
                        }
                        if (byArray2[n6] != 62 || byArray2[n6 - 1] != 62) continue;
                        ++n6;
                        --n12;
                    }
                    if (this.type != 14) continue;
                    --n6;
                }
                if (this.type != 18 && byArray2[n6] == 110 && byArray2[n6 + 1] == 117 && byArray2[n6 + 2] == 108 && byArray2[n6 + 3] == 108) {
                    n12 = 93;
                    if (n == 826881374 || n == 1110717793) {
                        for (int i = n6 + 3; i < byArray2.length; ++i) {
                            if (byArray2[i] == 10 || byArray2[i] == 13 || byArray2[i] == 32 || byArray2[i] == 9) continue;
                            n12 = byArray2[i];
                            i = byArray2.length;
                        }
                    }
                    if (n12 == 93) {
                        bl8 = true;
                        n3 = 1;
                        break;
                    }
                    bl8 = false;
                    n6 += 4;
                    n7 = 1;
                    continue;
                }
                if (bl7 && (byArray2[n6] == 32 || byArray2[n6] == 13 || byArray2[n6] == 10) || n10 != -1 && n6 > n10) break;
                if (this.type == 14) {
                    if (byArray2[n6] == 82 || (n == 9250 || n == 1248888446) && byArray2[n6] == 47) {
                        ++n3;
                    }
                } else if (byArray2[n6] == 40) {
                    ++n3;
                    while (byArray2[n6] != 41 || ObjectUtils.isEscaped(byArray2, n6)) {
                        ++n6;
                        n7 = 1;
                    }
                } else if (byArray2[n6] == 60) {
                    ++n3;
                    while (byArray2[n6] != 62) {
                        ++n6;
                        n7 = 1;
                    }
                } else if (byArray2[n6] == 91) {
                    ++n3;
                    n12 = 1;
                    while (++n6 != byArray2.length) {
                        if (byArray2[n6] == 93) {
                            --n12;
                        } else if (byArray2[n6] == 91) {
                            ++n12;
                        }
                        if (n12 != 0) continue;
                    }
                    bl9 = true;
                    n7 = 1;
                } else {
                    int n13 = n8 = byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32 || byArray2[n6] == 47 ? 1 : 0;
                    if (n7 != 0 && n8 == 0) {
                        if ((this.type == 18 || this.type == 22) && byArray2[n6] == 82 && byArray2[n6 - 1] != 47) {
                            hashMap.put(--n3 - 1, "x");
                        } else {
                            ++n3;
                        }
                    }
                    n7 = n8;
                }
                if (!bl9 && n6 < n11 && byArray2[n6] == 93 && this.type != 14) {
                    n12 = n6 - 1;
                    while (byArray2[n12] == 13 || byArray2[n12] == 10 || byArray2[n12] == 32) {
                        --n12;
                    }
                    if (byArray2[n12] != 91) break;
                    n3 = 0;
                    break;
                }
                ++n6;
            }
            if (n3 == 0) {
                // empty if block
            }
        }
        if (bl && !bl4) {
            return n6;
        }
        this.initObjectArray(n3);
        if (byArray2[n5] == 110 && byArray2[n5 + 1] == 117 && byArray2[n5 + 2] == 108 && byArray2[n5 + 3] == 108 && bl8 && (this.type != 22 || n3 == 1)) {
            n5 += 3;
            if (this.type == 18) {
                this.mixedValues[n2] = null;
            } else if (this.type == 14) {
                this.keyValues[n2] = null;
            } else if (this.type == 20) {
                this.stringValues[n2] = null;
            } else if (this.type == 22) {
                this.objectValues[n2] = null;
            }
        } else {
            n5 = this.setValue(bl, byArray, pdfObject, n, hashMap, bl3, false, n2, n3, n5, byArray2, bl6, n6);
        }
        if (!bl2) {
            this.i = n5;
        }
        if (this.type == 10) {
            pdfObject.setFloatArray(n, this.floatValues);
        } else if (this.type == 9) {
            pdfObject.setIntArray(n, this.intValues);
        } else if (this.type == 12) {
            pdfObject.setBooleanArray(n, this.booleanValues);
        } else if (this.type == 16) {
            pdfObject.setDoubleArray(n, this.doubleValues);
        } else if (this.type == 18) {
            pdfObject.setMixedArray(n, this.mixedValues);
        } else if (this.type == 14) {
            this.setKeyArrayValue(pdfObject, n, n3);
        } else if (this.type == 20) {
            pdfObject.setStringArray(n, this.stringValues);
        } else if (this.type == 22) {
            this.setObjectArrayValue(pdfObject, n, this.objectValuesArray, this.keyReached, false);
        }
        if (this.i < byArray.length && (byArray[this.i] == 47 || byArray[this.i] == 62 || byArray[this.i] >= 48 && byArray[this.i] <= 57)) {
            --this.i;
        }
        return this.i;
    }

    private int setValue(boolean bl, byte[] byArray, PdfObject pdfObject, int n, Map map, boolean bl2, boolean bl3, int n2, int n3, int n4, byte[] byArray2, boolean bl4, int n5) {
        while (byArray2[n4] != 93 && (n5 <= -1 || n4 < n5)) {
            int n6;
            while (byArray2[n4] == 10 || byArray2[n4] == 13 || byArray2[n4] == 32 || byArray2[n4] == 47) {
                ++n4;
            }
            int n7 = n4;
            if (bl3) {
                System.out.print("j2=" + n4 + " value=" + (char)byArray2[n4]);
            }
            boolean bl5 = byArray2[n4 - 1] == 47;
            boolean bl6 = false;
            if (this.type == 14 || (this.type == 18 || this.type == 22) && (map.containsKey(n2) || n == 1110717793 && byArray2[n4] >= 48 && byArray2[n4] <= 57 || byArray2[n4] == 60 && byArray2[n4 + 1] == 60)) {
                if (bl3) {
                    System.out.println("ref currentElement=" + n2);
                }
                while (byArray2[n4] != 82 && byArray2[n4] != 93) {
                    if (byArray2[n4] == 60 && byArray2[n4 + 1] == 60) {
                        n6 = 1;
                        if (bl3) {
                            System.out.println(padding + "Reading Direct value");
                        }
                        while (n6 > 0) {
                            if (byArray2[++n4] == 60 && byArray2[n4 + 1] == 60) {
                                ++n4;
                                ++n6;
                                continue;
                            }
                            if (byArray2[n4] != 62 || byArray2[n4 + 1] != 62) continue;
                            ++n4;
                            --n6;
                        }
                        break;
                    }
                    if (bl5 && n == 9250 && byArray2[n4 + 1] == 32) break;
                    ++n4;
                }
                ++n4;
            } else if (byArray2[n4] == 40) {
                n7 = n4 + 1;
                while (byArray2[n4] != 41 || ObjectUtils.isEscaped(byArray2, n4)) {
                    ++n4;
                }
                bl2 = false;
            } else if (byArray2[n4] == 91 && this.type == 18 && n == 826094945) {
                n7 = n4;
                while (byArray2[n4] != 93) {
                    ++n4;
                }
                ++n4;
            } else if (byArray2[n4] == 60) {
                bl2 = true;
                n7 = n4 + 1;
                while (byArray2[n4] != 62) {
                    if (byArray2[n4] == 47) {
                        bl2 = false;
                    }
                    ++n4;
                }
            } else if (byArray2[n4] == 91 && this.type == 22) {
                int n8;
                n6 = n4 + 1;
                int n9 = 1;
                while (++n6 != byArray2.length) {
                    if (byArray2[n6] == 93) {
                        --n9;
                    } else if (byArray2[n6] == 91) {
                        ++n9;
                    }
                    if (n9 != 0) continue;
                }
                ++n6;
                if (bl3) {
                    padding = padding + "   ";
                }
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n4, n6, this.type, this.objectValues, n2);
                n4 = arrayDecoder.readArray(bl, byArray2, pdfObject, n);
                if (bl3 && (n8 = padding.length()) > 3) {
                    padding = padding.substring(0, n8 - 3);
                }
                if (byArray2[n4] != 91) {
                    ++n4;
                }
                bl6 = true;
                while (n4 < byArray2.length && byArray2[n4] == 93) {
                    ++n4;
                }
            } else if (!bl5 && n3 - n2 == 1 && this.type == 18) {
                while (byArray2[n4] != 93 && byArray2[n4] != 47 && (byArray2[n4] != 62 || byArray2[n4 + 1] != 62)) {
                    ++n4;
                }
            } else {
                if (this.type == 22 && byArray2[n4] == 110 && byArray2[n4 + 1] == 117 && byArray2[n4 + 2] == 108 && byArray2[n4 + 3] == 108) {
                    n4 += 4;
                    this.objectValues[n2] = null;
                    ++n2;
                    continue;
                }
                while (byArray2[n4] != 10 && byArray2[n4] != 13 && byArray2[n4] != 32 && byArray2[n4] != 93 && byArray2[n4] != 47 && (byArray2[n4] != 62 || byArray2[n4 + 1] != 62) && ++n4 != byArray2.length) {
                }
            }
            if (this.type == 10) {
                this.floatValues[n2] = NumberUtils.parseFloat(n7, n4, byArray2);
            } else if (this.type == 9) {
                this.intValues[n2] = NumberUtils.parseInt(n7, n4, byArray2);
            } else if (this.type == 12) {
                if (byArray[n7] == 116 && byArray[n7 + 1] == 114 && byArray[n7 + 2] == 117 && byArray[n7 + 3] == 101) {
                    this.booleanValues[n2] = true;
                }
            } else if (this.type == 16) {
                this.doubleValues[n2] = NumberUtils.parseFloat(n7, n4, byArray2);
            } else if (!bl6) {
                n4 = this.setObjectArrayValue(pdfObject, n, bl2, bl3, n2, n3, n4, byArray2, bl4, n7);
            }
            ++n2;
            if (bl3) {
                System.out.println(padding + "roll onto ==================================>" + n2 + '/' + n3);
            }
            if (n2 != n3) continue;
            break;
        }
        return n4;
    }

    private int setObjectArrayValue(PdfObject pdfObject, int n, boolean bl, boolean bl2, int n2, int n3, int n4, byte[] byArray, boolean bl3, int n5) {
        if (n5 > 0 && byArray[n5 - 1] == 47) {
            --n5;
        }
        if (n5 > 0 && byArray[n5] == 91 && n != 826094945) {
            ++n5;
        }
        if (n == 1110717793 || n == 826881374) {
            while (byArray[n5] == 110 && byArray[n5 + 1] == 117 && byArray[n5 + 2] == 108 && byArray[n5 + 3] == 108) {
                n5 += 4;
                while (n5 >= 0 && (byArray[n5] == 32 || byArray[n5] == 10 || byArray[n5] == 13 || byArray[n5] == 9)) {
                    ++n5;
                }
            }
        }
        while (n5 >= 0 && (byArray[n5] == 32 || byArray[n5] == 10 || byArray[n5] == 13 || byArray[n5] == 9)) {
            ++n5;
        }
        byte[] byArray2 = ObjectUtils.readEscapedValue(n4, byArray, n5, n == 6420);
        if (bl2) {
            System.out.println(padding + "<1.Element -----" + n2 + '/' + n3 + "( j2=" + n4 + " ) value=" + new String(byArray2) + '<');
        }
        if (n4 != byArray.length) {
            if (byArray[n4] == 62) {
                ++n4;
            } else if (byArray[n4] == 41) {
                block27: {
                    ++n4;
                    try {
                        if (!pdfObject.isInCompressedStream() && this.decryption != null) {
                            byArray2 = this.decryption.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (PdfSecurityException pdfSecurityException) {
                        if (!LogWriter.isOutput()) break block27;
                        LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
                    }
                }
                if (n == 1110717793) {
                    byArray2 = StringUtils.toBytes(StringUtils.getTextString(byArray2, false));
                }
            }
        }
        if (bl3) {
            this.i = n4;
        }
        if (this.type == 18) {
            this.mixedValues[n2] = byArray2;
        } else if (this.type == 14) {
            this.keyValues[n2] = ObjectUtils.convertReturnsToSpaces(byArray2);
        } else if (this.type == 20) {
            if (bl) {
                String string = new String(byArray2);
                byte[] byArray3 = new byte[byArray2.length / 2];
                for (int i = 0; i < byArray2.length; i += 2) {
                    if (i + 2 > byArray2.length) continue;
                    if (string.charAt(i) == '\n') {
                        ++i;
                    }
                    String string2 = string.substring(i, i + 2);
                    byArray3[i / 2] = (byte)Integer.parseInt(string2, 16);
                }
                byArray2 = byArray3;
            }
            this.stringValues[n2] = byArray2;
        } else if (this.type == 22) {
            this.objectValues[n2] = byArray2;
            if (bl2) {
                System.out.println(padding + "objectValues[" + n2 + "]=" + Arrays.toString(this.objectValues) + ' ');
            }
        }
        return n4;
    }

    private void initObjectArray(int n) {
        if (this.type == 10) {
            this.floatValues = new float[n];
        } else if (this.type == 9) {
            this.intValues = new int[n];
        } else if (this.type == 12) {
            this.booleanValues = new boolean[n];
        } else if (this.type == 16) {
            this.doubleValues = new double[n];
        } else if (this.type == 18) {
            this.mixedValues = new byte[n][];
        } else if (this.type == 14) {
            this.keyValues = new byte[n][];
        } else if (this.type == 20) {
            this.stringValues = new byte[n][];
        } else if (this.type == 22) {
            this.objectValues = new Object[n];
        }
    }

    private boolean handleIndirect(int n, byte[] byArray, boolean bl) {
        boolean bl2 = true;
        int n2 = this.i;
        int n3 = byArray.length;
        while (byArray[n2] != 93 && ++n2 < n && n2 < n3 && (byArray[n2] != 82 || byArray[n2 - 1] != 32 && byArray[n2 - 1] != 10 && byArray[n2 - 1] != 13)) {
            if (byArray[n2] == 62 && byArray[n2 - 1] == 62) {
                bl2 = false;
                if (!bl) break;
                System.out.println(padding + "1. rejected as indirect ref");
                break;
            }
            if (byArray[n2] != 47) continue;
            bl2 = false;
            if (!bl) break;
            System.out.println(padding + "2. rejected as indirect ref - starts with /");
            break;
        }
        return bl2;
    }

    private void skipComment(byte[] byArray) {
        while (byArray[this.i] != 10 && byArray[this.i] != 13) {
            ++this.i;
        }
        while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32) {
            ++this.i;
        }
    }

    private void setKeyArrayValue(PdfObject pdfObject, int n, int n2) {
        if (this.type == 14 && n2 == 1 && n == 1044338049) {
            PdfObject pdfObject2;
            byte[] byArray;
            int n3;
            byte[] byArray2 = this.keyValues[0];
            if (byArray2 != null && byArray2[(n3 = byArray2.length) - 1] == 82 && (byArray = this.objectReader.readObjectData(pdfObject2 = new PdfObject(new String(byArray2)))) != null) {
                int n4 = 0;
                int n5 = byArray.length;
                boolean bl = false;
                while (n4 < n5 && ++n4 != byArray.length) {
                    if (byArray[n4] == 91) {
                        bl = true;
                        break;
                    }
                    if (byArray[n4 - 1] != 60 || byArray[n4] != 60) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n4, n5, 14);
                    arrayDecoder.readArray(false, byArray, pdfObject, n);
                } else {
                    pdfObject.setKeyArray(n, this.keyValues);
                }
            }
        } else {
            pdfObject.setKeyArray(n, this.keyValues);
        }
    }

    private void setObjectArrayValue(PdfObject pdfObject, int n, Object[] objectArray, int n2, boolean bl) {
        int n3;
        byte[] byArray;
        if (n == 1110717793 && this.objectValues != null && this.objectValues.length == 1 && this.objectValues[0] instanceof byte[] && (byArray = (byte[])this.objectValues[0])[(n3 = byArray.length) - 1] == 82) {
            OCObject oCObject = new OCObject(new String(byArray));
            byte[] byArray2 = this.objectReader.readObjectData(oCObject);
            int n4 = 0;
            int n5 = byArray2.length;
            boolean bl2 = false;
            while (n4 < n5 && ++n4 != byArray2.length) {
                if (byArray2[n4] != 91) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n4, n5, 22);
                arrayDecoder.readArray(false, byArray2, pdfObject, n);
            }
            this.objectValues = null;
        }
        if (objectArray != null) {
            objectArray[n2] = this.objectValues;
            if (bl) {
                System.out.println(padding + "set Object objectValuesArray[" + n2 + "]=" + Arrays.toString(this.objectValues));
            }
        } else if (this.objectValues != null) {
            pdfObject.setObjectArray(n, this.objectValues);
            if (bl) {
                System.out.println(padding + n + " set Object value=" + Arrays.toString(this.objectValues));
            }
        }
    }

    private void showValues() {
        String string = "[";
        if (this.type == 10) {
            for (float f : this.floatValues) {
                string = string + f + ' ';
            }
        } else if (this.type == 16) {
            for (double d : this.doubleValues) {
                string = string + d + ' ';
            }
        } else if (this.type == 9) {
            for (int n : this.intValues) {
                string = string + n + ' ';
            }
        } else if (this.type == 12) {
            for (boolean bl : this.booleanValues) {
                string = string + bl + ' ';
            }
        } else if (this.type == 18) {
            for (byte[] byArray : this.mixedValues) {
                string = byArray == null ? string + "null " : string + new String(byArray) + ' ';
            }
        } else if (this.type == 14) {
            for (byte[] byArray : this.keyValues) {
                string = byArray == null ? string + "null " : string + new String(byArray) + ' ';
            }
        } else if (this.type == 20) {
            for (byte[] byArray : this.stringValues) {
                string = byArray == null ? string + "null " : string + new String(byArray) + ' ';
            }
        } else if (this.type == 22) {
            string = ObjectUtils.showMixedValuesAsString(this.objectValues, "");
        }
        string = string + " ]";
        System.out.println(padding + "values=" + string);
    }
}

