/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;
import org.jpedal.utils.LogWriter;

public class CFFWriter
extends Type1
implements FontTableWriter {
    private static final boolean debugTopDictOffsets = false;
    private String name;
    private byte[][] subrs;
    private final String[] glyphNames;
    private byte[][] charstrings;
    private int[] charstringXDisplacement;
    private int[] charstringYDisplacement;
    private byte[] header;
    private byte[] nameIndex;
    private byte[] topDictIndex;
    private byte[] globalSubrIndex;
    private byte[] encodings;
    private byte[] charsets;
    private byte[] charStringsIndex;
    private byte[] privateDict;
    private byte[] localSubrIndex;
    private byte[] stringIndex;
    private final ArrayList<String> strings = new ArrayList();
    private int[] widthX;
    private int[] widthY;
    private int[] lsbX;
    private int[] lsbY;
    private int defaultWidthX;
    private int nominalWidthX;
    private ArrayList<CharstringElement> currentCharString;
    private int currentCharStringID;
    private float[] bbox = new float[4];
    private boolean inFlex = false;
    private CharstringElement currentFlexCommand;
    private boolean firstArgsAdded = false;
    private double emSquareSize = 1000.0;
    private double scale = 1.0;
    private boolean inSeac = false;

    public CFFWriter(PdfJavaGlyphs pdfJavaGlyphs, String string) {
        String string2;
        int n;
        this.glyphs = pdfJavaGlyphs;
        this.name = string;
        Map map = pdfJavaGlyphs.getCharStrings();
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < map.size(); ++n) {
            string2 = (String)objectArray[n];
            if (string2.startsWith("subrs")) {
                int n5;
                int n6 = Integer.parseInt(string2.replaceAll("[^0-9]", ""));
                if (n6 > n2) {
                    n2 = n6;
                }
                if ((n5 = ((byte[])map.get(string2)).length) <= n3) continue;
                n3 = n5;
                continue;
            }
            ++n4;
        }
        this.subrs = new byte[n2 + 1][];
        this.glyphNames = new String[n4];
        this.charstrings = new byte[n4][];
        this.charstringXDisplacement = new int[n4];
        this.charstringYDisplacement = new int[n4];
        n4 = 0;
        for (n = 0; n < map.size(); ++n) {
            string2 = (String)objectArray[n];
            Object v = map.get(string2);
            byte[] byArray = (byte[])v;
            if (string2.startsWith("subrs")) {
                int n7 = Integer.parseInt(string2.replaceAll("[^0-9]", ""));
                this.subrs[n7] = byArray;
                continue;
            }
            this.glyphNames[n4] = string2;
            this.charstrings[n4] = byArray;
            ++n4;
        }
        this.convertCharstrings();
    }

    private void convertCharstrings() {
        int n;
        int n2;
        Object object;
        block12: {
            try {
                this.widthX = new int[this.charstrings.length];
                this.widthY = new int[this.charstrings.length];
                this.lsbX = new int[this.charstrings.length];
                this.lsbY = new int[this.charstrings.length];
                object = new byte[this.charstrings.length][];
                for (n2 = 0; n2 < this.charstrings.length; ++n2) {
                    object[n2] = this.convertCharstring(this.charstrings[n2], n2);
                }
                if (this.bbox[2] - this.bbox[0] > 1100.0f) {
                    this.emSquareSize = this.bbox[2] - this.bbox[0];
                    this.scale = 1.0 / (this.emSquareSize / 1000.0);
                    this.charstringXDisplacement = new int[this.charstringXDisplacement.length];
                    this.charstringYDisplacement = new int[this.charstringYDisplacement.length];
                    this.bbox = new float[4];
                    for (n2 = 0; n2 < this.charstrings.length; ++n2) {
                        object[n2] = this.convertCharstring(this.charstrings[n2], n2);
                    }
                    this.charstrings = (byte[][])object;
                } else {
                    this.charstrings = (byte[][])object;
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block12;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        object = new HashMap();
        for (n2 = 0; n2 < this.charstrings.length; ++n2) {
            Integer n3 = (Integer)((HashMap)object).get(this.widthX[n2]);
            n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
            ((HashMap)object).put(this.widthX[n2], n3);
        }
        Object[] objectArray = ((HashMap)object).keySet().toArray();
        int n4 = 0;
        this.defaultWidthX = 0;
        for (Object object2 : objectArray) {
            int n5 = (Integer)((HashMap)object).get(object2);
            if (n5 <= n4) continue;
            n4 = n5;
            this.defaultWidthX = (Integer)object2;
        }
        int n6 = 0;
        int n7 = 0;
        for (Object object3 : objectArray) {
            if ((Integer)object3 == this.defaultWidthX) continue;
            ++n7;
            n6 += ((Integer)object3).intValue();
        }
        this.nominalWidthX = n7 != 0 ? n6 / n7 : 0;
        for (n = 0; n < this.widthX.length; ++n) {
            this.widthX[n] = this.widthX[n] == this.defaultWidthX ? Integer.MIN_VALUE : this.widthX[n] - this.nominalWidthX;
        }
        for (n = 0; n < this.widthX.length; ++n) {
            if (this.widthX[n] == Integer.MIN_VALUE) continue;
            byte[] byArray = FontWriter.setCharstringType2Number(this.widthX[n]);
            byte[] byArray2 = new byte[byArray.length + this.charstrings[n].length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(this.charstrings[n], 0, byArray2, byArray.length, this.charstrings[n].length);
            this.charstrings[n] = byArray2;
        }
        for (n = 0; n < this.charstrings.length; ++n) {
            if (this.charstrings[n][this.charstrings[n].length - 1] == 14) continue;
            byte[] byArray = new byte[this.charstrings[n].length + 1];
            System.arraycopy(this.charstrings[n], 0, byArray, 0, this.charstrings[n].length);
            byArray[byArray.length - 1] = 14;
            this.charstrings[n] = byArray;
        }
    }

    private byte[] convertCharstring(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        block8: {
            CharstringElement charstringElement;
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.currentCharString = new ArrayList();
            this.currentCharStringID = n;
            for (int i = 0; i < nArray.length; i += charstringElement.getLength()) {
                charstringElement = new CharstringElement(nArray, i);
            }
            if (this.emSquareSize != 1000.0 && !this.inSeac) {
                for (CharstringElement charstringElement2 : this.currentCharString) {
                    charstringElement2.scale();
                }
                this.widthX[n] = (int)(this.scale * (double)this.widthX[n]);
                this.widthY[n] = (int)(this.scale * (double)this.widthY[n]);
                this.lsbX[n] = (int)(this.scale * (double)this.lsbX[n]);
                this.lsbY[n] = (int)(this.scale * (double)this.lsbY[n]);
            }
            for (CharstringElement charstringElement2 : this.currentCharString) {
                int[] nArray2 = charstringElement2.getDisplacement();
                int n3 = n;
                this.charstringXDisplacement[n3] = this.charstringXDisplacement[n3] + nArray2[0];
                int n4 = n;
                this.charstringYDisplacement[n4] = this.charstringYDisplacement[n4] + nArray2[1];
                this.bbox[0] = (float)this.charstringXDisplacement[n] < this.bbox[0] ? (float)this.charstringXDisplacement[n] : this.bbox[0];
                this.bbox[1] = (float)this.charstringYDisplacement[n] < this.bbox[1] ? (float)this.charstringYDisplacement[n] : this.bbox[1];
                this.bbox[2] = (float)this.charstringXDisplacement[n] > this.bbox[2] ? (float)this.charstringXDisplacement[n] : this.bbox[2];
                this.bbox[3] = (float)this.charstringYDisplacement[n] > this.bbox[3] ? (float)this.charstringYDisplacement[n] : this.bbox[3];
            }
            try {
                for (CharstringElement charstringElement2 : this.currentCharString) {
                    byteArrayOutputStream.write(charstringElement2.getType2Bytes());
                }
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getSIDForString(String string) {
        int n;
        for (n = 0; n < Type1C.type1CStdStrings.length; ++n) {
            if (!string.equals(Type1C.type1CStdStrings[n])) continue;
            return n;
        }
        for (n = 0; n < this.strings.size(); ++n) {
            if (!string.equals(this.strings.get(n))) continue;
            return 391 + n;
        }
        this.strings.add(string);
        return 390 + this.strings.size();
    }

    public byte[] writeTable() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.localSubrIndex = new byte[0];
        this.privateDict = this.localSubrIndex;
        this.charStringsIndex = this.localSubrIndex;
        this.charsets = this.localSubrIndex;
        this.encodings = this.localSubrIndex;
        this.stringIndex = this.localSubrIndex;
        this.globalSubrIndex = this.localSubrIndex;
        this.topDictIndex = this.localSubrIndex;
        this.header = new byte[]{TTFontWriter.setNextUint8(1), TTFontWriter.setNextUint8(0), TTFontWriter.setNextUint8(4), TTFontWriter.setNextUint8(2)};
        this.nameIndex = CFFWriter.createIndex(new byte[][]{this.name.getBytes()});
        this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        this.globalSubrIndex = CFFWriter.createIndex(new byte[0][]);
        this.encodings = CFFWriter.createEncodings();
        this.charsets = this.createCharsets();
        this.charStringsIndex = CFFWriter.createIndex(this.charstrings);
        this.privateDict = this.createPrivateDict();
        this.stringIndex = CFFWriter.createIndex(this.createStrings());
        do {
            byArray2 = new byte[this.privateDict.length];
            System.arraycopy(this.privateDict, 0, byArray2, 0, this.privateDict.length);
            this.privateDict = this.createPrivateDict();
        } while (!Arrays.equals(this.privateDict, byArray2));
        do {
            byArray = new byte[this.topDictIndex.length];
            System.arraycopy(this.topDictIndex, 0, byArray, 0, this.topDictIndex.length);
            this.topDictIndex = CFFWriter.createIndex(new byte[][]{this.createTopDict()});
        } while (!Arrays.equals(byArray, this.topDictIndex));
        byteArrayOutputStream.write(this.header);
        byteArrayOutputStream.write(this.nameIndex);
        byteArrayOutputStream.write(this.topDictIndex);
        byteArrayOutputStream.write(this.stringIndex);
        byteArrayOutputStream.write(this.globalSubrIndex);
        byteArrayOutputStream.write(this.encodings);
        byteArrayOutputStream.write(this.charsets);
        byteArrayOutputStream.write(this.charStringsIndex);
        byteArrayOutputStream.write(this.privateDict);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] createIndex(byte[][] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return new byte[]{0, 0};
        }
        int[] nArray = new int[n2 + 1];
        nArray[0] = 1;
        for (n = 1; n < n2 + 1; ++n) {
            byte[] byArray2 = byArray[n - 1];
            nArray[n] = byArray2 != null ? nArray[n - 1] + byArray2.length : nArray[n - 1];
        }
        n = CFFWriter.getOffsizeForMaxVal(nArray[n2]);
        int n3 = 3 + n * nArray.length + nArray[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(n2));
        byteArrayOutputStream.write(TTFontWriter.setNextUint8(n));
        for (int n5 : nArray) {
            byteArrayOutputStream.write(FontWriter.setUintAsBytes(n5, n));
        }
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) continue;
            byteArrayOutputStream.write(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] createTopDict() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.getSIDForString("1")));
        byteArrayOutputStream.write(0);
        if (this.copyright != null) {
            byteArrayOutputStream.write(FontWriter.set1cNumber(this.getSIDForString(this.copyright)));
            byteArrayOutputStream.write(1);
        }
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.bbox[0]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.bbox[1]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.bbox[2]));
        byteArrayOutputStream.write(FontWriter.set1cNumber((int)this.bbox[3]));
        byteArrayOutputStream.write(5);
        int n = this.header.length + this.nameIndex.length + this.topDictIndex.length + this.stringIndex.length + this.globalSubrIndex.length;
        if (this.encodings.length != 0) {
            byteArrayOutputStream.write(FontWriter.set1cNumber(n));
            byteArrayOutputStream.write(16);
        }
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.encodings.length));
        byteArrayOutputStream.write(15);
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.charsets.length));
        byteArrayOutputStream.write(17);
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.privateDict.length));
        byteArrayOutputStream.write(FontWriter.set1cNumber(n += this.charStringsIndex.length));
        byteArrayOutputStream.write(18);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[][] createStrings() {
        byte[][] byArrayArray = new byte[this.strings.size()][];
        for (int i = 0; i < this.strings.size(); ++i) {
            byArrayArray[i] = this.strings.get(i).getBytes();
        }
        return byArrayArray;
    }

    private byte[] createCharsets() {
        String[] stringArray = null;
        for (int i = 0; i < this.glyphNames.length; ++i) {
            if (!".notdef".equals(this.glyphNames[i])) continue;
            stringArray = new String[this.glyphNames.length - 1];
            System.arraycopy(this.glyphNames, 0, stringArray, 0, i);
            System.arraycopy(this.glyphNames, i + 1, stringArray, i, stringArray.length - i);
        }
        if (stringArray == null) {
            stringArray = this.glyphNames;
        }
        byte[] byArray = new byte[stringArray.length * 2 + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray2 = FontWriter.setUintAsBytes(this.getSIDForString(stringArray[i]), 2);
            byArray[1 + i * 2] = byArray2[0];
            byArray[2 + i * 2] = byArray2[1];
        }
        return byArray;
    }

    private static byte[] createEncodings() {
        return new byte[0];
    }

    private byte[] createPrivateDict() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.defaultWidthX));
        byteArrayOutputStream.write(20);
        byteArrayOutputStream.write(FontWriter.set1cNumber(this.nominalWidthX));
        byteArrayOutputStream.write(21);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte getOffsizeForMaxVal(int n) {
        byte by = 1;
        while (n > 256) {
            by = (byte)(by + 1);
            n /= 256;
        }
        return by;
    }

    public int getIntValue(int n) {
        return -1;
    }

    public String[] getGlyphList() {
        return this.glyphNames;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.widthX.length];
        for (int i = 0; i < this.widthX.length; ++i) {
            nArray[i] = this.widthX[i] == Integer.MIN_VALUE ? this.defaultWidthX : this.widthX[i] + this.nominalWidthX;
        }
        return nArray;
    }

    public int[] getBearings() {
        return this.lsbX;
    }

    public float[] getBBox() {
        return this.bbox;
    }

    public double getEmSquareSize() {
        return this.emSquareSize;
    }

    static /* synthetic */ String[] access$1100(CFFWriter cFFWriter) {
        return cFFWriter.glyphNames;
    }

    static /* synthetic */ int[] access$1200(CFFWriter cFFWriter) {
        return cFFWriter.charstringXDisplacement;
    }

    static /* synthetic */ int[] access$1300(CFFWriter cFFWriter) {
        return cFFWriter.charstringYDisplacement;
    }

    static /* synthetic */ boolean access$1402(CFFWriter cFFWriter, boolean bl) {
        cFFWriter.inSeac = bl;
        return cFFWriter.inSeac;
    }

    static /* synthetic */ byte[][] access$1500(CFFWriter cFFWriter) {
        return cFFWriter.charstrings;
    }

    static /* synthetic */ byte[] access$1600(CFFWriter cFFWriter, byte[] byArray, int n) {
        return cFFWriter.convertCharstring(byArray, n);
    }

    static /* synthetic */ int access$602(CFFWriter cFFWriter, int n) {
        cFFWriter.currentCharStringID = n;
        return cFFWriter.currentCharStringID;
    }

    private class CharstringElement {
        private boolean isCommand = true;
        private String commandName;
        private int numberValue;
        private int length = 1;
        private ArrayList<CharstringElement> args = new ArrayList();
        private final boolean isResult;
        private CharstringElement parent;

        public CharstringElement(int n) {
            this.isResult = false;
            this.isCommand = false;
            this.numberValue = n;
        }

        public CharstringElement(CharstringElement charstringElement) {
            this.isResult = true;
            this.isCommand = false;
            this.parent = charstringElement;
            CFFWriter.this.currentCharString.add(this);
        }

        public CharstringElement(int[] nArray, int n) {
            this.isResult = false;
            CFFWriter.this.currentCharString.add(this);
            int n2 = nArray[n];
            if (n2 >= 32 && n2 <= 246) {
                this.numberValue = n2 - 139;
                this.isCommand = false;
            } else if (n2 >= 247 && n2 <= 250 || n2 >= 251 && n2 <= 254) {
                this.numberValue = n2 < 251 ? (n2 - 247) * 256 + nArray[n + 1] + 108 : -((n2 - 251) * 256) - nArray[n + 1] - 108;
                this.isCommand = false;
                this.length = 2;
            } else {
                boolean bl = false;
                block0 : switch (n2) {
                    case 1: {
                        this.commandName = "hstem";
                        this.claimArguments(2, true, true);
                        break;
                    }
                    case 3: {
                        this.commandName = "vstem";
                        this.claimArguments(2, true, true);
                        break;
                    }
                    case 4: {
                        int n32;
                        this.commandName = "vmoveto";
                        this.claimArguments(1, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            n32 = ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int n4 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n32));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n4));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 5: {
                        this.commandName = "rlineto";
                        this.claimArguments(2, true, true);
                        bl = true;
                        break;
                    }
                    case 6: {
                        this.commandName = "hlineto";
                        this.claimArguments(1, true, true);
                        break;
                    }
                    case 7: {
                        this.commandName = "vlineto";
                        this.claimArguments(1, true, true);
                        break;
                    }
                    case 8: {
                        this.commandName = "rrcurveto";
                        this.claimArguments(6, true, true);
                        bl = true;
                        break;
                    }
                    case 9: {
                        this.commandName = "closepath";
                        this.claimArguments(0, false, true);
                        break;
                    }
                    case 10: {
                        CharstringElement charstringElement;
                        int n3;
                        this.commandName = "callsubr";
                        this.claimArguments(1, false, false);
                        int n32 = this.args.get((int)0).numberValue;
                        if (!CFFWriter.this.inFlex && n32 == 1) {
                            this.args.clear();
                            this.commandName = "flex";
                            CFFWriter.this.currentFlexCommand = this;
                            CFFWriter.this.inFlex = true;
                        }
                        if (CFFWriter.this.inFlex && n32 >= 0 && n32 <= 2) {
                            if (n32 != 0) break;
                            this.claimArguments(3, false, false);
                            if (this.args.size() >= 4) {
                                ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(3));
                            } else {
                                ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                            }
                            CFFWriter.this.inFlex = false;
                            CFFWriter.this.firstArgsAdded = false;
                            break;
                        }
                        byte[] byArray = CFFWriter.this.subrs[n32];
                        int[] object = new int[byArray.length];
                        for (n3 = 0; n3 < byArray.length; ++n3) {
                            object[n3] = byArray[n3];
                            if (object[n3] >= 0) continue;
                            int n4 = n3;
                            object[n4] = object[n4] + 256;
                        }
                        for (int i = 0; i < object.length; i += charstringElement.length) {
                            charstringElement = new CharstringElement(object, i);
                        }
                        break;
                    }
                    case 11: {
                        this.commandName = "return";
                        break;
                    }
                    case 12: {
                        int n3;
                        this.length = 2;
                        switch (nArray[n + 1]) {
                            case 0: {
                                this.commandName = "dotsection";
                                this.claimArguments(0, false, true);
                                break;
                            }
                            case 1: {
                                this.commandName = "vstem3";
                                this.claimArguments(6, true, true);
                                break;
                            }
                            case 2: {
                                this.commandName = "hstem3";
                                this.claimArguments(6, true, true);
                                break;
                            }
                            case 6: {
                                this.commandName = "seac";
                                this.claimArguments(5, true, true);
                                break;
                            }
                            case 7: {
                                this.commandName = "sbw";
                                this.claimArguments(4, true, true);
                                ((CFFWriter)CFFWriter.this).lsbX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(0).evaluate();
                                ((CFFWriter)CFFWriter.this).lsbY[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(1).evaluate();
                                ((CFFWriter)CFFWriter.this).widthX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(2).evaluate();
                                ((CFFWriter)CFFWriter.this).widthY[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(3).evaluate();
                                if (CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID] == 0) break;
                                this.commandName = "rmoveto";
                                this.args.clear();
                                this.args.add(new CharstringElement(CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID]));
                                this.args.add(new CharstringElement(CFFWriter.this.lsbY[CFFWriter.this.currentCharStringID]));
                                break;
                            }
                            case 12: {
                                this.commandName = "div";
                                this.claimArguments(2, false, false);
                                new CharstringElement(this);
                                break;
                            }
                            case 16: {
                                this.commandName = "callothersubr";
                                this.claimArguments(2, false, false);
                                if (this.args.size() <= 1) break;
                                int n7 = this.args.get((int)1).numberValue;
                                boolean bl2 = this.claimArguments(n7, false, false);
                                if (!bl2) {
                                    CFFWriter.this.currentCharString.remove(this);
                                    return;
                                }
                                for (n3 = 0; n3 < n7; ++n3) {
                                    new CharstringElement(this.args.get((int)(1 + n7 - n3)).numberValue);
                                }
                                break block0;
                            }
                            case 17: {
                                this.commandName = "pop";
                                new CharstringElement(this);
                                break;
                            }
                            case 33: {
                                this.commandName = "setcurrentpoint";
                                this.claimArguments(2, true, true);
                                break;
                            }
                        }
                        break;
                    }
                    case 13: {
                        this.commandName = "hsbw";
                        this.claimArguments(2, true, true);
                        ((CFFWriter)CFFWriter.this).lsbX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(0).evaluate();
                        ((CFFWriter)CFFWriter.this).widthX[((CFFWriter)CFFWriter.this).currentCharStringID] = this.args.get(1).evaluate();
                        if (CFFWriter.this.lsbX[CFFWriter.this.currentCharStringID] == 0) break;
                        this.commandName = "rmoveto";
                        this.args.set(1, new CharstringElement(0));
                        break;
                    }
                    case 14: {
                        this.commandName = "endchar";
                        this.claimArguments(0, false, true);
                        break;
                    }
                    case 21: {
                        this.commandName = "rmoveto";
                        this.claimArguments(2, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            int n8 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int n9 = this.args.get((int)1).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n8));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n9));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(1));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 22: {
                        this.commandName = "hmoveto";
                        this.claimArguments(1, true, true);
                        if (!CFFWriter.this.inFlex) break;
                        if (((CFFWriter)CFFWriter.this).currentFlexCommand.args.size() == 2 && !CFFWriter.this.firstArgsAdded) {
                            int n10 = this.args.get((int)0).numberValue + ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)0).numberValue;
                            int n11 = ((CFFWriter)CFFWriter.this).currentFlexCommand.args.get((int)1).numberValue;
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.clear();
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n10));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(n11));
                            CFFWriter.this.firstArgsAdded = true;
                        } else {
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(this.args.get(0));
                            ((CFFWriter)CFFWriter.this).currentFlexCommand.args.add(new CharstringElement(0));
                        }
                        this.commandName = "";
                        break;
                    }
                    case 30: {
                        this.commandName = "vhcurveto";
                        this.claimArguments(4, true, true);
                        break;
                    }
                    case 31: {
                        this.commandName = "hvcurveto";
                        this.claimArguments(4, true, true);
                        break;
                    }
                    case 255: {
                        this.length = 5;
                        this.isCommand = false;
                        this.numberValue = (nArray[n + 4] & 0xFF) + ((nArray[n + 3] & 0xFF) << 8) + ((nArray[n + 2] & 0xFF) << 16) + ((nArray[n + 1] & 0xFF) << 24);
                        break;
                    }
                }
                if (bl) {
                    CharstringElement charstringElement = (CharstringElement)CFFWriter.this.currentCharString.get(CFFWriter.this.currentCharString.indexOf(this) - 1);
                    if (this.commandName.equals(charstringElement.commandName) && charstringElement.args.size() <= 39 - this.args.size()) {
                        CFFWriter.this.currentCharString.remove(charstringElement);
                        for (CharstringElement charstringElement2 : this.args) {
                            charstringElement.args.add(charstringElement2);
                        }
                        this.args = charstringElement.args;
                    }
                }
            }
        }

        private int evaluate() {
            if (this.isResult) {
                return this.parent.evaluate();
            }
            if (this.isCommand && "div".equals(this.commandName)) {
                return this.args.get(1).evaluate() / this.args.get(0).evaluate();
            }
            return this.numberValue;
        }

        public int getLength() {
            return this.length;
        }

        public int[] getDisplacement() {
            if (!this.isCommand) {
                return new int[]{0, 0};
            }
            if (!"hstem".equals(this.commandName) && !"vstem".equals(this.commandName)) {
                if ("vmoveto".equals(this.commandName)) {
                    return new int[]{0, this.args.get(0).evaluate()};
                }
                if ("rlineto".equals(this.commandName)) {
                    int n = 0;
                    int n2 = 0;
                    for (int i = 0; i < this.args.size() / 2; ++i) {
                        n += this.args.get(i * 2).evaluate();
                        n2 += this.args.get(1 + i * 2).evaluate();
                    }
                    return new int[]{n, n2};
                }
                if ("hlineto".equals(this.commandName)) {
                    return new int[]{this.args.get(0).evaluate(), 0};
                }
                if ("vlineto".equals(this.commandName)) {
                    return new int[]{0, this.args.get(0).evaluate()};
                }
                if ("rrcurveto".equals(this.commandName)) {
                    int n = 0;
                    int n3 = 0;
                    for (int i = 0; i < this.args.size() / 2; ++i) {
                        n += this.args.get(i * 2).evaluate();
                        n3 += this.args.get(1 + i * 2).evaluate();
                    }
                    return new int[]{n, n3};
                }
                if (!("closepath".equals(this.commandName) || "callsubr".equals(this.commandName) || "return".equals(this.commandName) || "dotsection".equals(this.commandName) || "vstem3".equals(this.commandName) || "hstem3".equals(this.commandName) || "seac".equals(this.commandName) || "sbw".equals(this.commandName) || "div".equals(this.commandName) || "callothersubr".equals(this.commandName) || "pop".equals(this.commandName) || "setcurrentpoint".equals(this.commandName) || "hsbw".equals(this.commandName) || "endchar".equals(this.commandName))) {
                    if ("rmoveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate(), this.args.get(1).evaluate()};
                    }
                    if ("hmoveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate(), 0};
                    }
                    if ("vhcurveto".equals(this.commandName)) {
                        return new int[]{this.args.get(1).evaluate() + this.args.get(3).evaluate(), this.args.get(0).evaluate() + this.args.get(2).evaluate()};
                    }
                    if ("hvcurveto".equals(this.commandName)) {
                        return new int[]{this.args.get(0).evaluate() + this.args.get(1).evaluate(), this.args.get(2).evaluate() + this.args.get(3).evaluate()};
                    }
                    if ("flex".equals(this.commandName)) {
                        int n = 0;
                        int n4 = 0;
                        for (int i = 0; i < 6; ++i) {
                            n += this.args.get(i * 2).evaluate();
                            n4 += this.args.get(1 + i * 2).evaluate();
                        }
                        return new int[]{n, n4};
                    }
                    if (this.commandName.length() == 0) {
                        return new int[]{0, 0};
                    }
                }
            }
            return new int[]{0, 0};
        }

        public void scale() {
            if (this.isResult) {
                return;
            }
            if (!this.isCommand) {
                this.numberValue = (int)((double)this.numberValue * CFFWriter.this.scale);
                return;
            }
            boolean bl = false;
            if ("hstem".equals(this.commandName)) {
                bl = true;
            } else if ("vstem".equals(this.commandName)) {
                bl = true;
            } else if ("vmoveto".equals(this.commandName)) {
                bl = true;
            } else if ("rlineto".equals(this.commandName)) {
                bl = true;
            } else if ("hlineto".equals(this.commandName)) {
                bl = true;
            } else if ("vlineto".equals(this.commandName)) {
                bl = true;
            } else if ("rrcurveto".equals(this.commandName)) {
                bl = true;
            } else if (!("closepath".equals(this.commandName) || "callsubr".equals(this.commandName) || "return".equals(this.commandName) || "dotsection".equals(this.commandName))) {
                if ("vstem3".equals(this.commandName)) {
                    bl = true;
                } else if ("hstem3".equals(this.commandName)) {
                    bl = true;
                } else if ("seac".equals(this.commandName)) {
                    for (int i = 0; i < 3; ++i) {
                        this.args.get(i).scale();
                    }
                } else if (!"sbw".equals(this.commandName)) {
                    if ("div".equals(this.commandName)) {
                        bl = true;
                    } else if (!"callothersubr".equals(this.commandName) && !"pop".equals(this.commandName)) {
                        if ("setcurrentpoint".equals(this.commandName)) {
                            bl = true;
                        } else if (!"hsbw".equals(this.commandName) && !"endchar".equals(this.commandName)) {
                            if ("rmoveto".equals(this.commandName)) {
                                bl = true;
                            } else if ("hmoveto".equals(this.commandName)) {
                                bl = true;
                            } else if ("vhcurveto".equals(this.commandName)) {
                                bl = true;
                            } else if ("hvcurveto".equals(this.commandName)) {
                                bl = true;
                            } else if ("flex".equals(this.commandName)) {
                                bl = true;
                            } else if (this.commandName.length() == 0) {
                                // empty if block
                            }
                        }
                    }
                }
            }
            if (bl) {
                for (CharstringElement charstringElement : this.args) {
                    charstringElement.scale();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public byte[] getType2Bytes() {
            if (!this.isCommand) {
                if (this.isResult) {
                    return new byte[0];
                }
                return FontWriter.setCharstringType2Number(this.numberValue);
            }
            var1_1 = false;
            var2_2 = new byte[]{};
            if ("hstem".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{1};
            } else if ("vstem".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{3};
            } else if ("vmoveto".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{4};
            } else if ("rlineto".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{5};
            } else if ("hlineto".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{6};
            } else if ("vlineto".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{7};
            } else if ("rrcurveto".equals(this.commandName)) {
                var1_1 = true;
                var2_2 = new byte[]{8};
            } else {
                if ("closepath".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("callsubr".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("return".equals(this.commandName)) {
                    return new byte[0];
                }
                if ("dotsection".equals(this.commandName)) {
                    return new byte[0];
                }
                if (!"vstem3".equals(this.commandName) && !"hstem3".equals(this.commandName)) {
                    if ("seac".equals(this.commandName)) {
                        var3_3 = this.args.get((int)1).numberValue;
                        var4_5 = this.args.get((int)2).numberValue;
                        var5_7 = this.args.get((int)3).numberValue;
                        var6_8 = this.args.get((int)4).numberValue;
                        var7_9 = StandardFonts.getEncodedChar(1, var6_8).charAt(0);
                        var8_10 = StandardFonts.getEncodedChar(1, var5_7).charAt(0);
                        var9_11 = -1;
                        var10_12 = -1;
                        for (var11_13 = 0; var11_13 < CFFWriter.access$1100(CFFWriter.this).length; ++var11_13) {
                            var12_16 = StandardFonts.getAdobeMap(CFFWriter.access$1100(CFFWriter.this)[var11_13]);
                            if (var12_16 < 0 || var12_16 >= 512) continue;
                            if (var12_16 == var7_9) {
                                var9_11 = var11_13;
                            }
                            if (var12_16 != var8_10) continue;
                            var10_12 = var11_13;
                        }
                        if (var9_11 == -1 || var10_12 == -1) {
                            return new byte[0];
                        }
                        try {
                            var11_14 = new ByteArrayOutputStream();
                            var12_16 = CFFWriter.access$600(CFFWriter.this);
                            CFFWriter.access$1200((CFFWriter)CFFWriter.this)[var10_12] = 0;
                            CFFWriter.access$1300((CFFWriter)CFFWriter.this)[var10_12] = 0;
                            CFFWriter.access$1402(CFFWriter.this, true);
                            var13_17 = CFFWriter.access$1600(CFFWriter.this, CFFWriter.access$1500(CFFWriter.this)[var10_12], var10_12);
                            CFFWriter.access$1402(CFFWriter.this, false);
                            CFFWriter.access$602(CFFWriter.this, var12_16);
                            var14_18 = new byte[var13_17.length - 1];
                            System.arraycopy(var13_17, 0, var14_18, 0, var14_18.length);
                            var11_14.write(var14_18);
                            var11_14.write(FontWriter.setCharstringType2Number(-CFFWriter.access$1200(CFFWriter.this)[var10_12] + var3_3));
                            var11_14.write(FontWriter.setCharstringType2Number(-CFFWriter.access$1300(CFFWriter.this)[var10_12] + var4_5));
                            var11_14.write(21);
                            CFFWriter.access$1200((CFFWriter)CFFWriter.this)[var9_11] = 0;
                            CFFWriter.access$1300((CFFWriter)CFFWriter.this)[var9_11] = 0;
                            var15_19 = CFFWriter.access$1600(CFFWriter.this, CFFWriter.access$1500(CFFWriter.this)[var9_11], var9_11);
                            CFFWriter.access$602(CFFWriter.this, var12_16);
                            var11_14.write(var15_19);
                            return var11_14.toByteArray();
                        }
                        catch (IOException var11_15) {
                            if (!LogWriter.isOutput()) ** GOTO lbl127
                            LogWriter.writeLog("Exception: " + var11_15.getMessage());
                        }
                    } else {
                        if ("sbw".equals(this.commandName)) {
                            return new byte[0];
                        }
                        if ("div".equals(this.commandName)) {
                            var1_1 = true;
                            var2_2 = new byte[]{12, 12};
                        } else if (!("callothersubr".equals(this.commandName) || "pop".equals(this.commandName) || "setcurrentpoint".equals(this.commandName))) {
                            if ("hsbw".equals(this.commandName)) {
                                return new byte[0];
                            }
                            if ("endchar".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{14};
                            } else if ("rmoveto".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{21};
                            } else if ("hmoveto".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{22};
                            } else if ("vhcurveto".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{30};
                            } else if ("hvcurveto".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{31};
                            } else if ("flex".equals(this.commandName)) {
                                var1_1 = true;
                                var2_2 = new byte[]{12, 35};
                            } else if (this.commandName.length() == 0) {
                                return new byte[0];
                            }
                        }
                    }
                }
            }
lbl127:
            // 22 sources

            if (var1_1) {
                block49: {
                    var3_4 = this.getStreamWithArgs();
                    try {
                        var3_4.write(var2_2);
                    }
                    catch (IOException var4_6) {
                        if (!LogWriter.isOutput()) break block49;
                        LogWriter.writeLog("Exception: " + var4_6.getMessage());
                    }
                }
                return var3_4.toByteArray();
            }
            return new byte[0];
        }

        private ByteArrayOutputStream getStreamWithArgs() {
            ByteArrayOutputStream byteArrayOutputStream;
            block3: {
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    for (CharstringElement charstringElement : this.args) {
                        byteArrayOutputStream.write(charstringElement.getType2Bytes());
                    }
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
            return byteArrayOutputStream;
        }

        public String toString() {
            if (this.isCommand) {
                return this.commandName + this.args.toString();
            }
            if (this.isResult) {
                return "result of " + this.parent;
            }
            return String.valueOf(this.numberValue);
        }

        private void printStack() {
            System.out.println("Stack bottom");
            for (CharstringElement charstringElement : CFFWriter.this.currentCharString) {
                if (charstringElement.isCommand) continue;
                System.out.println(charstringElement);
            }
            System.out.println("Stack top");
        }

        private boolean claimArguments(int n, boolean bl, boolean bl2) {
            int n2;
            if (n > 0) {
                n2 = CFFWriter.this.currentCharString.indexOf(this);
                if (n2 == -1) {
                    throw new RuntimeException("Not in list!");
                }
                int n3 = 0;
                boolean bl3 = false;
                while (n3 < n && !bl3) {
                    CharstringElement charstringElement;
                    int n4;
                    boolean bl4 = false;
                    if (bl) {
                        for (n4 = 0; !bl4 && n4 <= n2; ++n4) {
                            charstringElement = (CharstringElement)CFFWriter.this.currentCharString.get(n4);
                            if (charstringElement.isCommand) continue;
                            ++n3;
                            this.args.add(charstringElement);
                            CFFWriter.this.currentCharString.remove(charstringElement);
                            bl4 = true;
                        }
                    } else {
                        for (n4 = n2; !bl4 && n4 >= 0; --n4) {
                            charstringElement = (CharstringElement)CFFWriter.this.currentCharString.get(n4);
                            if (charstringElement.isCommand) continue;
                            ++n3;
                            this.args.add(charstringElement);
                            CFFWriter.this.currentCharString.remove(charstringElement);
                            bl4 = true;
                            --n2;
                        }
                    }
                    if (bl4) continue;
                    bl3 = true;
                }
                if (n3 < n) {
                    return false;
                }
            }
            if (bl2) {
                for (n2 = 0; n2 < CFFWriter.this.currentCharString.size(); ++n2) {
                    CharstringElement charstringElement = (CharstringElement)CFFWriter.this.currentCharString.get(n2);
                    if (charstringElement.isCommand) continue;
                    CFFWriter.this.currentCharString.remove(charstringElement);
                }
            }
            return true;
        }
    }
}

