/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    private boolean subfontAlreadyLoaded;
    private Map fontsLoaded;
    private Rectangle BBox = null;

    TrueType() {
    }

    private void readFontData(byte[] byArray, FontData fontData) {
        if (this.subfontAlreadyLoaded) {
            this.glyphs = (PdfJavaGlyphs)this.fontsLoaded.get(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + byArray.length);
            this.fontTypes = this.glyphs.getType();
        } else {
            if (!this.isCIDFont && byArray != null) {
                this.fontsLoaded.put(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + byArray.length, this.glyphs);
            }
            this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, byArray, fontData);
        }
    }

    protected void substituteFontUsed(String string) throws PdfFontException {
        block10: {
            InputStream inputStream;
            block9: {
                inputStream = null;
                try {
                    inputStream = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + string);
                    if (inputStream == null) {
                        inputStream = new FileInputStream(string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
                    }
                    if (!ExternalHandlers.throwMissingCIDError || !exception.getMessage().contains("kochi")) break block9;
                    throw new Error(exception);
                }
            }
            if (inputStream == null) {
                throw new PdfFontException("Unable to load font " + string);
            }
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[65535];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                inputStream.close();
                FontData fontData = null;
                this.readFontData(byteArrayOutputStream.toByteArray(), fontData);
                this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), true, this.isCIDFont);
                this.isFontEmbedded = true;
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
                }
                if (!ExternalHandlers.throwMissingCIDError || !exception.getMessage().contains("kochi")) break block10;
                throw new Error(exception);
            }
        }
    }

    public TrueType(byte[] byArray, PdfJavaGlyphs pdfJavaGlyphs) {
        this.fontsLoaded = new HashMap();
        this.init(null);
    }

    public TrueType(String string) {
        this.glyphs = new TTGlyphs();
        this.fontsLoaded = new HashMap();
        this.init(null);
        this.substituteFont = string;
    }

    public TrueType(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new TTGlyphs();
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        this.fontTypes = 1217103210;
        this.fontsLoaded = map;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject2);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, pdfObject2);
        if (bl) {
            Object object;
            Object object2;
            if (pdfObject2 != null && this.substituteFont == null) {
                object2 = null;
                object = pdfObject2.getDictionary(2021292334);
                if (object == null && (object = pdfObject2.getDictionary(746093177)) == null) {
                    object = pdfObject2.getDictionary(2021292335);
                }
                if (object != null) {
                    object2 = this.currentPdfFile.readStream((PdfObject)object, true, true, false, false, false, ((PdfObject)object).getCacheName(this.currentPdfFile.getObjectReader()));
                }
                if (object2 != null) {
                    this.readEmbeddedFont((byte[])object2, null, this.hasEncoding, false);
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                if (this.glyphs.remapFont) {
                    this.glyphs.remapFont = false;
                }
                this.subfontAlreadyLoaded = !this.isCIDFont && this.fontsLoaded.containsKey(this.substituteFont + '_' + this.glyphs.getBaseFontName());
                object = null;
                int n = 0;
                if (!this.subfontAlreadyLoaded) {
                    object2 = new File(this.substituteFont);
                    n = (int)((File)object2).length();
                }
                if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
                    if (!this.subfontAlreadyLoaded) {
                        object = new FontData(this.substituteFont);
                    }
                    this.readEmbeddedFont(null, (FontData)object, false, true);
                } else if (this.subfontAlreadyLoaded) {
                    this.readEmbeddedFont(null, null, false, true);
                } else {
                    int n2;
                    InputStream inputStream;
                    block19: {
                        inputStream = null;
                        try {
                            inputStream = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("1.Unable to open " + this.substituteFont);
                            }
                        }
                        catch (Error error) {
                            if (!LogWriter.isOutput()) break block19;
                            LogWriter.writeLog("1.Unable to open " + this.substituteFont);
                        }
                    }
                    BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[65535];
                    while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.close();
                    bufferedInputStream.close();
                    this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(pdfObject, true);
        if (bl) {
            this.setFont(this.glyphs.fontName, 1);
        }
        this.glyphs.setDiffValues(this.diffTable);
    }

    public void createFont(String string) throws Exception {
        this.fontTypes = 1217103210;
        this.setBaseFontName(string);
        File file = new File(this.substituteFont);
        int n = (int)file.length();
        if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
            FontData fontData = new FontData(this.substituteFont);
            this.readEmbeddedFont(null, fontData, false, true);
        } else {
            int n2;
            InputStream inputStream;
            block7: {
                inputStream = null;
                try {
                    inputStream = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("2.Unable to open " + this.substituteFont);
                    }
                }
                catch (Error error) {
                    if (!LogWriter.isOutput()) break block7;
                    LogWriter.writeLog("2.Unable to open " + this.substituteFont);
                }
            }
            BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            bufferedInputStream.close();
            this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
        }
        this.isFontSubstituted = true;
        this.glyphs.setDiffValues(this.diffTable);
    }

    protected final void readEmbeddedFont(byte[] byArray, FontData fontData, boolean bl, boolean bl2) {
        block3: {
            try {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Embedded TrueType font used");
                }
                this.readFontData(byArray, fontData);
                this.isFontEmbedded = true;
                this.glyphs.setFontEmbedded(true);
                this.glyphs.setEncodingToUse(bl, this.getFontEncoding(false), bl2, this.TTstreamisCID);
            }
            catch (Exception exception) {
                this.isFontEmbedded = false;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + exception + " processing TrueType font");
            }
        }
    }

    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            this.BBox = this.isFontEmbedded && !this.isFontSubstituted ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        }
        return this.BBox;
    }
}

