/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMousePageTurn;
import org.jpedal.examples.viewer.gui.swing.SwingMousePanMode;
import org.jpedal.examples.viewer.gui.swing.SwingMouseSelector;
import org.jpedal.io.PdfObjectReader;

public class SwingMouseListener
implements GUIMouseHandler,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    SwingMouseSelector selectionFunctions;
    SwingMousePanMode panningFunctions;
    SwingMousePageTurn pageTurnFunctions;
    private static SwingMouseFunctionality customMouseFunctions;
    private boolean scrollPageChanging = false;
    private int cx;
    private int cy;
    private String message = "";
    private MouseMode mouseMode = new MouseMode();
    private AutoScrollThread scrollThread = new AutoScrollThread();
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    int scrollToPage = -1;

    public SwingMouseListener(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
        this.mouseMode = commands.getMouseMode();
        this.selectionFunctions = new SwingMouseSelector(pdfDecoder, swingGUI, values, commands);
        this.panningFunctions = new SwingMousePanMode(pdfDecoder);
        this.pageTurnFunctions = new SwingMousePageTurn(pdfDecoder, swingGUI, values, commands);
        if (SwingUtilities.isEventDispatchThread()) {
            this.scrollThread.init();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SwingMouseListener.this.scrollThread.init();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        pdfDecoder.addExternalHandler(this, 10);
    }

    public void setupExtractor() {
        System.out.println("Set up extractor called");
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
        this.decode_pdf.addMouseWheelListener(this);
        this.decode_pdf.setDefaultCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateRectangle() {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.updateRectangle();
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseClicked(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseClicked(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseEntered(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int[] nArray = new int[]{1, 0};
        this.currentGUI.setMultibox(nArray);
        this.scrollThread.setAutoScroll(false, 0, 0, 0);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseExited(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mousePressed(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mousePressed(mouseEvent);
            }
        }
        if (mouseEvent.getButton() == 2) {
            this.middleDragStartX = (double)mouseEvent.getX() - this.decode_pdf.getVisibleRect().getX();
            this.middleDragStartY = (double)mouseEvent.getY() - this.decode_pdf.getVisibleRect().getY();
            this.decode_pdf.setCursor(this.currentGUI.getCursor(4));
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer(100, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Rectangle rectangle = SwingMouseListener.this.decode_pdf.getVisibleRect();
                        rectangle.translate((int)SwingMouseListener.this.xVelocity, (int)SwingMouseListener.this.yVelocity);
                        if (SwingMouseListener.this.xVelocity < -2.0) {
                            if (SwingMouseListener.this.yVelocity < -2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(6));
                            } else if (SwingMouseListener.this.yVelocity > 2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(12));
                            } else {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(5));
                            }
                        } else if (SwingMouseListener.this.xVelocity > 2.0) {
                            if (SwingMouseListener.this.yVelocity < -2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(8));
                            } else if (SwingMouseListener.this.yVelocity > 2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(10));
                            } else {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(9));
                            }
                        } else if (SwingMouseListener.this.yVelocity < -2.0) {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(7));
                        } else if (SwingMouseListener.this.yVelocity > 2.0) {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(11));
                        } else {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(4));
                        }
                        SwingMouseListener.this.decode_pdf.scrollRectToVisible(rectangle);
                    }
                });
            }
            this.middleDragTimer.start();
        }
        if (!SwingUtilities.isMiddleMouseButton(mouseEvent) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mousePressed(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseReleased(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mouseReleased(mouseEvent);
            }
        }
        if (mouseEvent.getButton() == 2) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(this.currentGUI.getCursor(3));
            this.middleDragTimer.stop();
            this.decode_pdf.repaint();
        }
        if (!SwingUtilities.isMiddleMouseButton(mouseEvent) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseReleased(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseReleased(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.scrollAndUpdateCoords(mouseEvent);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseDragged(mouseEvent);
                break;
            }
            case 1: {
                this.panningFunctions.mouseDragged(mouseEvent);
            }
        }
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.xVelocity = ((double)mouseEvent.getX() - this.decode_pdf.getVisibleRect().getX() - this.middleDragStartX) / 4.0;
            this.yVelocity = ((double)mouseEvent.getY() - this.decode_pdf.getVisibleRect().getY() - this.middleDragStartY) / 4.0;
        }
        if (!SwingUtilities.isMiddleMouseButton(mouseEvent) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseDragged(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseDragged(mouseEvent);
        }
    }

    public static void setCustomMouseFunctions(SwingMouseFunctionality swingMouseFunctionality) {
        customMouseFunctions = swingMouseFunctionality;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.commonValues.getCurrentPage();
        Point point = this.selectionFunctions.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), n);
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        this.updateCoords(n2, n3, mouseEvent.isShiftDown());
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                int[] nArray = this.selectionFunctions.updateXY(mouseEvent.getX(), mouseEvent.getY());
                n2 = nArray[0];
                n3 = nArray[1];
                if (!this.currentCommands.extractingAsImage) {
                    this.getObjectUnderneath(n2, n3);
                }
                this.selectionFunctions.mouseMoved(mouseEvent);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseMoved(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseMoved(mouseEvent);
        }
    }

    private void getObjectUnderneath(int n, int n2) {
        if (this.decode_pdf.getDisplayView() == 1) {
            int n3 = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(n, n2);
            switch (n3) {
                case -1: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 3: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                case 4: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 5: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 6: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void mouseWheelMoved(MouseWheelEvent var1_1) {
        switch (this.decode_pdf.getDisplayView()) {
            case 5: {
                break;
            }
            case 3: {
                if (!this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON)) break;
                this.pageTurnFunctions.mouseWheelMoved(var1_1);
                break;
            }
            case 1: {
                if (!this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") || !var1_1.isMetaDown() && !var1_1.isControlDown()) ** GOTO lbl47
                var2_2 = this.currentGUI.getSelectedComboIndex(252);
                if (var2_2 == -1) ** GOTO lbl14
                var2_2 = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                ** GOTO lbl31
lbl14:
                // 1 sources

                var3_5 = (String)this.currentGUI.getSelectedComboItem(252);
                try {
                    var2_2 = (int)Float.parseFloat(var3_5);
                }
                catch (Exception var4_10) {
                    var2_2 = -1;
                    var5_12 = var3_5.length();
                    for (var6_14 = 0; var6_14 < var5_12 && ((var7_16 = var3_5.charAt(var6_14)) >= '0' && var7_16 <= '9') | var7_16 == '.'; ++var6_14) {
                    }
                    if (var6_14 > 0) {
                        var3_5 = var3_5.substring(0, var6_14);
                    }
                    if (var2_2 != -1) ** GOTO lbl31
                    try {
                        var2_2 = (int)Float.parseFloat(var3_5);
                    }
                    catch (Exception var7_17) {
                        var2_2 = -1;
                    }
                }
lbl31:
                // 5 sources

                var3_6 = var1_1.getWheelRotation();
                if ((var2_2 != 1 || var3_6 < 0.0f) && !((float)var2_2 + (var3_6 = var3_6 < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                    var4_11 = (float)var2_2 * var3_6;
                    var4_11 = (int)var4_11 == var2_2 ? (float)(var2_2 + 1) : (float)((int)var4_11);
                    if (var4_11 < 1.0f) {
                        var4_11 = 1.0f;
                    }
                    if (var4_11 > 1000.0f) {
                        var4_11 = 1000.0f;
                    }
                    var5_13 = this.decode_pdf.getVisibleRect();
                    var6_15 = (double)var1_1.getX() / this.decode_pdf.getBounds().getWidth();
                    var8_18 = (double)var1_1.getY() / this.decode_pdf.getBounds().getHeight();
                    this.currentGUI.snapScalingToDefaults(var4_11);
                    var10_19 = new Thread(){

                        public void run() {
                            try {
                                SwingMouseListener.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(var6_15 * (double)SwingMouseListener.this.decode_pdf.getWidth() - var5_13.getWidth() / 2.0), (int)(var8_18 * (double)SwingMouseListener.this.decode_pdf.getHeight() - var5_13.getHeight() / 2.0), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getHeight()));
                                SwingMouseListener.this.decode_pdf.repaint();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    var10_19.start();
                    SwingUtilities.invokeLater(var10_19);
                }
                ** GOTO lbl80
lbl47:
                // 1 sources

                var2_3 = this.currentGUI.getVerticalScrollBar();
                this.scrollToPage = var2_3.getValue();
                if (var2_3.getValue() < var2_3.getMaximum() - var2_3.getHeight() && var2_3.getHeight() != 0 || var1_1.getUnitsToScroll() <= 0 || this.scrollToPage > this.decode_pdf.getPageCount()) ** GOTO lbl65
                if (this.scrollPageChanging) {
                    return;
                }
                this.scrollPageChanging = true;
                if (this.scrollToPage < this.decode_pdf.getPageCount()) {
                    ++this.scrollToPage;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    var2_3.setValue(this.scrollToPage);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                var2_3.setValue(SwingMouseListener.this.scrollToPage);
                            }
                        });
                    }
                    catch (Exception var3_7) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                var2_3.setValue(SwingMouseListener.this.scrollToPage);
                            }
                        });
                    }
                }
                this.scrollPageChanging = false;
                ** GOTO lbl80
lbl65:
                // 1 sources

                if (var2_3.getValue() >= var2_3.getMinimum() && var1_1.getUnitsToScroll() < 0 && this.scrollToPage >= 1) {
                    if (this.scrollPageChanging) {
                        return;
                    }
                    this.scrollPageChanging = true;
                    if (this.scrollToPage >= 1) {
                        --this.scrollToPage;
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        var2_3.setValue(this.scrollToPage);
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    var2_3.setValue(SwingMouseListener.this.scrollToPage);
                                }
                            });
                        }
                        catch (Exception var3_8) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    var2_3.setValue(SwingMouseListener.this.scrollToPage);
                                }
                            });
                        }
                    }
                    this.scrollPageChanging = false;
                }
            }
lbl80:
            // 6 sources

            default: {
                var2_4 = new Area(this.decode_pdf.getVisibleRect());
                var3_9 = new AffineTransform();
                var3_9.translate(0.0, var1_1.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                var2_4 = var2_4.createTransformedArea(var3_9);
                this.decode_pdf.scrollRectToVisible(var2_4.getBounds());
            }
        }
    }

    protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
        int n = this.decode_pdf.getScrollInterval();
        Rectangle rectangle = new Rectangle(this.currentGUI.AdjustForAlignment(mouseEvent.getX()), mouseEvent.getY(), n, n);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(rectangle)) {
            this.decode_pdf.scrollRectToVisible(rectangle);
        }
        int n2 = this.commonValues.getCurrentPage();
        Point point = this.selectionFunctions.getCoordsOnPage(mouseEvent.getX(), mouseEvent.getY(), n2);
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        this.updateCoords(n3, n4, mouseEvent.isShiftDown());
    }

    public void updateCoords(int n, int n2, boolean bl) {
        this.cx = n;
        this.cy = n2;
        if (this.decode_pdf.getDisplayView() != 1) {
            if (SwingMouseSelector.activateMultipageHighlight) {
                if (this.decode_pdf.getDisplayView() == 3) {
                    this.cx = 0;
                    this.cy = 0;
                }
            } else {
                this.cx = 0;
                this.cy = 0;
            }
        }
        if (Values.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + ' ' + ' ' + this.message);
        }
    }

    public int[] getCursorLocation() {
        return new int[]{this.cx, this.cy};
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader) {
        this.pageTurnFunctions.checkLinks(bl, pdfObjectReader, this.cx, this.cy);
    }

    public void updateCordsFromFormComponent(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        int n = jComponent.getX() + mouseEvent.getX();
        int n2 = jComponent.getY() + mouseEvent.getY();
        Point point = this.selectionFunctions.getCoordsOnPage(n, n2, this.commonValues.getCurrentPage());
        n = (int)point.getX();
        n2 = (int)point.getY();
        this.updateCoords(n, n2, mouseEvent.isShiftDown());
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnFunctions.getPageTurnAnimating();
    }

    public void setPageTurnAnimating(boolean bl) {
        this.pageTurnFunctions.setPageTurnAnimating(bl);
    }

    class AutoScrollThread
    implements Runnable {
        Thread scroll = new Thread(this);
        boolean autoScroll = false;
        int x = 0;
        int y = 0;
        int interval = 0;
        int usedX;
        int usedY;

        public void setAutoScroll(boolean bl, int n, int n2, int n3) {
            this.autoScroll = bl;
            this.x = SwingMouseListener.this.currentGUI.AdjustForAlignment(n);
            this.y = n2;
            this.interval = n3;
        }

        public void init() {
            this.scroll.start();
        }

        public void run() {
            while (Thread.currentThread().equals(this.scroll)) {
                if (this.autoScroll) {
                    final Rectangle rectangle = new Rectangle(this.x - this.interval, this.y - this.interval, this.interval * 2, this.interval * 2);
                    Rectangle rectangle2 = SwingMouseListener.this.decode_pdf.getVisibleRect();
                    if (!rectangle2.contains(rectangle)) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            SwingMouseListener.this.decode_pdf.scrollRectToVisible(rectangle);
                        } else {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    SwingMouseListener.this.decode_pdf.scrollRectToVisible(rectangle);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                        if (this.x - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x) {
                            this.x -= this.interval;
                        } else if (this.x + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().width) {
                            this.x += this.interval;
                        }
                        if (this.y - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y) {
                            this.y -= this.interval;
                        } else if (this.y + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().height) {
                            this.y += this.interval;
                        }
                    }
                    this.usedX = this.x;
                    this.usedY = this.y;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

