/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.javafx;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.output.GenericFontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.javafx.FXMLDisplay;
import org.jpedal.render.output.javafx.JavaFXDisplay;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsJavaFX {
    private String user_dir;
    public static boolean outputMessages = false;
    String output_dir;
    String separator;
    PdfDecoder decode_pdf;
    private boolean useHiresImage;
    private String test_file;
    public static boolean isTest = false;
    private String password;
    private String firstPageName;
    private static boolean createTemplate = false;
    private static String saveTemplateFileName = "/Users/markee/Desktop/test.xml";
    private static boolean loadTemplate = false;
    private static String loadTemplateFileName;
    private boolean outputAsFXML;
    int end;
    int page;
    private boolean exitRequested;
    private int numPages;

    public ExtractPagesAsJavaFX() {
        this.user_dir = System.getProperty("user.dir");
        this.output_dir = null;
        this.separator = System.getProperty("file.separator");
        this.decode_pdf = null;
        this.useHiresImage = false;
        this.test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
        this.password = "";
        this.firstPageName = null;
        this.outputAsFXML = false;
        this.numPages = -1;
        ExtractPagesAsJavaFX.init();
    }

    public ExtractPagesAsJavaFX(String[] stringArray) {
        String string;
        block6: {
            this.user_dir = System.getProperty("user.dir");
            this.output_dir = null;
            this.separator = System.getProperty("file.separator");
            this.decode_pdf = null;
            this.useHiresImage = false;
            this.test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
            this.password = "";
            this.firstPageName = null;
            this.outputAsFXML = false;
            this.numPages = -1;
            ExtractPagesAsJavaFX.init();
            String string2 = this.setParams(stringArray);
            File file = new File(string2);
            if (!file.exists()) {
                System.out.println("File " + file + " not found");
                System.out.println("May need full path");
                return;
            }
            if (System.getProperty("org.jpedal.pdf2javafx.outputAsFXML") != null && System.getProperty("org.jpedal.pdf2javafx.outputAsFXML").toLowerCase().equals("true")) {
                this.outputAsFXML = true;
            }
            this.extraction(string2, this.output_dir);
            String string3 = file.getName();
            string = System.getProperty("IsOnlineConverter") != null ? ExtractPagesAsJavaFX.getStrippedText(string3.substring(0, string3.length() - 4)) : ExtractPagesAsJavaFX.convertPDFName(string3.substring(0, string3.length() - 4), !this.outputAsFXML);
            ExtractPagesAsJavaFX.compile(this.output_dir, string);
            if (this.firstPageName == null) {
                this.firstPageName = "page";
                for (int i = 1; i < String.valueOf(this.numPages).length(); ++i) {
                    this.firstPageName = this.firstPageName + '0';
                }
                this.firstPageName = this.firstPageName + '1';
            }
            try {
                ExtractPagesAsJavaFX.mkJar(this.output_dir, string, this.firstPageName);
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        ExtractPagesAsJavaFX.tidyUpClassFiles(this.output_dir, string);
    }

    private static void tidyUpClassFiles(String string, String string2) {
        File file = new File(string, string2);
        for (File file2 : file.listFiles()) {
            if (!file2.getAbsolutePath().endsWith(".class")) continue;
            file2.delete();
        }
    }

    private static void mkJar(String string, String string2, String string3) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, string2 + '/' + string3);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(string + string2 + ".jar"), manifest);
        ExtractPagesAsJavaFX.add(new File(string, string2), jarOutputStream, string);
        jarOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void add(File file, JarOutputStream jarOutputStream, String string) throws IOException {
        BufferedInputStream bufferedInputStream;
        block7: {
            block6: {
                bufferedInputStream = null;
                try {
                    if (file.isDirectory()) {
                        for (File file2 : file.listFiles()) {
                            ExtractPagesAsJavaFX.add(file2, jarOutputStream, string);
                        }
                        Object var9_11 = null;
                        if (bufferedInputStream == null) return;
                        break block6;
                    }
                    JarEntry jarEntry = new JarEntry(file.getPath().replace("\\", "/").replace((new File(string).getPath() + "/").replace("\\", "/"), ""));
                    jarEntry.setTime(file.lastModified());
                    jarOutputStream.putNextEntry(jarEntry);
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] byArray = new byte[1024];
                    while (true) {
                        int n;
                        if ((n = bufferedInputStream.read(byArray)) == -1) {
                            jarOutputStream.closeEntry();
                            break block7;
                        }
                        jarOutputStream.write(byArray, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (bufferedInputStream == null) throw throwable;
                    bufferedInputStream.close();
                    throw throwable;
                }
            }
            bufferedInputStream.close();
            return;
        }
        Object var9_12 = null;
        if (bufferedInputStream == null) return;
        bufferedInputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void compile(String string, String string2) {
        block6: {
            void var7_12;
            File file = new File(string, string2);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File stringArray2 : file.listFiles()) {
                if (!stringArray2.getAbsolutePath().endsWith(".java")) continue;
                arrayList.add(stringArray2);
            }
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            if (javaCompiler == null) {
                throw new RuntimeException("Jar could not be created as Java version requires javac.");
            }
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(arrayList);
            if (System.getProperty("IsOnlineConverter") != null) {
                String[] stringArray = new String[]{"-encoding", "UTF-8", "-classpath", "../jfxrt.jar"};
            } else {
                String[] stringArray = new String[]{"-encoding", "UTF-8"};
            }
            List<String> list = Arrays.asList(var7_12);
            javaCompiler.getTask(null, standardJavaFileManager, null, list, null, iterable).call();
            try {
                standardJavaFileManager.close();
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    private static void init() {
        loadTemplateFileName = System.getProperty("org.jpedal.loadXML");
        loadTemplate = loadTemplateFileName != null && new File(loadTemplateFileName).exists();
        saveTemplateFileName = System.getProperty("org.jpedal.saveXML");
        createTemplate = saveTemplateFileName != null;
    }

    public void extraction(String string, String string2) {
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                File file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = file.list();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    if (!string3.toLowerCase().endsWith(".pdf") || string3.startsWith(".")) continue;
                    if (outputMessages) {
                        System.out.println(string + string3);
                    }
                    this.decodeFile(string + string3, string2);
                }
            }
        }
        if (outputMessages) {
            System.out.println("JavaFX created");
        }
    }

    private void decodeFile(String string, String string2) {
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string3 = string.substring(0, string.length() - 4);
        }
        string3 = ExtractPagesAsJavaFX.getStrippedText(string3);
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(string, this.password);
            } else {
                this.decode_pdf.openPdfFile(string);
            }
            this.numPages = this.decode_pdf.getPageCount();
        }
        catch (Exception exception) {
            System.err.println("8.Exception " + exception + " in pdf code in " + string);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + '<');
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            if (!this.outputAsFXML) {
                if (System.getProperty("IsOnlineConverter") != null) {
                    this.extractPageAsJavaFX(string, string2 + string3 + this.separator, string3);
                } else {
                    this.extractPageAsJavaFX(string, string2 + "FX" + string3 + this.separator, "FX" + string3);
                }
            } else if (System.getProperty("IsOnlineConverter") != null) {
                this.extractPageAsJavaFX(string, string2 + string3 + this.separator, string3);
            } else {
                this.extractPageAsJavaFX(string, string2 + "FXML" + string3 + this.separator, "FXML" + string3);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public int getPageCount() {
        return this.end;
    }

    public int getPageReached() {
        return this.page;
    }

    public static String convertPDFName(String string, boolean bl) {
        if (bl) {
            return "FX" + ExtractPagesAsJavaFX.getStrippedText(string);
        }
        return "FXML" + ExtractPagesAsJavaFX.getStrippedText(string);
    }

    private void extractPageAsJavaFX(String string, String string2, String string3) {
        File file;
        if (string2 != null && !(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        int n = 1;
        this.end = this.decode_pdf.getPageCount();
        if (this.end > 10 && isTest) {
            this.end = 10;
        }
        if (outputMessages) {
            System.out.println("JavaFX file will be in  " + string2);
        }
        try {
            Object object;
            Object object2;
            File file2;
            GenericFontMapper.setXMLTemplate(createTemplate);
            if (loadTemplate) {
                GenericFontMapper.loadCustomFontMappings(new FileInputStream(new File(loadTemplateFileName)));
            }
            if (!(file2 = new File(string2 + "/icons")).exists()) {
                file2.mkdirs();
            }
            String[] stringArray = new String[]{"smstart.gif", "smback.gif", "smfback.gif", "smforward.gif", "smfforward.gif", "smend.gif", "logo.gif"};
            for (String string4 : stringArray) {
                int n2;
                InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/javafx/icons/" + string4);
                object2 = new BufferedOutputStream(new FileOutputStream(file2 + this.separator + string4));
                object = new byte[65536];
                while ((n2 = inputStream.read((byte[])object)) > 0) {
                    ((BufferedOutputStream)object2).write((byte[])object, 0, n2);
                }
                ((FilterOutputStream)object2).close();
                inputStream.close();
            }
            this.page = n;
            while (this.page < this.end + 1) {
                int n3;
                int n4;
                Object object3 = String.valueOf(this.page);
                if (this.firstPageName != null && this.page == n) {
                    object3 = this.firstPageName;
                } else {
                    String string5 = String.valueOf(this.end);
                    n4 = string5.length() - ((String)object3).length();
                    for (n3 = 0; n3 < n4; ++n3) {
                        object3 = '0' + (String)object3;
                    }
                }
                if (outputMessages) {
                    System.out.println("Page " + (String)object3);
                }
                int n5 = this.decode_pdf.getPdfPageData().getCropBoxX(this.page);
                n4 = this.decode_pdf.getPdfPageData().getCropBoxY(this.page);
                n3 = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.page);
                int n6 = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.page);
                object2 = new Rectangle(0, 0, n3, n6);
                object = new Point2D.Double(n3 / 2 + n5, n6 / 2 + n4);
                OutputDisplay outputDisplay = this.outputAsFXML ? new FXMLDisplay(this.page, (Point2D)object, (Rectangle)object2, false, 100, new ObjectStore(null)) : new JavaFXDisplay(this.page, (Point2D)object, (Rectangle)object2, false, 100, new ObjectStore(null));
                float f = 1.0f;
                outputDisplay.setValue(2, (int)(f * 100.0f));
                outputDisplay.writeCustom(11, this.decode_pdf.getPdfPageData());
                outputDisplay.setValue(0, 0);
                outputDisplay.setOutputDir(string2, string3, (String)object3);
                this.decode_pdf.addExternalHandler(outputDisplay, 20);
                outputDisplay.setValue(22, n);
                outputDisplay.setValue(23, this.end);
                outputDisplay.setBooleanValue(8, true);
                outputDisplay.setBooleanValue(16, true);
                this.decode_pdf.decodePage(this.page);
                this.decode_pdf.flushObjectValues(true);
                if (this.exitRequested) {
                    this.end = this.page;
                }
                ++this.page;
            }
        }
        catch (Exception exception) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + exception.getMessage() + " on File=" + string);
        }
        if (createTemplate) {
            GenericFontMapper.createXMLTemplate(saveTemplateFileName);
        }
    }

    public static void main(String[] stringArray) {
        if (outputMessages) {
            System.out.println("Simple demo to extract JavaFX version of a page");
        }
        new ExtractPagesAsJavaFX(stringArray);
    }

    private String setParams(String[] stringArray) {
        String string = this.test_file;
        int n = stringArray.length;
        if (n == 0) {
            ExtractPagesAsJavaFX.showCommandLineValues();
        } else if (n == 1) {
            string = stringArray[0];
        } else if (n < 6) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.endsWith("/") || string2.endsWith("\\")) {
                    this.output_dir = string2;
                    continue;
                }
                this.password = string2;
            }
        }
        return string;
    }

    private static void showCommandLineValues() {
        System.out.println("Example takes 2 or 3 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("Value 2 is the pass to write out JavaFX and directories and must end with / or \\ character)");
        System.out.println("Value 3 (optional) password for PDF file");
        System.exit(0);
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    public void stopConversion() {
        this.exitRequested = true;
    }

    protected static String getStrippedText(String string) {
        String string2 = "";
        char[] cArray = new char[]{'<', '>', '\\', ':', ';', '*', '^', '@', '?', '=', '[', ']', '`'};
        char c = '0';
        char c2 = 'z';
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < c || string.charAt(i) > c2) continue;
            boolean bl = false;
            for (char c3 : cArray) {
                if (string.charAt(i) != c3) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }
}

