/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private int[] a1;
    private int[] b1;
    private int[] c1;
    private Map cache = new HashMap();
    boolean isCached = false;

    public void reset() {
        super.reset();
        this.isConverted = false;
        this.isCached = true;
    }

    public ICCColorSpace(PdfObject pdfObject) {
        this.a1 = new int[256];
        this.b1 = new int[256];
        this.c1 = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.a1[i] = -1;
            this.b1[i] = -1;
            this.c1[i] = -1;
        }
        this.value = 1247168582;
        this.cs = ColorSpace.getInstance(1000);
        byte[] byArray = pdfObject.getDecodedStream();
        if (byArray == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error in ICC data");
            }
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                }
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    public final void setColor(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int[] nArray = new int[n];
        this.rawValues = new float[n];
        for (int i = 0; i < n; ++i) {
            float f;
            this.rawValues[i] = f = fArray[i];
            fArray2[i] = f;
            nArray[i] = f > 1.0f ? (int)f : (int)(f * 255.0f);
        }
        if (n == 3 && this.a1[nArray[0]] != -1 && this.b1[nArray[1]] != -1 && this.c1[nArray[2]] != -1) {
            this.currentColor = new PdfColor(this.a1[nArray[0]], this.b1[nArray[1]], this.c1[nArray[2]]);
        } else if (n == 4 && this.cache.get((nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + nArray[3]) != null) {
            Object v = this.cache.get((nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + nArray[3]);
            int n2 = (Integer)v;
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            this.currentColor = new PdfColor(n3, n4, n5);
        } else {
            try {
                fArray2 = this.cs.toRGB(fArray2);
            }
            catch (Exception exception) {
                float[] fArray3 = new float[]{fArray2[0], fArray2[0], fArray2[0]};
                fArray2 = fArray3;
            }
            this.currentColor = new PdfColor(fArray2[0], fArray2[1], fArray2[2]);
            if (n == 3) {
                this.a1[nArray[0]] = (int)(fArray2[0] * 255.0f);
                this.b1[nArray[1]] = (int)(fArray2[1] * 255.0f);
                this.c1[nArray[2]] = (int)(fArray2[2] * 255.0f);
            } else if (n == 4) {
                int n6 = ((int)(fArray2[0] * 255.0f) << 16) + ((int)(fArray2[1] * 255.0f) << 8) + (int)(fArray2[2] * 255.0f);
                this.cache.put((nArray[0] << 24) + (nArray[1] << 16) + (nArray[2] << 8) + nArray[3], n6);
            }
        }
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        if (this.componentCount == 4) {
            return this.convert4Index(byArray);
        }
        return byArray;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        if (byArray.length > 9 && byArray[6] == 74 && byArray[7] == 70 && byArray[8] == 73 && byArray[9] == 70) {
            return this.nonRGBJPEGToRGBImage(byArray, n, n2, null, n3, n4);
        }
        return this.algorithmicICCToRGB(byArray, n, n2, false, n3, n4, fArray);
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) throws PdfException {
        BufferedImage bufferedImage;
        byte[] byArray2 = this.getIndexedMap();
        if (this.cs.getNumComponents() == 3 || byArray2 != null) {
            return super.JPEG2000ToRGBImage(byArray, n, n2, fArray, n3, n4);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            if (byArray2 != null) {
                if (!this.isIndexConverted()) {
                    byArray2 = this.convertIndexToRGB(byArray2);
                }
                RenderedImage renderedImage = imageReader.readAsRenderedImage(0, imageReader.getDefaultReadParam());
                Raster raster = renderedImage.getData();
                IndexColorModel indexColorModel = new IndexColorModel(8, byArray2.length / 3, byArray2, 0, false);
                bufferedImage = new BufferedImage(indexColorModel, raster.createCompatibleWritableRaster(), false, null);
                bufferedImage = ICCColorSpace.cleanupImage(bufferedImage, n3, n4, bufferedImage.getType());
            } else {
                Object object;
                bufferedImage = imageReader.read(0);
                Raster raster = bufferedImage.getRaster();
                if (fArray != null) {
                    if (fArray.length == 6 && fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 1.0f && fArray[3] == 0.0f && fArray[4] == 1.0f && fArray[5] == 0.0f || fArray.length > 2 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                        object = raster.getDataBuffer();
                        int n5 = ((DataBuffer)object).getSize();
                        for (int i = 0; i < n5; ++i) {
                            ((DataBuffer)object).setElem(i, 255 - ((DataBuffer)object).getElem(i));
                        }
                    } else if (fArray.length == 6 && fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 1.0f || fArray == null || fArray.length > 0) {
                        // empty if block
                    }
                }
                raster = ICCColorSpace.cleanupRaster(raster, n3, n4, 4);
                n = raster.getWidth();
                n2 = raster.getHeight();
                if (bufferedImage.getType() == 13) {
                    object = ColorSpaceConvertor.createCompatibleWritableRaaster(bufferedImage.getColorModel(), n, n2);
                    CSToRGB = new ColorConvertOp(this.cs, bufferedImage.getColorModel().getColorSpace(), ColorSpaces.hints);
                    bufferedImage = new BufferedImage(n, n2, bufferedImage.getType());
                } else if (bufferedImage.getType() != 10) {
                    if (CSToRGB == null) {
                        ICCColorSpace.initCMYKColorspace();
                    }
                    object = ColorSpaceConvertor.createCompatibleWritableRaaster(rgbModel, n, n2);
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    CSToRGB.filter(raster, (WritableRaster)object);
                    bufferedImage = new BufferedImage(n, n2, 1);
                } else {
                    object = null;
                }
                if (object != null) {
                    bufferedImage.setData((Raster)object);
                }
            }
            imageReader.dispose();
            imageInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
            }
            exception.printStackTrace();
            throw new PdfException("Exception " + exception + " with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        catch (Error error) {
            error.printStackTrace();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000 with error " + error);
            }
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BufferedImage algorithmicICCToRGB(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, float[] fArray) {
        BufferedImage bufferedImage;
        block19: {
            Object object;
            ByteArrayInputStream byteArrayInputStream;
            ImageInputStream imageInputStream;
            ImageReader imageReader;
            block17: {
                BufferedImage bufferedImage2;
                block18: {
                    bufferedImage = null;
                    imageReader = null;
                    imageInputStream = null;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(imageReader = (object = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    imageReader.setInput(imageInputStream, true);
                    object = imageReader.readRaster(0, null);
                    if (imageReader.getRawImageType(0) != null && this.alternative != -1) break block17;
                    bufferedImage2 = this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
                    Object var30_17 = null;
                    try {
                        byteArrayInputStream.close();
                        imageReader.dispose();
                        imageInputStream.close();
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block18;
                        LogWriter.writeLog("Problem closing  " + exception);
                    }
                }
                return bufferedImage2;
            }
            object = ICCColorSpace.cleanupRaster((Raster)object, n3, n4, this.componentCount);
            n = ((Raster)object).getWidth();
            n2 = ((Raster)object).getHeight();
            byte[] byArray2 = new byte[n * n2 * 3];
            byArray = ((DataBufferByte)((Raster)object).getDataBuffer()).getData();
            int n5 = n * n2 * 3;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n6 = 0;
            float f4 = -1.0f;
            float f5 = -1.0f;
            float f6 = -1.0f;
            for (int i = 0; i < n5; i += 3) {
                float f7 = (float)(byArray[i] & 0xFF) / 255.0f;
                float f8 = (float)(byArray[1 + i] & 0xFF) / 255.0f;
                float f9 = (float)(byArray[2 + i] & 0xFF) / 255.0f;
                if (f4 != f7 || f5 != f8 || f6 != f9) {
                    if (bl) {
                        System.out.println(f7 + " " + f8 + ' ' + f9);
                    }
                    float[] fArray2 = new float[]{f7, f8, f9};
                    float[] fArray3 = this.cs.toRGB(fArray2);
                    f = fArray3[0] * 255.0f;
                    f2 = fArray3[1] * 255.0f;
                    f3 = fArray3[2] * 255.0f;
                    f4 = f7;
                    f5 = f8;
                    f6 = f9;
                }
                byArray2[n6++] = (byte)f;
                byArray2[n6++] = (byte)f2;
                byArray2[n6++] = (byte)f3;
            }
            int[] nArray = new int[]{0, 1, 2};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
            Object var30_18 = null;
            try {
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Problem closing  " + exception);
                }
                break block19;
            }
            {
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Problem with color conversion");
                    }
                    Object var30_19 = null;
                    try {
                        byteArrayInputStream.close();
                        imageReader.dispose();
                        imageInputStream.close();
                    }
                    catch (Exception exception2) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Problem closing  " + exception2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block20: {
                    Object var30_20 = null;
                    try {
                        byteArrayInputStream.close();
                        imageReader.dispose();
                        imageInputStream.close();
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block20;
                        LogWriter.writeLog("Problem closing  " + exception);
                    }
                }
                throw throwable;
            }
        }
        return bufferedImage;
    }
}

