/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.mvel;

import java.util.Map;
import org.apache.tiles.context.TilesRequestContextHolder;
import org.apache.tiles.mvel.ReadOnlyVariableResolverFactory;
import org.apache.tiles.request.Request;
import org.mvel2.integration.VariableResolver;

public class ScopeVariableResolverFactory
extends ReadOnlyVariableResolverFactory {
    private static final int SCOPE_SUFFIX_LENGTH = 5;

    public ScopeVariableResolverFactory(TilesRequestContextHolder requestHolder) {
        super(requestHolder);
    }

    @Override
    public VariableResolver createVariableResolver(String name) {
        return new ScopeVariableResolver(name);
    }

    public boolean isTarget(String name) {
        Request request = this.requestHolder.getTilesRequestContext();
        if (name.endsWith("Scope")) {
            String scopeName = name.substring(0, name.length() - 5);
            for (String availableScope : request.getAvailableScopes()) {
                if (!scopeName.equals(availableScope)) continue;
                return true;
            }
        }
        return false;
    }

    private class ScopeVariableResolver
    extends ReadOnlyVariableResolverFactory.ReadOnlyVariableResolver {
        public ScopeVariableResolver(String name) {
            super(name);
        }

        public Class getType() {
            return Map.class;
        }

        public Object getValue() {
            Request request = ScopeVariableResolverFactory.this.requestHolder.getTilesRequestContext();
            return request.getContext(this.name.substring(0, this.name.length() - 5));
        }
    }
}

