<%@ page import="java.util.regex.Pattern" %>
<%@ page import="java.util.regex.Matcher" %>
<%@ page import="com.wisedu.coeus.helper.ApplicationHelper" %>
<%@ page import="com.wisedu.coeus.core.ConstantStatic" %>
<%@ page import="com.wisedu.coeus.web.LoginContext" %>
<%@ page import="com.wisedu.coeus.core.bo.LoginUser" %>
<%@ page import="java.util.Locale" %>
<%@ page import="com.wisedu.coeus.web.LocaleResolver" %>
<%@ page import="com.wisedu.coeus.util.UrlUtils" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%
    LoginContext.setRequest(request);
    LoginContext.setResponse(response);

    LoginUser loginUser = LoginContext.load();

    Locale locale = LocaleResolver.getLocale(request);
    loginUser.setUserLocale(locale);

    String userAgent = request.getHeader("User-Agent");

    Pattern pattern;
    Matcher matcher;

    boolean find = false;

    String browseName = "";

    pattern = Pattern.compile("MSIE[ \\/]([\\d\\.]+)", Pattern.CASE_INSENSITIVE);
    matcher = pattern.matcher(userAgent);
    double version = 100.0D;
    if (matcher.find()) {
        browseName = "IE";
        version = Double.parseDouble(matcher.group(1));
        find = true;
        if (version >= 8.0D) {
            UrlUtils.redirect(request, response, "/");
            return;
        }
    }

    if (! find) {
        pattern = Pattern.compile("Chrome[ \\/]([\\d]+)", Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            browseName = "Chrome";
            version = Double.parseDouble(matcher.group(1));
            find = true;
            if (version >= 28.0D) {
                UrlUtils.redirect(request, response, "/");
                return;
            }
        }
    }

    if (! find) {
        pattern = Pattern.compile("Firefox[ \\/]([\\d]+)", Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            browseName = "FireFox";
            version = Double.parseDouble(matcher.group(1));
            find = true;
            if (version >= 28.0D) {
                UrlUtils.redirect(request, response, "/");
                return;
            }
        }
    }

    request.setAttribute("imageBasePath", ConstantStatic.getResourceDomain());
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
    <meta charset="utf-8"/>
    <title>升级浏览器</title>
    <!--[if lt IE 8]>
    <script src="iepngfix_tilebg.js"></script>
    <![endif]-->
    <style>
        body {margin: 0 auto;padding: 0;font-size: 12px;line-height: 1.42857;color: #434d57;font-family: "Microsoft Yahei",Arial, Helvetica, sans-serif;text-align:center;background-color:white;}
        #header {width: 100%;background-color: #f5f5f6;min-width: 960px;}
        .content {width: 960px;margin: 0 auto;min-height: 590px;padding: 10px 0;}
        .icon-tip-max {display: inline-block;vertical-align: middle;background-repeat: no-repeat;background-image: url(${imageBasePath}/images/browse.png);}
        h1, h2, h3, h4, h5, h6 {font-size: 100%;font-weight: normal;}
        :link, :visited, ins {text-decoration: none;}
        :link, :visited, ins {text-decoration: none;}
        a {color: #434d57;font-size: 12px;}
        img {border: 0;vertical-align: middle;}
        #inner-header {height: 94px;}
        .header-logo{text-align:center;}
        .header-logo .logo{float:none;margin-top:27px;display:inline-block;margin-left:0;}
        .browse-tip-wrap{width:960px;margin:auto;}
        .browse-tip-header{font-size:16px;border-bottom:1px solid #d0d6dc;line-height:32px;padding-bottom:8px;padding-left:10px;}
        .icon-tip-max{width:32px;height:32px;background-position:0 -210px;margin-right:5px;}
        .browse-tip-body{text-align:center;padding-top:38px;}
        .browse-tip-img{margin-left:-15px;}
        .bu-header{height:1px;background-color:#d0d6dc;position:relative;margin-top:25px;}
        .bu-text{padding:0 15px;background-color:#fff;font-size:16px;top:-10px;line-height:19px;height:20px;position:absolute;width:260px;margin-left:-105px;left:50%;}
        .bu-box{float:left;width:188px;border:1px solid white;text-align:center;transition:all 0.3s;padding:10px 0 38px 0;}
        .bu-body{width:570px;margin:18px auto;}
        .bu-box h3{font-size:16px;margin-top:15px;}
        .bu-box:hover{background-color:#f5f8f8;border-color:#dcd9d9;}
        .bu-box i{width:70px;height:70px;display:inline-block;vertical-align:middle;background:url(${imageBasePath}/images/browse.png) no-repeat;}
        .bu-box .browse-chorme{background-position:0 0;}
        .bu-box .browse-firefox{background-position:0 -70px;}
        .bu-box .browse-ie{background-position:0 -140px;}
    </style>
    <!--[if lt IE 8]>
    <style type="text/css">
        img, div, a, i { behavior: url("iepngfix.htc") }
    </style>
    <![endif]-->
</head>
<body>
<div id="header">
    <div id="inner-header" class="header-logo clearfix">
        <a class="logo" href="javascript:void(0)"> <img src="${imageBasePath}/images/logo.png"/> </a>
    </div>
</div>
<div class="content">
    <div class="browse-tip-wrap">
        <h3 class="browse-tip-header">
            <i class="icon-tip-max"></i>正在使用 <%=browseName%> <%=version%> 内核的浏览器，版本过低，请进行模式更改或升级到最新版本！
        </h3>
        <div class="browse-tip-body">
            <img class="browse-tip-img" src="${imageBasePath}/images/browser-tip.jpg"/>
            <div class="browse-update">
                <div class="bu-header">
                    <span class="bu-text">您还可以安装使用以下浏览器</span>
                </div>
                <div class="bu-body clearfix">
                    <a href="http://rj.baidu.com/soft/detail/14744.html" class="bu-box" target="_blank">
                        <i class="browse-chrome"></i>
                        <h3>谷歌浏览器</h3>
                    </a>
                    <a href="http://rj.baidu.com/soft/detail/11843.html" class="bu-box" target="_blank">
                        <i class="browse-firefox"></i>
                        <h3>Firefox</h3>
                    </a>
                    <a href="http://rj.baidu.com/soft/detail/23253.html" class="bu-box" target="_blank">
                        <i class="browse-ie"></i>
                        <h3>Internet Explorer 8</h3>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<%
    LoginContext.clear();
%>