<%@ page language="java" pageEncoding="utf-8" %>
<%@include file="/WEB-INF/jsp/includes.jsp" %>
<c:set var="pageCount" value="${pageMaker.pageCount}"></c:set>
<c:set var="pageIndex" value="${pageMaker.pageIndex==0?1:pageMaker.pageIndex}"></c:set>
<c:set var="pageSize" value="${pageMaker.pageSize}"></c:set>
<c:set var="rowCount" value="${pageMaker.rowCount}"></c:set>
<c:if test="${pageCount>1 || (rowCount>10 && (pageSize eq 10 || pageSize eq 20 || pageSize eq 30 || pageSize eq 40 || pageSize eq 50))}">
    <div class="pagination page-mod" id="${(empty pageId)?'pageId':pageId}">
        <span class="pcount-total">总记录数：${pageMaker.rowCount}</span>
        <ul class="clearfix">
        	<c:if test="${pageSizeChange!=1 && (pageSize eq 10 || pageSize eq 20 || pageSize eq 30 || pageSize eq 40 || pageSize eq 50)}">
				<li class="page-dropdown">每页
					<select class="page-select">
						<option value="10" <c:if test="${pageSize eq 10}">selected="selected"</c:if>>10</option>
						<option value="20" <c:if test="${pageSize eq 20}">selected="selected"</c:if>>20</option>
						<option value="30" <c:if test="${pageSize eq 30}">selected="selected"</c:if>>30</option>
						<option value="40" <c:if test="${pageSize eq 40}">selected="selected"</c:if>>40</option>
						<option value="50" <c:if test="${pageSize eq 50}">selected="selected"</c:if>>50</option>
					</select>条
				</li>
			</c:if>
			<li class="page-first <c:if test="${pageIndex eq 1}">disabled</c:if>">
				<a href="javascript:void(0)" id="page-first" pageNum="1">首页</a>
			</li>
			<li class="page-prev <c:if test="${pageIndex eq 1}">disabled</c:if>">
                <a href="javascript:void(0);" id="page-prev"
                   pageNum='${(pageIndex-1) gt 0?(pageIndex-1):1}'>上一页</a>
            </li>
            <li class="page-num ${(pageIndex eq 1)?'current':''}">
                <a href="javascript:void(0);" pageNum="1">1</a>
            </li>
            <c:if test="${pageCount gt 1}">
                <c:if test="${pageIndex-2 gt 3}">
                    <li class="page-num">
                        <a class="page-dot" href="javascript:void(0);">...</a>
                    </li>
                </c:if>
                <c:forEach var="page" begin="${(pageIndex-5) gt 0?(pageIndex-2):2}"
                           end="${((pageCount-pageIndex) gt 4) ?(pageIndex+2):pageCount-1}">
                    <li class="page-num ${(page eq pageIndex)?'current':''}">
                        <a href="javascript:void(0);" pageNum="${page}">${page}</a>
                    </li>
                </c:forEach>
                <c:if test="${pageCount-pageIndex gt 4}">
                    <li class="page-num ">
                        <a class="page-dot" href="javascript:void(0);">...</a>
                    </li>
                </c:if>
                <li class="page-num ${(pageCount eq pageIndex)?'current':''}">
                    <a href="javascript:void(0);" pageNum='${pageCount}'>${pageCount}</a>
                </li>
            </c:if>
            <li class="page-next <c:if test="${pageIndex eq pageCount}">disabled</c:if>">
                <a href="javascript:void(0);" id="page-next"
                   pageNum='${(pageIndex+1) gt pageCount?pageCount:(pageIndex+1)}'>下一页</a>
            </li>
            <li class="page-last <c:if test="${pageIndex eq pageCount}">disabled</c:if>">
            	<a href="javascript:void(0)" id="page-last" pageNum="${pageCount}">尾页</a>
            </li>
            <li class="page-action">
                <input type="text" class="input-text input-page" title="Enter Search" _type="changeIndex">
                <span class="page-total">/${pageCount}页</span>
            </li>
        </ul>
    </div>
</c:if>

<script>
    $(function () {
		var $pageSelect = $("#${(empty pageId)?'pageId':pageId}").find(".page-select").select({
			change:function(){
				if (this.value == '${pageSize}') {
	                return;
	            }
				var fn = "${(empty gotoCallback)?'':gotoCallback}";
		
	            if (fn.length > 0) {
	                fn = fn+"(" + 1 + ",\""+"${(empty pageId)?'pageId':pageId}"+"\","+this.value+")";
	                eval(fn);
	            } else {
	            	gotoPage(1, "${(empty pageId)?'pageId':pageId}",this.value);
	            }
			}
		});
        
        $("#${(empty pageId)?'pageId':pageId}").find(".page-num,.page-prev,.page-next,.page-first,.page-last").click(function () {
            var pageNum = $(this).children('a').attr("pageNum");
            if (typeof(pageNum) == 'undefined') {
                return;
            }
            if (pageNum == '${pageIndex}') {
                return;
            }
            var fn = "${(empty gotoCallback)?'':gotoCallback}";

            if (fn.length > 0) {
                fn = fn+"(" + pageNum + ",\""+"${(empty pageId)?'pageId':pageId}"+"\","+$pageSelect.val()+")";
                eval(fn);
            } else {
            	gotoPage && gotoPage(pageNum, "${(empty pageId)?'pageId':pageId}", $pageSelect.val());
            }
        })
        $("#${(empty pageId)?'pageId':pageId}").find('[_type="changeIndex"]').on("keyup.changeIndex", function (event) {
            var $this = $(this);
            if ($.trim($this.val()||"").length > 0) {
                var pageNum = parseInt($this.val())
                if (isNaN(pageNum)) {
                    pageNum = 0;
                }
                if (pageNum > "${pageCount}") {
                    pageNum = " ${pageCount}" || 0;
                }
                if (pageNum < 1) {
                    pageNum = 1
                }
                if (pageNum == '${pageIndex}') {
                    return;
                }
                if (event.keyCode == 13) {
                	var fn = "${(empty gotoCallback)?'':gotoCallback}";

                    if (fn.length > 0) {
                        fn = fn+"(" + pageNum + ",\""+"${(empty pageId)?'pageId':pageId}"+"\","+$pageSelect.val()+")";
                        eval(fn);
                    } else {
                    	gotoPage(pageNum, "${(empty pageId)?'pageId':pageId}", $pageSelect.val());
                    }
                }
            }

        })
    })
</script>