package com.wisedu.mooc.app.user.bo;

import com.wisedu.mooc.app.user.UserConstant;
import java.util.Date;
import javax.persistence.*;

@Entity
@Table(name = "mooc_user_info")
public class UserInfo implements java.io.Serializable{

	/** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The user id. */
    private Long userId;

    /** The login name. */
    private String loginName;

    /** The nick name. */
    private String nickName;

    /** The password. */
    private String password;

    /** The last login date. */
    private Date lastLoginDate;

    /** The useravatar. */
    private String useravatar;

    /** The delete flag. */
    private Integer deleteFlag;

    /** The useravatar90. */
    private String useravatar90;

    /** The useravatar60. */
    private String useravatar60;

    /** The useravatar30. */
    private String useravatar30;

    /** The role. */
    private Integer role; //角色 10，管理员，20:普通用户
    
    private Long lastItemId;
    
    /**
     * Gets the user id.
     * 
     * @return the user id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "USER_ID", unique = true, nullable = false)
    public Long getUserId() {
        return this.userId;
    }

    
    /**
     * Sets the user id.
     * 
     * @param userId the user id
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * Gets the login name.
     * 
     * @return the login name
     */
    @Column(name = "LOGIN_NAME", length = 128)
    public String getLoginName() {
        return this.loginName;
    }

    /**
     * Sets the login name.
     * 
     * @param loginName the login name
     */
    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    

    /**
     * Gets the nick name.
     * 
     * @return the nick name
     */
    @Column(name = "NICK_NAME", length = 128)
    public String getNickName() {
        return this.nickName;
    }

    /**
     * Sets the nick name.
     * 
     * @param nickName the nick name
     */
    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    /**
     * Gets the password.
     * 
     * @return the password
     */
    @Column(name = "PASSWORD", length = 128)
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets the password.
     * 
     * @param password the password
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Gets the last login date.
     * 
     * @return the last login date
     */
    @Column(name = "LAST_LOGIN_DATE", precision = 22, scale = 0)
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    /**
     * Sets the last login date.
     * 
     * @param lastLoginDate the last login date
     */
    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    /**
     * Gets the useravatar.
     * 
     * @return the useravatar
     */
    @Column(name = "useravatar")
    public String getUseravatar() {
        return useravatar;
    }

    /**
     * Sets the useravatar.
     * 
     * @param useravatar the useravatar
     */
    public void setUseravatar(String useravatar) {
        this.useravatar = useravatar;
    }


    /**
     * Gets the delete flag.
     * 
     * @return the delete flag
     */
    @Column(name = "DELETE_FLAG")
    public Integer getDeleteFlag() {
        return this.deleteFlag;
    }

    /**
     * Sets the delete flag.
     * 
     * @param deleteFlag the delete flag
     */
    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    /**
     * Gets the role.
     * 
     * @return the role
     */
    @Column(name = "role")
	public Integer getRole() {
		return role;
	}

	/**
	 * Sets the role.
	 * 
	 * @param role the role
	 */
	public void setRole(Integer role) {
		this.role = role;
	}

	@Column(name = "LAST_ITEM_ID")
	public Long getLastItemId() {
		return lastItemId;
	}


	public void setLastItemId(Long lastItemId) {
		this.lastItemId = lastItemId;
	}

	public void setUseravatar90(String useravatar90) {
		this.useravatar90 = useravatar90;
	}

	/**
     * Gets the useravatar90.
     *
     * @return the useravatar90
     */
	@Transient
    public String getUseravatar90() {
        return UserConstant.getUserHeadImage(useravatar, 90);
    }
	
	public void setUseravatar60(String useravatar60) {
		this.useravatar60 = useravatar60;
	}

    /**
     * Gets the useravatar60.
     *
     * @return the useravatar60
     */
	@Transient
    public String getUseravatar60() {
        return UserConstant.getUserHeadImage(useravatar, 60);
    }

	public void setUseravatar30(String useravatar30) {
		this.useravatar30 = useravatar30;
	}

	/**
     * Gets the useravatar30.
     *
     * @return the useravatar30
     */
	@Transient
    public String getUseravatar30() {
		return UserConstant.getUserHeadImage(useravatar, 30);
    }
	
}
