package com.wisedu.mooc.app.upload.service;

import com.wisedu.mooc.app.upload.RsConstant;
import com.wisedu.mooc.app.upload.exception.UploadException;
import com.wisedu.mooc.app.upload.service.impl.ResUploadServiceImpl;
import com.wisedu.mooc.app.upload.service.impl.UserUploadServiceImpl;

/**
 * 上传实例获取工厂类
 * @author 01115035
 *
 */
public class UploadFactory {

	/**
	 * 根据参数获取上传文件实例
	 * @param uploadResType
	 * @return
	 * @throws UploadException
	 */
    public static UploadService getInstance(String uploadResType) throws UploadException {
        UploadService uploadService = null;
        // 用户头像
        if (uploadResType.equals(RsConstant.USR_PIC_PATH)) {
            uploadService = new UserUploadServiceImpl();
        }
        // 基本资源类
        if (uploadResType.equals(RsConstant.NODES_PATH)) {
        	uploadService = new ResUploadServiceImpl();
        }
        
        return uploadService;
    }
}
