package com.wisedu.mooc.app.upload.exception;

import com.wisedu.coeus.core.exception.CoeusBaseException;

/**
 * 上传自定义异常类
 * @author 01115035
 *
 */
public class UploadException extends CoeusBaseException {



    public UploadException(String code, String message) {
        super(code, message);
    }

    public UploadException(String code, String message, String messageId) {
        super(code, message, messageId);
    }

    public UploadException(Throwable throwable) {
        super(throwable);
    }

    public static final String UPLOAD_RES_TYPE_ERROR = "250001";  //文件上传失败，没有匹配到（resource,schimg,usrimg）中的任何一个
    public static final String UPLOAD_FILE_INVALID = "250002";//用户文件不是有效地文件格式
    public static final String UPLOAD_SAVE_FILE_ERROR = "250003"; //文件写入失败
    public static final String UPLOAD_FILE_NOT_EXIST = "250004"; //文件未找到
    public static final String MOVE_FILE_ERROR = "250005"; //移动文件失败
    public static final String MOVE_FILE_NOT_EXIST = "250006"; //移动源文件不存在
    public static final String UPLOAD_PARAM_INVALID = "250007"; //移动源文件不存在
    public static final String UPLOAD_FILE_ENCODEING_INVALID = "250008";//用户文件不是有效地文件编码格式
    public static final String UPLOAD_FILE_EXT_INVALID = "25009"; //无效文件后缀
    public static final String UPLOAD_FILE_SRT_ENCODEING_INVALID = "250010";//不是有效地文件编码格式
}
