package com.wisedu.mooc.app.thirdparty.service;

import com.wisedu.mooc.app.thirdparty.service.impl.AliyunImageHandler;
import com.wisedu.mooc.app.thirdparty.service.impl.AliyunVideoHandler;
import com.wisedu.mooc.app.upload.RsConstant;
import com.wisedu.mooc.app.upload.exception.UploadException;

/**
 * 处理工厂类
 * @author 01115035
 *
 */
public class HandlerFactory {

    public static Handler getInstance(String handlerName) throws UploadException {
    	Handler handler = null;
        // 阿里云处理类
        if (handlerName.equals(RsConstant.UPLOAD_RESOURCE_ALIYUN_HANDLER_VIDEO)) { //视频处理
        	handler = new AliyunVideoHandler();
        }else if(handlerName.equals(RsConstant.UPLOAD_RESOURCE_ALIYUN_HANDLER_IMAGE)){ //图片处理
        	handler = new AliyunImageHandler();
        }
        return handler;
    }
}
