package com.wisedu.mooc.app.study.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.DateUtils;
import com.wisedu.mooc.app.platform.bo.UnitItem;
import com.wisedu.mooc.app.platform.service.UnitItemService;
import com.wisedu.mooc.app.study.bo.UserStudy;
import com.wisedu.mooc.app.study.dao.UserStudyDao;
import com.wisedu.mooc.app.study.service.UserStudyService;


@Service("userStudyService")
public class UserStudyServiceImpl implements UserStudyService {
	
	@Autowired
	private UserStudyDao userStudyDao;
	@Autowired
	private UnitItemService unitItemService;
	
	/**
	 * 用户学习记录
	 * @return
	 */
	@Override
	public List<UserStudy> queryUserStudyRecord(Long userId) {
		return this.userStudyDao.queryUserStudyRecord(userId,null);
	}

	@Override
	public List<UserStudy> queryUserStudy(Long unitId, Integer isOver, Long userId) {
		return this.userStudyDao.queryUserStudy(unitId, isOver, userId);
	}

	@Override
	public UserStudy queryUserStudy(Long itemId, Long userId) {
		return this.userStudyDao.queryUserStudy(itemId, userId);
	}
	
	/**
	 * 更新学习时长(视频)
	 * 
	 * @param itemId
	 *            条目id
	 * @param currentPosition
	 *            当前时间点
	 * @param isOver
	 *            是否结束 1.学习中；2.已学完
	 * @param duration
	 *            视频最大时长
	 * @return
	 */
	@Override
	public void updateDurationVideo(Long itemId, Long currentPosition, Integer isOver, Long duration, Long userId) {
		// 获取条目对象
		UnitItem item = this.unitItemService.queryUnitItemById(itemId);

		// 更新学习时长
		UserStudy userStudy = this.userStudyDao.queryUserStudy(itemId, userId);
		if (userStudy == null) {//首次更新数据
			Date date = DateUtils.getCurrentDate();
			userStudy = new UserStudy();
			userStudy.setDuration(duration);//视频总时长
			userStudy.setFirstDate(date);
			userStudy.setFirstTimedate(date.getTime());

			userStudy.setItemId(itemId);

			userStudy.setUnitId(item.getUnitId());
			userStudy.setUserId(userId);
			//学完或剩余不足一分钟系统默认为学完
			if (isOver == UserStudy.IS_OVER_YES
					|| ((currentPosition + ConstantStatic.STUDY_OVER_DEFAULT_TIME) >= duration)) {//剩余不足时间（此处为一分钟），计算为学习完成
				userStudy.setCurrentPosition(0L);//当前学习的点
				userStudy.setIsOver(UserStudy.IS_OVER_YES);
				userStudy.setMaxPosition(duration);//用户看过的最长的时间点
			} else {
				userStudy.setCurrentPosition(currentPosition);
				userStudy.setIsOver(UserStudy.IS_OVER_NO);
				userStudy.setMaxPosition(currentPosition);
			}
			this.userStudyDao.insert(userStudy);
		} else {
			Long maxPosition = 0L;
			if (isOver == UserStudy.IS_OVER_YES
					|| ((currentPosition + ConstantStatic.STUDY_OVER_DEFAULT_TIME) >= userStudy
							.getDuration())) {
				isOver = UserStudy.IS_OVER_YES;
				currentPosition = 0L;
				maxPosition = duration;
			} else if (currentPosition < userStudy.getMaxPosition()) {
				maxPosition = userStudy.getMaxPosition();
			} else if (currentPosition >= userStudy.getMaxPosition()) {//当前学习点大于最大学习时间点，更新最大学习时间点
				maxPosition = currentPosition;
			}
			userStudy.setCurrentPosition(currentPosition);
			if (userStudy.getIsOver() == UserStudy.IS_OVER_NO){//学习完成后不再更新学习状态
				userStudy.setIsOver(isOver);
			}
			userStudy.setMaxPosition(maxPosition);
			this.userStudyDao.update(userStudy);
		}
	}
}
