package com.wisedu.mooc.app.platform.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.wisedu.coeus.util.Strings;
import org.springframework.stereotype.Repository;

import com.wisedu.coeus.core.dao.BaseDao;
import com.wisedu.mooc.app.platform.bo.Unit;
import com.wisedu.mooc.app.platform.bo.UnitItem;

@Repository("unitItemDao")
public class UnitItemDao extends BaseDao {
	
	public List<Unit> queryUnitList(){
		String sql = "select * from mooc_unit where delete_flag=0 order by display_order";
		Map<String, Object> params = new HashMap<String, Object>();
		return this.queryForBeanList(Unit.class, sql, params, 0, 0);
	}

    /**
     * 检索单元信息
     * @return
     */
    public List<Unit> queryUnit(Long unitId) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql="select * from mooc_unit where delete_flag = 0 ";
        if (Strings.isNotEmpty(unitId)){
            sql = sql +" and unit_id=:unitId";
            params.put("unitId",unitId);
        }
        return this.queryForBeanList(Unit.class, sql, params, 0, 0);
    }

    public List<UnitItem> queryItemList(Long unitId){
		String sql = "select * from mooc_unit_item where unit_id=:unitId and delete_flag=0 order by display_order";
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("unitId", unitId);
		return this.queryForBeanList(UnitItem.class, sql, params, 0, 0);
	}
	
	public Unit queryUnitById(Long unitId){
		return this.load(Unit.class, unitId);
	}
	
	public UnitItem queryUnitItem(Long itemId){
		return this.load(UnitItem.class, itemId);
	}
	
	public void saveUnitItem(UnitItem unitItem){
		this.insert(unitItem);
	}

	public void updateUnitItem(UnitItem unitItem){
		this.update(unitItem);
	}
	
	public Integer queryMaxDisplayOrder(Long unitId){
		String sql = "select max(display_order) from mooc_unit_item where unit_id=:unitId and delete_flag=0 ";
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("unitId", unitId);
		return this.queryForInt(sql, params);
	}

    /**
     * 检索unit下的所有视频信息
     * @return
     */
    public List<UnitItem> queryUnitItem(List<Long> unitIdList) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql="select * from mooc_unit_item where delete_flag = 0 ";
        if (unitIdList!=null && unitIdList.size()>0){
            sql = sql +" and unit_id in(:unitIdList)";
            params.put("unitIdList",unitIdList);
        }
        sql = sql +" order by display_order asc";
        return this.queryForBeanList(UnitItem.class, sql, params, 0, 0);
    }

    public int queryMaxOrder(){
        Map<String, Object> params = new HashMap<String, Object>();
        String sql="select ifnull(max(display_order),0) as display_order from mooc_unit ";
        return this.queryForInt(sql, params);
    }

    public List<Unit> queryUnitListById(List<Long> unitIdList) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql=" select * from mooc_unit "
                 + " where delete_flag = 0 ";
        if (unitIdList!=null && unitIdList.size()>0){
            sql = sql +" and unit_id in(:unitIdList)";
            params.put("unitIdList",unitIdList);
        }
        return this.queryForBeanList(Unit.class, sql, params, 0, 0);
    }

    public List<UnitItem> queryItemListById(List<Long> itemIdList) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql=" select * from mooc_unit_item "
                + " where delete_flag = 0 ";
        if (itemIdList!=null && itemIdList.size()>0){
            sql = sql +" and item_id in(:itemIdList)";
            params.put("itemIdList",itemIdList);
        }
        return this.queryForBeanList(UnitItem.class, sql, params, 0, 0);
    }
}
