package com.wisedu.mooc.app.log.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.util.Strings;
import com.wisedu.mooc.app.log.LogConstant;
import com.wisedu.mooc.app.log.bo.LogStudy;
import com.wisedu.mooc.app.log.bo.LogStudyPos;
import com.wisedu.mooc.app.log.dao.LogStudyDao;
import com.wisedu.mooc.app.log.service.LogStudyService;
@Service("logStudyService")
public class LogStudyServiceImpl implements LogStudyService {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(LogStudyServiceImpl.class);

	@Autowired
	private LogStudyDao logStudyDao; 
	
    @Override
    public void insertLog(LogStudy logStudy, LogStudyPos logStudyPos) {
    	
        List<LogStudy> list = this.logStudyDao.queryLogList(logStudy);
        //生成一个随机串作为学习记录表的id
        String posId= Strings.getUUID();
        if (list.size() == 0) {
            // 设置第一个访问点
            String logId= Strings.getUUID();

            logStudy.setLogId(logId);
            logStudy.setVisitPosCount(1);
            logStudy.setVisitFirstPos(logStudyPos.getVisitPos());
            logStudy.setVisitLastPos(logStudyPos.getVisitPos());
            logStudy.setLastPosId(posId);
            // 新的访问记录
            this.logStudyDao.insert(logStudy);

            logStudyPos.setPosId(posId);
            logStudyPos.setLogId(logId);
            //行为类型（进入、暂停、快进、快退、离开等）
            logStudyPos.setActionType(LogConstant.ACTIONTYPE_START);
            this.logStudyDao.insert(logStudyPos);
        } else {
            Long diff = 0L;
            LogStudy exitsStudy = list.get(0);
            // 获取上次访问点
            LogStudyPos lastStudyPos = this.logStudyDao.queryLogStudyPos(exitsStudy.getLastPosId());
            if (lastStudyPos != null) {
            	if (lastStudyPos.getActionType()==50){
                	return;
                }
                // 更新上次访问点的持续时间
                diff = logStudyPos.getVisitTime() - lastStudyPos.getVisitTime();
                lastStudyPos.setVisitDuration(diff.intValue());
                try {
                    this.logStudyDao.merge(lastStudyPos);
                } catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }

            // 保存本次访问点
            logStudyPos.setPosId(posId);
            logStudyPos.setLogId(exitsStudy.getLogId());
            this.logStudyDao.insert(logStudyPos);

            // 更新已存在日志记录
            diff = logStudyPos.getVisitTime() - exitsStudy.getVisitTime();

            exitsStudy.setVisitDuration(diff.intValue());
            exitsStudy.setVisitPosCount(exitsStudy.getVisitPosCount()+1);
            exitsStudy.setVisitLastPos(logStudyPos.getVisitPos());
            exitsStudy.setLastPosId(posId);

            try {
                this.logStudyDao.merge(exitsStudy);
            } catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }
}
