package com.wisedu.mooc.app.log.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.wisedu.coeus.core.dao.BaseDao;
import com.wisedu.mooc.app.log.bo.LogStudy;
import com.wisedu.mooc.app.log.bo.LogStudyPos;

@Repository("logStudyDao")
public class LogStudyDao extends BaseDao{
	
	/**
	 * 通过session和key获取同一次的学习行为记录
	 * @param logStudy
	 * @return
	 */
	public List<LogStudy> queryLogList(LogStudy logStudy){
		String sql = "select * from log_study where visit_session=:visitSession and visit_key=:visitKey";
        Map<String, Object> map = new HashMap<String, Object>();

        map.put("visitSession", logStudy.getVisitSession());
        map.put("visitKey", logStudy.getVisitKey());

        List<LogStudy> list = this.queryForBeanList(LogStudy.class, sql, map, 1, 1);
        return list;
	}

	public LogStudyPos queryLogStudyPos(String posId) {
        return this.load(LogStudyPos.class, posId);
    }
}
