package com.wisedu.mooc.app.home.exception;

import com.wisedu.coeus.core.exception.CoeusBaseException;

public class HomeException extends CoeusBaseException {

    public static final String EMAIL_EXIST = "610001";

    public static final String EMAIL_NULL = "610002";

    public static final String PASSWORD_NULL = "610003";

    public static final String PASSWORD_ERROR = "610004"; //密码错误

    public static final String EMAIL_ERROR = "610005";

    public static final String EMAIL_NOT_EXIST = "610006";

    public static final String LOGIN_ERROR = "610007";

    //激活
    public static final String ACTIVE_FALSE = "610008";

    public static final String STUDENT_NO_EXIST = "610009"; //学号不存在

    public static final String IDCARD_NULL = "610010"; //身份证后4位不正确

    public static final String USER_NOT_EXIST = "610011"; //用户不存在

    public static final String CHECKCODE_ERROR = "610012"; //验证码不正确

    public static final String ACTIVE_FLAG_TRUE = "610013"; //	账号已经激活

    public static final String STUDENTNO_NULL = "610014"; //	学号为空

    public static final String SCHOOL_NULL = "610015"; //	学校为空

    public static final String USERNAME_NULL = "610016"; //	姓名为空

    public static final String SCHOOL_ERROR = "610017"; //	学校错误

    public static final String USERNAME_ERROR = "610018"; //	姓名错误

    public static final String STUDENTNO_ERROR = "610019"; //	学号错误

    public static final String USERSTATUS_DISABLED = "610020"; //	账户已禁用

    public static final String CONFIRMPASSWORD_ERROR = "610021"; //	确认密码输入错误

    public static final String EMIAL_ACTIVE_FALSE = "610022"; //	账户未激活

    public static final String REPEATED_ERROR = "610023";

    public static final String REPEATED_STUDENTNO_ERROR = "610024"; //学号重复，请联系管理员

    public static final String REPEATED_SPOCUSER_NOTLOGIN = "610026"; //非SPOC用户，不能登录

    public static final String REPEATED_ALLIANCEUSER_NOTLOGIN = "610027"; //非联盟及成员下的用户，不能登录

    public static final String IDCARD_ERROR = "610028"; //身份证不正确

    public static final String INPUT_USER_NAME_ERROR = "610029"; //输入的用户姓名与库中的姓名不一致

    public static final String USER_MOBILE_EXIST = "610030"; //注册-手机号码已经存在

    public static final String MOBILE_VERIFYCODE_VALID = "610031"; //手机短信码失效

    public static final String MOBILE_NOT_VERIFY = "610032"; //手机短信码失效

    public static final String VERIFY_CODE_ERROR = "610033"; //图片验证码不匹配

    public static final String MOBILE_NOTEXIST = "610034"; //手机号不存在

    public static final String TRACK_CODE_NOT_VERIFY = "610035"; //邀请码失效

    public static final String CURRENT_USER_LOGINED = "610133"; //当前用户已登录

    public static final String EMAIL_MUTI_ERROR = "610134"; //当前用户已登录

    public static final String EMAIL_NOTEXIST_ERROR = "610135"; //邮箱不存在

    public static final String ACCOUNT_ALREADY_EXISTS = "610136"; //账号已存在

    public HomeException(String code, String message) {
        super(code, message);
    }

    public HomeException(String code, String message, String messageId) {
        super(code, message, messageId);
    }

    public HomeException(Throwable throwable) {
        super(throwable);
    }


}
