package com.wisedu.coeus.web;

import java.util.Locale;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;

import com.wisedu.coeus.core.bo.LoginUser;
import com.wisedu.mooc.app.user.bo.UserInfo;

/**
 * Created by 01112026 on 14-7-28.
 */
public class LocaleResolver extends CookieGenerator implements org.springframework.web.servlet.LocaleResolver {
    public static final String REQUEST_LOCALE_KEY = "REQUEST_LOCALE";
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final String USER_LOCALE_COOKIE_KEY = "userLocale";

    public Locale resolveLocale(HttpServletRequest request) {
        return getLocale(request);
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (locale != null) {
            request.setAttribute(REQUEST_LOCALE_KEY, locale);
        }
    }

    public static Locale getLocale() {
        LoginUser loginUser = LoginContext.getLoginUser();

        if (loginUser == null || loginUser.getUserLocale() == null) {
            return DEFAULT_LOCALE;
        }

        return loginUser.getUserLocale();
    }

    public static Locale getLocale(HttpServletRequest request) {

        if (request == null) {
            return DEFAULT_LOCALE;
        }

        // 从用户的cookie中获取用户语言设置
        String userLocale = getCookie(request, USER_LOCALE_COOKIE_KEY);

        if (! StringUtils.isEmpty(userLocale)) {
            // 把cookie中的locale

            return getNewLocale(userLocale);
        }

        LoginUser loginUser = LoginContext.getLoginUser();

        if (loginUser == null) {
            return getRequestLocale(request);
        }

        if (loginUser.getUserLocale() != null) {
            return loginUser.getUserLocale();
        }

        UserInfo userInfo = loginUser.getUserInfo();

//        // 获取用户语言设置
//        if (curUser != null && !StringUtils.isEmpty(curUser.getLang())) {
//            return getNewLocale(curUser.getLang());
//        }

        // 从request中获取当前的locale
        return getRequestLocale(request);
    }

    public static Locale getRequestLocale(HttpServletRequest request) {
        Locale locale = request.getLocale();
        if (locale.getLanguage().equalsIgnoreCase("en")) {
            return getNewLocale("en_US");
        }
        if (locale.getLanguage().equalsIgnoreCase("zh")) {
            return getNewLocale("zh_CN");
        }
        return getNewLocale("en_US");
    }

    public static Locale getNewLocale(String userLocale) {
        if (StringUtils.isEmpty(userLocale)) {
            return DEFAULT_LOCALE;
        }
        Locale locale = null;

        int idx = userLocale.indexOf('_');

        if (idx < 0) {
            locale = new Locale(userLocale);
        }
        else {
            String language = userLocale.substring(0, idx);
            String country = userLocale.substring(idx + 1);
            locale = new Locale(language, country);
        }

        return locale;
    }

    private static String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();

        if (cookies == null || cookies.length == 0) {
            return null;
        }

        Cookie cookie = null;

        for (int i = 0, length = cookies.length; i < length; i++) {
            cookie = cookies[i];
            if (cookie == null) {
                continue;
            }

            if (cookie.getName() != null && cookie.getName().equals(key)) {
                return cookie.getValue();
            }
        }

        return null;
    }
}
