package com.wisedu.coeus.web;

import org.springframework.core.convert.converter.Converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by 01112026 on 14-8-15.
 */
public class DateConverter implements Converter<String, Date> {
    @Override
    public Date convert(String source) {
        String format = "yyyy-MM-dd";
        int pos = source.indexOf(":");
        if (pos > 0) {
        	if (source.indexOf(":",pos+1) > pos) {
        		format = "yyyy-MM-dd HH:mm:ss";
        	} else {
        		format = "yyyy-MM-dd HH:mm";
        	}
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        try {
            return dateFormat.parse(source);
        } catch (ParseException e) {
        }
        return null;
    }
}