package com.wisedu.coeus.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;

/**
 * Created by 01112018 on 14-8-21.
 * 用于处理类对象转化
 */
public class ObjectUtils {
    protected static Logger LOGGER = LoggerFactory.getLogger(ObjectUtils.class);

    public static List<Method> filterSetMethods(Method[] outputObjectMethods) {
        List<Method> methodList = new ArrayList<Method>();
        for (Method outputObjectMethod : outputObjectMethods) {
            if (outputObjectMethod.getName().indexOf("set") == 0) {
                methodList.add(outputObjectMethod);
            }
        }
        return methodList;
    }



    public static void objectConcat(Object receive, Object transmit) {
        Field[] rFieldArr = receive.getClass().getDeclaredFields();
        Field[] tFieldArr = transmit.getClass().getDeclaredFields();
        for (Field rField : rFieldArr) {
            for (Field tField : tFieldArr) {
                rField.setAccessible(true);
                tField.setAccessible(true);
                if (rField.getName().equals(tField.getName())) {
                    try {
                        rField.set(receive, tField.get(transmit));
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}
