package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.util.Strings;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Created by 01112026 on 15-11-30.
 */
public abstract class TextTag extends TagSupport {
    @Override
    public int doEndTag() throws JspException {
        final String content = getOutputText();
        if (Strings.isNotEmpty(content)) {
            try {
                pageContext.getOut().write(content);
            } catch (IOException e) {
                throw new JspException(e);
            }
        }

        return EVAL_PAGE;
    }

    protected abstract String getOutputText();
}
