package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.Strings;

/**
 * Created by 01112026 on 14-8-1.
 */
public class IMGTag extends StaticResourceTag {
    private String className;
    private String type;
    private String style;
    private String id;
    private String alt;
    private String onload;
    private String onerror;

    public void setClassName(final String className) {
        this.className = className;
    }

    public void setStyle(final String style) {
        this.style = style;
    }

    public void setAutoLocale(boolean autoLocale) {
        this.autoLocale = autoLocale;
    }

    public void setSrc(final String href) {
        this.resourceUrl = href;
    }

    public void setType(final String type) {
       this.type = type;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    @Override
    protected String getOutputHtml() {
        final StringBuilder sbHtml = new StringBuilder(256);

        sbHtml.setLength(0);

        if ("background".equals(type)) {
            sbHtml.append(getResourceUrl());
        } else {
            sbHtml.append("<img src=\"").append(getResourceUrl()).append("\" ");

            if (Strings.isNotEmpty(className)) {
                sbHtml.append(" class=\"").append(className).append("\"");
            }

            if (Strings.isNotEmpty(style)) {
                sbHtml.append(" class=\"").append(style).append("\"");
            }
            if (Strings.isNotEmpty(id)) {
                sbHtml.append(" id=\"").append(id).append("\"");
            }
            if (Strings.isNotEmpty(alt)) {
                sbHtml.append(" alt=\"").append(alt).append("\"");
            }
            if (Strings.isNotEmpty(onload)) {
                sbHtml.append(" onload=\"").append(onload).append("\"");
            }
            if (Strings.isNotEmpty(onerror)) {
                sbHtml.append(" onerror=\"").append(onerror).append("\"");
            }
            sbHtml.append("/>");
        }

        return sbHtml.toString();
    }

    @Override
    public void release() {
        resourceUrl = null;
        className = null;
        style = null;
        alt = null;
    }

    private static String basePath;

    @Override
    protected String getBaseUrl() {
        if (basePath != null) {
            return basePath;
        }

        return ConstantStatic.getImgDomain();
    }

	public void setId(String id) {
		this.id = id;
	}

    public void setOnerror(String onerror) {
        this.onerror = onerror;
    }

    public void setOnload(String onload) {
        this.onload = onload;
    }
}

