package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.util.Strings;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Created by 01112026 on 14-9-11.
 */
public class HtmlFormatTag extends TagSupport {
    protected String value;         // 文本
    protected Boolean stripUnsafe = false;  // 当escapeHtml为false时有效，剔除非安全的标记，例如<script><style><link>
    protected Boolean escapeHtml = true;   // 转移HTML标记

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getStripUnsafe() {
        return stripUnsafe;
    }

    public void setStripUnsafe(Boolean stripUnsafe) {
        this.stripUnsafe = stripUnsafe;
    }

    public Boolean getEscapeHtml() {
        return escapeHtml;
    }

    public void setEscapeHtml(Boolean escapeHtml) {
        this.escapeHtml = escapeHtml;
    }

    @Override
    @SuppressWarnings("unchecked")
    public int doEndTag() throws JspException {
        String tempValue;
        StringBuilder sbHtml = new StringBuilder(1024);

        if (this.escapeHtml) {
            sbHtml.append(Strings.escapeHtml(this.value));
        } else {
            if (this.stripUnsafe) {
                sbHtml.append(Strings.stripUnsafeTag(this.value));
            } else {
                sbHtml.append(value);
            }
        }

        try {
            pageContext.getOut().write(sbHtml.toString());
        }
        catch (IOException e) {

        }
        return EVAL_PAGE;
    }
}
