package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.util.MessageUtils;
import com.wisedu.coeus.util.Strings;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * Created by 01112026 on 14-8-18.
 */
public class DateTimeTag extends TagSupport {

    protected Date dateValue;   // 日期值
    protected Long millisValue; // 毫秒值
    protected String pattern;   // 日期时间字符串
    protected Object timeZone;  // 时区
    protected String type;      // 类型，duration持续时间

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getDateValue() {
        return dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public Long getMillisValue() {
        return millisValue;
    }

    public void setMillisValue(Long millisValue) {
        this.millisValue = millisValue;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Object getTimeZone() {
        return timeZone;
    }

    public void setTimeZone(Object timeZone) {
        this.timeZone = timeZone;
    }



    public DateTimeTag() {
        super();
        this.dateValue = null;
        this.millisValue = null;
        this.timeZone = null;
        this.type = null;
    }


    @Override
    public int doEndTag() throws JspException {
        if ("duration".equals(this.type))
        {
            try {
                pageContext.getOut().write(formatDuration(this.millisValue));
            }
            catch (IOException e) {
                e.getMessage();
            }
            return EVAL_PAGE;
        }
        if ("duration2".equals(this.type))
        {
            try {
                pageContext.getOut().write(formatDuration2(this.millisValue));
            }
            catch (IOException e) {
                e.getMessage();
            }
            return EVAL_PAGE;
        }
        if ("residue".equals(this.type))
        {
            try {
                pageContext.getOut().write(formatResidueSecond(this.millisValue));
            }
            catch (IOException e) {
                e.getMessage();
            }
            return EVAL_PAGE;
        }
        Date date;
        String output;
        if (millisValue != null) {
            date = new Date(millisValue);
        } else if (dateValue != null) {
            date = dateValue;
        } else {
        	try {
                pageContext.getOut().write("");
            }
            catch (IOException e) {
                e.getMessage();
            }
        	return EVAL_PAGE;
            //throw new JspException("dateValue or millisValue");
        }
        TimeZone tz = null;

        if (((this.timeZone instanceof String)) && (((String)this.timeZone).equals("")))
        {
            this.timeZone = null;
        }
        if (this.timeZone != null) {
            if ((this.timeZone instanceof String)) {
                tz = TimeZone.getTimeZone((String)this.timeZone);
            } else if ((this.timeZone instanceof TimeZone)) {
                tz = (TimeZone)this.timeZone;
            } else {
                throw new JspException(MessageUtils.getMessage("FORMAT_DATE_BAD_TIMEZONE"));
            }
        }

        if ("compact".equals(pattern)) {
            output = formatCompactDateTime(date, tz);
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
            if (tz != null) {
                formatter.setTimeZone(tz);
            }
            output = formatter.format(date);
        }
        try {
            pageContext.getOut().write(output);
        }
        catch (IOException e) {
            e.getMessage();
        }
        return EVAL_PAGE;
    }

    private String formatCompactDateTime(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        long currentTimeMillis = System.currentTimeMillis();
        long time = currentTimeMillis - calendar.getTime().getTime();
        long ss = (time < 0 ? - time : time) / 1000;
        long mm = ss / 60;
        long hh = mm / 60;
        String str = "";

        if ("remain".equals(type)) {

            if (time >= 0) {
                str = "";
            }else if (ss < 60) {
                str =MessageUtils.getMessage("exam.remain.second",new Object[]{ss}); //"剩"+ss + "秒";
            }else if (mm < 60) {
                str = MessageUtils.getMessage("exam.remain.miute",new Object[]{mm}); // "剩"+mm + "分钟";
            }
            else if(hh < 24){
                str =  MessageUtils.getMessage("exam.remain.hour",new Object[]{hh}); // "剩"+hh + "小时";
            }
            else  if(hh>=24){
                str=MessageUtils.getMessage("exam.remain.day",new Object[]{hh/24}); // "剩"+hh/24 + "天";
            }
            return str;
        }
        if (ss < 0) {
            str = "";
        } else if (ss<30) {
            str = "刚刚";
        } else if (ss < 60) {
            str = ss + "秒前";
        } else if (mm < 60) {
            str = mm + "分钟前";
        } else if (hh < 24) {
            str = hh + "小时前";
        }
        if (str.length() == 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            if (timeZone != null ) {
                formatter.setTimeZone(timeZone);
            }
            str = formatter.format(calendar.getTime());
        }
        return str;
    }
    
    private String formatResidueSecond(Long time) {
        long ss = (time < 0 ? - time : time) / 1000;
        long mm = ss / 60;
        long hh = mm / 60;
        String str = "";

        if (ss < 60) {
            str =MessageUtils.getMessage("exam.remain.second",new Object[]{ss}); //"剩"+ss + "秒";
        }else if (mm < 60) {
            str = MessageUtils.getMessage("exam.remain.miute",new Object[]{mm}); // "剩"+mm + "分钟";
        }
        else if(hh < 24){
            str =  MessageUtils.getMessage("exam.remain.hour",new Object[]{hh}); // "剩"+hh + "小时";
        }
        else  if(hh>=24){
            str=MessageUtils.getMessage("exam.remain.day",new Object[]{hh/24}); // "剩"+hh/24 + "天";
        }
        return str;
    }

    private String formatDuration(Long mills){
        if (Strings.isEmpty(mills))
        {
            return "00:00:00";
        }
        long ss = (mills/1000)%60;
        long mm = (mills/60000)%60;
        long hh = mills/3600000;
        return getFormatString(hh)+":"+getFormatString(mm)+":"+getFormatString(ss);
    }

    private String getFormatString(long time){
        if (time < 10l)
        {
            return "0"+time;
        }
        return time+"";
    }
    
    private String formatDuration2(Long mills){
        if (Strings.isEmpty(mills))
        {
            return "00:00";
        }
        long ss = (mills/1000)%60;
        long mm = mills/60000;
        return getFormatString(mm)+":"+getFormatString(ss);
    }
}
