package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.Strings;

import java.util.Locale;

/**
 * coeus:css 标签
 */
public class CSSTag extends StaticResourceTag {

    // style标签中的media属性
    private String media;

    // style标签中的charset属性
    private String charset;

    public void setMedia(final String media) {
        this.media = media;
    }

    public void setCharset(final String charset) {
        this.charset = charset;
    }

    public void setAutoLocale(boolean autoLocale) {
        this.autoLocale = autoLocale;
    }

    public void setHref(final String href) {
        resourceUrl = href;
    }


    @Override
    protected String getOutputHtml() {
        final StringBuilder sbHtml = new StringBuilder(256);

        sbHtml.setLength(0);
        sbHtml.append("<link rel=\"stylesheet\" href=\"").append(getResourceUrl()).append("\" type=\"text/css\"");

        if (Strings.isNotEmpty(media)) {
            sbHtml.append(" media=\"").append(media).append("\"");
        }

        if (Strings.isNotEmpty(charset)) {
            sbHtml.append(" charset=\"").append(charset).append("\"");
        }

        sbHtml.append("/>");

        return sbHtml.toString();
    }

    @Override
    protected String getBaseUrl() {
        return null;
    }

    @Override
    public void release() {
        resourceUrl = null;
        charset = null;
        media = null;
    }

    private static String basePath;

}
