package com.wisedu.coeus.core.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.wisedu.coeus.core.bo.LoginUser;
import com.wisedu.coeus.web.LoginContext;

/**
 * 授权判断工具
 */
public class AuthHelper {
    /**
     * 判断指定登录用户是否有对应的权限
     * @param loginUser
     * @param key
     * @param type
     * @return
     */
	@SuppressWarnings("unchecked")
    public static boolean hasAuthority(LoginUser loginUser, String key, String type){
        boolean matched = false;
        int matchedCount = 0;

        // 先判断身份
        if ("identity".equals(type)) {
            List<String> identityList = loginUser.getIdentityList();
            if (identityList != null && identityList.size() > 0) {
                for (String identity : identityList) {
                    if (identity.equalsIgnoreCase(key)) {
                        matched = true;
                        break;
                    }
                }
            }

            return matched;
        }

    	Map<String, Map<String, Set<String>>> map=loginUser.getRoleKeyMap();
    	if(map == null) {
            return false;
        }

        Map<String, Map<String, Set<String>>> siteMap=new HashMap<String, Map<String, Set<String>>>();

        if (loginUser.getCurrentSiteUuid() != null && ("role".equals(type) || "function".equals(type))) {
        	siteMap.put(loginUser.getCurrentSiteUuid(), map.get(loginUser.getCurrentSiteUuid()));
        } else {
        	siteMap.putAll(map);
        	type=type.replace("*", "");
        }

        String[] keyArray = key.split("\\+");

        for (Map.Entry<String, Map<String, Set<String>>> siteEntry : siteMap.entrySet()) {
            // 循环站点
            matched = false;

            // 匹配到当前访问站点

            // 站点内权限参数存储结构
            // {
            //  "role": [role1, role2],
            //  "function": [function1, function2]
            // }
            Map<String, Set<String>> roleFunctionMap = siteEntry.getValue();

            // 根据类型获取相应列表
            Set<String> set = roleFunctionMap.get(type);

            if(set != null && set.size() > 0){
                if(keyArray.length>1){
                    //@AuthCheck(keys={"key1+key2"}) 必须同时满足key1,key2
                    matchedCount = 0;
                    for(String funKey : keyArray){
                        for(String item : set){
                            if(funKey.equalsIgnoreCase(item)){
                                matchedCount ++;
                                break;
                            }
                        }
                    }
                    if (matchedCount == keyArray.length) {
                        matched = true;
                    }
                }
                else{
                    //@AuthCheck(keys={"key1","key2"}) 只要满意一个即可
                    for(String item : set){
                        if (key.equalsIgnoreCase(item)) {
                            matched = true;
                            break;
                        }
                    }
                }
            }

            if (matched) return matched;
        }

        return matched;
    }

    /**
     * 判断当前登录用户是否有对应的权限
     * @param key
     * @param type
     * @return
     */
    public static boolean hasAuthority(String key, String type){
        return hasAuthority(LoginContext.getLoginUser(), key, type);
    }
}
