$.checkBoxToggle = $.checkBoxToggle || function (itemObj, allObj, p) {
    itemObj = itemObj || "#undefined";
    allObj = allObj || "#undefined";
    p = p || {};
    var def = {
        beforeItemClick: function (current, g) {
            return true
        },
        beforeAllClick: function (current, g) {
            return true
        },
        onItemClick: null,
        onAllClick: null
    }
    p = $.extend({}, def, p);
    $("body").off("click.checkItem", itemObj);
    $("body").on("click.checkItem", itemObj, checkBox);

    $("body").off("click.checkAll", allObj);
    $("body").on("click.checkAll", allObj, checkAll);

    function checkBox() {
        var $this = $(this);
        var oldClicked = $this.hasClass("selected");
        if (p.beforeAllClick(oldClicked, g) === "false") {
            return;
        }
        if (oldClicked) {
            $this.removeClass("selected");
            $(allObj).removeClass("selected");
        } else {
            $this.addClass("selected");
            var flag = true;
            $(itemObj).each(function () {
                if (!$(this).hasClass("selected")) {
                    flag = false;
                }
            })
            if (flag) {
                $(allObj).addClass("selected");
            }
        }
        var nowClicked = $this.hasClass("selected");
        p.onItemClick && p.onItemClick(nowClicked, g);
    }

    function checkAll() {
        var $this = $(this);
        var oldClicked = $this.hasClass("selected")
        if (p.beforeItemClick(oldClicked, g) === "false") {
            return;
        }
        if (oldClicked) {
            $this.removeClass("selected");
            $(itemObj).each(function () {
                $(this).removeClass("selected");
            });
        } else {
            $this.addClass("selected");
            $(itemObj).each(function () {
                $(this).addClass("selected");
            });
        }
        var nowClicked = $this.hasClass("selected");
        p.onAllClick && p.onAllClick(nowClicked, g);
    }


    var g = {
        getLength: function () {
            return $(itemObj + "[class *='selected']").length;
        },
        getCheckedObj: function () {
            return $(itemObj + "[class *='selected']");
        }
    }

    return g;
};
	
	
	