//定义全局变量
var imageType = '*.jpg;*.png;*.gif;*.bmp;*.webp';
var jcrop_api, boundx, boundy;
$(function () {

    $('#head_upload,#head_upload_2').uploader({
        uploadUrl: CONTEXTPATH + '/upload/file/usrimg.mooc',
        buttonTemplate: '<a id="head_upload" class="btn-public btn-replace" href="javascript:void(0)">上传头像</a>',
        fileTypeExts: imageType,
        width: 80,
        height: 30,
        method: 'post',
        multi: false,
        onSelect: function (file) {
            var json = JSON.stringify(file);
            if ((file.type == '.jpg' || file.type == '.png' || file.type == '.gif' || file.type == '.bmp' || file.type == '.webp')) {
                if (file.size > 2048000) {
                    $.warn('文件过大', 3);
                    return false;
                }
                return true;
            } else {
                $.warn('格式不正确', 3);
                return false;
            }
        },
        onUploadProgress: function (file, loadedBytes, totalBytes) {
            var process = parseInt(loadedBytes / totalBytes * 100);
            $(".view-progressbar").show();
            $(".view-progressbar").find(".progressbar-in").css("width", process + "%");
            $(".progressbar-text").html(process + "%");
        },
        onUploadSuccess: function (file, data) {
            var retData = JSON.parse(data);
            $(".view-progressbar").hide();

            var tempImageUrl = retData.fileTempUrl;

            $('#srcRFile').val(retData.fileRelativePath);
            $('#srcTFile').val(retData.fileTempPath);
            $('#srcUFile').val(tempImageUrl);
            $.upload.previewPicture(tempImageUrl);
        },
        onUploadError: function (file, errorCode, errorMsg) {
            if (errorCode) {
                $.error(errorMsg + " (" + errorCode + ")", 5);
            } else {
                $.error('操作错误', 5);
            }
        }
    });
})
$.upload = $.upload || {};
var PREVIEW_LARGE = 'preview_large';
var PREVIEW_MID = 'preview_middle';
var PREVIEW_TINY = 'preview_tiny';
//预览图片
$.upload.previewPicture = function (imageUrl) {
    var orginImg = $('.wblock-action');
    orginImg.empty();
    orginImg.append('<img id="user_avatar" src="' + imageUrl + '">');

    $('#' + PREVIEW_LARGE).attr('src', imageUrl);
    $('#' + PREVIEW_MID).attr('src', imageUrl);
    $('#' + PREVIEW_TINY + "").attr('src', imageUrl);

    $('#user_avatar').Jcrop({
        onChange: function (c) {
            $.upload.updatePreview(c, PREVIEW_LARGE);
            $.upload.updatePreview(c, PREVIEW_MID);
            $.upload.updatePreview(c, PREVIEW_TINY);
            $.upload.setCoords(c);
        },
        setSelect: [ 0, 0, 48, 48 ],
        onSelect: function (c) {
            $.upload.updatePreview(c, PREVIEW_LARGE);
            $.upload.updatePreview(c, PREVIEW_MID);
            $.upload.updatePreview(c, PREVIEW_TINY);
            $.upload.setCoords(c);
        },
        aspectRatio: 1
    }, function () {
        var bounds = this.getBounds();//获取图片实际尺寸，格式为：[w,h]
        boundx = bounds[0];    //  180
        boundy = bounds[1];    //  101
        jcrop_api = this;
    });
};


$.upload.updatePreview = function (c, previewImgId) {
    if (parseInt(c.w) > 0) {
        if (previewImgId == PREVIEW_LARGE) {
            //alert(PREVIEW_MAX)
            var px = 90;
            var py = 90;

        }
        if (previewImgId == PREVIEW_MID) {
            var px = 60;
            var py = 60;
        }
        if (previewImgId == PREVIEW_TINY) {
            var px = 30;
            var py = 30;
        }
        var rx = px / c.w;
        var ry = py / c.h;
        $('#' + previewImgId).css({
            width: Math.round(rx * boundx) + 'px',
            height: Math.round(ry * boundy) + 'px',
            marginLeft: '-' + Math.round(rx * c.x) + 'px',
            marginTop: '-' + Math.round(ry * c.y) + 'px'
        });
//        formatAvatar(".img-show img");
    }

};
$.upload.setCoords = function (c) {
    $('#x').val(c.x);
    $('#y').val(c.y);
    $('#w').val(c.w);
    $('#h').val(c.h);
};
	