<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<%@include file="/WEB-INF/jsp/includes.jsp" %>
<input type="hidden" id="currentMenu" value="unit"/>

<div class="main main-res-upload">
			    
	<input type="hidden" id="thumbFileRelativePath" value="${thumbFileRelativePath}">
	<input type="hidden" id="thumbFileTempPath" value="${thumbFileTempPath}">
	<input type="hidden" id="thumbFileTempUrl" value="${thumbFileTempUrl}">
	<input type="hidden" id="videoFileRelativePath" value="${videoFileRelativePath}">
	<input type="hidden" id="videoFileTempPath" value="${videoFileTempPath}">
	<input type="hidden" id="videoFileTempUrl" value="${videoFileTempUrl}">
	<input type="hidden" id="videoFileName" value="${videoFileName}">
	<input type="hidden" id="currentVideoFilePath" value="${currentVideoFilePath}">
	<input type="hidden" id="currentThumbFilePath" value="${currentThumbFilePath}">
	<input type="hidden" id="unitId" value="${unit.unitId}">
    <input type="hidden" id="itemId" value="${not empty item ? item.itemId : 0}">
    <div class="main-body">
    	<div class="crumbs">
            <a class="link-action" href="${contextPath}/platform/queryunit.mooc"><i class="icon-ttm icon-back02"> </i> 返回 </a>
            	&gt; 
            	<c:choose>
	           		<c:when test="${empty item}">
	           			添加视频课件
	           		</c:when>
	           		<c:otherwise>
	           			修改视频课件
	           		</c:otherwise>
	           	</c:choose>
        </div>
        <div class="res-upload-box">
        	<br/>
        	<div class="input-group">
                <label>&nbsp;&nbsp;&nbsp;</label>
                <span class="public-tip"><i class="icon-tip"></i>提示：有效的课件文件格式(mp4，视频格式为H264，音频格式为LLC)</span>
            </div>
        	<div class="input-group">
				<ul class="cimg-list clearfix" >
	                <li class="cimg-item" id="answerFileAddLi">
	                    <div class="view-show view-add">
	                        <div class="view-img">
	                            <div class="v-add-action" id="videoFileAdd">
	                                <div class="btn-upload-view">
	                                    <a class="btn-icon" href="javascript:void(0)" id="videoButtonName">
	                                    	<i class="icon-btn"><i class="i-upload"></i></i>
	                                        	上传文件
	                                    </a>
	                                </div>
	                                <span class="view-sign res-name">视频课件</span>
	                                <div class="v-add-tip drop_tip">
	                                </div>
	                            </div>
	                        </div>
	                    </div>
	                </li>
	                <li class="cimg-item publicTip" id="videoFileProgress">
				        <div class="view-show view">
				            <div class="view-img">
				            	<c:choose>
				            		<c:when test="${empty item.videoPic}">
				            			<img src="${contextPath}/images/uploading-video.png">
				            		</c:when>
				            		<c:otherwise>
				            			<img src="${host}${item.videoPic}">
				            		</c:otherwise>
				            	</c:choose>
				                
				                <div class="upload-fun">
				                    <i class="icon-del00" id="videoFileDelete"></i>
				                </div>
				            </div>
				            <div class="view-progressbar upload-progressbar publicTip">
								<div class="progressbar-ui">
									<div class="progressbar-value">								
									</div>
									<div class="progressbar-bg" style="width:256px;">
										<div class="progressbar-in"></div>
									</div>
								</div>
							</div>
							<h3 class="view-title substr publicTip" title="${not empty item ? item.videoName : ''}" id="videoFileNameHtml">${not empty item ? item.videoName : ''}</h3>
				        </div>
				    </li>
	            </ul>
            </div>
            <div class="input-group">
                <label>&nbsp;&nbsp;&nbsp;</label>
                <span class="public-tip"><i class="icon-tip"></i>提示：有效的视频封面格式(jpg，png，bmp，webp，gif)</span>
            </div>
			<div class="input-group">
				<ul class="cimg-list clearfix">
	                <li class="cimg-item" id="quizFileAddLi">
	                    <div class="view-show view-add">
	                        <div class="view-img">
	                            <div class="v-add-action" id="thumbFileAdd">
	                                <div class="btn-upload-view">
	                                    <a class="btn-icon" href="javascript:void(0)" id="thumbButtonName">
	                                    	<i class="icon-btn"><i class="i-upload"></i></i>
	                                        	上传文件
	                                    </a>
	                                </div>
	                                <span class="view-sign res-name">视频封面</span>
	                                <div class="v-add-tip drop_tip">
	                                </div>
	                            </div>
	                        </div>
	                    </div>
	                </li>
	                <li class="cimg-item publicTip" id="thumbFileProgress" >
				        <div class="view-show view">
				            <div class="view-img" id="quizFileImageDiv">
				                <img src="${host}${item.videoPic}" id="thumbImg">
				                <div class="upload-fun">
				                    <i class="icon-del00" id="thumbFileDelete"></i>
				                </div>
				            </div>
				            <div class="view-progressbar upload-progressbar publicTip" >
								<div class="progressbar-ui">
									<div class="progressbar-value">								
									</div>
									<div class="progressbar-bg" style="width:256px;">
										<div class="progressbar-in"></div>
									</div>
								</div>
							</div>
							<%--<h3 class="view-title substr publicTip" id="thumbFileNameHtml"></h3>
				        --%></div>
				    </li>
	            </ul>
            </div>
            
            <div class="btn-area">
                <a class="btn-public btn-min" href="javascript:submitItem()">
                    	提交
                </a>
                <a class="btn-cancel" href="${contextPath}/platform/queryunit.mooc" >
                    	取消
                </a>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    var mockType;
    var mockUseType;
    var host = "${host}";
    var videoTypes = 'mp4';
    var filePicType = "|jpg|png|bmp|webp|gif|"
	$(function () {
    	//添加图片
    	var videoText = "上传文件";
    	var thumbText = "上传文件";
    	currentVideoPath = $("#currentVideoFilePath").val();
    	currentThumbPath = $("#currentThumbFilePath").val();
    	if((currentVideoPath+'').length > 0){
    		$('#videoFileProgress').removeClass("publicTip");
    		$('#videoFileNameHtml').removeClass("publicTip");
    		videoText = "更改文件";
    	}
    	initVideoFile(videoText);
    	
    	if((currentThumbPath+'').length > 0){
    		$('#thumbFileProgress').removeClass("publicTip");
//    		$('#thumbFileNameHtml').removeClass("publicTip");
    		thumbText = "更改文件";
    	}
    	initThumbFile(thumbText);
    	
    	$("#thumbFileDelete").click(function(){
    		$('#thumbFileRelativePath').val('');
		    $('#thumbFileTempPath').val('');
		    $('#thumbFileTempUrl').val('');
		    $('#currentThumbFilePath').val('');
		    $('#thumbFileProgress').addClass("publicTip");
		    initThumbButtonName("上传文件");
    	});
    	$("#videoFileDelete").click(function(){
    		$('#videoFileRelativePath').val('');
		    $('#videoFileTempPath').val('');
		    $('#videoFileTempUrl').val('');
		    $('#currentVideoFilePath').val('');
		    $('#videoFileProgress').addClass("publicTip");
		    initVideoButtonName("上传文件");
    	});
    	
    })	
    
    function initVideoFile(name){
		$("#videoFileAdd").uploader({
	        'uploadUrl': CONTEXTPATH + '/upload/file/resource.mooc',
	        'buttonTemplate':'<div class="v-add-action" id="videoFileAdd">' +
     							'<div class="btn-upload-view">' +
	        				    	'<a class="btn-icon" href="javascript:void(0)" id="videoButtonName"><i class="icon-btn"><i class="i-upload"></i></i>'+name+'</a>' +
	        				    '</div>' +
	        				    '<span class="view-sign res-name">视频课件</span>' +
	        				 	'<div class="v-add-tip drop_tip"></div>'+
	        				 '</div>',	
	        width : 256,
	        height : 181,
	        buttonLeft : 60,
	        buttonTop : 20,
	        buttonWidth : 120,
	        buttonHeight : 120,
	        onSelect: function(file) {
	            var json = JSON.stringify(file);
	            var type = $.trim(file.type.replace(".",""));
	            
	            if(videoTypes.indexOf(type) == -1){
	            	$.dialog.error('请选择   '+videoTypes+' 类型文件!',3);
	            	return;
	            }
            	$("#videoFileProgress").removeClass("publicTip");
            	$("#videoFileProgress").find(".upload-progressbar").removeClass("publicTip");
            	$('#videoFileNameHtml').addClass("publicTip");
                return true;
	        },
	        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes) {
	            var percentage = Math.round(fileBytesLoaded / fileTotalBytes * 100);     
	            $("#videoFileProgress").find(".view-progressbar").find(".progressbar-in").css("width",percentage+"%");
	            $("#videoFileProgress").find(".progressbar-value").html("文件上传"+percentage+"%");
	        },
	        onUploadSuccess: function (file, JsonStr) {
	        	$("#videoFileProgress").find(".upload-progressbar").addClass("publicTip");
	        	$("#videoFileNameHtml").removeClass("publicTip");
	            var JsonData = JSON.parse(JsonStr);
	            //传完成功后，发一个请求处理。
	            var fileSize = file.size;
            	var fileName = file.name.replace(new RegExp(",", 'g'), "，");
			    $('#videoFileRelativePath').val(JsonData.fileRelativePath);
			    $('#videoFileTempPath').val(JsonData.fileTempPath);
			    $('#videoFileTempUrl').val(JsonData.fileTempUrl);
			    $('#videoFileName').val(fileName);
			    $('#videoFileNameHtml').html(fileName);
			    initVideoButtonName("更换文件");
	        },
	        onUploadError: function (file, errorCode, errorMsg) {
	            if (errorCode) {
	                $.error(errorMsg + " (" + errorCode + ")", 5);
	            } else {
	                $.error("上传失败，未知错误", 5);
	            }
	        }
	    });
	}
    
    function initThumbFile(name){
		$("#thumbFileAdd").uploader({
	        'uploadUrl': CONTEXTPATH + '/upload/file/resource.mooc',
	        'buttonTemplate':'<div class="v-add-action" id="thumbFileAdd">' +
     							'<div class="btn-upload-view">' +
	        				    	'<a class="btn-icon" href="javascript:void(0)" id="thumbButtonName"><i class="icon-btn"><i class="i-upload"></i></i>'+name+'</a>' +
	        				    '</div>' +
	        				    '<span class="view-sign res-name">视频封面</span>' +
	        				 	'<div class="v-add-tip drop_tip"></div>'+
	        				 '</div>',	
	        width : 256,
	        height : 181,
	        buttonLeft : 60,
	        buttonTop : 20,
	        buttonWidth : 120,
	        buttonHeight : 120,
	        onSelect: function(file) {
	            var json = JSON.stringify(file);
	            var type = $.trim(file.type.replace(".",""));
	            if(filePicType.indexOf(type) == -1){
	            	$.dialog.error('请选择 '+filePicType+' 类型文件!',3);
	            	return;
	            }
            	$("#thumbFileProgress").removeClass("publicTip");
	            
            	$("#thumbFileProgress").find(".upload-progressbar").removeClass("publicTip");
//            	$('#thumbFileNameHtml').addClass("publicTip");
	            
                return true;
	        },
	        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes) {
	            var percentage = Math.round(fileBytesLoaded / fileTotalBytes * 100);     
	            $("#thumbFileProgress").find(".view-progressbar").find(".progressbar-in").css("width",percentage+"%");
	            $("#thumbFileProgress").find(".progressbar-value").html("文件上传"+percentage+"%");
	        },
	        onUploadSuccess: function (file, JsonStr) {
	        	$("#thumbFileProgress").find(".upload-progressbar").addClass("publicTip");
//	        	$("#thumbFileNameHtml").removeClass("publicTip");
	            var JsonData = JSON.parse(JsonStr);
	            var fileSize = file.size;
            	var fileName = file.name.replace(new RegExp(",", 'g'), "，");
	            
            	$("#thumbImg").attr("src",JsonData.fileTempUrl);
            	
			    $('#thumbFileRelativePath').val(JsonData.fileRelativePath);
			    $('#thumbFileTempPath').val(JsonData.fileTempPath);
			    $('#thumbFileTempUrl').val(JsonData.fileTempUrl);
//			    $('#thumbFileNameHtml').html(fileName);
	            initThumbButtonName("更改文件");
	        },
	        onUploadError: function (file, errorCode, errorMsg) {
	            if (errorCode) {
	                $.error(errorMsg + " (" + errorCode + ")", 5);
	            } else {
	                $.error("上传失败，未知错误", 5);
	            }
	        }
	    });
    }
    
    function submitItem(){
    	var lock;
		var unitId = $("#unitId").val();
		var itemId = $("#itemId").val();
		var thumbFileRelativePath = $("#thumbFileRelativePath").val();
		var thumbFileTempPath = $("#thumbFileTempPath").val();
		var videoFileRelativePath = $("#videoFileRelativePath").val();
		var videoFileTempPath = $("#videoFileTempPath").val();
		var videoFileName = $('#videoFileName').val();
		var currentVideoFilePath = $("#currentVideoFilePath").val();
		var currentThumbFilePath = $("#currentThumbFilePath").val();
		if((videoFileRelativePath+'').length == 0 && (currentVideoFilePath+'').length == 0){
			$.warn("请上视频课件文件", 3);
			return ;
		}
		lock = $.dialog.lockTips("正在提交...", 60)
		$.ajax({
			type:"post",
			url:CONTEXTPATH+"/platform/unit/"+unitId+"/item/operate.mooc",
			data:{
				itemId:itemId,
				thumbRelativePath:thumbFileRelativePath,
				thumbTempPath:thumbFileTempPath,
				videoRelativePath:videoFileRelativePath,
				videoTempPath:videoFileTempPath,
				currentVideoPath:currentVideoFilePath,
				currentThumbPath:currentThumbFilePath,
				videoFileName:videoFileName
			},
			dataType:'json',
			success:function(result){
				lock.close();
				if(result.successFlag == true){
					if(itemId != 0){
						$.success("操作成功！", 3);
						location.href=CONTEXTPATH+"/platform/queryunit.mooc";
					}else{
						$.success("操作成功！", 3);
						location.href=CONTEXTPATH+"/platform/queryunit.mooc";
					}
					
				}else{
					$.error("操作失败！", 3);
				}
			},
			error:function(){
				$.error("操作异常！", 3);
			}
		});
    }
    
	
    function initThumbButtonName(name){
    	$("#thumbButtonName").html('<i class="icon-btn"><i class="i-upload"></i></i>'+name+'');
    }
    
    function initVideoButtonName(name){
    	$("#videoButtonName").html('<i class="icon-btn"><i class="i-upload"></i></i>'+name+'');
    }
</script>
