package com.wisedu.mooc.app.user.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.wisedu.coeus.core.db.PageMaker;
import com.wisedu.coeus.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.mooc.app.user.bo.UserInfo;
import com.wisedu.mooc.app.user.dao.UserInfoDao;
import com.wisedu.mooc.app.user.service.UserInfoService;

@Service("userInfoService")
public class UserInfoServiceImpl implements UserInfoService {

    protected static Logger LOGGER = LoggerFactory.getLogger(UserInfoServiceImpl.class);

    @Autowired
    private UserInfoDao userInfoDao;

    @Override
    public List<UserInfo> getAllUser() {
        return this.userInfoDao.getAllUser();
    }

    @Override
    public UserInfo queryUserInfo(Long userId) {
        return this.userInfoDao.queryUserInfo(userId);
    }

    @Override
    public void updateUserInfo(UserInfo userInfo) {
        this.userInfoDao.update(userInfo);
    }

    @Override
    public Long saveUserInfo(UserInfo userInfo) {
        this.userInfoDao.insert(userInfo);
        return userInfo.getUserId();
    }

    @Override
    public PageMaker getUserInfo(String keyword,int pageIndex, int pageSize) {
        return this.userInfoDao.queryUserInfo(keyword,pageIndex,pageSize);
    }

    @Override
    public void deleteUser(List<Long> userIdList) {
        this.userInfoDao.deleteUser(userIdList);
    }

    @Override
    public void updateUserPassword(List<Long> userIdList) {
        this.userInfoDao.updateUserPassword(userIdList);
    }
}
