package com.wisedu.mooc.app.user.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.core.db.PageMaker;
import com.wisedu.coeus.util.SecurityUtils;
import com.wisedu.coeus.util.Strings;
import org.springframework.stereotype.Repository;

import com.wisedu.coeus.core.dao.BaseDao;
import com.wisedu.mooc.app.user.bo.UserInfo;

@Repository("userInfoDao")

public class UserInfoDao extends BaseDao {

    public List<UserInfo> getAllUser() {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql = "select a.* from mooc_user_info a ";
        return this.queryForEntityList(UserInfo.class, sql, params, 0, 0);
    }

    public List<UserInfo> queryByLoginName(String loginName) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql = " select * from mooc_user_info where delete_flag=:deleteFlag and login_name=:loginName limit 1";
        params.put("deleteFlag", ConstantStatic.DELETE_FLAG_FALSE);
        params.put("loginName", loginName);
        return this.queryForEntityList(UserInfo.class, sql, params, 0, 0);
    }

    public List<UserInfo> queryByLoginNamePwd(String loginName, String password) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql = " select * from mooc_user_info where delete_flag =:deleteFlag" +
                " and password =:password and login_name =:loginName limit 1";
        params.put("deleteFlag", ConstantStatic.DELETE_FLAG_FALSE);
        params.put("loginName", loginName);
        params.put("password", password);
        return this.queryForEntityList(UserInfo.class, sql, params, 0, 0);
    }
	
	public UserInfo queryUserInfo(Long userId){
		return this.load(UserInfo.class, userId);
	}

    public PageMaker queryUserInfo(String keyword,int pageIndex, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        String sql ="select * from mooc_user_info "
                + " where delete_flag = 0 ";
        if (Strings.isNotEmpty(keyword)){
            sql = sql +" and (login_name like :keyword "+ sqlHelper.supportLike()
            + " or nick_name like :keyword "+ sqlHelper.supportLike() +")";
            params.put("keyword",sqlHelper.toLikeValue(keyword));
        }
        sql = sql + " order by create_date desc" ;
        return this.query(sql.toString(), params, pageIndex, pageSize);
    }

    public void deleteUser(List<Long> userIdList){
        Map<String, Object> params = new HashMap<String, Object>();
        String sql =" update mooc_user_info set delete_flag=1"
                  + " where user_id in(:userIdList) ";
        params.put("userIdList",userIdList);
        this.exec(sql,params);
    }

    public void updateUserPassword(List<Long> userIdList){
        Map<String, Object> params = new HashMap<String, Object>();
        String sql =" update mooc_user_info set password =:password"
                + " where user_id in(:userIdList) ";
        params.put("userIdList",userIdList);
        params.put("password", SecurityUtils.hashMD5("123456").toLowerCase());
        this.exec(sql,params);
    }

}
