package com.wisedu.mooc.app.user;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.Strings;

/**
 * Created by 01312170 on 14-7-28.
 */
public class UserConstant {

	public static final Integer USER_HEAD_PX_30 = 30;
	public static final Integer USER_HEAD_PX_60 = 60;
	public static final Integer USER_HEAD_PX_90 = 90;
	public static final String USER_HEAD_PX = "90;60;30";
    public static final String USER_HEAD_OSS_PX = "h_90,w_90;h_60,w_60;h_30,w_30";
    public static final String USER_HEAD_TYPE = ".png";
    
    /**
     * 根据用户头像图片路径和图片尺寸获取对应头像的Url
     * @param useravatarPath
     * @param size
     * @return
     */
    public static String getUserHeadImage(String useravatarPath, Integer size){
    	String imageHeadFormat = "";
    	String imageHeadFormats = "";
    	String result = "";
    	if(ConstantStatic.UPLOAD_RESOURCE_TYPE.equals(ConstantStatic.UPLOAD_RESOURCE_TYPE_ALIYUN)){
    		imageHeadFormats = UserConstant.USER_HEAD_OSS_PX;
    	}else{
    		imageHeadFormats = UserConstant.USER_HEAD_PX;
    	}
    	
    	if(size.equals(UserConstant.USER_HEAD_PX_90)){
    		imageHeadFormat = imageHeadFormats.split(";")[0];
    	}else if(size.equals(UserConstant.USER_HEAD_PX_60)){
    		imageHeadFormat = imageHeadFormats.split(";")[1];
    	}else if(size.equals(UserConstant.USER_HEAD_PX_30)){
    		imageHeadFormat = imageHeadFormats.split(";")[2];
    	}
    	
    	/**根据不同上传类型 拼接各自的头像Url**/
    	if(ConstantStatic.UPLOAD_RESOURCE_TYPE.equals(ConstantStatic.UPLOAD_RESOURCE_TYPE_ALIYUN)){  //阿里云OSS
    		result = Strings.isEmpty(useravatarPath) ? useravatarPath : useravatarPath +"?x-oss-process=image/resize,m_fixed," + imageHeadFormat;
    	}else{
    		result = Strings.isEmpty(useravatarPath) ? useravatarPath : useravatarPath + imageHeadFormat + UserConstant.USER_HEAD_TYPE;
    	}
    	
    	String url = ConstantStatic.RESOURCE_URL_PREFIX;
    	
    	if(Strings.isEmpty(url)){
    		url = ConstantStatic.RESOURCE_DOMAIN;
    	}
    	
    	if(Strings.isNotEmpty(url)){
    		result = url.concat(result); 
    	}
    	if(!result.toLowerCase().startsWith("http")){
			if(!result.toLowerCase().startsWith("/")){
				result = "http://" + result;
			}
		}
    	return result;
    }
    
}
