package com.wisedu.mooc.app.upload.service;

import com.wisedu.mooc.app.upload.exception.UploadException;
import com.wisedu.mooc.app.upload.vo.UploadVo;

import java.io.InputStream;
import java.util.Calendar;


public abstract class UploadService {

    protected String fileExt = "";

    public UploadVo uploadVo = new UploadVo();


    public UploadVo getUploadVo() {
        return uploadVo;
    }


    /**
     * 通过扩展名判断是否允许
     *
     * @param fileExt
     * @return
     */
    public abstract boolean isFileExtValid(String fileExt) throws UploadException;

    /**
     * 文件上传后，处理如何保存到临时目录，
     * 在这个过程中可以对图片进行转格式操作
     * @return
     */
    public abstract UploadVo saveFile(InputStream inputStream, String fileName) throws UploadException;

    /**
     * 对文件的后续处理
     * 需要根据情况把临时目录中把文件复制到实际的目录中
     * 删除临时文件
     * @param uploadVo
     * @return
     */
    public abstract void uploadEndOperate(UploadVo uploadVo) throws UploadException;

    /**
     * 文件的相对路径
     *
     * @param fileExt
     */
    protected abstract void setFilePath(String fileExt) throws UploadException;


    /**
     * 获取扩展名
     *
     * @param fileName
     * @return
     * @throws UploadException
     */
    public String getFileExt(String fileName) throws UploadException {
        if ("".equals(fileExt)) {
            try {
                if (fileName.lastIndexOf(".") != -1) {
                    fileExt = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
                }
            } catch (Exception e) {
            }

        }
        return fileExt;
    }

    /**
     * 返回当前年月
     * @return format 201602
     */
    protected String getYearAndMonth(){
    	String shortYear = String.valueOf(Calendar.getInstance().get(Calendar.YEAR)-2000);
		//月
		String month =String.valueOf(Calendar.getInstance().get(Calendar.MONTH)+1);
		month = month.length()==1?"0"+month:month;
		//日
		
		return shortYear+month;
    }

}
