package com.wisedu.mooc.app.upload;

import java.io.File;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.Strings;
import com.wisedu.coeus.util.UrlUtils;
import com.wisedu.coeus.web.AppConfig;

/**
 * Created by 01312170 on 14-7-28.
 */
public class RsConstant {

	public static final String ALIYUN_OSS_END_POINT = AppConfig.getProperty("yun.oss.end_point");
	public static final String ALIYUN_ACCESS_KEY_ID = AppConfig.getProperty("yun.access_key_id");
	public static final String ALIYUN_SECRET_ACCESS_KEY =  AppConfig.getProperty("yun.secret_access_key");
	public static final String ALIYUN_SOURCE_BUCKET_NAME =  AppConfig.getProperty("yun.bucket_name");
    public static final String ALIYUN_OSS_FILE_URL_HEAD =  AppConfig.getProperty("yun.oss.file.url.head");
	
	
	//上传文件第三方处理类
    public static final String UPLOAD_RESOURCE_ALIYUN_HANDLER_VIDEO = "aliyunVideo"; //上传阿里云视频处理类
    public static final String UPLOAD_RESOURCE_ALIYUN_HANDLER_IMAGE = "aliyunImage"; //上传阿里云图片处理类
	

    public static final String UPLOAD_FILE_ORIGINAL = "original"; //文件扩展名无效

    /**
     * 常见文件类型
     */
    public static final String PIC_SUFFIX = "|bmp|dib|rle|cr2|crw|dcr|emf|gif|jp2|jpx|jpk|j2k|jpc|j2c|jpg|jpeg|jpe|jif|jfif|ldf|lwf|mrw|nef|orf|pcd|pcx|dcx|pef|pic|png|psd|psp|raf|raw|sgi|rgb|rgba|bw|int|inta|tga|tif|tiff|xif|wbm|wbmp|wmf|x3f|";
    public static final String VIDEO_SUFFIX = "|asf|avi|wm|wmp|wmv|rm|rmvb|rp|rpm|rt|smi|smil|dat|m1v|m2p|m2t|m2ts|m2v|mp2v|mpe|mpeg|mpg|mpv2|pss|pva|tp|tpr|ts|m4b|m4p|m4v|mp4|peg4|3g2|3gp|3gp2|3gpp|mov|qt|f4v|flv|hlv|ifo|vob|amv|bik|csf|divx|evo|ivm|mkv|mod|mts|ogm|pmp|scm|tod|vp6|";
    public static final String VIDEO_SUFFIX_LOCAL = "|mp4|wmv|avi|mov|flv|rmvb|rm|asf|mkv|mpeg|mpg|"; //上传视频类型

    public static final String USER_IMAGE_SUFFIX = "|jpg|png|bmp|webp|gif|";

    public static final String SPECIAL_FILE_EXT_APPEND = "_";
    public static final String PATH_JOIN = File.separator;

    public static final String NODES_PATH = "resource";  //资源节点
    public static final String USR_PIC_PATH = "usrimg";  //用户头像

    public static final String RS_IMAGE_PATH = "i";//图片
    public static final String RS_VIDEO_PATH = "v"; //视频
    public static final String RS_OTHER_PATH = "o";//其它

    /**
     * 获取文件存储 二级目录
     * @return
     */
    public static String getOssUrlHead() {
        String urlHead = ALIYUN_OSS_FILE_URL_HEAD;

        if(!ConstantStatic.UPLOAD_RESOURCE_TYPE.equals(ConstantStatic.UPLOAD_RESOURCE_TYPE_ALIYUN)
                || Strings.isEmpty(urlHead)){
            return Strings.EMPTY;
        }
        if(!urlHead.startsWith("/")){
            urlHead = "/".concat(urlHead);
        }
        if(urlHead.endsWith("/")){
            urlHead = urlHead.substring(0,urlHead.length() - 2);
        }
        return urlHead;
    }

    /**
     * 获取文件存储 二级目录
     *
     * @param ext
     * @return
     */
    public static String getRsTypePath(String ext) {
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        String path = null;
        String fileExt = "|" + ext.toLowerCase() + "|";
        if (PIC_SUFFIX.contains(fileExt)) {
            path = RS_IMAGE_PATH;
        } else if (VIDEO_SUFFIX.contains(fileExt)) {
            path = RS_VIDEO_PATH;
        }else {
            path = RS_OTHER_PATH;
        }
        return path;
    }
    
    
    /**
     * 获取内容文件类型对应的ContentType
     * @param FilenameExtension
     * @return
     */
    public static String getContentTypeByFileExt(final String FilenameExtension) {
        if (FilenameExtension.equals("ASF") || FilenameExtension.equals("asf")) {
            return "video/x-ms-asf";
        }
        if (FilenameExtension.equals("AVI") || FilenameExtension.equals("avi")) {
            return "video/avi";
        }
        if (FilenameExtension.equals("MP4") || FilenameExtension.equals("mp4")) {
            return "video/mpeg4";
        }
        if (FilenameExtension.equals("MPE") || FilenameExtension.equals("mpe")) {
            return "video/x-mpeg";
        }
        if (FilenameExtension.equals("MPG") || FilenameExtension.equals("mpg")) {
            return "video/mpg";
        }
        if (FilenameExtension.equals("MPEG")
                || FilenameExtension.equals("mpeg")) {
            return "ivideo/mpg";
        }
        if (FilenameExtension.equals("WM") || FilenameExtension.equals("wm")) {
            return "video/x-ms-wm";
        }
        if (FilenameExtension.equals("WMV") || FilenameExtension.equals("wmv")) {
            return "video/x-ms-wmv";
        }
        if (FilenameExtension.equals("RMVB")
                || FilenameExtension.equals("rmvb")) {
            return "application/vnd.rn-realmedia-vbr";
        }
        if (FilenameExtension.equals("PDF") || FilenameExtension.equals("pdf")) {
            return "application/pdf";
        }
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG")
                || FilenameExtension.equals("jpeg")
                || FilenameExtension.equals("JPG")
                || FilenameExtension.equals("jpg")
                || FilenameExtension.equals("PNG")
                || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML")
                || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX")
                || FilenameExtension.equals("pptx")
                || FilenameExtension.equals("PPT")
                || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX")
                || FilenameExtension.equals("docx")
                || FilenameExtension.equals("DOC")
                || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
    

}
