package com.wisedu.mooc.app.thirdparty.service.impl;

import java.io.File;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.helper.ApplicationHelper;
import com.wisedu.coeus.util.Strings;
import com.wisedu.mooc.app.platform.bo.UnitItem;
import com.wisedu.mooc.app.platform.dao.UnitItemDao;
import com.wisedu.mooc.app.platform.service.UnitItemService;
import com.wisedu.mooc.app.platform.service.impl.PlatformServiceImpl;
import com.wisedu.mooc.app.thirdparty.service.Handler;
import com.wisedu.mooc.app.thirdparty.service.HandlerFactory;
import com.wisedu.mooc.app.thirdparty.service.ThirdpartyService;
import com.wisedu.mooc.app.upload.RsConstant;


@Service("aliyunThirdpartyService")
public class AliyunThirdpartyService implements ThirdpartyService {

	private static final Logger LOGGER = LoggerFactory.getLogger(PlatformServiceImpl.class);
	
	/** 使用spring注解方式注入**/
	@Autowired
	private UnitItemDao unitItemDao;
	
	/**
	 * 资源上传
	 * @param itemId 资源课件Id
	 */
	@SuppressWarnings("null")
	@Override
	public void doUpload(Long itemId) {
		
		LOGGER.debug("aliyunThirdpartyService upload file start,itemId:{}",itemId);
		
		try{
			
			/**根据课件Id查询课件信息 **/
			UnitItem item = unitItemDao.queryUnitItem(itemId);
			
			LOGGER.debug("aliyunThirdpartyService upload file ,itemId:{},resourceType:{},videoUrl:{}",
					itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE,item.getVideoUrl());
			
			/**判断此资源课件是否存在服务访问地址 **/
			if(null == item && Strings.isEmpty(item.getVideoUrl())){
				
				LOGGER.error("aliyunThirdpartyService upload file false end," +
						"message item is null or videoUrl is null itemId:{},resourceType:{}",
						itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE);
				
				return;
			}
			String filePath = ConstantStatic.RESOURCE_PATH.concat(item.getVideoUrl());
			File file = new File(filePath);
			/**判断此文件是否存在 **/
			if(!file.exists()){
				
				LOGGER.error("aliyunThirdpartyService upload file false end," +
						"message file is not found,itemId:{},resourceType:{},filePath:{}",
						itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				
				return;
			}
			String fileName = file.getName();
			if(fileName.indexOf(".") == -1){
	    		return ;
	    	}
	    	
	    	String prefix=fileName.substring(fileName.lastIndexOf(".")+1);
	    	Handler handler = null;
	    	
	    	/**判断此文件格式是否符合 **/
	    	if(!RsConstant.VIDEO_SUFFIX_LOCAL.contains(prefix)){
	    		return;
	    	}
			
	    	/**获取相应的实例 **/
	    	handler = HandlerFactory.getInstance(RsConstant.UPLOAD_RESOURCE_ALIYUN_HANDLER_VIDEO);
	    	/**判断是否获取相应的实例 **/
			if(handler != null && handler.check()){
				
				LOGGER.error("aliyunThirdpartyService upload file false end," +
						"message handler is not found,itemId:{},resourceType:{},filePath:{}",
						itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				
				String targetPath = item.getVideoUrl();
				
				/**上传文件 **/
				boolean result = handler.uploadFile(file, targetPath.substring(1));
				if(result){  //上传成功更新课件信息
					item.setVideoFlvUrl(item.getVideoUrl());
					UnitItemService unitItemService = (UnitItemService) ApplicationHelper.getBean("unitItemService");
					unitItemService.updateItem(item);
					LOGGER.debug("aliyunThirdpartyService upload file success end,itemId:{},resourceType:{},filePath:{}",
							itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				}
				
			}else{
				LOGGER.error("aliyunThirdpartyService upload file false end,itemId:{},resourceType:{},filePath:{}",
						itemId,ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				return;
			}
			
		}catch(Exception e){
			LOGGER.debug(e.getMessage(),e);
		}
		

	}
	
	/**
	 * 资源上传
	 * @param filePath 上传文件地址
	 * @param targetKey 目标文件地址
	 */
	@Override
	public void doUpload(String filePath,String targetKey) {
		
		LOGGER.debug("aliyunThirdpartyService upload image file start,image file path:{},targetKey:{}",filePath,targetKey);
		try{
			/**获取此文件的绝对地址 **/
			filePath = ConstantStatic.RESOURCE_PATH.concat(filePath);
			File file = new File(filePath);
			if(!file.exists()){
				
				LOGGER.error("aliyunThirdpartyService upload image file false end," +
						"message file is not found,resourceType:{},filePath:{}",
						ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				
				return;
			}
			String fileName = file.getName();
			if(fileName.indexOf(".") == -1){
	    		return ;
	    	}
	    	
	    	String prefix=fileName.substring(fileName.lastIndexOf(".")+1);
	    	Handler handler = null;
	    	/**判断此文件格式是否符合 **/
	    	if(!RsConstant.USER_IMAGE_SUFFIX.contains(prefix)){
	    		
	    		LOGGER.error("aliyunThirdpartyService upload image file false end," +
						"message file is not found,resourceType:{},filePath:{}",
						ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
	    		
	    		return ;
	    	}
	    	
	    	/**获取相应的实例 **/
	    	handler = HandlerFactory.getInstance(RsConstant.UPLOAD_RESOURCE_ALIYUN_HANDLER_IMAGE);
	    	
			if(handler != null && handler.check()){
				
				LOGGER.error("aliyunThirdpartyService upload image file false end," +
						"message handler is not found,resourceType:{},filePath:{}",
						ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
				
				/**文件上传 **/
				handler.uploadFile(file, targetKey);
				LOGGER.debug("aliyunThirdpartyService upload file success end,resourceType:{},filePath:{}",
						ConstantStatic.UPLOAD_RESOURCE_TYPE,filePath);
			}
			
		}catch(Exception e){
			LOGGER.debug(e.getMessage(),e);
		}
		
	}
	
}
