package com.wisedu.mooc.app.thirdparty.service;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.helper.ApplicationHelper;
import com.wisedu.mooc.app.platform.service.impl.PlatformServiceImpl;
import com.wisedu.mooc.app.thirdparty.service.ThirdpartyService;

/**
 * 第三方类实例
 * @author 01115035
 *
 */
public class ThirdpartyInstance {

	private static final Logger LOGGER = LoggerFactory.getLogger(ThirdpartyInstance.class);
	
	/**
	 * 根据配置文件值获取相应类的实例
	 * @return
	 */
	public static ThirdpartyService getThirdpartyService(){
		
		ThirdpartyService thirdpartyService = null;
		
		try{
			String serviceName = ConstantStatic.UPLOAD_RESOURCE_TYPE;
			/**使用 ApplicationHelper.getBean()的方式得到一个类的实例**/
			thirdpartyService = (ThirdpartyService) ApplicationHelper.getBean(serviceName.concat("ThirdpartyService"));
		}catch(Exception e){
			LOGGER.error(e.getMessage(),e);
		}
		
        return thirdpartyService;
	} 
	
}
