package com.wisedu.mooc.app.study.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.json.JSONObject;
import com.wisedu.coeus.web.LoginContext;
import com.wisedu.mooc.app.platform.bo.Unit;
import com.wisedu.mooc.app.platform.bo.UnitItem;
import com.wisedu.mooc.app.platform.service.UnitItemService;
import com.wisedu.mooc.app.study.bo.UserStudy;
import com.wisedu.mooc.app.study.service.UserStudyService;
import com.wisedu.mooc.app.user.bo.UserInfo;
import com.wisedu.mooc.app.user.service.UserInfoService;


@Controller
@RequestMapping(value = "/study")
public class UserStudyController {
	
	@Autowired
	private UnitItemService unitItemService;
	@Autowired
	private UserStudyService userStudyService;
	@Autowired
	private UserInfoService userInfoService;
	
	/**
	 * 课件学习页面
	 * @param itemId 视频id
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/init/play/{itemId}", method = RequestMethod.GET)
    public String initPlay(@PathVariable("itemId") Long itemId, ModelMap model) {
        // 获取课件对象
        UnitItem itemBo = this.unitItemService.queryUnitItemById(itemId);
        // 获取课件所属章节信息
        Unit unit = this.unitItemService.queryUnitById(itemBo.getUnitId());
        //当前登录用户
        Long userId = LoginContext.getLoginUser().getUserInfo().getUserId();
        // 获取章节下所有课件列表
        List<UnitItem> itemList = this.unitItemService.queryItemList(itemBo.getUnitId());
        // 将信息回填到model中
        model.put("itemBo", itemBo);
        model.put("itemId", itemId);
        model.put("itemList", itemList);
        model.put("userId", userId);
        model.put("unit", unit);
        return "study.play.index";
    }

	/**
	 * 视频播放
	 * @param itemId 视频课件id
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/play", method = RequestMethod.POST)
    public String player(@RequestParam Long itemId, ModelMap model) {
		//当前登录用户
    	Long userId = LoginContext.getLoginUser().getUserInfo().getUserId();
    	// 获取课件对象
        UnitItem itemBo = this.unitItemService.queryUnitItemById(itemId);
        UserInfo userInfo = this.userInfoService.queryUserInfo(userId);
        //更新当前用户最后学习的课件id
        userInfo.setLastItemId(itemId);
        this.userInfoService.updateUserInfo(userInfo);
        // 获取该课件学习情况
        UserStudy userStudy = this.userStudyService.queryUserStudy(itemId, userId);

        model.put("resourcePath", ConstantStatic.getResourceDomainUrl());//资源地址配置
        model.put("isOver", userStudy==null?0:userStudy.getIsOver());//课件是否学完
        model.put("myDuration", userStudy==null?0:userStudy.getCurrentPosition());//课件的当前学习位置，播放器定位
        model.put("itemBo", itemBo);
        return "study.play.item";
    }
    
	/**
     * 更新学习时长
     *
     * @param itemId          条目id
     * @param currentPosition 当前时间点
     * @param isOver          是否结束 1.学习中；2.已学完
     * @param duration        视频最大时长
     * @return
	 * @throws IOException 
     */
	@RequestMapping(value = "/updateDurationVideo", method = RequestMethod.POST)
	public String updateDurationVideo(@RequestParam Long itemId,
			@RequestParam Long currentPosition, @RequestParam Integer isOver,
			@RequestParam Long duration, HttpServletResponse response) throws IOException {
		Long userId = LoginContext.getLoginUser().getUserInfo().getUserId();
		// 更新学习时长
		this.userStudyService.updateDurationVideo(itemId, currentPosition, isOver, duration, userId);
		response.getWriter().print(new JSONObject());
		return null;
	}
}
