package com.wisedu.mooc.app.platform.service.impl;

import com.wisedu.mooc.app.platform.bo.Unit;
import com.wisedu.mooc.app.platform.bo.UnitItem;
import com.wisedu.mooc.app.platform.dao.UnitItemDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.mooc.app.platform.service.PlatformService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The Class PlatformServiceImpl.
 */
@Service("platformService")
public class PlatformServiceImpl implements PlatformService {
	
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformServiceImpl.class);

    @Autowired
    private UnitItemDao unitItemDao;

    @Override
    public List<Map<String,Object>> queryunit() {
        List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
        //获取章节信息
        List<Unit> unitList = this.unitItemDao.queryUnitList();
        if (unitList!=null && unitList.size()>0){
            List<Long> unitIdList = new ArrayList<Long>();
            for (int i=0;i<unitList.size();i++){
                unitIdList.add(unitList.get(i).getUnitId());
            }
            //获取unit下所有的视频
            List<UnitItem> itemList = this.unitItemDao.queryUnitItem(unitIdList);

            //解析unit与视频。
            Map<String,Object> unitMap = null;
            for (int a=0;a<unitList.size();a++){
                unitMap =new HashMap<String, Object>();
                Unit unit = unitList.get(a);
                unitMap.put("unit",unit);
                Map<String,Object> itemMap = null;
                List<Map<String,Object>> itemMapList = new ArrayList<Map<String, Object>>();
                if (itemList!=null && itemList.size()>0){
                    for (int b=0;b<itemList.size();b++){
                        itemMap = new HashMap<String, Object>();
                        UnitItem item = itemList.get(b);
                        if (item.getUnitId().equals(unit.getUnitId())) {
                            itemMap.put("item",item);
                            itemMapList.add(itemMap);
                        }
                    }
                }
                unitMap.put("itemList",itemMapList);
                list.add(unitMap);
            }
        }
        return list;
    }


}
